/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index.xml;

import com.db4o.ObjectContainer;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.Executor;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.FileBucket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import plugins.Library.Index;
import plugins.Library.Library;
import plugins.Library.index.TermEntry;
import plugins.Library.index.TermPageEntry;
import plugins.Library.index.URIEntry;
import plugins.Library.index.xml.FindRequest;
import plugins.Library.index.xml.MainIndexParser;
import plugins.Library.index.xml.URLUpdateHook;
import plugins.Library.index.xml.Util;
import plugins.Library.search.InvalidSearchException;
import plugins.Library.util.exec.Execution;
import plugins.Library.util.exec.TaskAbortException;

public class XMLIndex
implements Index,
ClientGetCallback,
RequestClient {
    public static final String MIME_TYPE = "application/xml";
    public static final String DEFAULT_FILE = "index.xml";
    private PluginRespirator pr;
    private Executor executor;
    private ClientGetter rootGetter;
    private int fetchFailures = 0;
    protected FetchStatus fetchStatus = FetchStatus.UNFETCHED;
    protected HashMap<String, String> indexMeta = new HashMap();
    protected String indexuri;
    protected long origEdition;
    private URLUpdateHook updateHook;
    private String updateContext;
    private HighLevelSimpleClient hlsc;
    private int version;
    private List<String> subIndiceList;
    private SortedMap<String, SubIndex> subIndice;
    private ArrayList<FindRequest> waitingOnMainIndex = new ArrayList();
    static volatile boolean logMINOR;
    static volatile boolean logDEBUG;
    ClientEventListener mainIndexListener = new ClientEventListener(){

        public void receive(ClientEvent ce, ObjectContainer maybeContainer, ClientContext context) {
            FindRequest.updateWithEvent(XMLIndex.this.waitingOnMainIndex, ce);
        }

        public void onRemoveEventProducer(ObjectContainer container) {
            throw new UnsupportedOperationException();
        }
    };

    public XMLIndex(String baseURI, long edition, PluginRespirator pr, URLUpdateHook hook, String context) throws InvalidSearchException {
        this.pr = pr;
        this.origEdition = edition;
        this.updateHook = hook;
        this.updateContext = context;
        if (pr != null) {
            this.executor = pr.getNode().executor;
        }
        if (baseURI.endsWith(DEFAULT_FILE)) {
            baseURI = baseURI.replace(DEFAULT_FILE, "");
        }
        if (!baseURI.endsWith("/")) {
            baseURI = baseURI + "/";
        }
        this.indexuri = baseURI;
        if (!Util.isValid(baseURI)) {
            throw new InvalidSearchException(baseURI + " is neither a valid file nor valid Freenet URI");
        }
        if (pr != null) {
            this.hlsc = pr.getNode().clientCore.makeClient((short)1, false, false);
            this.hlsc.addEventHook(this.mainIndexListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequests(Bucket bucket) {
        try {
            InputStream is = bucket.getInputStream();
            this.parse(is);
            is.close();
            this.fetchStatus = FetchStatus.FETCHED;
            for (FindRequest req : this.waitingOnMainIndex) {
                this.setdependencies(req);
            }
            this.waitingOnMainIndex.clear();
        }
        catch (Exception e) {
            this.fetchStatus = FetchStatus.FAILED;
            for (FindRequest findRequest : this.waitingOnMainIndex) {
                findRequest.setError(new TaskAbortException("Failure parsing " + this.toString(), e));
            }
            Logger.error((Object)this, (String)this.indexuri, (Throwable)e);
        }
        finally {
            bucket.free();
        }
    }

    public void onSuccess(FetchResult result, ClientGetter state, ObjectContainer container) {
        this.processRequests(result.asBucket());
    }

    public void onFailure(FetchException e, ClientGetter state, ObjectContainer container) {
        ++this.fetchFailures;
        if (this.fetchFailures < 20 && e.newURI != null) {
            try {
                if (logMINOR) {
                    Logger.minor((Object)this, (String)("Trying new URI: " + e.newURI));
                }
                this.indexuri = e.newURI.setMetaString(new String[]{""}).toString();
                if (this.origEdition == -1L || e.newURI.getEdition() >= this.origEdition) {
                    if (logMINOR) {
                        Logger.minor((Object)this, (String)("Trying new URI: " + e.newURI + " : " + this.indexuri));
                    }
                    this.startFetch(true);
                    if (this.updateHook != null) {
                        this.updateHook.update(this.updateContext, this.indexuri);
                    }
                    return;
                }
                Logger.error((Object)this, (String)("Redirect to earlier edition?!?!?!?: " + e.newURI.getEdition() + " from " + this.origEdition));
            }
            catch (FetchException ex) {
                e = ex;
            }
            catch (MalformedURLException ex) {
                Logger.error((Object)this, (String)"what?", (Throwable)ex);
            }
        }
        this.fetchStatus = FetchStatus.FAILED;
        for (FindRequest findRequest : this.waitingOnMainIndex) {
            findRequest.setError(new TaskAbortException("Failure fetching rootindex of " + this.toString(), e));
        }
        Logger.error((Object)this, (String)("Fetch failed on " + this.toString() + " -- state = " + state), (Throwable)e);
    }

    public void onMajorProgress(ObjectContainer container) {
    }

    public boolean persistent() {
        return false;
    }

    public void removeFrom(ObjectContainer container) {
        throw new UnsupportedOperationException();
    }

    private synchronized void startFetch(boolean retry) throws FetchException, MalformedURLException {
        if (!retry && this.fetchStatus != FetchStatus.UNFETCHED && this.fetchStatus != FetchStatus.FAILED) {
            return;
        }
        this.fetchStatus = FetchStatus.FETCHING;
        String uri = this.indexuri + DEFAULT_FILE;
        File file = new File(uri);
        if (file.exists() && file.canRead()) {
            this.processRequests((Bucket)new FileBucket(file, true, false, false, false, false));
            return;
        }
        if (logMINOR) {
            Logger.minor((Object)this, (String)("Fetching " + uri));
        }
        FreenetURI u = new FreenetURI(uri);
        while (true) {
            try {
                this.rootGetter = this.hlsc.fetch(u, -1L, (RequestClient)this, (ClientGetCallback)this, this.hlsc.getFetchContext().clone());
                Logger.normal((Object)this, (String)("Fetch started : " + this.toString()));
            }
            catch (FetchException e) {
                if (e.newURI != null) {
                    u = e.newURI;
                    if (!logMINOR) continue;
                    Logger.minor((Object)this, (String)("New URI: " + uri));
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void parse(InputStream is) throws SAXException, IOException {
        block5: {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                factory.setNamespaceAware(true);
                factory.setFeature("http://xml.org/sax/features/namespaces", true);
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                SAXParser saxParser = factory.newSAXParser();
                MainIndexParser parser = new MainIndexParser();
                saxParser.parse(is, (DefaultHandler)parser);
                this.version = parser.getVersion();
                if (this.version != 1) break block5;
                this.indexMeta.put("title", parser.getHeader("title"));
                this.indexMeta.put("ownerName", parser.getHeader("owner"));
                this.indexMeta.put("ownerEmail", parser.getHeader("email"));
                this.subIndiceList = new ArrayList<String>();
                this.subIndice = new TreeMap<String, SubIndex>();
                for (String key : parser.getSubIndice()) {
                    String stillbase;
                    this.subIndiceList.add(key);
                    try {
                        FreenetURI furi = new FreenetURI(this.indexuri);
                        stillbase = (furi.isUSK() ? furi.sskForUSK() : furi).toString();
                    }
                    catch (MalformedURLException e) {
                        stillbase = this.indexuri;
                    }
                    this.subIndice.put(key, new SubIndex(stillbase, "index_" + key + ".xml"));
                }
                Collections.sort(this.subIndiceList);
            }
            catch (ParserConfigurationException e) {
                Logger.error((Object)this, (String)"SAX ParserConfigurationException", (Throwable)e);
                throw new SAXException(e);
            }
        }
    }

    public String toString() {
        String output = "Index:[ " + this.indexuri + " " + (Object)((Object)this.fetchStatus) + " " + this.waitingOnMainIndex + "\n\t" + this.subIndice + (this.rootGetter == null ? "]" : " GETTING(" + this.rootGetter.toString() + ")]");
        return output;
    }

    private SubIndex getSubIndex(String keyword) {
        String md5 = Library.MD5(keyword);
        int idx = Collections.binarySearch(this.subIndiceList, md5);
        if (idx < 0) {
            idx = -idx - 2;
        }
        return (SubIndex)this.subIndice.get(this.subIndiceList.get(idx));
    }

    @Override
    public synchronized Execution<Set<TermEntry>> getTermEntries(String term) {
        try {
            FindRequest request = new FindRequest(term);
            this.setdependencies(request);
            this.notifyAll();
            return request;
        }
        catch (FetchException ex) {
            Logger.error((Object)this, (String)("Trying to find " + term), (Throwable)ex);
            return null;
        }
        catch (MalformedURLException ex) {
            Logger.error((Object)this, (String)("Trying to find " + term), (Throwable)ex);
            return null;
        }
    }

    @Override
    public Execution<URIEntry> getURIEntry(FreenetURI uri) {
        throw new UnsupportedOperationException("getURIEntry not Implemented in XMLIndex");
    }

    private synchronized void setdependencies(FindRequest request) throws FetchException, MalformedURLException {
        if (this.fetchStatus != FetchStatus.FETCHED) {
            this.waitingOnMainIndex.add(request);
            request.setStage(FindRequest.Stages.FETCHROOT);
            this.startFetch(false);
        } else {
            request.setStage(FindRequest.Stages.FETCHSUBINDEX);
            SubIndex subindex = this.getSubIndex(request.getSubject());
            subindex.addRequest(request);
            if (this.executor != null) {
                this.executor.execute((Runnable)subindex, "Subindex:" + subindex.getFileName());
            } else {
                new Thread((Runnable)subindex, "Subindex:" + subindex.getFileName()).start();
            }
        }
    }

    public String getIndexURI() {
        return this.indexuri;
    }

    public boolean realTimeFlag() {
        return true;
    }

    static {
        Logger.registerClass(XMLIndex.class);
    }

    private class SubIndex
    implements Runnable {
        String indexuri;
        String filename;
        private final ArrayList<FindRequest> waitingOnSubindex = new ArrayList();
        private final ArrayList<FindRequest> parsingSubindex = new ArrayList();
        FetchStatus fetchStatus = FetchStatus.UNFETCHED;
        HighLevelSimpleClient hlsc;
        Bucket bucket;
        Exception error;
        ClientEventListener subIndexListener = new ClientEventListener(){

            public void receive(ClientEvent ce, ObjectContainer maybeContainer, ClientContext context) {
                FindRequest.updateWithEvent(SubIndex.this.waitingOnSubindex, ce);
            }

            public void onRemoveEventProducer(ObjectContainer container) {
                throw new UnsupportedOperationException();
            }
        };
        Map<String, ArrayList<FileMatch>> idToFileMatches = new HashMap<String, ArrayList<FileMatch>>();
        int totalFileCount = -1;

        SubIndex(String indexuri, String filename) {
            this.indexuri = indexuri;
            this.filename = filename;
            if (XMLIndex.this.pr != null) {
                this.hlsc = ((XMLIndex)XMLIndex.this).pr.getNode().clientCore.makeClient((short)1, false, false);
                this.hlsc.addEventHook(this.subIndexListener);
            }
        }

        String getFileName() {
            return this.filename;
        }

        FetchStatus getFetchStatus() {
            return this.fetchStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addRequest(FindRequest request) {
            if (this.fetchStatus == FetchStatus.FETCHED) {
                request.setStage(FindRequest.Stages.PARSE);
            } else {
                request.setStage(FindRequest.Stages.FETCHSUBINDEX);
            }
            ArrayList<FindRequest> arrayList = this.waitingOnSubindex;
            synchronized (arrayList) {
                this.waitingOnSubindex.add(request);
            }
        }

        public String toString() {
            return this.filename + " " + (Object)((Object)this.fetchStatus) + " " + this.waitingOnSubindex;
        }

        @Override
        public synchronized void run() {
            try {
                while (this.waitingOnSubindex.size() > 0) {
                    if (this.fetchStatus == FetchStatus.UNFETCHED || this.fetchStatus == FetchStatus.FAILED) {
                        try {
                            this.fetchStatus = FetchStatus.FETCHING;
                            this.bucket = Util.fetchBucket(this.indexuri + this.filename, this.hlsc);
                            this.fetchStatus = FetchStatus.FETCHED;
                            continue;
                        }
                        catch (Exception e) {
                            String msg = this.indexuri + this.filename + " could not be opened: " + e.toString();
                            Logger.error((Object)this, (String)msg, (Throwable)e);
                            throw new TaskAbortException(msg, e);
                        }
                    }
                    if (this.fetchStatus == FetchStatus.FETCHED) {
                        this.parseSubIndex();
                        continue;
                    }
                    break;
                }
            }
            catch (TaskAbortException e) {
                this.fetchStatus = FetchStatus.FAILED;
                this.error = e;
                Logger.error((Object)this, (String)"Dropping from subindex run loop", (Throwable)e);
                for (FindRequest r : this.parsingSubindex) {
                    r.setError(e);
                }
                for (FindRequest r : this.waitingOnSubindex) {
                    r.setError(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parseSubIndex() throws TaskAbortException {
            ArrayList<FindRequest> arrayList = this.parsingSubindex;
            synchronized (arrayList) {
                Bucket filesBucket;
                Bucket mainBucket;
                ArrayList<FindRequest> arrayList2 = this.waitingOnSubindex;
                synchronized (arrayList2) {
                    this.parsingSubindex.addAll(this.waitingOnSubindex);
                    this.waitingOnSubindex.removeAll(this.parsingSubindex);
                }
                for (FindRequest r : this.parsingSubindex) {
                    r.setStage(FindRequest.Stages.PARSE);
                }
                try {
                    int b;
                    InputStream is = this.bucket.getInputStream();
                    mainBucket = ((XMLIndex)XMLIndex.this).pr.getNode().clientCore.tempBucketFactory.makeBucket(-1L);
                    filesBucket = ((XMLIndex)XMLIndex.this).pr.getNode().clientCore.tempBucketFactory.makeBucket(-1L);
                    BufferedOutputStream mainOS = new BufferedOutputStream(mainBucket.getOutputStream());
                    BufferedOutputStream filesOS = new BufferedOutputStream(filesBucket.getOutputStream());
                    BufferedInputStream bis = new BufferedInputStream(is);
                    byte greaterThan = ">".getBytes("UTF-8")[0];
                    byte[] filesPrefix = "<files ".getBytes("UTF-8");
                    byte[] filesPrefixAlt = "<files>".getBytes("UTF-8");
                    assert (filesPrefix.length == filesPrefixAlt.length);
                    byte[] filesEnd = "</files>".getBytes("UTF-8");
                    boolean MODE_SEEKING_DECLARATION = true;
                    int MODE_SEEKING_FILES = 2;
                    int MODE_COPYING_FILES = 3;
                    int MODE_COPYING_REST = 4;
                    int mode = 1;
                    byte[] declarationBuf = new byte[100];
                    int declarationPtr = 0;
                    byte[] prefixBuffer = new byte[filesPrefix.length];
                    int prefixPtr = 0;
                    byte[] endBuffer = new byte[filesEnd.length];
                    int endPtr = 0;
                    while ((b = bis.read()) != -1) {
                        if (mode == 1) {
                            if (declarationPtr == declarationBuf.length) {
                                throw new TaskAbortException("Could not split up XML: declaration too long", new Exception("bad xml"));
                            }
                            declarationBuf[declarationPtr++] = (byte)b;
                            ((OutputStream)mainOS).write(b);
                            ((OutputStream)filesOS).write(b);
                            if (b != greaterThan) continue;
                            mode = 2;
                            continue;
                        }
                        if (mode == 2) {
                            if (prefixPtr != prefixBuffer.length) {
                                prefixBuffer[prefixPtr++] = (byte)b;
                                continue;
                            }
                            if (Fields.byteArrayEqual((byte[])filesPrefix, (byte[])prefixBuffer) || Fields.byteArrayEqual((byte[])filesPrefixAlt, (byte[])prefixBuffer)) {
                                mode = 3;
                                ((OutputStream)filesOS).write(prefixBuffer);
                                ((OutputStream)filesOS).write(b);
                                continue;
                            }
                            ((OutputStream)mainOS).write(prefixBuffer[0]);
                            System.arraycopy(prefixBuffer, 1, prefixBuffer, 0, prefixBuffer.length - 1);
                            prefixBuffer[prefixBuffer.length - 1] = (byte)b;
                            continue;
                        }
                        if (mode == 3) {
                            if (endPtr != endBuffer.length) {
                                endBuffer[endPtr++] = (byte)b;
                                continue;
                            }
                            if (Fields.byteArrayEqual((byte[])filesEnd, (byte[])endBuffer)) {
                                mode = 4;
                                ((OutputStream)filesOS).write(endBuffer);
                                ((OutputStream)mainOS).write(b);
                                continue;
                            }
                            ((OutputStream)filesOS).write(endBuffer[0]);
                            System.arraycopy(endBuffer, 1, endBuffer, 0, endBuffer.length - 1);
                            endBuffer[endBuffer.length - 1] = (byte)b;
                            continue;
                        }
                        if (mode != 4) continue;
                        ((OutputStream)mainOS).write(b);
                    }
                    if (mode != 4) {
                        throw new TaskAbortException("Could not split up XML: Last mode was " + mode, new Exception("bad xml"));
                    }
                    ((OutputStream)mainOS).close();
                    ((OutputStream)filesOS).close();
                }
                catch (IOException e) {
                    throw new TaskAbortException("Could not split XML: ", e);
                }
                if (logMINOR) {
                    Logger.minor((Object)this, (String)"Finished splitting XML");
                }
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    SAXParser saxParser = factory.newSAXParser();
                    InputStream is = mainBucket.getInputStream();
                    StageTwoHandler stageTwoHandler = new StageTwoHandler();
                    saxParser.parse(is, (DefaultHandler)stageTwoHandler);
                    if (logMINOR) {
                        Logger.minor((Object)this, (String)"Finished stage two XML parse");
                    }
                    is.close();
                    is = filesBucket.getInputStream();
                    StageThreeHandler stageThreeHandler = new StageThreeHandler();
                    saxParser.parse(is, (DefaultHandler)stageThreeHandler);
                    if (logMINOR) {
                        Logger.minor((Object)this, (String)"Finished stage three XML parse");
                    }
                    is.close();
                    Logger.minor((Object)this, (String)("parsing finished " + this.parsingSubindex.toString()));
                    for (FindRequest findRequest : this.parsingSubindex) {
                        findRequest.setFinished();
                    }
                    this.parsingSubindex.clear();
                }
                catch (Exception err) {
                    Logger.error((Object)this, (String)("Error parsing " + this.filename), (Throwable)err);
                    throw new TaskAbortException("Could not parse XML: ", err);
                }
            }
        }

        class StageThreeHandler
        extends DefaultHandler {
            StageThreeHandler() {
            }

            @Override
            public void setDocumentLocator(Locator value) {
            }

            @Override
            public void endDocument() throws SAXException {
            }

            @Override
            public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
                block19: {
                    String elt_name;
                    if (SubIndex.this.idToFileMatches.isEmpty()) {
                        return;
                    }
                    if (rawName == null) {
                        rawName = localName;
                    }
                    if ((elt_name = rawName).equals("files")) {
                        String fileCount = attrs.getValue("", "totalFileCount");
                        if (fileCount != null) {
                            SubIndex.this.totalFileCount = Integer.parseInt(fileCount);
                        }
                        Logger.minor((Object)this, (String)("totalfilecount = " + SubIndex.this.totalFileCount));
                    }
                    if (elt_name.equals("file")) {
                        try {
                            String id = attrs.getValue("id");
                            ArrayList<FileMatch> matches = SubIndex.this.idToFileMatches.get(id);
                            if (matches == null) break block19;
                            for (FileMatch match : matches) {
                                String key = attrs.getValue("key");
                                int l = attrs.getLength();
                                String title = null;
                                int wordCount = -1;
                                if (l >= 3) {
                                    try {
                                        title = attrs.getValue("title");
                                    }
                                    catch (Exception e) {
                                        Logger.error((Object)this, (String)("Index Format not compatible " + e.toString()), (Throwable)e);
                                    }
                                    try {
                                        String wordCountString = attrs.getValue("wordCount");
                                        if (wordCountString != null) {
                                            wordCount = Integer.parseInt(attrs.getValue("wordCount"));
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                for (FindRequest req : match.word.searches) {
                                    Set<TermPageEntry> result = req.getUnfinishedResult();
                                    float relevance = 0.0f;
                                    if (logDEBUG) {
                                        Logger.debug((Object)this, (String)("termcount " + (match.termpositions == null ? 0 : match.termpositions.size()) + " filewordcount = " + wordCount));
                                    }
                                    if (match.termpositions != null && match.termpositions.size() > 0 && wordCount > 0) {
                                        relevance = (float)match.termpositions.size() / (float)wordCount;
                                        if (SubIndex.this.totalFileCount > 0 && match.word.inWordFileCount > 0) {
                                            relevance = (float)((double)relevance * Math.log((float)SubIndex.this.totalFileCount / (float)match.word.inWordFileCount));
                                        }
                                        if (logDEBUG) {
                                            Logger.debug((Object)this, (String)("Set relevance of " + title + " to " + relevance + " - " + key));
                                        }
                                    }
                                    TermPageEntry pageEntry = new TermPageEntry(req.getSubject(), relevance, new FreenetURI(key), title, match.termpositions);
                                    result.add(pageEntry);
                                }
                            }
                        }
                        catch (Exception e) {
                            Logger.error((Object)this, (String)"File id and key could not be retrieved. May be due to format clash", (Throwable)e);
                        }
                    }
                }
            }
        }

        class StageTwoHandler
        extends DefaultHandler {
            private boolean processingWord;
            private List<FindRequest> requests;
            private List<FindRequest> wordMatches;
            private int inWordFileCount;
            private StringBuilder characters;
            private String match;
            private ArrayList<FileMatch> fileMatches = new ArrayList();
            private String id;
            private WordMatch thisWordMatch;

            StageTwoHandler() {
                this.requests = new ArrayList<FindRequest>(SubIndex.this.parsingSubindex);
                for (FindRequest r : SubIndex.this.parsingSubindex) {
                    r.setResult((Set<TermPageEntry>)new HashSet<TermPageEntry>());
                }
            }

            @Override
            public void setDocumentLocator(Locator value) {
            }

            @Override
            public void endDocument() throws SAXException {
            }

            @Override
            public void startDocument() throws SAXException {
            }

            @Override
            public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
                String elt_name;
                if (this.requests.size() == 0 && (this.wordMatches == null || this.wordMatches.size() == 0)) {
                    return;
                }
                if (rawName == null) {
                    rawName = localName;
                }
                if ((elt_name = rawName).equals("keywords")) {
                    this.processingWord = true;
                }
                if (elt_name.equals("word")) {
                    try {
                        this.fileMatches.clear();
                        this.wordMatches = null;
                        this.match = attrs.getValue("v");
                        if (this.requests != null) {
                            Iterator<FindRequest> it = this.requests.iterator();
                            while (it.hasNext()) {
                                FindRequest r = it.next();
                                if (!this.match.equals(r.getSubject())) continue;
                                if (this.wordMatches == null) {
                                    this.wordMatches = new ArrayList<FindRequest>();
                                }
                                this.wordMatches.add(r);
                                it.remove();
                                Logger.minor((Object)this, (String)("found word match " + this.wordMatches));
                            }
                            if (this.wordMatches != null) {
                                if (attrs.getValue("fileCount") != null) {
                                    this.inWordFileCount = Integer.parseInt(attrs.getValue("fileCount"));
                                }
                                this.thisWordMatch = new WordMatch(new ArrayList<FindRequest>(this.wordMatches), this.inWordFileCount);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new SAXException(e);
                    }
                }
                if (elt_name.equals("file") && this.processingWord && this.wordMatches != null) {
                    try {
                        this.id = attrs.getValue("id");
                        this.characters = new StringBuilder();
                    }
                    catch (Exception e) {
                        Logger.error((Object)this, (String)("Index format may be outdated " + e.toString()), (Throwable)e);
                    }
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                if (this.processingWord && this.wordMatches != null && this.characters != null) {
                    this.characters.append(ch, start, length);
                }
            }

            @Override
            public void endElement(String namespaceURI, String localName, String qName) {
                if (this.processingWord && this.wordMatches != null && qName.equals("file")) {
                    HashMap<Integer, String> termpositions = null;
                    if (this.characters != null) {
                        String[] termposs = this.characters.toString().split(",");
                        termpositions = new HashMap<Integer, String>();
                        for (String pos : termposs) {
                            try {
                                termpositions.put(Integer.valueOf(pos), null);
                            }
                            catch (NumberFormatException e) {
                                Logger.error((Object)this, (String)("Position in index not an integer :" + pos), (Throwable)e);
                            }
                        }
                        this.characters = null;
                    }
                    FileMatch thisFile = new FileMatch(this.id, termpositions, this.thisWordMatch);
                    ArrayList<FileMatch> matchList = SubIndex.this.idToFileMatches.get(this.id);
                    if (matchList == null) {
                        matchList = new ArrayList();
                        SubIndex.this.idToFileMatches.put(this.id, matchList);
                    }
                    if (logMINOR) {
                        Logger.minor((Object)this, (String)("Match: id=" + this.id + " for word " + this.match));
                    }
                    matchList.add(thisFile);
                }
            }
        }

        class FileMatch {
            final String id;
            final HashMap<Integer, String> termpositions;
            final WordMatch word;

            public FileMatch(String id2, HashMap<Integer, String> termpositions2, WordMatch thisWordMatch) {
                this.id = id2;
                this.termpositions = termpositions2;
                this.word = thisWordMatch;
            }
        }

        class WordMatch {
            final List<FindRequest> searches;
            int inWordFileCount;

            public WordMatch(ArrayList<FindRequest> searches, int inWordFileCount) {
                this.searches = searches;
                this.inWordFileCount = inWordFileCount;
            }
        }
    }

    public static enum FetchStatus {
        UNFETCHED,
        FETCHING,
        FETCHED,
        FAILED;

    }
}

