/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.search;

import freenet.support.Executor;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plugins.Library.Library;
import plugins.Library.index.TermEntry;
import plugins.Library.search.InvalidSearchException;
import plugins.Library.search.ResultSet;
import plugins.Library.search.SearchUtil;
import plugins.Library.ui.ResultNodeGenerator;
import plugins.Library.util.exec.AbstractExecution;
import plugins.Library.util.exec.CompositeProgress;
import plugins.Library.util.exec.Execution;
import plugins.Library.util.exec.Progress;
import plugins.Library.util.exec.ProgressParts;
import plugins.Library.util.exec.TaskAbortException;

public class Search
extends AbstractExecution<Set<TermEntry>>
implements CompositeProgress,
Execution<Set<TermEntry>> {
    private static Library library;
    private static Executor executor;
    private ResultSet.ResultOperation resultOperation;
    private List<Execution<Set<TermEntry>>> subsearches;
    private String query;
    private String indexURI;
    private static HashMap<String, Search> allsearches;
    private static HashMap<Integer, Search> searchhashes;
    private ResultSet resultset;
    private boolean formatResult = false;
    private boolean htmlgroupusk;
    private boolean htmlshowold;
    private boolean htmljs;
    private ResultNodeGenerator resultNodeGenerator;
    private HTMLNode pageEntryNode;
    private SearchStatus status = SearchStatus.Unstarted;
    static volatile boolean logMINOR;
    static volatile boolean logDEBUG;

    private static synchronized void storeSearch(Search search) {
        allsearches.put(search.getSubject(), search);
        searchhashes.put(search.hashCode(), search);
    }

    private static synchronized void removeSearch(Search search) {
        allsearches.remove(search.subject);
        searchhashes.remove(search.hashCode());
    }

    public static Search startSearch(String search, String indexuri) throws InvalidSearchException, TaskAbortException {
        String[] indices;
        if ((search = search.toLowerCase(Locale.US).trim()).length() == 0) {
            throw new InvalidSearchException("Blank search");
        }
        if (Search.hasSearch(search = Search.fixCJK(search), indexuri)) {
            return Search.getSearch(search, indexuri);
        }
        if (logMINOR) {
            Logger.minor(Search.class, (String)("Starting new search for " + search + " in " + indexuri));
        }
        if ((indices = indexuri.split("[ ;]")).length < 1 || search.trim().length() < 1) {
            throw new InvalidSearchException("Attempt to start search with no index or terms");
        }
        if (indices.length == 1) {
            Search newSearch = Search.splitQuery(search, indexuri);
            return newSearch;
        }
        ArrayList<Search> indexrequests = new ArrayList<Search>(indices.length);
        for (String index : indices) {
            Search indexsearch = Search.startSearch(search, index);
            if (indexsearch == null) {
                return null;
            }
            indexrequests.add(indexsearch);
        }
        Search newSearch = new Search(search, indexuri, indexrequests, ResultSet.ResultOperation.DIFFERENTINDEXES);
        return newSearch;
    }

    private static String fixCJK(String search) {
        int character;
        StringBuffer sb = null;
        boolean wasCJK = false;
        for (int offset = 0; offset < search.length(); offset += Character.charCount(character)) {
            character = search.codePointAt(offset);
            if (SearchUtil.isCJK(character)) {
                if (wasCJK) {
                    sb.append(' ');
                }
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append(search.substring(0, offset));
                }
                wasCJK = true;
            } else {
                wasCJK = false;
            }
            if (sb == null) continue;
            sb.append(Character.toChars(character));
        }
        if (sb != null) {
            return sb.toString();
        }
        return search;
    }

    private Search(String query, String indexURI, List<? extends Execution<Set<TermEntry>>> requests, ResultSet.ResultOperation resultOperation) throws InvalidSearchException {
        super(Search.makeString(query, indexURI));
        if (resultOperation == ResultSet.ResultOperation.SINGLE && requests.size() != 1) {
            throw new InvalidSearchException(requests.size() + " requests supplied with SINGLE operation");
        }
        if (resultOperation == ResultSet.ResultOperation.REMOVE && requests.size() != 2) {
            throw new InvalidSearchException("Negative operations can only have 2 parameters");
        }
        if ((resultOperation == ResultSet.ResultOperation.PHRASE || resultOperation == ResultSet.ResultOperation.INTERSECTION || resultOperation == ResultSet.ResultOperation.UNION || resultOperation == ResultSet.ResultOperation.DIFFERENTINDEXES) && requests.size() < 2) {
            throw new InvalidSearchException(resultOperation.toString() + " operations need more than one term");
        }
        query = query.toLowerCase(Locale.US).trim();
        ArrayList<Execution<Set<TermEntry>>> tempsubsearches = new ArrayList<Execution<Set<TermEntry>>>();
        for (Execution<Set<TermEntry>> execution : requests) {
            if (execution != null || resultOperation == ResultSet.ResultOperation.PHRASE) {
                tempsubsearches.add(execution);
                continue;
            }
            throw new NullPointerException("Search cannot encapsulate nulls except in the case of a ResultOperation.PHRASE where they are treated as blanks");
        }
        this.subsearches = Collections.unmodifiableList(tempsubsearches);
        this.query = query;
        this.indexURI = indexURI;
        this.resultOperation = resultOperation;
        try {
            this.setStatus();
        }
        catch (TaskAbortException ex) {
            this.setError(ex);
        }
        Search.storeSearch(this);
        if (logMINOR) {
            Logger.minor((Object)this, (String)("Created Search object for with subRequests :" + this.subsearches));
        }
    }

    private Search(String query, String indexURI, Execution<Set<TermEntry>> request) {
        super(Search.makeString(query, indexURI));
        if (request == null) {
            throw new NullPointerException("Search cannot encapsulate null (query=\"" + query + "\" indexURI=\"" + indexURI + "\")");
        }
        query = query.toLowerCase(Locale.US).trim();
        this.subsearches = Collections.singletonList(request);
        this.query = query;
        this.indexURI = indexURI;
        this.resultOperation = ResultSet.ResultOperation.SINGLE;
        try {
            this.setStatus();
        }
        catch (TaskAbortException ex) {
            this.setError(ex);
        }
        Search.storeSearch(this);
    }

    private static Search splitQuery(String query, String indexuri) throws InvalidSearchException, TaskAbortException {
        if ((query = query.trim()).matches("\\A[\\S&&[^-\"]]*\\Z")) {
            if (SearchUtil.isStopWord(query)) {
                return null;
            }
            Execution<Set<TermEntry>> request = library.getIndex(indexuri).getTermEntries(query);
            if (request == null) {
                throw new InvalidSearchException("Something wrong with query=\"" + query + "\" or indexURI=\"" + indexuri + "\", maybe something is wrong with the index or it's uri is wrong.");
            }
            return new Search(query, indexuri, request);
        }
        if (query.matches("\\A\"[^\"]*\"\\Z") || query.matches("\\A((?:[\\S&&[^-]]+-)+[\\S&&[^-]]+)\\Z")) {
            ArrayList<Search> phrasesearches = new ArrayList<Search>();
            String[] phrase = query.replaceAll("\"(.*)\"", "$1").split("[\\s-]+");
            if (logMINOR) {
                Logger.minor(Search.class, (String)("Phrase split: " + query));
            }
            for (String subquery : phrase) {
                Search term = Search.startSearch(subquery, indexuri);
                phrasesearches.add(term);
            }
            while (phrasesearches.size() > 0 && phrasesearches.get(0) == null) {
                phrasesearches.remove(0);
            }
            while (phrasesearches.size() > 0 && phrasesearches.get(phrasesearches.size() - 1) == null) {
                phrasesearches.remove(phrasesearches.size() - 1);
            }
            if (phrasesearches.size() > 1) {
                return new Search(query, indexuri, phrasesearches, ResultSet.ResultOperation.PHRASE);
            }
            return null;
        }
        if (logMINOR) {
            Logger.minor(Search.class, (String)("Splitting " + query));
        }
        ArrayList<String> phrases = new ArrayList<String>();
        Matcher nextPhrase = Pattern.compile("\"([^\"]*?)\"").matcher(query);
        StringBuffer sb = new StringBuffer();
        while (nextPhrase.find()) {
            String phrase = nextPhrase.group(1);
            nextPhrase.appendReplacement(sb, "\u00a3" + phrases.size() + "\u20ac");
            phrases.add(phrase);
        }
        nextPhrase.appendTail(sb);
        if (logMINOR) {
            Logger.minor(Search.class, (String)("Phrases removed query: " + sb));
        }
        String formattedquery = sb.toString().replaceFirst("\"", "");
        if (logMINOR) {
            Logger.minor(Search.class, (String)("Removing the unmatched bracket: " + formattedquery));
        }
        nextPhrase = Pattern.compile("((?:[\\S&&[^-]]+-)+[\\S&&[^-]]+)").matcher(formattedquery);
        sb.setLength(0);
        while (nextPhrase.find()) {
            String phrase = nextPhrase.group(1);
            nextPhrase.appendReplacement(sb, "\u00a3" + phrases.size() + "\u20ac");
            phrases.add(phrase);
        }
        nextPhrase.appendTail(sb);
        formattedquery = sb.toString();
        if (logMINOR) {
            Logger.minor(Search.class, (String)("Treat hyphenated words as phrases: " + formattedquery));
        }
        formattedquery = formattedquery.replaceAll("\\s+or\\s+", "||");
        if (logMINOR) {
            Logger.minor(Search.class, (String)("OR-subst query : " + formattedquery));
        }
        formattedquery = formattedquery.replaceAll("\\s+(?:not\\s*|-)(\\S+)", "^^($1)");
        if (logMINOR) {
            Logger.minor(Search.class, (String)("NOT-subst query : " + formattedquery));
        }
        formattedquery = formattedquery.replaceAll("\\s+", "&&");
        if (logMINOR) {
            Logger.minor(Search.class, (String)("AND-subst query : " + formattedquery));
        }
        String[] phraseparts = formattedquery.split("\u00a3");
        formattedquery = phraseparts[0];
        for (int i = 1; i < phraseparts.length; ++i) {
            String string = phraseparts[i];
            if (logMINOR) {
                Logger.minor(Search.class, (String)("replacing phrase " + string.replaceFirst("(\\d+).*", "$1")));
            }
            formattedquery = formattedquery + "\"" + (String)phrases.get(Integer.parseInt(string.replaceFirst("(\\d+).*", "$1"))) + "\"" + string.replaceFirst("\\d+\u20ac(.*)", "$1");
        }
        if (logMINOR) {
            Logger.minor(Search.class, (String)("Phrase back query: " + formattedquery));
        }
        if (formattedquery.contains("^^(")) {
            ArrayList<Search> complementsearches = new ArrayList<Search>();
            String[] splitup = formattedquery.split("(\\^\\^\\(|\\))", 3);
            Search add = Search.startSearch(splitup[0] + splitup[2], indexuri);
            Search subtract = Search.startSearch(splitup[1], indexuri);
            if (add == null || subtract == null) {
                return null;
            }
            complementsearches.add(add);
            complementsearches.add(subtract);
            return new Search(query, indexuri, complementsearches, ResultSet.ResultOperation.REMOVE);
        }
        if (formattedquery.contains("&&")) {
            String[] intersects;
            ArrayList<Search> intersectsearches = new ArrayList<Search>();
            for (String subquery : intersects = formattedquery.split("&&")) {
                Search subsearch = Search.startSearch(subquery, indexuri);
                if (subsearch == null) continue;
                intersectsearches.add(subsearch);
            }
            switch (intersectsearches.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (Search)intersectsearches.get(0);
                }
            }
            return new Search(query, indexuri, intersectsearches, ResultSet.ResultOperation.INTERSECTION);
        }
        if (formattedquery.contains("||")) {
            String[] unions;
            ArrayList<Search> unionsearches = new ArrayList<Search>();
            for (String subquery : unions = formattedquery.split("\\|\\|")) {
                Search add = Search.startSearch(subquery, indexuri);
                if (add == null) {
                    return null;
                }
                unionsearches.add(add);
            }
            return new Search(query, indexuri, unionsearches, ResultSet.ResultOperation.UNION);
        }
        Logger.error(Search.class, (String)("No split made, " + formattedquery + query));
        return null;
    }

    public static void setup(Library library, Executor executor) {
        Search.library = library;
        Search.executor = executor;
        allsearches = new HashMap();
    }

    public static synchronized Search getSearch(String search, String indexuri) {
        if (search == null || indexuri == null) {
            return null;
        }
        search = search.toLowerCase(Locale.US).trim();
        return allsearches.get(Search.makeString(search, indexuri));
    }

    public static synchronized Search getSearch(int searchHash) {
        return searchhashes.get(searchHash);
    }

    public static boolean hasSearch(String search, String indexuri) {
        if (search == null || indexuri == null) {
            return false;
        }
        search = search.toLowerCase(Locale.US).trim();
        return allsearches.containsKey(Search.makeString(search, indexuri));
    }

    public static boolean hasSearch(int searchHash) {
        return searchhashes.containsKey(searchHash);
    }

    public static synchronized Map<String, Search> getAllSearches() {
        return Collections.unmodifiableMap(allsearches);
    }

    public String getQuery() {
        return this.query;
    }

    public String getIndexURI() {
        return this.indexURI;
    }

    public static String makeString(String search, String indexuri) {
        return search + "@" + indexuri;
    }

    public String toString() {
        return "Search: " + (Object)((Object)this.resultOperation) + " - " + (Object)((Object)this.status) + " : " + this.subject + " : " + this.subsearches;
    }

    public List<? extends Progress> getSubProgress() {
        if (logMINOR) {
            Logger.minor((Object)this, (String)this.toString());
        }
        if (this.subsearches == null) {
            return null;
        }
        if (this.resultOperation == ResultSet.ResultOperation.DIFFERENTINDEXES) {
            return this.subsearches;
        }
        ArrayList<Progress> subprogresses = new ArrayList<Progress>();
        for (Execution<Set<TermEntry>> request : this.subsearches) {
            if (request == null) continue;
            if (request instanceof CompositeProgress && ((CompositeProgress)((Object)request)).getSubProgress() != null && ((CompositeProgress)((Object)request)).getSubProgress().iterator().hasNext()) {
                for (Progress progress : ((CompositeProgress)((Object)request)).getSubProgress()) {
                    subprogresses.add(progress);
                }
                continue;
            }
            subprogresses.add(request);
        }
        return subprogresses;
    }

    @Override
    public boolean isDone() throws TaskAbortException {
        this.setStatus();
        return this.status == SearchStatus.Done;
    }

    public boolean hasGeneratedResultNode() {
        return this.pageEntryNode != null;
    }

    private synchronized void setStatus() throws TaskAbortException {
        switch (this.status) {
            case Unstarted: {
                this.status = SearchStatus.Busy;
            }
            case Busy: {
                if (!this.isSubRequestsComplete()) {
                    for (Execution<Set<TermEntry>> request : this.subsearches) {
                        if (request == null || request instanceof Search && ((Search)request).status != SearchStatus.Busy) continue;
                        return;
                    }
                }
                this.status = SearchStatus.Combining_First;
            }
            case Combining_First: {
                if (!this.isSubRequestsComplete()) {
                    return;
                }
                this.resultset = new ResultSet(this.subject, this.resultOperation, this.subsearches, this.innerCanFailAndStillComplete());
                if (executor != null) {
                    executor.execute((Runnable)this.resultset, "Library.Search : combining results");
                } else {
                    new Thread((Runnable)this.resultset, "Library.Search : combining results").start();
                }
                this.status = SearchStatus.Combining_Last;
            }
            case Combining_Last: {
                if (!this.resultset.isDone()) {
                    return;
                }
                this.subsearches = null;
                if (this.formatResult) {
                    this.resultNodeGenerator = new ResultNodeGenerator(this.resultset, this.htmlgroupusk, this.htmlshowold, this.htmljs);
                    if (executor != null) {
                        executor.execute((Runnable)this.resultNodeGenerator, "Library.Search : formatting results");
                    } else {
                        new Thread((Runnable)this.resultNodeGenerator, "Library.Search : formatting results").start();
                    }
                    this.status = SearchStatus.Formatting;
                } else {
                    this.status = SearchStatus.Done;
                }
            }
            case Formatting: {
                if (this.formatResult) {
                    if (!this.resultNodeGenerator.isDone()) {
                        return;
                    }
                    this.pageEntryNode = this.resultNodeGenerator.getPageEntryNode();
                    this.resultNodeGenerator = null;
                }
                this.status = SearchStatus.Done;
            }
        }
    }

    private boolean isSubRequestsComplete() throws TaskAbortException {
        for (Execution<Set<TermEntry>> r : this.subsearches) {
            try {
                if (r == null || r.isDone()) continue;
                return false;
            }
            catch (TaskAbortException e) {
                if (this.innerCanFailAndStillComplete()) continue;
                throw e;
            }
        }
        return true;
    }

    @Override
    public Set<TermEntry> getResult() throws TaskAbortException {
        try {
            if (!this.isDone()) {
                return null;
            }
        }
        catch (TaskAbortException e) {
            Search.removeSearch(this);
            throw e;
        }
        Search.removeSearch(this);
        ResultSet rs = this.resultset;
        return rs;
    }

    public HTMLNode getHTMLNode() {
        try {
            if (!this.isDone() || !this.formatResult) {
                return null;
            }
        }
        catch (TaskAbortException ex) {
            Logger.error((Object)this, (String)"Error finding out whether this is done", (Throwable)ex);
            return null;
        }
        Search.removeSearch(this);
        HTMLNode pen = this.pageEntryNode;
        this.pageEntryNode = null;
        return pen;
    }

    public synchronized void setMakeResultNode(boolean groupusk, boolean showold, boolean js) {
        this.formatResult = true;
        this.htmlgroupusk = groupusk;
        this.htmlshowold = showold;
        this.htmljs = js;
    }

    @Override
    public ProgressParts getParts() throws TaskAbortException {
        if (this.subsearches == null) {
            return ProgressParts.normalise(0, 0);
        }
        return ProgressParts.getParts(this.getSubProgress(), -2);
    }

    @Override
    public String getStatus() {
        try {
            this.setStatus();
            return this.status.name();
        }
        catch (TaskAbortException ex) {
            return "Error finding Status";
        }
    }

    @Override
    public boolean isPartiallyDone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void remove() {
        if (this.subsearches != null) {
            for (Execution<Set<TermEntry>> sub : this.subsearches) {
                if (!(sub instanceof Search)) continue;
                ((Search)sub).remove();
            }
        }
        Search.removeSearch(this);
    }

    public boolean innerCanFailAndStillComplete() {
        switch (this.resultOperation) {
            case DIFFERENTINDEXES: 
            case UNION: {
                return true;
            }
        }
        return false;
    }

    static {
        allsearches = new HashMap();
        searchhashes = new HashMap();
        Logger.registerClass(Search.class);
    }

    private static enum SearchStatus {
        Unstarted,
        Busy,
        Combining_First,
        Combining_Last,
        Formatting,
        Done;

    }
}

