/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import plugins.Library.search.SearchUtil;

public class SearchTokenizer
implements Iterable<String>,
Iterator<String> {
    private ArrayList<Mode> mode;
    private ArrayList<String> segments;
    private int nextPos;
    private final boolean returnPairs;
    static final int KEEP_NON_LETTER_MIN_CHARS = 3;
    static final String allowedMidWord = "'";
    static final String discardIfEndWord = "'";
    private Iterator<String> cjkTokenizer;

    public SearchTokenizer(String text, boolean returnPairs) {
        this.returnPairs = returnPairs;
        text = this.normalize(text);
        int length = text.length();
        this.segments = new ArrayList();
        this.mode = new ArrayList();
        Mode curMode = Mode.UNDEF;
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        while (offset < length) {
            char c;
            int codepoint = text.codePointAt(offset);
            int charCount = Character.charCount(codepoint);
            offset += charCount;
            if (Character.isLetterOrDigit(codepoint)) {
                boolean isCJK = SearchUtil.isCJK(codepoint);
                boolean isNum = Character.isDigit(codepoint);
                if (isCJK) {
                    if (curMode == Mode.LATIN && sb.length() != 0) {
                        this.segments.add(sb.toString());
                        this.mode.add(curMode);
                        sb = new StringBuilder();
                    }
                    curMode = Mode.CJK;
                } else if (!isNum) {
                    if (curMode == Mode.CJK && sb.length() != 0) {
                        this.segments.add(sb.toString());
                        this.mode.add(curMode);
                        sb = new StringBuilder();
                    }
                    curMode = Mode.LATIN;
                }
                sb.append(Character.toChars(codepoint));
                continue;
            }
            if (sb.length() == 0) continue;
            boolean passed = false;
            if (charCount == 1 && "'".indexOf(c = text.charAt(offset - 1)) != -1) {
                sb.append(c);
                passed = true;
            }
            if (passed) continue;
            if (curMode != Mode.UNDEF || sb.length() >= 3) {
                while (sb.length() > 0 && "'".indexOf(sb.charAt(sb.length() - 1)) != -1) {
                    sb.setLength(sb.length() - 1);
                }
                if (sb.length() > 0) {
                    this.segments.add(sb.toString());
                    this.mode.add(curMode);
                }
            }
            curMode = Mode.UNDEF;
            sb = new StringBuilder();
        }
        if (sb.length() != 0) {
            while (sb.length() > 0 && "'".indexOf(sb.charAt(sb.length() - 1)) != -1) {
                sb.setLength(sb.length() - 1);
            }
            if (sb.length() > 0) {
                this.segments.add(sb.toString());
                this.mode.add(curMode);
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("->[");
        Iterator<String> it = this.segments.iterator();
        if (it.hasNext()) {
            str.append(it.next());
        }
        while (it.hasNext()) {
            str.append(',');
            str.append(it.next());
        }
        str.append("]");
        for (String s : this) {
            str.append(';');
            str.append(s);
        }
        return str.toString();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.cjkTokenizer != null && this.cjkTokenizer.hasNext() || this.nextPos < this.segments.size();
    }

    @Override
    public String next() {
        if (this.cjkTokenizer != null) {
            if (this.cjkTokenizer.hasNext()) {
                return this.cjkTokenizer.next();
            }
            this.cjkTokenizer = null;
        }
        Mode curMode = this.mode.get(this.nextPos);
        String curSeg = this.segments.get(this.nextPos);
        ++this.nextPos;
        switch (curMode) {
            case LATIN: {
                return curSeg;
            }
            case CJK: {
                this.cjkTokenizer = this.cjkIterator(curSeg, this.returnPairs);
                assert (this.cjkTokenizer.hasNext());
                return this.cjkTokenizer.next();
            }
            case UNDEF: {
                return curSeg;
            }
        }
        assert (false);
        return null;
    }

    private Iterator<String> cjkIterator(String cjkText, boolean returnPairs) {
        ArrayList<String> cjkToken = new ArrayList<String>();
        String lastChar = null;
        int length = cjkText.length();
        int offset = 0;
        while (offset < length) {
            int codepoint = cjkText.codePointAt(offset);
            offset += Character.charCount(codepoint);
            String curChar = new String(Character.toChars(codepoint));
            if (lastChar != null && returnPairs) {
                cjkToken.add(lastChar + curChar);
            }
            if (SearchUtil.isCJK(codepoint)) {
                cjkToken.add(curChar);
            }
            lastChar = curChar;
        }
        return cjkToken.iterator();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected String normalize(String text) {
        return text.toUpperCase(Locale.US).toLowerCase(Locale.US);
    }

    static enum Mode {
        UNDEF,
        LATIN,
        CJK;

    }
}

