/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import freenet.support.Logger;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import plugins.Library.io.DataFormatException;
import plugins.Library.io.serial.IterableSerialiser;
import plugins.Library.io.serial.MapSerialiser;
import plugins.Library.io.serial.ProgressTracker;
import plugins.Library.io.serial.ScheduledSerialiser;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.io.serial.Translator;
import plugins.Library.util.BTreeMap;
import plugins.Library.util.DataNotLoadedException;
import plugins.Library.util.Maps;
import plugins.Library.util.Skeleton;
import plugins.Library.util.SkeletonMap;
import plugins.Library.util.SkeletonTreeMap;
import plugins.Library.util.Sorted;
import plugins.Library.util.TaskAbortExceptionConvertor;
import plugins.Library.util.concurrent.BoundedPriorityBlockingQueue;
import plugins.Library.util.concurrent.ExceptionConvertor;
import plugins.Library.util.concurrent.Executors;
import plugins.Library.util.concurrent.Notifier;
import plugins.Library.util.concurrent.ObjectProcessor;
import plugins.Library.util.event.AbstractSweeper;
import plugins.Library.util.event.CountingSweeper;
import plugins.Library.util.event.TrackingSweeper;
import plugins.Library.util.exec.BaseCompositeProgress;
import plugins.Library.util.exec.TaskAbortException;
import plugins.Library.util.exec.TaskCompleteException;
import plugins.Library.util.exec.TaskInProgressException;
import plugins.Library.util.func.Closure;
import plugins.Library.util.func.SafeClosure;
import plugins.Library.util.func.Tuples;

public class SkeletonBTreeMap<K, V>
extends BTreeMap<K, V>
implements SkeletonMap<K, V> {
    protected IterableSerialiser<SkeletonNode> nsrl;
    protected MapSerialiser<K, V> vsrl;
    static volatile boolean logMINOR;
    static volatile boolean logDEBUG;
    public final Comparator<Serialiser.PullTask<SkeletonNode>> CMP_PULL = new Comparator<Serialiser.PullTask<SkeletonNode>>(){

        @Override
        public int compare(Serialiser.PullTask<SkeletonNode> t1, Serialiser.PullTask<SkeletonNode> t2) {
            return ((GhostNode)t1.meta).compareTo((GhostNode)t2.meta);
        }
    };
    public final Comparator<Serialiser.PushTask<SkeletonNode>> CMP_PUSH = new Comparator<Serialiser.PushTask<SkeletonNode>>(){

        @Override
        public int compare(Serialiser.PushTask<SkeletonNode> t1, Serialiser.PushTask<SkeletonNode> t2) {
            return ((SkeletonNode)t1.data).compareTo((BTreeMap.Node)t2.data);
        }
    };
    public final Comparator<Map.Entry<K, V>> CMP_ENTRY = new Comparator<Map.Entry<K, V>>(){

        @Override
        public int compare(Map.Entry<K, V> t1, Map.Entry<K, V> t2) {
            return SkeletonBTreeMap.this.compare(t1.getKey(), t2.getKey());
        }
    };
    BaseCompositeProgress pr_inf = new BaseCompositeProgress();
    private static Executor value_exec;
    public static final Executor VALUE_EXECUTOR;
    private static Executor deflate_exec;
    public static final Executor DEFLATE_EXECUTOR;
    private Set<K> keySet = null;

    public void setSerialiser(IterableSerialiser<SkeletonNode> n, MapSerialiser<K, V> v) {
        if (!(this.nsrl == null && this.vsrl == null || this.isLive())) {
            throw new IllegalStateException("Cannot change the serialiser when the structure is not live.");
        }
        this.nsrl = n;
        this.vsrl = v;
        ((SkeletonNode)this.root).setSerialiser();
    }

    public SkeletonBTreeMap(Comparator<? super K> cmp, int node_min) {
        super(cmp, node_min);
    }

    public SkeletonBTreeMap(int node_min) {
        super(node_min);
    }

    protected SkeletonNode postPullTask(Serialiser.PullTask<SkeletonNode> task, SkeletonNode parent) throws DataFormatException {
        SkeletonNode node = (SkeletonNode)task.data;
        GhostNode ghost = (GhostNode)task.meta;
        if (!this.compare0(ghost.lkey, node.lkey) || !this.compare0(ghost.rkey, node.rkey)) {
            throw new DataFormatException("BTreeMap Node lkey/rkey does not match", null, node);
        }
        parent.attachSkeleton(node);
        return node;
    }

    protected GhostNode postPushTask(Serialiser.PushTask<SkeletonNode> task, SkeletonNode parent) {
        GhostNode ghost = (GhostNode)task.meta;
        parent.attachGhost(ghost);
        return ghost;
    }

    @Override
    protected BTreeMap.Node newNode(K lk, K rk, boolean lf) {
        return new SkeletonNode(lk, rk, lf);
    }

    @Override
    protected void swapKey(K key, BTreeMap.Node src, BTreeMap.Node dst) {
        SkeletonTreeMap.swapKey(key, (SkeletonTreeMap)src.entries, (SkeletonTreeMap)dst.entries);
    }

    @Override
    public Object getMeta() {
        return null;
    }

    @Override
    public void setMeta(Object m) {
    }

    @Override
    public MapSerialiser<K, V> getSerialiser() {
        return this.vsrl;
    }

    @Override
    public boolean isLive() {
        return ((SkeletonNode)this.root).isLive();
    }

    @Override
    public boolean isBare() {
        return ((SkeletonNode)this.root).isBare();
    }

    @Override
    public void deflate() throws TaskAbortException {
        ((SkeletonNode)this.root).deflate();
    }

    public BaseCompositeProgress getProgressInflate() {
        return this.pr_inf;
    }

    @Override
    public void inflate() throws TaskAbortException {
        if (!(this.nsrl instanceof ScheduledSerialiser)) {
            ((SkeletonNode)this.root).inflate();
            return;
        }
        PriorityQueue<SkeletonNode> nodequeue = new PriorityQueue<SkeletonNode>();
        LinkedHashMap ids = null;
        ProgressTracker ntracker = null;
        if (this.nsrl instanceof Serialiser.Trackable) {
            ids = new LinkedHashMap();
            ntracker = ((Serialiser.Trackable)((Object)this.nsrl)).getTracker();
            this.pr_inf.setSubProgress(ProgressTracker.makePullProgressIterable(ids));
            this.pr_inf.setSubject("Pulling all entries in B-tree");
        }
        ObjectProcessor proc_pull = ((ScheduledSerialiser)this.nsrl).pullSchedule(new PriorityBlockingQueue(16, this.CMP_PULL), new LinkedBlockingQueue(16), new HashMap());
        try {
            nodequeue.add((SkeletonNode)this.root);
            while (true) {
                if (proc_pull.hasCompleted()) {
                    Tuples.X3 res = proc_pull.accept();
                    Serialiser.PullTask task = (Serialiser.PullTask)res._0;
                    SkeletonNode parent = (SkeletonNode)res._1;
                    TaskAbortException ex = (TaskAbortException)res._2;
                    if (ex != null) {
                        assert (!(ex instanceof TaskInProgressException));
                        if (!(ex instanceof TaskCompleteException)) {
                            throw ex;
                        }
                        GhostNode ghost = (GhostNode)task.meta;
                        assert (!((BTreeMap.Node)parent.rnodes.get(ghost.lkey)).isGhost());
                        nodequeue.add((SkeletonNode)parent.rnodes.get(ghost.lkey));
                        continue;
                    }
                    SkeletonNode node = this.postPullTask(task, parent);
                    nodequeue.add(node);
                    continue;
                }
                while (!nodequeue.isEmpty()) {
                    SkeletonNode node = (SkeletonNode)nodequeue.remove();
                    ((SkeletonTreeMap)node.entries).inflate();
                    if (node.isLeaf()) continue;
                    for (BTreeMap.Node next : node.iterNodes()) {
                        if (!next.isGhost()) {
                            SkeletonNode skel = (SkeletonNode)next;
                            if (skel.isLive()) continue;
                            nodequeue.add(skel);
                            continue;
                        }
                        Serialiser.PullTask task = new Serialiser.PullTask((GhostNode)next);
                        if (ids != null) {
                            ids.put(task, ntracker);
                        }
                        ObjectProcessor.submitSafe(proc_pull, task, node);
                    }
                }
                Thread.sleep(64L);
                if (!proc_pull.hasPending()) break;
            }
            this.pr_inf.setEstimate(-1);
        }
        catch (DataFormatException e) {
            throw new TaskAbortException("Bad data format", e);
        }
        catch (InterruptedException e) {
            throw new TaskAbortException("interrupted", e);
        }
        finally {
            proc_pull.close();
        }
    }

    @Override
    public void deflate(K key) throws TaskAbortException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void inflate(K key) throws TaskAbortException {
        this.inflate(key, false);
    }

    public void inflate(K key, boolean deflateRest) throws TaskAbortException {
        while (true) {
            try {
                if (deflateRest) {
                    this.getDeflateRest(key);
                    break;
                }
                this.get(key);
            }
            catch (DataNotLoadedException e) {
                e.getParent().inflate(e.getKey());
                continue;
            }
            break;
        }
    }

    public V getDeflateRest(Object k) throws TaskAbortException {
        Object key = k;
        BTreeMap.Node node = this.root;
        while (!node.isLeaf()) {
            BTreeMap.Node nextnode = node.selectNode(key);
            if (nextnode == null) {
                for (BTreeMap.Node sub : node.iterNodes()) {
                    if (sub == nextnode || !(sub instanceof SkeletonNode)) continue;
                    ((SkeletonNode)sub).deflate();
                    ((SkeletonNode)node).deflate(sub.lkey);
                }
                return node.entries.get(key);
            }
            node = nextnode;
        }
        return node.entries.get(key);
    }

    public void update(SortedMap<K, V> putmap, SortedSet<K> remkey) throws TaskAbortException {
        this.update(null, remkey, putmap, null, new TaskAbortExceptionConvertor());
    }

    public <X extends Exception> void update(SortedSet<K> putkey, SortedSet<K> remkey, Closure<Map.Entry<K, V>, X> value_handler, ExceptionConvertor<X> conv) throws TaskAbortException {
        this.update(putkey, remkey, null, value_handler, conv);
    }

    protected <X extends Exception> void update(SortedSet<K> putkey, SortedSet<K> remkey, SortedMap<K, V> putmap, Closure<Map.Entry<K, V>, X> value_handler, ExceptionConvertor<X> conv) throws TaskAbortException {
        if (value_handler == null) {
            assert (putkey == null);
            putkey = Sorted.keySet(putmap);
        } else assert (putmap == null);
        if (remkey != null && !remkey.isEmpty()) {
            throw new UnsupportedOperationException("SkeletonBTreeMap: update() currently only supports merge operations");
        }
        while (true) {
            TreeSet<K> rejected = value_handler == null ? null : new TreeSet<K>();
            this.update(putkey, putmap, value_handler, conv, rejected);
            if (rejected == null || rejected.isEmpty()) {
                return;
            }
            System.err.println("Rejected keys: " + rejected.size() + " - re-running merge with rejected keys.");
            putkey = rejected;
        }
    }

    protected <X extends Exception> void update(SortedSet<K> putkey, SortedMap<K, V> putmap, Closure<Map.Entry<K, V>, X> value_handler, ExceptionConvertor<X> conv, SortedSet<K> rejected) throws TaskAbortException {
        Notifier notifier = new Notifier();
        ObjectProcessor proc_pull = ((ScheduledSerialiser)this.nsrl).pullSchedule(new PriorityBlockingQueue(16, this.CMP_PULL), new LinkedBlockingQueue(8), new HashMap());
        proc_pull.setNotifier(notifier);
        ObjectProcessor proc_push = ((ScheduledSerialiser)this.nsrl).pushSchedule(new PriorityBlockingQueue(16, this.CMP_PUSH), new LinkedBlockingQueue(16), new HashMap());
        proc_push.setNotifier(notifier);
        ObjectProcessor proc_val = value_handler == null ? null : new ObjectProcessor(new BoundedPriorityBlockingQueue<Map.Entry<K, V>>(16, this.CMP_ENTRY), new LinkedBlockingQueue(this.ENT_MAX * 3), new HashMap(), value_handler, VALUE_EXECUTOR, conv, notifier).autostart();
        class DeflateNode
        extends TrackingSweeper<K, SortedSet<K>>
        implements Runnable,
        SafeClosure<Map.Entry<K, V>> {
            final SkeletonNode node;
            final CountingSweeper<SkeletonNode> parNClo;
            private boolean deflated;
            final /* synthetic */ ObjectProcessor val$proc_push;
            final /* synthetic */ SkeletonBTreeMap this$0;

            protected DeflateNode(SkeletonNode n, CountingSweeper<SkeletonNode> pnc) {
                this.this$0 = var1_1;
                this.val$proc_push = var4_4;
                super(true, true, new TreeSet(var1_1.comparator), null);
                this.parNClo = pnc;
                this.node = n;
            }

            @Override
            public void run() {
                try {
                    this.deflate();
                }
                catch (TaskAbortException e) {
                    throw new RuntimeException(e);
                }
                assert (this.node.isBare());
                if (this.parNClo == null) {
                    assert (this.node == this.this$0.root);
                    return;
                }
                ObjectProcessor.submitSafe(this.val$proc_push, new Serialiser.PushTask<SkeletonNode>(this.node), this.parNClo);
            }

            @Override
            public void invoke(Map.Entry<K, V> en) {
                assert (this.node.entries.containsKey(en.getKey()));
                this.node.entries.put(en.getKey(), en.getValue());
                if (logMINOR) {
                    Logger.minor((Object)this, (String)("New value for key " + en.getKey() + " : " + en.getValue() + " in " + this.node + " parent = " + this.parNClo));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void deflate() throws TaskAbortException {
                DeflateNode deflateNode = this;
                synchronized (deflateNode) {
                    if (this.deflated) {
                        return;
                    }
                    this.deflated = true;
                }
                ((SkeletonTreeMap)this.node.entries).deflate();
            }
        }
        Comparator<DeflateNode> CMP_DEFLATE = new Comparator<DeflateNode>(){

            @Override
            public int compare(DeflateNode arg0, DeflateNode arg1) {
                return arg0.node.compareTo(arg1.node);
            }
        };
        ObjectProcessor proc_deflate = new ObjectProcessor(new BoundedPriorityBlockingQueue<DeflateNode>(16, CMP_DEFLATE), new LinkedBlockingQueue(), new HashMap(), new Closure<DeflateNode, TaskAbortException>(){

            @Override
            public void invoke(DeflateNode param) throws TaskAbortException {
                param.deflate();
            }
        }, DEFLATE_EXECUTOR, new TaskAbortExceptionConvertor(), notifier).autostart();
        proc_deflate.setMaxConc(2);
        TreeMap EMPTY_SORTEDMAP = new TreeMap(this.comparator);
        proc_pull.setName("pull");
        proc_push.setName("push");
        if (proc_val != null) {
            proc_val.setName("val");
        }
        proc_deflate.setName("deflate");
        try {
            /*
             * Exception performing whole class analysis ignored.
             */
            class InflateChildNodes
            implements SafeClosure<SkeletonNode> {
                final SkeletonNode parent;
                final SortedSet<K> putkey;
                final SplitNode parNClo;
                final DeflateNode parVClo;
                final /* synthetic */ ObjectProcessor val$proc_push;
                final /* synthetic */ ObjectProcessor val$proc_val;
                final /* synthetic */ SortedMap val$EMPTY_SORTEDMAP;
                final /* synthetic */ ObjectProcessor val$proc_deflate;
                final /* synthetic */ SortedMap val$putmap;
                final /* synthetic */ SortedSet val$rejected;
                final /* synthetic */ ObjectProcessor val$proc_pull;
                final /* synthetic */ SkeletonBTreeMap this$0;

                protected InflateChildNodes(SkeletonNode p, SortedSet<K> ki, SplitNode pnc, DeflateNode pvc) {
                    this.this$0 = var1_1;
                    this.val$proc_push = var6_6;
                    this.val$proc_val = var7_7;
                    this.val$EMPTY_SORTEDMAP = var8_8;
                    this.val$proc_deflate = var9_9;
                    this.val$putmap = var10_10;
                    this.val$rejected = var11_11;
                    this.val$proc_pull = var12_12;
                    this.parent = p;
                    this.putkey = ki;
                    class SplitNode
                    extends CountingSweeper<SkeletonNode>
                    implements Runnable {
                        final SkeletonNode node;
                        SkeletonNode parent;
                        final DeflateNode nodeVClo;
                        SplitNode parNClo;
                        DeflateNode parVClo;
                        final /* synthetic */ ObjectProcessor val$proc_deflate;
                        final /* synthetic */ SortedMap val$EMPTY_SORTEDMAP;
                        final /* synthetic */ ObjectProcessor val$proc_push;
                        final /* synthetic */ ObjectProcessor val$proc_val;

                        protected SplitNode(SkeletonNode n, SkeletonNode p, DeflateNode vc, SplitNode pnc, DeflateNode pvc) {
                            this.val$proc_deflate = objectProcessor;
                            this.val$EMPTY_SORTEDMAP = sortedMap;
                            this.val$proc_push = objectProcessor2;
                            this.val$proc_val = objectProcessor3;
                            super(true, false);
                            this.node = n;
                            this.parent = p;
                            this.nodeVClo = vc;
                            this.parNClo = pnc;
                            this.parVClo = pvc;
                        }

                        @Override
                        public void run() {
                            assert (this.node.ghosts == this.node.childCount());
                            this.nodeVClo.close();
                            int sk = SkeletonBTreeMap.this.minKeysFor(this.node.nodeSize());
                            if (sk == 0) {
                                if (this.nodeVClo.isCleared()) {
                                    try {
                                        this.val$proc_deflate.submit(this.nodeVClo, this.nodeVClo.node);
                                    }
                                    catch (InterruptedException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                return;
                            }
                            if (this.parent == null) {
                                assert (this.parNClo == null && this.parVClo == null);
                                this.parent = new SkeletonNode(null, null, false);
                                this.parent.addAll(this.val$EMPTY_SORTEDMAP, Collections.singleton(this.node));
                                this.parVClo = new DeflateNode(SkeletonBTreeMap.this, this.parent, null, this.val$proc_push);
                                this.parNClo = new SplitNode(this.parent, null, this.parVClo, null, null);
                                this.parNClo.acquire(this.node);
                                this.parNClo.close();
                                SkeletonBTreeMap.this.root = this.parent;
                            }
                            List keys = Sorted.select(Sorted.keySet(this.node.entries), sk);
                            this.parent.split(this.node.lkey, keys, this.node.rkey);
                            Iterable<BTreeMap.Node> nodes = this.parent.iterNodes(this.node.lkey, this.node.rkey);
                            SortedSet held = (SortedSet)this.nodeVClo.view();
                            assert (this.val$proc_val != null || held.size() == 0);
                            for (Object key : keys) {
                                if (!held.contains(key)) continue;
                                this.reassignKeyToSweeper(key, this.parVClo);
                            }
                            this.parNClo.open();
                            for (BTreeMap.Node nn : nodes) {
                                SkeletonNode n = (SkeletonNode)nn;
                                DeflateNode vClo = new DeflateNode(SkeletonBTreeMap.this, n, (CountingSweeper)this.parNClo, this.val$proc_push);
                                SortedSet<Object> subheld = BTreeMap.subSet(held, n.lkey, n.rkey);
                                assert (subheld.isEmpty() || SkeletonBTreeMap.this.compareL(n.lkey, subheld.first()) < 0 && SkeletonBTreeMap.this.compareR(subheld.last(), n.rkey) < 0);
                                for (Object e : subheld) {
                                    this.reassignKeyToSweeper(e, vClo);
                                }
                                vClo.close();
                                if (vClo.isCleared()) {
                                    try {
                                        this.val$proc_deflate.submit(vClo, vClo.node);
                                    }
                                    catch (InterruptedException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                this.parNClo.acquire(n);
                            }
                            this.parNClo.release(this.node);
                            this.parNClo.close();
                            assert (!this.parNClo.isCleared());
                        }

                        private void reassignKeyToSweeper(K key, DeflateNode clo) {
                            clo.acquire(key);
                            this.val$proc_val.update(Maps.$K(key, null), clo);
                            if (logMINOR) {
                                Logger.minor((Object)this, (String)("Reassigning key " + key + " to " + clo + " on " + this + " parent=" + this.parent + " parent split node " + this.parNClo + " parent deflate node " + this.parVClo));
                            }
                        }
                    }
                    this.parNClo = pnc;
                    this.parVClo = pvc;
                }

                protected InflateChildNodes(SortedSet<K> ki) {
                    this(var1_1, null, ki, null, null, var3_3, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void invoke(SkeletonNode node) {
                    assert (this.this$0.compareL(node.lkey, this.putkey.first()) < 0);
                    assert (this.this$0.compareR(this.putkey.last(), node.rkey) < 0);
                    try {
                        ((SkeletonTreeMap)node.entries).inflate();
                    }
                    catch (TaskAbortException e) {
                        throw new RuntimeException(e);
                    }
                    DeflateNode vClo = new DeflateNode(this.this$0, node, (CountingSweeper)this.parNClo, this.val$proc_push);
                    SplitNode nClo = new SplitNode(this.this$0, node, this.parent, vClo, this.parNClo, this.parVClo, this.val$proc_deflate, this.val$EMPTY_SORTEDMAP, this.val$proc_push, this.val$proc_val);
                    node._size = -1;
                    if (node.isLeaf()) {
                        if (this.val$proc_val == null) {
                            for (Object key : this.putkey) {
                                if (this.val$putmap.get(key) == null) {
                                    throw new NullPointerException();
                                }
                                node.entries.put(key, this.val$putmap.get(key));
                            }
                        } else if (this.putkey.size() < this.val$proc_val.outputCapacity()) {
                            for (Object key : this.putkey) {
                                this.handleLocalPut(node, key, vClo);
                            }
                        } else {
                            TreeSet accepted = new TreeSet(Sorted.select(this.putkey, this.val$proc_val.outputCapacity() / 2));
                            List notAccepted = Sorted.split(this.putkey, accepted, new TreeSet());
                            System.err.println("Too many keys to add to a single node: We can add " + this.val$proc_val.outputCapacity() + " but are being asked to add " + this.putkey.size() + " - adding " + accepted.size() + " and rejecting the rest.");
                            for (Object k : accepted) {
                                this.handleLocalPut(node, k, vClo);
                            }
                            SortedSet i$ = this.val$rejected;
                            synchronized (i$) {
                                for (SortedSet set : notAccepted) {
                                    this.val$rejected.addAll(set);
                                }
                            }
                        }
                    } else {
                        TreeSet fkey = new TreeSet(this.this$0.comparator);
                        List range = Sorted.split(this.putkey, Sorted.keySet(node.entries), fkey);
                        if (this.val$proc_val == null) {
                            for (Object e : fkey) {
                                if (this.val$putmap.get(e) == null) {
                                    throw new NullPointerException();
                                }
                                node.entries.put(e, this.val$putmap.get(e));
                            }
                        } else {
                            for (Object e : fkey) {
                                this.handleLocalPut(node, e, vClo);
                            }
                        }
                        for (SortedSet sortedSet : range) {
                            GhostNode n;
                            try {
                                n = (GhostNode)node.selectNode(sortedSet.first());
                            }
                            catch (ClassCastException e) {
                                Logger.error((Object)this, (String)("Node is already loaded?!?!?!: " + node.selectNode(sortedSet.first())));
                                continue;
                            }
                            Serialiser.PullTask task = new Serialiser.PullTask(n);
                            nClo.acquire(null);
                            ObjectProcessor.submitSafe(this.val$proc_pull, task, new InflateChildNodes(this.this$0, node, sortedSet, nClo, vClo, this.val$proc_push, this.val$proc_val, this.val$EMPTY_SORTEDMAP, this.val$proc_deflate, this.val$putmap, this.val$rejected, this.val$proc_pull));
                        }
                    }
                    nClo.close();
                    if (nClo.isCleared()) {
                        nClo.run();
                    }
                }

                private void handleLocalPut(SkeletonNode n, K key, DeflateNode vClo) {
                    Object oldval = n.entries.put(key, null);
                    vClo.acquire(key);
                    if (logMINOR) {
                        Logger.minor((Object)this, (String)("handleLocalPut for key " + key + " old value " + oldval + " for deflate node " + vClo + " - passing to proc_val"));
                    }
                    ObjectProcessor.submitSafe(this.val$proc_val, Maps.$K(key, oldval), vClo);
                }

                private void handleLocalRemove(SkeletonNode n, K key, TrackingSweeper<K, SortedSet<K>> vClo) {
                    throw new UnsupportedOperationException("not implemented");
                }
            }
            new InflateChildNodes(this, putkey, proc_push, proc_val, EMPTY_SORTEDMAP, proc_deflate, putmap, rejected, proc_pull).invoke((SkeletonNode)this.root);
            int olds = this.size;
            boolean progress = true;
            int count = 0;
            boolean ccount = false;
            do {
                Exception ex;
                AbstractSweeper sw;
                Serialiser.Task task;
                Tuples.X3<Serialiser.Task, Object, TaskAbortException> res;
                if (!progress && count++ > 10) {
                    count = 0;
                    System.out.println(proc_val + " " + proc_pull + " " + proc_push + " " + proc_deflate);
                    notifier.waitUpdate(1000);
                }
                progress = false;
                boolean loop = false;
                while (proc_push.hasCompleted()) {
                    res = proc_push.accept();
                    task = (Serialiser.PushTask)res._0;
                    sw = (CountingSweeper)res._1;
                    ex = (TaskAbortException)res._2;
                    if (ex != null) {
                        throw new UnsupportedOperationException("SkeletonBTreeMap.update(): PushTask aborted; handler not implemented yet", ex);
                    }
                    this.postPushTask((Serialiser.PushTask<SkeletonNode>)task, ((SplitNode)sw).node);
                    sw.release(task.data);
                    if (sw.isCleared()) {
                        ((Runnable)((Object)sw)).run();
                    }
                    loop = true;
                    progress = true;
                }
                if (loop) continue;
                if (proc_deflate.hasCompleted()) {
                    res = proc_deflate.accept();
                    DeflateNode sw2 = (DeflateNode)res._0;
                    TaskAbortException ex2 = (TaskAbortException)res._2;
                    if (ex2 != null) {
                        throw ex2;
                    }
                    sw2.run();
                    progress = true;
                    continue;
                }
                if (loop) continue;
                if (proc_val != null && proc_val.hasCompleted()) {
                    res = proc_val.accept();
                    Map.Entry en = (Map.Entry)res._0;
                    sw = (DeflateNode)res._1;
                    ex = (Exception)res._2;
                    if (ex != null) {
                        throw new UnsupportedOperationException("SkeletonBTreeMap.update(): value-retrieval aborted; handler not implemented yet", ex);
                    }
                    ((DeflateNode)sw).invoke(en);
                    sw.release(en.getKey());
                    if (sw.isCleared()) {
                        proc_deflate.submit(sw, ((DeflateNode)sw).node);
                    }
                    progress = true;
                    continue;
                }
                if (!proc_pull.hasCompleted()) continue;
                res = proc_pull.accept();
                task = (Serialiser.PullTask)res._0;
                SafeClosure clo = (SafeClosure)res._1;
                ex = (TaskAbortException)res._2;
                if (ex != null) {
                    throw new UnsupportedOperationException("SkeletonBTreeMap.update(): PullTask aborted; handler not implemented yet", ex);
                }
                SkeletonNode node = this.postPullTask((Serialiser.PullTask<SkeletonNode>)task, ((InflateChildNodes)clo).parent);
                clo.invoke(node);
                progress = true;
            } while (proc_pull.hasPending() || proc_push.hasPending() || proc_val != null && proc_val.hasPending() || proc_deflate.hasPending());
            this.size = this.root.totalSize();
        }
        catch (RuntimeException e) {
            throw new TaskAbortException("Task failed", e);
        }
        catch (DataFormatException e) {
            throw new TaskAbortException("Bad data format", e);
        }
        catch (InterruptedException e) {
            throw new TaskAbortException("interrupted", e);
        }
        finally {
            proc_pull.close();
            proc_push.close();
            if (proc_val != null) {
                proc_val.close();
            }
            proc_deflate.close();
        }
    }

    public <Q, R> NodeTranslator<Q, R> makeNodeTranslator(Translator<K, Q> ktr, Translator<SkeletonTreeMap<K, V>, R> mtr) {
        return new NodeTranslator<Q, R>(ktr, mtr);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + ":size=" + this.size;
    }

    public Set<K> keySetAutoDeflate() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public int size() {
                    return SkeletonBTreeMap.this.size();
                }

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        Stack<SkeletonNode> nodestack = new Stack();
                        Stack<Iterator<Map.Entry<K, V>>> itstack = new Stack();
                        SkeletonNode cnode;
                        Iterator<Map.Entry<K, V>> centit;
                        K lastkey;
                        boolean removeok;
                        {
                            this.cnode = (SkeletonNode)SkeletonBTreeMap.this.root;
                            this.centit = this.cnode.entries.entrySet().iterator();
                            this.lastkey = null;
                            this.removeok = false;
                        }

                        @Override
                        public boolean hasNext() {
                            for (Iterator iterator : this.itstack) {
                                if (!iterator.hasNext()) continue;
                                return true;
                            }
                            if (this.centit.hasNext()) {
                                return true;
                            }
                            if (!this.cnode.isLeaf()) {
                                return true;
                            }
                            try {
                                SkeletonBTreeMap.this.deflate();
                            }
                            catch (TaskAbortException e) {
                                throw new RuntimeException(e);
                            }
                            return false;
                        }

                        @Override
                        public K next() {
                            if (this.cnode.isLeaf()) {
                                while (!this.centit.hasNext()) {
                                    if (this.nodestack.empty()) {
                                        assert (this.itstack.empty());
                                        throw new NoSuchElementException();
                                    }
                                    SkeletonNode parent = this.nodestack.pop();
                                    try {
                                        this.cnode.deflate();
                                        parent.deflate(this.cnode.lkey);
                                    }
                                    catch (TaskAbortException e) {
                                        throw new RuntimeException(e);
                                    }
                                    this.cnode = parent;
                                    this.centit = this.itstack.pop();
                                }
                            } else {
                                while (!this.cnode.isLeaf()) {
                                    BTreeMap.Node testnode = (BTreeMap.Node)this.cnode.rnodes.get(this.lastkey);
                                    if (testnode.isGhost()) {
                                        try {
                                            this.cnode.inflate(testnode.lkey, false);
                                        }
                                        catch (TaskAbortException e) {
                                            throw new RuntimeException(e);
                                        }
                                        testnode = (BTreeMap.Node)this.cnode.rnodes.get(this.lastkey);
                                        assert (testnode instanceof SkeletonNode);
                                    }
                                    assert (!testnode.isGhost());
                                    SkeletonNode n = (SkeletonNode)testnode;
                                    this.nodestack.push(this.cnode);
                                    this.itstack.push(this.centit);
                                    this.cnode = n;
                                    this.centit = this.cnode.entries.entrySet().iterator();
                                }
                            }
                            if (!this.centit.hasNext()) {
                                try {
                                    SkeletonBTreeMap.this.deflate();
                                }
                                catch (TaskAbortException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            Object next = this.centit.next().getKey();
                            this.lastkey = next;
                            this.removeok = true;
                            return next;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        private K findstopkey(K stopkey) {
                            SortedMap headmap = this.cnode.entries.headMap(this.lastkey);
                            if (!headmap.isEmpty()) {
                                stopkey = headmap.lastKey();
                                while (SkeletonBTreeMap.this.compare(this.centit.next().getKey(), stopkey) < 0) {
                                }
                            }
                            return stopkey;
                        }
                    };
                }

                @Override
                public void clear() {
                    SkeletonBTreeMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    Object value = SkeletonBTreeMap.this.get(o);
                    return value != null;
                }

                @Override
                public boolean remove(Object o) {
                    if (this.contains(o)) {
                        SkeletonBTreeMap.this.remove(o);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.keySet;
    }

    static {
        Logger.registerClass(SkeletonBTreeMap.class);
        value_exec = null;
        VALUE_EXECUTOR = new Executor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Runnable r) {
                Class<Executors> clazz = Executors.class;
                synchronized (Executors.class) {
                    if (value_exec == null) {
                        value_exec = new ThreadPoolExecutor(0, 64, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    value_exec.execute(r);
                    return;
                }
            }
        };
        deflate_exec = null;
        DEFLATE_EXECUTOR = new Executor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Runnable r) {
                Class<Executors> clazz = Executors.class;
                synchronized (Executors.class) {
                    if (deflate_exec == null) {
                        deflate_exec = new ThreadPoolExecutor(0, 64, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    deflate_exec.execute(r);
                    return;
                }
            }
        };
    }

    public static class TreeTranslator<K, V>
    implements Translator<SkeletonBTreeMap<K, V>, Map<String, Object>> {
        final Translator<K, ?> ktr;
        final Translator<SkeletonTreeMap<K, V>, ?> mtr;

        public TreeTranslator(Translator<K, ?> k, Translator<SkeletonTreeMap<K, V>, ?> m) {
            this.ktr = k;
            this.mtr = m;
        }

        @Override
        public Map<String, Object> app(SkeletonBTreeMap<K, V> tree) {
            if (tree.comparator() != null) {
                throw new UnsupportedOperationException("Sorry, this translator does not (yet) support comparators");
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("node_min", tree.NODE_MIN);
            map.put("size", tree.size);
            Map<String, Object> rmap = tree.makeNodeTranslator(this.ktr, this.mtr).app((SkeletonNode)tree.root);
            map.put("entries", rmap.get("entries"));
            if (!tree.root.isLeaf()) {
                map.put("subnodes", rmap.get("subnodes"));
            }
            return map;
        }

        @Override
        public SkeletonBTreeMap<K, V> rev(Map<String, Object> map) throws DataFormatException {
            try {
                SkeletonBTreeMap<K, V> tree = new SkeletonBTreeMap<K, V>((Integer)map.get("node_min"));
                tree.size = (Integer)map.get("size");
                tree.root = tree.makeNodeTranslator(this.ktr, this.mtr).rev(map);
                if (tree.size != tree.root.totalSize()) {
                    throw new DataFormatException("Mismatched sizes - tree: " + tree.size + "; root: " + tree.root.totalSize(), null, null);
                }
                return tree;
            }
            catch (ClassCastException e) {
                throw new DataFormatException("Could not build SkeletonBTreeMap from data", e, map, null, null);
            }
        }
    }

    public class NodeTranslator<Q, R>
    implements Translator<SkeletonNode, Map<String, Object>> {
        final Translator<K, Q> ktr;
        final Translator<SkeletonTreeMap<K, V>, R> mtr;

        public NodeTranslator(Translator<K, Q> k, Translator<SkeletonTreeMap<K, V>, R> m) {
            this.ktr = k;
            this.mtr = m;
        }

        @Override
        public Map<String, Object> app(SkeletonNode node) {
            if (!node.isBare()) {
                throw new IllegalStateException("Cannot translate non-bare node " + node.getRange() + "; size:" + node.nodeSize() + "; ghosts:" + node.ghosts + "; root:" + (SkeletonBTreeMap.this.root == node));
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("lkey", this.ktr == null ? node.lkey : this.ktr.app(node.lkey));
            map.put("rkey", this.ktr == null ? node.rkey : this.ktr.app(node.rkey));
            map.put("entries", this.mtr == null ? node.entries : this.mtr.app((SkeletonTreeMap)node.entries));
            if (!node.isLeaf()) {
                LinkedHashMap<Object, Integer> subnodes = new LinkedHashMap<Object, Integer>();
                for (Tuples.X3 next : node.iterNodesK()) {
                    GhostNode gh = (GhostNode)next._1;
                    subnodes.put(gh.getMeta(), gh.totalSize());
                }
                map.put("subnodes", subnodes);
            }
            return map;
        }

        @Override
        public SkeletonNode rev(Map<String, Object> map) throws DataFormatException {
            try {
                SkeletonNode node;
                boolean notleaf = map.containsKey("subnodes");
                ArrayList<GhostNode> gh = null;
                if (notleaf) {
                    Map subnodes = (Map)map.get("subnodes");
                    gh = new ArrayList<GhostNode>(subnodes.size());
                    for (Map.Entry en : subnodes.entrySet()) {
                        GhostNode ghost = new GhostNode(null, null, null, (Integer)en.getValue());
                        ghost.setMeta(en.getKey());
                        gh.add(ghost);
                    }
                }
                if (!(node = new SkeletonNode(this.ktr == null ? map.get("lkey") : this.ktr.rev(map.get("lkey")), this.ktr == null ? map.get("rkey") : this.ktr.rev(map.get("rkey")), !notleaf, this.mtr == null ? (SkeletonTreeMap)map.get("entries") : this.mtr.rev(map.get("entries")), gh)).isBare()) {
                    throw new IllegalStateException("map-translator did not produce a bare SkeletonTreeMap: " + this.mtr);
                }
                SkeletonBTreeMap.this.verifyNodeIntegrity(node);
                return node;
            }
            catch (ClassCastException e) {
                throw new DataFormatException("Could not build SkeletonNode from data", e, map, null, null);
            }
            catch (IllegalArgumentException e) {
                throw new DataFormatException("Could not build SkeletonNode from data", e, map, null, null);
            }
            catch (IllegalStateException e) {
                throw new DataFormatException("Could not build SkeletonNode from data", e, map, null, null);
            }
        }
    }

    public class GhostNode
    extends BTreeMap.Node {
        protected SkeletonNode parent;
        protected Object meta;

        protected GhostNode(K lk, K rk, SkeletonNode p, int s) {
            super(lk, rk, false, null);
            this.parent = p;
            this._size = s;
        }

        protected GhostNode(K lk, K rk, int s) {
            this(lk, rk, null, s);
        }

        public Object getMeta() {
            return this.meta;
        }

        public void setMeta(Object m) {
            this.meta = m;
        }

        @Override
        public int nodeSize() {
            throw new DataNotLoadedException("BTreeMap Node not loaded: " + this.getRange(), (Skeleton)this.parent, this.lkey, (Object)this);
        }

        @Override
        public int childCount() {
            throw new DataNotLoadedException("BTreeMap Node not loaded: " + this.getRange(), (Skeleton)this.parent, this.lkey, (Object)this);
        }

        @Override
        public boolean isLeaf() {
            throw new DataNotLoadedException("BTreeMap Node not loaded: " + this.getRange(), (Skeleton)this.parent, this.lkey, (Object)this);
        }

        @Override
        public BTreeMap.Node nodeL(BTreeMap.Node n) {
            throw new AssertionError((Object)"GhostNode: called nodeL()");
        }

        @Override
        public BTreeMap.Node nodeR(BTreeMap.Node n) {
            throw new AssertionError((Object)"GhostNode: called nodeR()");
        }

        @Override
        public BTreeMap.Node selectNode(K key) {
            throw new AssertionError((Object)"GhostNode: called selectNode()");
        }
    }

    public class SkeletonNode
    extends BTreeMap.Node
    implements Skeleton<K, IterableSerialiser<SkeletonNode>> {
        protected int ghosts;

        protected SkeletonNode(K lk, K rk, boolean lf, SkeletonTreeMap<K, V> map) {
            super(lk, rk, lf, map);
            this.ghosts = 0;
            this.setSerialiser();
        }

        protected SkeletonNode(K lk, K rk, boolean lf) {
            this(lk, rk, lf, new SkeletonTreeMap(skeletonBTreeMap.comparator));
        }

        protected SkeletonNode(K lk, K rk, boolean lf, SkeletonTreeMap<K, V> map, Collection<GhostNode> gh) {
            this(lk, rk, lf, map);
            this._size = map.size();
            if (!lf) {
                if (map.size() + 1 != gh.size()) {
                    throw new IllegalArgumentException("SkeletonNode: in constructing " + this.getName() + ", got size mismatch: map:" + map.size() + "; gh:" + gh.size());
                }
                Iterator<GhostNode> it = gh.iterator();
                for (Tuples.X2 kp : this.iterKeyPairs()) {
                    GhostNode ghost = it.next();
                    ghost.lkey = kp._0;
                    ghost.rkey = kp._1;
                    ghost.parent = this;
                    this._size += ghost._size;
                    this.addChildNode(ghost);
                }
                this.ghosts = gh.size();
            }
        }

        public void setSerialiser() {
            ((SkeletonTreeMap)this.entries).setSerialiser(SkeletonBTreeMap.this.vsrl);
            if (!this.isLeaf()) {
                for (BTreeMap.Node n : this.iterNodes()) {
                    if (n.isGhost()) continue;
                    ((SkeletonNode)n).setSerialiser();
                }
            }
        }

        public GhostNode makeGhost(Object meta) {
            GhostNode ghost = new GhostNode(this.lkey, this.rkey, this.totalSize());
            ghost.setMeta(meta);
            return ghost;
        }

        @Override
        public Object getMeta() {
            return null;
        }

        @Override
        public void setMeta(Object m) {
        }

        @Override
        public IterableSerialiser<SkeletonNode> getSerialiser() {
            return SkeletonBTreeMap.this.nsrl;
        }

        @Override
        public boolean isLive() {
            if (this.ghosts > 0 || !((SkeletonTreeMap)this.entries).isLive()) {
                return false;
            }
            if (!this.isLeaf()) {
                for (BTreeMap.Node n : this.iterNodes()) {
                    SkeletonNode skel = (SkeletonNode)n;
                    if (skel.isLive()) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isBare() {
            if (!this.isLeaf() && this.ghosts < this.childCount()) {
                return false;
            }
            return ((SkeletonTreeMap)this.entries).isBare();
        }

        @Override
        protected void addChildNode(BTreeMap.Node child) {
            super.addChildNode(child);
            if (child.isGhost()) {
                ++this.ghosts;
            }
        }

        protected void setChildNode(BTreeMap.Node child) {
            assert (this.lnodes.containsKey(child.rkey));
            assert (this.rnodes.containsKey(child.lkey));
            assert (this.lnodes.get(child.rkey) == this.rnodes.get(child.lkey));
            this.lnodes.put(child.rkey, child);
            this.rnodes.put(child.lkey, child);
        }

        protected void attachGhost(GhostNode ghost) {
            assert (!((BTreeMap.Node)this.rnodes.get(ghost.lkey)).isGhost());
            ghost.parent = this;
            this.setChildNode(ghost);
            ++this.ghosts;
        }

        protected void attachSkeleton(SkeletonNode skel) {
            assert (((BTreeMap.Node)this.rnodes.get(skel.lkey)).isGhost());
            this.setChildNode(skel);
            --this.ghosts;
        }

        @Override
        public void deflate() throws TaskAbortException {
            if (!this.isLeaf()) {
                ArrayList tasks = new ArrayList(this.childCount() - this.ghosts);
                for (BTreeMap.Node node : this.iterNodes()) {
                    if (node.isGhost()) continue;
                    if (!((SkeletonNode)node).isBare()) {
                        ((SkeletonNode)node).deflate();
                    }
                    tasks.add(new Serialiser.PushTask<SkeletonNode>((SkeletonNode)node));
                }
                SkeletonBTreeMap.this.nsrl.push(tasks);
                for (Serialiser.PushTask pushTask : tasks) {
                    try {
                        this.attachGhost((GhostNode)pushTask.meta);
                    }
                    catch (RuntimeException e) {
                        throw new TaskAbortException("Could not deflate BTreeMap Node " + this.getRange(), e);
                    }
                }
            }
            ((SkeletonTreeMap)this.entries).deflate();
            assert (this.isBare());
        }

        @Override
        public void inflate() throws TaskAbortException {
            ((SkeletonTreeMap)this.entries).inflate();
            if (!this.isLeaf()) {
                for (BTreeMap.Node node : this.iterNodes()) {
                    this.inflate(node.lkey, true);
                }
            }
            assert (this.isLive());
        }

        @Override
        public void inflate(K key) throws TaskAbortException {
            this.inflate(key, false);
        }

        @Override
        public void deflate(K key) throws TaskAbortException {
            if (this.isLeaf()) {
                return;
            }
            BTreeMap.Node node = (BTreeMap.Node)this.rnodes.get(key);
            if (node.isGhost()) {
                return;
            }
            if (!((SkeletonNode)node).isBare()) {
                throw new IllegalStateException("Cannot deflate non-bare BTreeMap node");
            }
            Serialiser.PushTask<SkeletonNode> task = new Serialiser.PushTask<SkeletonNode>((SkeletonNode)node);
            try {
                SkeletonBTreeMap.this.nsrl.push(task);
                this.attachGhost((GhostNode)task.meta);
            }
            catch (TaskCompleteException e) {
                assert (node.isGhost());
            }
            catch (RuntimeException e) {
                throw new TaskAbortException("Could not deflate BTreeMap Node " + node.getRange(), e);
            }
        }

        public void inflate(K key, boolean auto) throws TaskAbortException {
            if (this.isLeaf()) {
                return;
            }
            BTreeMap.Node node = (BTreeMap.Node)this.rnodes.get(key);
            if (!node.isGhost()) {
                return;
            }
            Serialiser.PullTask<SkeletonNode> task = new Serialiser.PullTask<SkeletonNode>(node);
            try {
                SkeletonBTreeMap.this.nsrl.pull(task);
                SkeletonBTreeMap.this.postPullTask(task, this);
                if (auto) {
                    ((SkeletonNode)task.data).inflate();
                }
            }
            catch (TaskCompleteException e) {
                assert (!node.isGhost());
            }
            catch (DataFormatException e) {
                throw new TaskAbortException("Could not inflate BTreeMap Node " + node.getRange(), e);
            }
            catch (RuntimeException e) {
                throw new TaskAbortException("Could not inflate BTreeMap Node " + node.getRange(), e);
            }
        }
    }
}

