/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Hashtable4;
import com.db4o.io.IoAdapter;

public class MemoryIoAdapter
extends IoAdapter {
    private byte[] _bytes;
    private int _length;
    private int _seekPos;
    private Hashtable4 _memoryFiles;
    private int _growBy;

    public MemoryIoAdapter() {
        this._memoryFiles = new Hashtable4();
        this._growBy = 10000;
    }

    public MemoryIoAdapter(int initialLength) {
        this();
        this._bytes = new byte[initialLength];
    }

    private MemoryIoAdapter(MemoryIoAdapter adapter, byte[] bytes) {
        this._bytes = bytes;
        this._length = bytes.length;
        this._growBy = adapter._growBy;
    }

    private MemoryIoAdapter(MemoryIoAdapter adapter, int initialLength) {
        this(adapter, new byte[initialLength]);
    }

    public void put(String name, byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        this._memoryFiles.put(name, (Object)new MemoryIoAdapter(this, bytes));
    }

    public byte[] get(String name) {
        MemoryIoAdapter mia = (MemoryIoAdapter)this._memoryFiles.get(name);
        if (mia == null) {
            return null;
        }
        return mia._bytes;
    }

    public void growBy(int length) {
        if (length < 1) {
            length = 1;
        }
        this._growBy = length;
    }

    @Override
    public void close() throws Db4oIOException {
    }

    @Override
    public void delete(String path) {
        this._memoryFiles.remove(path);
    }

    @Override
    public boolean exists(String path) {
        MemoryIoAdapter mia = (MemoryIoAdapter)this._memoryFiles.get(path);
        if (mia == null) {
            return false;
        }
        return mia._length > 0;
    }

    @Override
    public long getLength() throws Db4oIOException {
        return this._length;
    }

    @Override
    public IoAdapter open(String path, boolean lockFile, long initialLength, boolean readOnly) throws Db4oIOException {
        MemoryIoAdapter mia = (MemoryIoAdapter)this._memoryFiles.get(path);
        if (mia == null) {
            mia = new MemoryIoAdapter(this, (int)initialLength);
            this._memoryFiles.put(path, (Object)mia);
        }
        return mia;
    }

    @Override
    public int read(byte[] bytes, int length) throws Db4oIOException {
        System.arraycopy(this._bytes, this._seekPos, bytes, 0, length);
        this._seekPos += length;
        return length;
    }

    @Override
    public void seek(long pos) throws Db4oIOException {
        this._seekPos = (int)pos;
    }

    @Override
    public void sync() throws Db4oIOException {
    }

    @Override
    public void write(byte[] buffer, int length) throws Db4oIOException {
        if (this._seekPos + length > this._bytes.length) {
            int growBy = this._growBy;
            if (this._seekPos + length > growBy) {
                growBy = this._seekPos + length;
            }
            byte[] temp = new byte[this._bytes.length + growBy];
            System.arraycopy(this._bytes, 0, temp, 0, this._length);
            this._bytes = temp;
        }
        System.arraycopy(buffer, 0, this._bytes, this._seekPos, length);
        this._seekPos += length;
        if (this._seekPos > this._length) {
            this._length = this._seekPos;
        }
    }
}

