/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.CPUInformation;

import freenet.support.CPUInformation.AMDCPUInfo;
import freenet.support.CPUInformation.CPUInfo;
import freenet.support.CPUInformation.IntelCPUInfo;
import freenet.support.CPUInformation.UnknownCPUException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class CPUID {
    private static boolean _nativeOk = false;
    private static final boolean _doLog = true;
    private static final boolean isX86 = System.getProperty("os.arch").toLowerCase().matches("(i?[x0-9]86(_64)?|amd64)");

    private static native CPUIDResult doCPUID(int var0);

    private static String getCPUVendorID() {
        CPUIDResult c = CPUID.doCPUID(0);
        StringBuilder sb = new StringBuilder(13);
        sb.append((char)(c.EBX & 0xFF));
        sb.append((char)(c.EBX >> 8 & 0xFF));
        sb.append((char)(c.EBX >> 16 & 0xFF));
        sb.append((char)(c.EBX >> 24 & 0xFF));
        sb.append((char)(c.EDX & 0xFF));
        sb.append((char)(c.EDX >> 8 & 0xFF));
        sb.append((char)(c.EDX >> 16 & 0xFF));
        sb.append((char)(c.EDX >> 24 & 0xFF));
        sb.append((char)(c.ECX & 0xFF));
        sb.append((char)(c.ECX >> 8 & 0xFF));
        sb.append((char)(c.ECX >> 16 & 0xFF));
        sb.append((char)(c.ECX >> 24 & 0xFF));
        return sb.toString();
    }

    private static int getCPUFamily() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 8 & 0xF;
    }

    private static int getCPUModel() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 4 & 0xF;
    }

    private static int getCPUExtendedFamily() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 20 & 0xFF;
    }

    private static int getCPUStepping() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX & 0xF;
    }

    private static int getCPUFlags() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EDX;
    }

    public static CPUInfo getInfo() throws UnknownCPUException {
        if (!_nativeOk) {
            throw new UnknownCPUException("Failed to read CPU information from the system. Please verify the existence of the jcpuid dll/so.");
        }
        if (!isX86) {
            throw new UnknownCPUException("Failed to read CPU information from the system. The CPUID instruction exists on x86 CPU's only");
        }
        if (CPUID.getCPUVendorID().equals("AuthenticAMD")) {
            return new AMDInfoImpl();
        }
        if (CPUID.getCPUVendorID().equals("GenuineIntel")) {
            return new IntelInfoImpl();
        }
        throw new UnknownCPUException("Unknown CPU type: '" + CPUID.getCPUVendorID() + '\'');
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("os.arch").toLowerCase());
        if (!_nativeOk) {
            System.out.println("**Failed to retrieve CPUInfo. Please verify the existence of jcpuid dll/so**");
        }
        System.out.println("**CPUInfo**");
        System.out.println("CPU Vendor: " + CPUID.getCPUVendorID());
        System.out.println("CPU Family: " + CPUID.getCPUFamily());
        System.out.println("CPU Extended Family: " + CPUID.getCPUExtendedFamily());
        System.out.println("CPU Model: " + CPUID.getCPUModel());
        System.out.println("CPU Stepping: " + CPUID.getCPUStepping());
        System.out.println("CPU Flags: " + CPUID.getCPUFlags());
        CPUInfo c = CPUID.getInfo();
        System.out.println(" **More CPUInfo**");
        System.out.println(" CPU model string: " + c.getCPUModelString());
        System.out.println(" CPU has MMX: " + c.hasMMX());
        System.out.println(" CPU has SSE: " + c.hasSSE());
        System.out.println(" CPU has SSE2: " + c.hasSSE2());
        if (c instanceof IntelCPUInfo) {
            System.out.println("  **Intel-info**");
            System.out.println("  Is pII-compatible: " + ((IntelCPUInfo)c).IsPentium2Compatible());
            System.out.println("  Is pIII-compatible: " + ((IntelCPUInfo)c).IsPentium3Compatible());
            System.out.println("  Is pIV-compatible: " + ((IntelCPUInfo)c).IsPentium4Compatible());
        }
        if (c instanceof AMDCPUInfo) {
            System.out.println("  **AMD-info**");
            System.out.println("  Is Athlon-compatible: " + ((AMDCPUInfo)c).IsAthlonCompatible());
            System.out.println("  Is Athlon64-compatible: " + ((AMDCPUInfo)c).IsAthlon64Compatible());
        }
    }

    private static final void loadNative() {
        try {
            String wantedProp = System.getProperty("jcpuid.enable", "true");
            boolean wantNative = "true".equalsIgnoreCase(wantedProp);
            if (wantNative) {
                boolean loaded = CPUID.loadFromResource();
                if (loaded) {
                    _nativeOk = true;
                    System.err.println("INFO: Native CPUID library '" + CPUID.getResourceName() + "' loaded from resource");
                } else {
                    loaded = CPUID.loadGeneric();
                    if (loaded) {
                        _nativeOk = true;
                        System.err.println("INFO: Native CPUID library '" + CPUID.getLibraryMiddlePart() + "' loaded from somewhere in the path");
                    } else {
                        _nativeOk = false;
                        System.err.println("WARN: Native CPUID library jcpuid not loaded - will not be able to read CPU information using CPUID");
                    }
                }
            } else {
                System.err.println("INFO: Native CPUID library jcpuid not loaded - will not be able to read CPU information using CPUID");
            }
        }
        catch (Exception e) {
            System.err.println("INFO: Native CPUID library jcpuid not loaded, reason: '" + e.getMessage() + "' - will not be able to read CPU information using CPUID");
        }
    }

    private static final boolean loadGeneric() {
        try {
            System.loadLibrary(CPUID.getLibraryMiddlePart());
            return true;
        }
        catch (UnsatisfiedLinkError ule) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean loadFromResource() {
        String resourceName = CPUID.getResourceName();
        if (resourceName == null) {
            return false;
        }
        URL resource = CPUID.class.getClassLoader().getResource(resourceName);
        if (resource == null) {
            System.err.println("ERROR: Resource name [" + resourceName + "] was not found");
            return false;
        }
        File outFile = null;
        try {
            int read;
            InputStream libStream = resource.openStream();
            try {
                outFile = File.createTempFile("jcpuid", "lib.tmp");
            }
            catch (IOException e) {
                System.err.println("freenet.support.CPUInformation.CPUID: Can't create the temporary file in " + System.getProperty("java.io.tmpdir") + " trying something else now.");
                outFile = new File("cpuid-lib.tmp");
            }
            FileOutputStream fos = new FileOutputStream(outFile);
            byte[] buf = new byte[0x400000];
            while ((read = libStream.read(buf)) >= 0) {
                fos.write(buf, 0, read);
            }
            fos.close();
            System.load(outFile.getAbsolutePath());
            boolean bl = true;
            return bl;
        }
        catch (UnsatisfiedLinkError ule) {
            System.err.println("ERROR: The resource " + resourceName + " was not a valid library for this platform");
            ule.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            System.err.println("ERROR: Problem writing out the temporary native library data");
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (outFile != null) {
                outFile.deleteOnExit();
            }
        }
    }

    private static final String getResourceName() {
        String pname = CPUID.class.getPackage().getName().replace('.', '/');
        return pname + '/' + CPUID.getLibraryPrefix() + CPUID.getLibraryMiddlePart() + '.' + CPUID.getLibrarySuffix();
    }

    private static final String getLibraryPrefix() {
        boolean isWindows;
        boolean bl = isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        if (isWindows) {
            return "";
        }
        return "lib";
    }

    private static final String getLibraryMiddlePart() {
        boolean isMacOS;
        boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
        boolean isFreebsd = System.getProperty("os.name").toLowerCase().indexOf("freebsd") != -1;
        boolean bl = isMacOS = System.getProperty("os.name").toLowerCase().indexOf("mac os x") != -1;
        if (isWindows) {
            return "jcpuid-x86-windows";
        }
        if (isLinux) {
            return "jcpuid-x86-linux";
        }
        if (isFreebsd) {
            return "jcpuid-x86-freebsd";
        }
        if (isMacOS) {
            return "jcpuid-x86-osx";
        }
        throw new RuntimeException("Dont know jcpuid library name for os type '" + System.getProperty("os.name") + '\'');
    }

    private static final String getLibrarySuffix() {
        boolean isWindows;
        boolean bl = isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        if (isWindows) {
            return "dll";
        }
        return "so";
    }

    static {
        CPUID.loadNative();
    }

    protected static class IntelInfoImpl
    extends CPUIDCPUInfo
    implements IntelCPUInfo {
        protected IntelInfoImpl() {
        }

        @Override
        public boolean IsPentiumCompatible() {
            return CPUID.getCPUFamily() >= 5;
        }

        @Override
        public boolean IsPentiumMMXCompatible() {
            return this.IsPentium2Compatible() || CPUID.getCPUFamily() == 5 && (CPUID.getCPUModel() == 4 || CPUID.getCPUModel() == 8);
        }

        @Override
        public boolean IsPentium2Compatible() {
            return CPUID.getCPUFamily() > 6 || CPUID.getCPUFamily() == 6 && CPUID.getCPUModel() >= 3;
        }

        @Override
        public boolean IsPentium3Compatible() {
            return CPUID.getCPUFamily() > 6 || CPUID.getCPUFamily() == 6 && CPUID.getCPUModel() >= 7;
        }

        @Override
        public boolean IsPentium4Compatible() {
            return CPUID.getCPUFamily() >= 15;
        }

        @Override
        public String getCPUModelString() throws UnknownCPUException {
            if (CPUID.getCPUFamily() == 4) {
                switch (CPUID.getCPUModel()) {
                    case 0: {
                        return "486 DX-25/33";
                    }
                    case 1: {
                        return "486 DX-50";
                    }
                    case 2: {
                        return "486 SX";
                    }
                    case 3: {
                        return "486 DX/2";
                    }
                    case 4: {
                        return "486 SL";
                    }
                    case 5: {
                        return "486 SX/2";
                    }
                    case 7: {
                        return "486 DX/2-WB";
                    }
                    case 8: {
                        return "486 DX/4";
                    }
                    case 9: {
                        return "486 DX/4-WB";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 5) {
                switch (CPUID.getCPUModel()) {
                    case 0: {
                        return "Pentium 60/66 A-step";
                    }
                    case 1: {
                        return "Pentium 60/66";
                    }
                    case 2: {
                        return "Pentium 75 - 200";
                    }
                    case 3: {
                        return "OverDrive PODP5V83";
                    }
                    case 4: {
                        return "Pentium MMX";
                    }
                    case 7: {
                        return "Mobile Pentium 75 - 200";
                    }
                    case 8: {
                        return "Mobile Pentium MMX";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 6) {
                switch (CPUID.getCPUModel()) {
                    case 0: {
                        return "Pentium Pro A-step";
                    }
                    case 1: {
                        return "Pentium Pro";
                    }
                    case 3: {
                        return "Pentium II (Klamath)";
                    }
                    case 5: {
                        return "Pentium II (Deschutes), Celeron (Covington), Mobile Pentium II (Dixon)";
                    }
                    case 6: {
                        return "Mobile Pentium II, Celeron (Mendocino)";
                    }
                    case 7: {
                        return "Pentium III (Katmai)";
                    }
                    case 8: {
                        return "Pentium III (Coppermine), Celeron w/SSE";
                    }
                    case 9: {
                        return "Mobile Pentium III";
                    }
                    case 10: {
                        return "Pentium III Xeon (Cascades)";
                    }
                    case 11: {
                        return "Pentium III (130 nm)";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 7) {
                CPUID.getCPUModel();
            }
            if (CPUID.getCPUFamily() == 15) {
                if (CPUID.getCPUExtendedFamily() == 0) {
                    switch (CPUID.getCPUModel()) {
                        case 0: {
                            return "Pentium IV (180 nm)";
                        }
                        case 1: {
                            return "Pentium IV (180 nm)";
                        }
                        case 2: {
                            return "Pentium IV (130 nm)";
                        }
                        case 3: {
                            return "Pentium IV (90 nm)";
                        }
                    }
                }
                if (CPUID.getCPUExtendedFamily() == 1) {
                    CPUID.getCPUModel();
                }
            }
            throw new UnknownCPUException("Unknown Intel CPU; Family=" + CPUID.getCPUFamily() + ", Model=" + CPUID.getCPUModel());
        }
    }

    protected static class AMDInfoImpl
    extends CPUIDCPUInfo
    implements AMDCPUInfo {
        protected AMDInfoImpl() {
        }

        @Override
        public boolean IsK6Compatible() {
            return CPUID.getCPUFamily() >= 5 && CPUID.getCPUModel() >= 6;
        }

        @Override
        public boolean IsK6_2_Compatible() {
            return CPUID.getCPUFamily() >= 5 && CPUID.getCPUModel() >= 8;
        }

        @Override
        public boolean IsK6_3_Compatible() {
            return CPUID.getCPUFamily() >= 5 && CPUID.getCPUModel() >= 9;
        }

        @Override
        public boolean IsAthlonCompatible() {
            return CPUID.getCPUFamily() >= 6;
        }

        @Override
        public boolean IsAthlon64Compatible() {
            return CPUID.getCPUFamily() == 15 && CPUID.getCPUExtendedFamily() == 0;
        }

        @Override
        public String getCPUModelString() throws UnknownCPUException {
            if (CPUID.getCPUFamily() == 4) {
                switch (CPUID.getCPUModel()) {
                    case 3: {
                        return "486 DX/2";
                    }
                    case 7: {
                        return "486 DX/2-WB";
                    }
                    case 8: {
                        return "486 DX/4";
                    }
                    case 9: {
                        return "486 DX/4-WB";
                    }
                    case 14: {
                        return "Am5x86-WT";
                    }
                    case 15: {
                        return "Am5x86-WB";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 5) {
                switch (CPUID.getCPUModel()) {
                    case 0: {
                        return "K5/SSA5";
                    }
                    case 1: {
                        return "K5";
                    }
                    case 2: {
                        return "K5";
                    }
                    case 3: {
                        return "K5";
                    }
                    case 6: {
                        return "K6";
                    }
                    case 7: {
                        return "K6";
                    }
                    case 8: {
                        return "K6-2";
                    }
                    case 9: {
                        return "K6-3";
                    }
                    case 13: {
                        return "K6-2+ or K6-III+";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 6) {
                switch (CPUID.getCPUModel()) {
                    case 0: {
                        return "Athlon (250 nm)";
                    }
                    case 1: {
                        return "Athlon (250 nm)";
                    }
                    case 2: {
                        return "Athlon (180 nm)";
                    }
                    case 3: {
                        return "Duron";
                    }
                    case 4: {
                        return "Athlon (Thunderbird)";
                    }
                    case 6: {
                        return "Athlon (Palamino)";
                    }
                    case 7: {
                        return "Duron (Morgan)";
                    }
                    case 8: {
                        return "Athlon (Thoroughbred)";
                    }
                    case 10: {
                        return "Athlon (Barton)";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 15 && CPUID.getCPUExtendedFamily() == 0) {
                switch (CPUID.getCPUModel()) {
                    case 4: {
                        return "Athlon 64";
                    }
                    case 5: {
                        return "Athlon 64 FX Opteron";
                    }
                    case 7: {
                        return "Athlon 64 (0.13 um 939)";
                    }
                    case 8: {
                        return "Athlon 64 (0.13 um 754)";
                    }
                    case 11: {
                        return "Athlon 64 (0.13 um 939)";
                    }
                    case 12: {
                        return "Athlon 64 (0.13 um 754)";
                    }
                    case 15: {
                        return "Athlon 64 (0.13 um 939)";
                    }
                }
            }
            throw new UnknownCPUException("Unknown AMD CPU; Family=" + CPUID.getCPUFamily() + ", Model=" + CPUID.getCPUModel());
        }
    }

    protected static abstract class CPUIDCPUInfo {
        protected CPUIDCPUInfo() {
        }

        public String getVendor() {
            return CPUID.getCPUVendorID();
        }

        public boolean hasMMX() {
            return (CPUID.getCPUFlags() & 0x800000) != 0;
        }

        public boolean hasSSE() {
            return (CPUID.getCPUFlags() & 0x2000000) != 0;
        }

        public boolean hasSSE2() {
            return (CPUID.getCPUFlags() & 0x4000000) != 0;
        }
    }

    protected static class CPUIDResult {
        final int EAX;
        final int EBX;
        final int ECX;
        final int EDX;

        CPUIDResult(int EAX, int EBX, int ECX, int EDX) {
            this.EAX = EAX;
            this.EBX = EBX;
            this.ECX = ECX;
            this.EDX = EDX;
        }
    }
}

