/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeySalter;
import freenet.crypt.RandomSource;
import freenet.crypt.SHA256;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.SendableGet;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;

class KeyListenerTracker
implements KeySalter {
    private static volatile boolean logMINOR;
    private static final int MIN_RETRY_COUNT = 3;
    final boolean isInsertScheduler;
    final boolean isSSKScheduler;
    final boolean isRTScheduler;
    protected final ClientRequestScheduler sched;
    protected final ArrayList<KeyListener> keyListeners;
    final boolean persistent;
    public byte[] globalSalt;

    public boolean persistent() {
        return this.persistent;
    }

    protected KeyListenerTracker(boolean forInserts, boolean forSSKs, boolean forRT, RandomSource random, ClientRequestScheduler sched, byte[] globalSalt, boolean persistent) {
        this.isInsertScheduler = forInserts;
        this.isSSKScheduler = forSSKs;
        this.isRTScheduler = forRT;
        this.sched = sched;
        this.keyListeners = new ArrayList();
        if (globalSalt == null) {
            globalSalt = new byte[32];
            random.nextBytes(globalSalt);
        }
        this.globalSalt = globalSalt;
        this.persistent = persistent;
    }

    protected static int fixRetryCount(int retryCount) {
        return Math.max(0, retryCount - 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingKeys(KeyListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            if (this.keyListeners.contains(listener)) {
                return;
            }
            this.keyListeners.add(listener);
        }
        if (logMINOR) {
            Logger.minor(this, "Added pending keys to " + this + " : size now " + this.keyListeners.size() + " : " + listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePendingKeys(KeyListener listener) {
        boolean ret;
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            ret = this.keyListeners.remove(listener);
            while (logMINOR && this.keyListeners.remove(listener)) {
                Logger.error(this, "Still in pending keys after removal, must be in twice or more: " + listener, (Throwable)new Exception("error"));
            }
            listener.onRemove();
        }
        if (logMINOR) {
            Logger.minor(this, "Removed pending keys from " + this + " : size now " + this.keyListeners.size() + " : " + listener, (Throwable)new Exception("debug"));
        }
        return ret;
    }

    public synchronized boolean removePendingKeys(HasKeyListener hasListener) {
        boolean found = false;
        Iterator<KeyListener> i = this.keyListeners.iterator();
        while (i.hasNext()) {
            KeyListener listener = i.next();
            if (listener == null) {
                i.remove();
                Logger.error(this, "Null KeyListener in removePendingKeys()");
                continue;
            }
            if (listener.getHasKeyListener() != hasListener) continue;
            found = true;
            i.remove();
            listener.onRemove();
            Logger.normal(this, "Removed pending keys from " + this + " : size now " + this.keyListeners.size() + " : " + listener);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getKeyPrio(Key key, short priority, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        ArrayList<KeyListener> matches = null;
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            for (KeyListener listener : this.keyListeners) {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                if (matches == null) {
                    matches = new ArrayList<KeyListener>();
                }
                matches.add(listener);
            }
        }
        if (matches == null) {
            return priority;
        }
        for (KeyListener listener : matches) {
            short prio = listener.definitelyWantKey(key, saltedKey, this.sched.clientContext);
            if (prio == -1 || prio >= priority) continue;
            priority = prio;
        }
        return priority;
    }

    public synchronized long countWaitingKeys() {
        long count = 0L;
        for (KeyListener listener : this.keyListeners) {
            count += listener.countKeys();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anyWantKey(Key key, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        ArrayList<KeyListener> matches = null;
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            for (KeyListener listener : this.keyListeners) {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                if (matches == null) {
                    matches = new ArrayList<KeyListener>();
                }
                matches.add(listener);
            }
        }
        if (matches != null) {
            for (KeyListener listener : matches) {
                if (listener.definitelyWantKey(key, saltedKey, this.sched.clientContext) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean anyProbablyWantKey(Key key, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        for (KeyListener listener : this.keyListeners) {
            if (!listener.probablyWantKey(key, saltedKey)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tripPendingKey(Key key, KeyBlock block, ClientContext context) {
        if (key instanceof NodeSSK != this.isSSKScheduler) {
            Logger.error(this, "Key " + key + " on scheduler ssk=" + this.isSSKScheduler, (Throwable)new Exception("debug"));
            return false;
        }
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        ArrayList<KeyListener> matches = null;
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            for (KeyListener listener : this.keyListeners) {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                if (matches == null) {
                    matches = new ArrayList<KeyListener>();
                }
                if (matches.contains(listener)) {
                    Logger.error(this, "In matches twice, presumably in keyListeners twice?: " + listener);
                    continue;
                }
                matches.add(listener);
            }
        }
        boolean ret = false;
        if (matches != null) {
            for (KeyListener listener : matches) {
                try {
                    if (listener.handleBlock(key, saltedKey, block, context)) {
                        ret = true;
                    }
                }
                catch (Throwable t) {
                    Logger.error(this, String.format("Error in handleBlock callback for %s", listener), t);
                }
                if (!listener.isEmpty()) continue;
                KeyListenerTracker keyListenerTracker2 = this;
                synchronized (keyListenerTracker2) {
                    this.keyListeners.remove(listener);
                }
                listener.onRemove();
            }
        } else {
            return false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendableGet[] requestsForKey(Key key, ClientContext context) {
        ArrayList<SendableGet> list = null;
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            for (KeyListener listener : this.keyListeners) {
                SendableGet[] reqs;
                if (!listener.probablyWantKey(key, saltedKey) || (reqs = listener.getRequestsForKey(key, saltedKey, context)) == null) continue;
                if (list == null) {
                    list = new ArrayList<SendableGet>();
                }
                for (SendableGet req : reqs) {
                    list.add(req);
                }
            }
        }
        if (list == null) {
            return null;
        }
        return list.toArray(new SendableGet[list.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(':');
        if (this.isInsertScheduler) {
            sb.append("insert:");
        }
        if (this.isSSKScheduler) {
            sb.append("SSK");
        } else {
            sb.append("CHK");
        }
        return sb.toString();
    }

    @Override
    public byte[] saltKey(Key key) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(key.getRoutingKey());
        md.update(this.globalSalt);
        byte[] ret = md.digest();
        SHA256.returnMessageDigest(md);
        return ret;
    }

    protected void hintGlobalSalt(byte[] globalSalt2) {
        if (this.globalSalt == null) {
            this.globalSalt = globalSalt2;
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

