/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.client.Metadata;
import freenet.client.MetadataParseException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.FileGetCompletionCallback;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.KeySalter;
import freenet.client.async.SplitFileFetcherGet;
import freenet.client.async.SplitFileFetcherStorage;
import freenet.client.async.SplitFileFetcherStorageCallback;
import freenet.crypt.CRCChecksumChecker;
import freenet.crypt.ChecksumFailedException;
import freenet.keys.ClientCHKBlock;
import freenet.keys.FreenetURI;
import freenet.node.BaseSendableGet;
import freenet.support.Logger;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.compress.Compressor;
import freenet.support.io.BucketTools;
import freenet.support.io.InsufficientDiskSpaceException;
import freenet.support.io.PooledFileRandomAccessBuffer;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public class SplitFileFetcher
implements ClientGetState,
SplitFileFetcherStorageCallback,
Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    private volatile transient SplitFileFetcherStorage storage;
    private LockableRandomAccessBuffer raf;
    final ClientRequester parent;
    final GetCompletionCallback cb;
    final FileGetCompletionCallback callbackCompleteViaTruncation;
    final File fileCompleteViaTruncation;
    final boolean realTimeFlag;
    final FetchContext blockFetchContext;
    final long token;
    private transient ClientContext context;
    private volatile transient SplitFileFetcherGet getter;
    private boolean failed;
    private boolean succeeded;
    private final boolean wantBinaryBlob;
    private final boolean persistent;
    private int storeFetchCounter;
    private long lastNotifiedStoreFetch;
    static final int STORE_NOTIFY_BLOCKS = 100;
    static final long STORE_NOTIFY_INTERVAL = 200L;

    public SplitFileFetcher(Metadata metadata, GetCompletionCallback rcb, ClientRequester parent, FetchContext fetchContext, boolean realTimeFlag, List<Compressor.COMPRESSOR_TYPE> decompressors, ClientMetadata clientMetadata, long token, boolean topDontCompress, short topCompatibilityMode, boolean persistent, FreenetURI thisKey, boolean isFinalFetch, ClientContext context) throws FetchException, MetadataParseException {
        this.persistent = persistent;
        this.cb = rcb;
        this.parent = parent;
        this.realTimeFlag = realTimeFlag;
        this.token = token;
        this.context = context;
        this.wantBinaryBlob = parent instanceof ClientGetter ? ((ClientGetter)parent).collectingBinaryBlob() : false;
        this.blockFetchContext = new FetchContext(fetchContext, 1, true, null);
        if (parent.isCancelled()) {
            throw new FetchException(FetchException.FetchExceptionMode.CANCELLED);
        }
        try {
            if (isFinalFetch && this.cb instanceof FileGetCompletionCallback && (decompressors == null || decompressors.size() == 0) && !fetchContext.filterData) {
                FileGetCompletionCallback fileCallback = (FileGetCompletionCallback)this.cb;
                File targetFile = fileCallback.getCompletionFile();
                if (targetFile != null) {
                    this.callbackCompleteViaTruncation = fileCallback;
                    this.fileCompleteViaTruncation = File.createTempFile(targetFile.getName(), ".freenet-tmp", targetFile.getParentFile());
                } else {
                    this.callbackCompleteViaTruncation = null;
                    this.fileCompleteViaTruncation = null;
                }
            } else {
                this.callbackCompleteViaTruncation = null;
                this.fileCompleteViaTruncation = null;
            }
            CRCChecksumChecker checker = new CRCChecksumChecker();
            this.storage = new SplitFileFetcherStorage(metadata, this, decompressors, clientMetadata, topDontCompress, topCompatibilityMode, fetchContext, realTimeFlag, this.getSalter(), thisKey, parent.getURI(), isFinalFetch, parent.getClientDetail(checker), context.random, context.tempBucketFactory, persistent ? context.persistentRAFFactory : context.tempRAFFactory, persistent ? context.jobRunner : context.dummyJobRunner, context.ticker, context.memoryLimitedJobRunner, checker, persistent, this.fileCompleteViaTruncation, context.getFileRandomAccessBufferFactory(persistent), context.getChkFetchScheduler(realTimeFlag).fetchingKeys());
        }
        catch (InsufficientDiskSpaceException e) {
            throw new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_DISK_SPACE);
        }
        catch (IOException e) {
            Logger.error(this, "Failed to start splitfile fetcher because of disk I/O error?: " + e, (Throwable)e);
            throw new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e);
        }
        long eventualLength = Math.max(this.storage.decompressedLength, metadata.uncompressedDataLength());
        this.cb.onExpectedSize(eventualLength, context);
        if (metadata.uncompressedDataLength() > 0L) {
            this.cb.onFinalizedMetadata();
        }
        if (eventualLength > 0L && fetchContext.maxOutputLength > 0L && eventualLength > fetchContext.maxOutputLength) {
            throw new FetchException(FetchException.FetchExceptionMode.TOO_BIG, eventualLength, true, clientMetadata.getMIMEType());
        }
        this.getter = new SplitFileFetcherGet(this, this.storage);
        this.raf = this.storage.getRAF();
        if (logMINOR) {
            Logger.minor(this, "Created " + (persistent ? "persistent" : "transient") + " download for " + thisKey + " on " + this.raf + " for " + this);
        }
        this.lastNotifiedStoreFetch = System.currentTimeMillis();
    }

    protected SplitFileFetcher() {
        this.parent = null;
        this.cb = null;
        this.realTimeFlag = false;
        this.blockFetchContext = null;
        this.token = 0L;
        this.wantBinaryBlob = false;
        this.persistent = true;
        this.callbackCompleteViaTruncation = null;
        this.fileCompleteViaTruncation = null;
    }

    @Override
    public void schedule(ClientContext context) throws KeyListenerConstructionException {
        if (this.storage.start(false)) {
            this.getter.schedule(context, false);
        }
    }

    @Override
    public void failOnDiskError(IOException e) {
        this.fail(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR));
    }

    @Override
    public void failOnDiskError(ChecksumFailedException e) {
        this.fail(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail(FetchException e) {
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            if (this.succeeded || this.failed) {
                return;
            }
            this.failed = true;
        }
        if (this.storage != null) {
            this.context.getChkFetchScheduler(this.realTimeFlag).removePendingKeys(this.storage.keyListener, true);
        }
        if (this.getter != null) {
            this.getter.cancel(this.context);
        }
        if (this.storage != null) {
            this.storage.cancel();
        }
        this.cb.onFailure(e, this, this.context);
    }

    @Override
    public void cancel(ClientContext context) {
        this.fail(new FetchException(FetchException.FetchExceptionMode.CANCELLED));
    }

    @Override
    public long getToken() {
        return this.token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess() {
        boolean fail = false;
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            if (this.failed) {
                fail = true;
            } else {
                if (this.succeeded) {
                    Logger.error(this, "Called onSuccess() twice on " + this, (Throwable)new Exception("debug"));
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "onSuccess() on " + this, (Throwable)new Exception("debug"));
                }
                this.succeeded = true;
            }
        }
        if (fail) {
            this.storage.finishedFetcher();
            return;
        }
        this.context.getChkFetchScheduler(this.realTimeFlag).removePendingKeys(this.storage.keyListener, true);
        this.getter.cancel(this.context);
        if (this.callbackCompleteViaTruncation != null) {
            long finalLength = this.storage.finalLength;
            this.callbackCompleteViaTruncation.onSuccess(this.fileCompleteViaTruncation, finalLength, this.storage.clientMetadata, (ClientGetState)this, this.context);
        } else {
            this.cb.onSuccess(this.storage.streamGenerator(), this.storage.clientMetadata, this.storage.decompressors, this, this.context);
            this.storage.finishedFetcher();
        }
    }

    @Override
    public void onClosed() {
    }

    @Override
    public short getPriorityClass() {
        return this.parent.getPriorityClass();
    }

    @Override
    public void setSplitfileBlocks(int requiredBlocks, int remainingBlocks) {
        this.parent.addMustSucceedBlocks(requiredBlocks);
        this.parent.addBlocks(remainingBlocks);
        this.parent.notifyClients(this.context);
    }

    @Override
    public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] customSplitfileKey, boolean compressed, boolean bottomLayer, boolean definitiveAnyway) {
        this.cb.onSplitfileCompatibilityMode(min, max, customSplitfileKey, compressed, bottomLayer, definitiveAnyway, this.context);
    }

    @Override
    public void queueHeal(byte[] data, byte[] cryptoKey, byte cryptoAlgorithm) {
        try {
            this.context.healingQueue.queue(BucketTools.makeImmutableBucket(this.context.tempBucketFactory, data), cryptoKey, cryptoAlgorithm, this.context);
        }
        catch (IOException e) {
            Logger.error(this, "I/O error, failed to queue healing block: " + e, (Throwable)e);
        }
    }

    public boolean localRequestOnly() {
        return this.blockFetchContext.localRequestOnly;
    }

    public void toNetwork() {
        this.parent.toNetwork(this.context);
    }

    public boolean hasFinished() {
        return this.failed || this.succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFetchedBlock() {
        boolean dontNotify = true;
        if (this.getter.hasQueued()) {
            dontNotify = false;
        } else {
            SplitFileFetcher splitFileFetcher = this;
            synchronized (splitFileFetcher) {
                if (this.storeFetchCounter++ == 100) {
                    this.storeFetchCounter = 0;
                    dontNotify = false;
                    this.lastNotifiedStoreFetch = System.currentTimeMillis();
                } else {
                    long now = System.currentTimeMillis();
                    if (now - this.lastNotifiedStoreFetch >= 200L) {
                        dontNotify = false;
                        this.lastNotifiedStoreFetch = now;
                    }
                }
            }
        }
        this.parent.completedBlock(dontNotify, this.context);
    }

    @Override
    public void onFailedBlock() {
        this.parent.failedBlock(this.context);
    }

    @Override
    public void onResume(int succeededBlocks, int failedBlocks, ClientMetadata meta, long finalSize) {
        int i;
        for (i = 0; i < succeededBlocks - 1; ++i) {
            this.parent.completedBlock(true, this.context);
        }
        if (succeededBlocks > 0) {
            this.parent.completedBlock(false, this.context);
        }
        for (i = 0; i < failedBlocks - 1; ++i) {
            this.parent.failedBlock(true, this.context);
        }
        if (failedBlocks > 0) {
            this.parent.failedBlock(false, this.context);
        }
        this.parent.blockSetFinalized(this.context);
        try {
            this.cb.onExpectedMIME(meta, this.context);
        }
        catch (FetchException e) {
            this.fail(e);
            return;
        }
        this.cb.onExpectedSize(finalSize, this.context);
    }

    @Override
    public void maybeAddToBinaryBlob(ClientCHKBlock block) {
        if (this.parent instanceof ClientGetter) {
            ((ClientGetter)this.parent).addKeyToBinaryBlob(block, this.context);
        }
    }

    @Override
    public boolean wantBinaryBlob() {
        return this.wantBinaryBlob;
    }

    @Override
    public BaseSendableGet getSendableGet() {
        return this.getter;
    }

    @Override
    public void restartedAfterDataCorruption() {
        if (this.hasFinished()) {
            return;
        }
        Logger.error(this, "Restarting download " + this + " after data corruption");
        this.getter.unregister(this.context, this.getPriorityClass());
        try {
            this.getter.schedule(this.context, false);
        }
        catch (KeyListenerConstructionException keyListenerConstructionException) {
            // empty catch block
        }
        this.context.jobRunner.setCheckpointASAP();
    }

    @Override
    public void clearCooldown() {
        if (this.hasFinished()) {
            return;
        }
        this.getter.clearWakeupTime(this.context);
    }

    @Override
    public void reduceCooldown(long wakeupTime) {
        this.getter.reduceWakeupTime(wakeupTime, this.context);
    }

    @Override
    public HasKeyListener getHasKeyListener() {
        return this.getter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResume(ClientContext context) throws FetchException {
        if (logMINOR) {
            Logger.minor(this, "Restarting SplitFileFetcher from storage...");
        }
        boolean resumed = this.parent instanceof ClientGetter && ((ClientGetter)this.parent).resumedFetcher();
        this.context = context;
        try {
            KeySalter salter = this.getSalter();
            this.raf.onResume(context);
            this.storage = new SplitFileFetcherStorage(this.raf, this.realTimeFlag, this, this.blockFetchContext, context.random, context.jobRunner, context.getChkFetchScheduler(this.realTimeFlag).fetchingKeys(), context.ticker, context.memoryLimitedJobRunner, new CRCChecksumChecker(), context.jobRunner.newSalt(), salter, resumed, this.callbackCompleteViaTruncation != null);
        }
        catch (ResumeFailedException e) {
            this.raf.free();
            Logger.error(this, "Failed to resume storage file: " + e + " for " + this.raf, (Throwable)e);
            throw new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            this.raf.free();
            Logger.error(this, "Failed to resume due to I/O error: " + e + " raf = " + this.raf, (Throwable)e);
            throw new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e);
        }
        catch (StorageFormatException e) {
            this.raf.free();
            Logger.error(this, "Failed to resume due to storage error: " + e + " raf = " + this.raf, (Throwable)e);
            throw new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Resume failed: " + e, e);
        }
        catch (FetchException e) {
            this.raf.free();
            throw e;
        }
        SplitFileFetcher e = this;
        synchronized (e) {
            this.lastNotifiedStoreFetch = System.currentTimeMillis();
        }
        this.getter = new SplitFileFetcherGet(this, this.storage);
        try {
            if (this.storage.start(resumed)) {
                this.getter.schedule(context, this.storage.hasCheckedStore());
            }
        }
        catch (KeyListenerConstructionException e2) {
            Logger.error(this, "Key listener construction failed during resume: " + e2, (Throwable)e2);
            this.fail(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Resume failed: " + e2, e2));
            return;
        }
    }

    @Override
    public KeySalter getSalter() {
        return this.context.getChkFetchScheduler(this.realTimeFlag).getGlobalKeySalter(this.persistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTrivialProgress(DataOutputStream dos) throws IOException {
        boolean done = false;
        SplitFileFetcher splitFileFetcher = this;
        synchronized (splitFileFetcher) {
            done = this.failed || this.succeeded;
        }
        if (done) {
            dos.writeBoolean(false);
            return false;
        }
        dos.writeBoolean(true);
        if (this.callbackCompleteViaTruncation == null) {
            dos.writeBoolean(false);
            this.raf.storeTo(dos);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(this.fileCompleteViaTruncation.toString());
            dos.writeLong(this.raf.size());
        }
        dos.writeLong(this.token);
        return true;
    }

    public SplitFileFetcher(ClientGetter getter, DataInputStream dis, ClientContext context) throws StorageFormatException, ResumeFailedException, IOException {
        Logger.normal(this, "Resuming splitfile download for " + this);
        boolean completeViaTruncation = dis.readBoolean();
        if (completeViaTruncation) {
            this.fileCompleteViaTruncation = new File(dis.readUTF());
            if (!this.fileCompleteViaTruncation.exists()) {
                throw new ResumeFailedException("Storage file does not exist: " + this.fileCompleteViaTruncation);
            }
            this.callbackCompleteViaTruncation = getter;
            long rafSize = dis.readLong();
            if (this.fileCompleteViaTruncation.length() != rafSize) {
                throw new ResumeFailedException("Storage file is not of the correct length");
            }
            this.raf = new PooledFileRandomAccessBuffer(this.fileCompleteViaTruncation, false, rafSize, null, -1L, true);
        } else {
            this.raf = BucketTools.restoreRAFFrom(dis, context.persistentFG, context.persistentFileTracker, context.getPersistentMasterSecret());
            this.fileCompleteViaTruncation = null;
            this.callbackCompleteViaTruncation = null;
        }
        this.parent = getter;
        this.cb = getter;
        this.persistent = true;
        this.realTimeFlag = this.parent.realTimeFlag();
        this.token = dis.readLong();
        this.blockFetchContext = getter.ctx;
        this.wantBinaryBlob = getter.collectingBinaryBlob();
        Logger.normal(this, "Resumed splitfile download for " + this);
        this.lastNotifiedStoreFetch = System.currentTimeMillis();
    }

    @Override
    public void onShutdown(ClientContext context) {
        this.storage.onShutdown(context);
    }

    static {
        Logger.registerClass(SplitFileFetcher.class);
    }
}

