/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ClientMetadata;
import freenet.client.FECCodec;
import freenet.client.FailureCodeTracker;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.client.Metadata;
import freenet.client.MetadataParseException;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.ClientContext;
import freenet.client.async.KeySalter;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.client.async.PersistentJobRunner;
import freenet.client.async.SplitFileFetcherCrossSegmentStorage;
import freenet.client.async.SplitFileFetcherKeyListener;
import freenet.client.async.SplitFileFetcherSegmentStorage;
import freenet.client.async.SplitFileFetcherStorageCallback;
import freenet.client.async.SplitFileSegmentKeys;
import freenet.client.async.StreamGenerator;
import freenet.crypt.ChecksumChecker;
import freenet.crypt.ChecksumFailedException;
import freenet.crypt.HashType;
import freenet.crypt.MultiHashOutputStream;
import freenet.crypt.RandomSource;
import freenet.keys.ClientKey;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.node.KeysFetchingLocally;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestItemKey;
import freenet.support.Logger;
import freenet.support.MemoryLimitedJobRunner;
import freenet.support.RandomArrayIterator;
import freenet.support.Ticker;
import freenet.support.api.BucketFactory;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.LockableRandomAccessBufferFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.Compressor;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.BucketTools;
import freenet.support.io.FileRandomAccessBufferFactory;
import freenet.support.io.NativeThread;
import freenet.support.io.PrependLengthOutputStream;
import freenet.support.io.StorageFormatException;
import freenet.support.math.MersenneTwister;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class SplitFileFetcherStorage {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final SplitFileFetcherStorageCallback fetcher;
    private final LockableRandomAccessBuffer raf;
    private final long rafLength;
    final boolean completeViaTruncation;
    final SplitFileFetcherSegmentStorage[] segments;
    final SplitFileFetcherCrossSegmentStorage[] crossSegments;
    private final RandomArrayIterator<SplitFileFetcherSegmentStorage> randomSegmentIterator;
    final byte splitfileSingleCryptoAlgorithm;
    final byte[] splitfileSingleCryptoKey;
    public final FECCodec fecCodec;
    final Ticker ticker;
    final PersistentJobRunner jobRunner;
    final MemoryLimitedJobRunner memoryLimitedJobRunner;
    final long finalLength;
    final long decompressedLength;
    final Metadata.SplitfileAlgorithm splitfileType;
    final ClientMetadata clientMetadata;
    final List<Compressor.COMPRESSOR_TYPE> decompressors;
    final boolean persistent;
    private boolean finishedFetcher;
    private boolean finishedEncoding;
    private boolean cancelled;
    private boolean succeeded;
    private FailureCodeTracker errors;
    final int maxRetries;
    final int cooldownTries;
    final long cooldownLength;
    private long overallCooldownWakeupTime;
    final InsertContext.CompatibilityMode finalMinCompatMode;
    final SplitFileFetcherKeyListener keyListener;
    final RandomSource random;
    final long offsetKeyList;
    final long offsetSegmentStatus;
    final long offsetGeneralProgress;
    final long offsetMainBloomFilter;
    final long offsetSegmentBloomFilters;
    final long offsetOriginalMetadata;
    final long offsetOriginalDetails;
    final long offsetBasicSettings;
    final int checksumLength;
    final ChecksumChecker checksumChecker;
    private boolean hasCheckedDatastore;
    private boolean dirtyGeneralProgress;
    static final long HAS_CHECKED_DATASTORE_FLAG = 1L;
    static final long END_MAGIC = 2932737918599345903L;
    static final int VERSION = 1;
    private List<SplitFileFetcherSegmentStorage> segmentsToTryDecode;
    static final long LAZY_WRITE_METADATA_DELAY;
    private final PersistentJob writeMetadataJob = new PersistentJob(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run(ClientContext context) {
            try {
                if (SplitFileFetcherStorage.this.isFinishing()) {
                    return false;
                }
                LockableRandomAccessBuffer.RAFLock lock = SplitFileFetcherStorage.this.raf.lockOpen();
                try {
                    for (SplitFileFetcherSegmentStorage segment : SplitFileFetcherStorage.this.segments) {
                        segment.writeMetadata(false);
                    }
                    SplitFileFetcherStorage.this.keyListener.maybeWriteMainBloomFilter(SplitFileFetcherStorage.this.offsetMainBloomFilter);
                }
                finally {
                    lock.unlock();
                }
                SplitFileFetcherStorage.this.writeGeneralProgress(false);
                return false;
            }
            catch (IOException e) {
                if (SplitFileFetcherStorage.this.isFinishing()) {
                    return false;
                }
                Logger.error(this, "Failed writing metadata for " + SplitFileFetcherStorage.this + ": " + e, (Throwable)e);
                return false;
            }
        }
    };
    private final Runnable wrapLazyWriteMetadata = new Runnable(){

        @Override
        public void run() {
            SplitFileFetcherStorage.this.jobRunner.queueNormalOrDrop(SplitFileFetcherStorage.this.writeMetadataJob);
        }
    };
    private final Object cooldownLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitFileFetcherStorage(Metadata metadata, SplitFileFetcherStorageCallback fetcher, List<Compressor.COMPRESSOR_TYPE> decompressors, ClientMetadata clientMetadata, boolean topDontCompress, short topCompatibilityMode, FetchContext origFetchContext, boolean realTime, KeySalter salt, FreenetURI thisKey, FreenetURI origKey, boolean isFinalFetch, byte[] clientDetails, RandomSource random, BucketFactory tempBucketFactory, LockableRandomAccessBufferFactory rafFactory, PersistentJobRunner exec, Ticker ticker, MemoryLimitedJobRunner memoryLimitedJobRunner, ChecksumChecker checker, boolean persistent, File storageFile, FileRandomAccessBufferFactory diskSpaceCheckingRAFFactory, KeysFetchingLocally keysFetching) throws FetchException, MetadataParseException, IOException {
        long totalLength;
        byte[] encodedBasicSettings;
        byte[] encodedURI;
        RandomAccessBucket metadataTemp;
        this.fetcher = fetcher;
        this.jobRunner = exec;
        this.ticker = ticker;
        this.memoryLimitedJobRunner = memoryLimitedJobRunner;
        this.finalLength = metadata.dataLength();
        this.decompressedLength = metadata.uncompressedDataLength();
        this.splitfileType = metadata.getSplitfileType();
        this.fecCodec = FECCodec.getInstance(this.splitfileType);
        this.decompressors = decompressors;
        this.random = random;
        this.errors = new FailureCodeTracker(false);
        this.checksumChecker = checker;
        this.checksumLength = checker.checksumLength();
        this.persistent = persistent;
        boolean bl = this.completeViaTruncation = storageFile != null;
        if (decompressors.size() > 1) {
            Logger.error(this, "Multiple decompressors: " + decompressors.size() + " - this is almost certainly a bug", (Throwable)new Exception("debug"));
        }
        this.clientMetadata = clientMetadata == null ? new ClientMetadata() : clientMetadata.clone();
        SplitFileSegmentKeys[] segmentKeys = metadata.getSegmentKeys();
        InsertContext.CompatibilityMode minCompatMode = metadata.getMinCompatMode();
        InsertContext.CompatibilityMode maxCompatMode = metadata.getMaxCompatMode();
        int crossCheckBlocks = metadata.getCrossCheckBlocks();
        this.maxRetries = origFetchContext.maxSplitfileBlockRetries;
        this.cooldownTries = origFetchContext.getCooldownRetries();
        this.cooldownLength = origFetchContext.getCooldownTime();
        this.splitfileSingleCryptoAlgorithm = metadata.getSplitfileCryptoAlgorithm();
        this.splitfileSingleCryptoKey = metadata.getSplitfileCryptoKey();
        int blocksPerSegment = metadata.getDataBlocksPerSegment();
        int checkBlocksPerSegment = metadata.getCheckBlocksPerSegment();
        int splitfileDataBlocks = 0;
        int splitfileCheckBlocks = 0;
        long storedBlocksLength = 0L;
        long storedKeysLength = 0L;
        long storedSegmentStatusLength = 0L;
        long storedCrossCheckBlocksLength = 0L;
        for (SplitFileSegmentKeys keys : segmentKeys) {
            int dataBlocks = keys.getDataBlocks();
            int checkBlocks = keys.getCheckBlocks();
            splitfileDataBlocks += dataBlocks;
            splitfileCheckBlocks += checkBlocks;
            storedKeysLength += (long)SplitFileFetcherSegmentStorage.storedKeysLength(dataBlocks, checkBlocks, this.splitfileSingleCryptoKey != null, this.checksumLength);
            storedSegmentStatusLength += (long)SplitFileFetcherSegmentStorage.paddedStoredSegmentStatusLength(dataBlocks - crossCheckBlocks, checkBlocks, crossCheckBlocks, this.maxRetries != -1, this.checksumLength, persistent);
        }
        int totalCrossCheckBlocks = segmentKeys.length * crossCheckBlocks;
        splitfileDataBlocks -= totalCrossCheckBlocks;
        if (this.completeViaTruncation) {
            storedCrossCheckBlocksLength = (long)totalCrossCheckBlocks * 32768L;
            storedBlocksLength = (long)splitfileDataBlocks * 32768L;
        } else {
            storedCrossCheckBlocksLength = 0L;
            storedBlocksLength = ((long)splitfileDataBlocks + (long)totalCrossCheckBlocks) * 32768L;
        }
        int segmentCount = metadata.getSegmentCount();
        if (this.splitfileType == Metadata.SplitfileAlgorithm.NONREDUNDANT) {
            if (splitfileCheckBlocks > 0) {
                Logger.error(this, "Splitfile type is SPLITFILE_NONREDUNDANT yet " + splitfileCheckBlocks + " check blocks found!! : " + this);
                throw new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, "Splitfile type is non-redundant yet have " + splitfileCheckBlocks + " check blocks");
            }
        } else if (this.splitfileType == Metadata.SplitfileAlgorithm.ONION_STANDARD) {
            boolean dontCompress = decompressors.isEmpty();
            if (topCompatibilityMode != 0) {
                if (minCompatMode == InsertContext.CompatibilityMode.COMPAT_UNKNOWN || minCompatMode.ordinal() <= topCompatibilityMode && maxCompatMode.ordinal() >= topCompatibilityMode) {
                    minCompatMode = maxCompatMode = InsertContext.CompatibilityMode.values()[topCompatibilityMode];
                    dontCompress = topDontCompress;
                } else {
                    throw new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, "Top compatibility mode is incompatible with detected compatibility mode");
                }
            }
            fetcher.onSplitfileCompatibilityMode(minCompatMode, maxCompatMode, metadata.getCustomSplitfileKey(), dontCompress, true, topCompatibilityMode != 0);
            if (blocksPerSegment > origFetchContext.maxDataBlocksPerSegment || checkBlocksPerSegment > origFetchContext.maxCheckBlocksPerSegment) {
                throw new FetchException(FetchException.FetchExceptionMode.TOO_MANY_BLOCKS_PER_SEGMENT, "Too many blocks per segment: " + blocksPerSegment + " data, " + checkBlocksPerSegment + " check");
            }
        } else {
            throw new MetadataParseException("Unknown splitfile format: " + (Object)((Object)this.splitfileType));
        }
        if (logMINOR) {
            Logger.minor(this, "Algorithm: " + (Object)((Object)this.splitfileType) + ", blocks per segment: " + blocksPerSegment + ", check blocks per segment: " + checkBlocksPerSegment + ", segments: " + segmentCount + ", data blocks: " + splitfileDataBlocks + ", check blocks: " + splitfileCheckBlocks);
        }
        this.segments = new SplitFileFetcherSegmentStorage[segmentCount];
        this.randomSegmentIterator = new RandomArrayIterator<SplitFileFetcherSegmentStorage>(this.segments);
        long checkLength = 1L * (long)(splitfileDataBlocks - segmentCount * crossCheckBlocks) * 32768L;
        if (checkLength > this.finalLength && checkLength - this.finalLength > 32768L) {
            throw new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, "Splitfile is " + checkLength + " bytes long but length is " + this.finalLength + " bytes");
        }
        byte[] localSalt = new byte[32];
        random.nextBytes(localSalt);
        this.keyListener = new SplitFileFetcherKeyListener(fetcher, this, false, localSalt, splitfileDataBlocks + totalCrossCheckBlocks + splitfileCheckBlocks, blocksPerSegment + checkBlocksPerSegment, segmentCount);
        this.finalMinCompatMode = minCompatMode;
        this.offsetKeyList = storedBlocksLength + storedCrossCheckBlocksLength;
        this.offsetSegmentStatus = this.offsetKeyList + storedKeysLength;
        byte[] generalProgress = this.encodeGeneralProgress();
        if (persistent) {
            this.offsetGeneralProgress = this.offsetSegmentStatus + storedSegmentStatusLength;
            this.offsetMainBloomFilter = this.offsetGeneralProgress + (long)generalProgress.length;
            this.offsetSegmentBloomFilters = this.offsetMainBloomFilter + (long)this.keyListener.paddedMainBloomFilterSize();
            this.offsetOriginalMetadata = this.offsetSegmentBloomFilters + (long)this.keyListener.totalSegmentBloomFiltersSize();
        } else {
            this.offsetSegmentBloomFilters = this.offsetOriginalMetadata = this.offsetSegmentStatus;
            this.offsetMainBloomFilter = this.offsetOriginalMetadata;
            this.offsetGeneralProgress = this.offsetOriginalMetadata;
        }
        long dataOffset = 0L;
        long crossCheckBlocksOffset = storedBlocksLength;
        long segmentKeysOffset = this.offsetKeyList;
        long segmentStatusOffset = this.offsetSegmentStatus;
        for (int i = 0; i < this.segments.length; ++i) {
            SplitFileSegmentKeys keys = segmentKeys[i];
            int dataBlocks = keys.getDataBlocks() - crossCheckBlocks;
            int checkBlocks = keys.getCheckBlocks();
            if (dataBlocks > origFetchContext.maxDataBlocksPerSegment || checkBlocks > origFetchContext.maxCheckBlocksPerSegment) {
                throw new FetchException(FetchException.FetchExceptionMode.TOO_MANY_BLOCKS_PER_SEGMENT, "Too many blocks per segment: " + blocksPerSegment + " data, " + checkBlocksPerSegment + " check");
            }
            this.segments[i] = new SplitFileFetcherSegmentStorage(this, i, this.splitfileType, dataBlocks, checkBlocks, crossCheckBlocks, dataOffset, this.completeViaTruncation ? crossCheckBlocksOffset : -1L, segmentKeysOffset, segmentStatusOffset, this.maxRetries != -1, keys, keysFetching);
            dataOffset += (long)(dataBlocks * 32768);
            if (!this.completeViaTruncation) {
                dataOffset += (long)(crossCheckBlocks * 32768);
            } else {
                crossCheckBlocksOffset += (long)(crossCheckBlocks * 32768);
            }
            segmentKeysOffset += (long)SplitFileFetcherSegmentStorage.storedKeysLength(dataBlocks + crossCheckBlocks, checkBlocks, this.splitfileSingleCryptoKey != null, this.checksumLength);
            segmentStatusOffset += (long)SplitFileFetcherSegmentStorage.paddedStoredSegmentStatusLength(dataBlocks, checkBlocks, crossCheckBlocks, this.maxRetries != -1, this.checksumLength, persistent);
            for (int j = 0; j < dataBlocks + crossCheckBlocks + checkBlocks; ++j) {
                this.keyListener.addKey(keys.getKey(j, null, false).getNodeKey(false), i, salt);
            }
            if (!logDEBUG) continue;
            Logger.debug(this, "Segment " + i + ": data blocks offset " + this.segments[i].segmentBlockDataOffset + " cross-check blocks offset " + this.segments[i].segmentCrossCheckBlockDataOffset + " for segment " + i + " of " + this);
        }
        assert (dataOffset == storedBlocksLength);
        if (this.completeViaTruncation) assert (crossCheckBlocksOffset == storedCrossCheckBlocksLength + storedBlocksLength);
        assert (segmentKeysOffset == storedBlocksLength + storedCrossCheckBlocksLength + storedKeysLength);
        assert (segmentStatusOffset == storedBlocksLength + storedCrossCheckBlocksLength + storedKeysLength + storedSegmentStatusLength);
        fetcher.setSplitfileBlocks(splitfileDataBlocks + totalCrossCheckBlocks, splitfileCheckBlocks);
        this.keyListener.finishedSetup();
        if (crossCheckBlocks != 0) {
            MersenneTwister crossSegmentRandom = new MersenneTwister(Metadata.getCrossSegmentSeed(metadata.getHashes(), metadata.getHashThisLayerOnly()));
            this.crossSegments = new SplitFileFetcherCrossSegmentStorage[this.segments.length];
            int segLen = blocksPerSegment;
            int deductBlocksFromSegments = metadata.getDeductBlocksFromSegments();
            for (int i = 0; i < this.crossSegments.length; ++i) {
                int j;
                SplitFileFetcherCrossSegmentStorage seg;
                Logger.normal(this, "Allocating blocks (on fetch) for cross segment " + i);
                if (this.segments.length - i == deductBlocksFromSegments) {
                    --segLen;
                }
                this.crossSegments[i] = seg = new SplitFileFetcherCrossSegmentStorage(i, segLen, crossCheckBlocks, this, this.fecCodec);
                for (j = 0; j < segLen; ++j) {
                    this.allocateCrossDataBlock(seg, (Random)((Object)crossSegmentRandom));
                }
                for (j = 0; j < crossCheckBlocks; ++j) {
                    this.allocateCrossCheckBlock(seg, (Random)((Object)crossSegmentRandom));
                }
            }
        } else {
            this.crossSegments = null;
        }
        if (persistent) {
            metadataTemp = tempBucketFactory.makeBucket(-1L);
            OutputStream os = metadataTemp.getOutputStream();
            OutputStream cos = this.checksumOutputStream(os);
            BufferedOutputStream bos = new BufferedOutputStream(cos);
            try {
                MultiHashOutputStream mos = new MultiHashOutputStream(bos, HashType.SHA256.bitmask);
                metadata.writeTo(new DataOutputStream(mos));
                mos.getResults()[0].writeTo(bos);
            }
            catch (MetadataUnresolvedException e) {
                throw new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Metadata not resolved starting splitfile fetch?!: " + e, e);
            }
            bos.close();
            long metadataLength = metadataTemp.size();
            this.offsetOriginalDetails = this.offsetOriginalMetadata + metadataLength;
            encodedURI = this.encodeAndChecksumOriginalDetails(thisKey, origKey, clientDetails, isFinalFetch);
            this.offsetBasicSettings = this.offsetOriginalDetails + (long)encodedURI.length;
            encodedBasicSettings = this.encodeBasicSettings(splitfileDataBlocks, splitfileCheckBlocks, crossCheckBlocks * this.segments.length);
            totalLength = this.offsetBasicSettings + (long)encodedBasicSettings.length + 4L + (long)this.checksumLength + 4L + 4L + 2L + 8L;
        } else {
            totalLength = this.offsetSegmentStatus;
            this.offsetOriginalDetails = this.offsetBasicSettings = this.offsetSegmentStatus;
            metadataTemp = null;
            encodedBasicSettings = null;
            encodedURI = null;
        }
        this.rafLength = totalLength;
        if (storageFile != null) {
            if (!storageFile.exists()) {
                throw new IOException("Must have already created storage file");
            }
            if (storageFile.length() > 0L) {
                throw new IOException("Storage file must be empty");
            }
            this.raf = diskSpaceCheckingRAFFactory.createNewRAF(storageFile, totalLength, random);
            Logger.normal(this, "Creating splitfile storage file for complete-via-truncation: " + storageFile);
        } else {
            this.raf = rafFactory.makeRAF(totalLength);
        }
        LockableRandomAccessBuffer.RAFLock lock = this.raf.lockOpen();
        try {
            for (int i = 0; i < this.segments.length; ++i) {
                SplitFileFetcherSegmentStorage segment = this.segments[i];
                segment.writeKeysWithChecksum(segmentKeys[i]);
            }
            if (persistent) {
                for (SplitFileFetcherSegmentStorage segment : this.segments) {
                    segment.writeMetadata();
                }
                this.raf.pwrite(this.offsetGeneralProgress, generalProgress, 0, generalProgress.length);
                this.keyListener.innerWriteMainBloomFilter(this.offsetMainBloomFilter);
                this.keyListener.initialWriteSegmentBloomFilters(this.offsetSegmentBloomFilters);
                BucketTools.copyTo(metadataTemp, this.raf, this.offsetOriginalMetadata, -1L);
                metadataTemp.free();
                this.raf.pwrite(this.offsetOriginalDetails, encodedURI, 0, encodedURI.length);
                this.raf.pwrite(this.offsetBasicSettings, encodedBasicSettings, 0, encodedBasicSettings.length);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeInt(encodedBasicSettings.length - this.checksumLength);
                byte[] bufToWrite = baos.toByteArray();
                baos = new ByteArrayOutputStream();
                dos = new DataOutputStream(baos);
                dos.writeInt(0);
                dos.writeShort(this.checksumChecker.getChecksumTypeID());
                dos.writeInt(1);
                byte[] version = baos.toByteArray();
                byte[] bufToChecksum = Arrays.copyOf(bufToWrite, bufToWrite.length + version.length);
                System.arraycopy(version, 0, bufToChecksum, bufToWrite.length, version.length);
                byte[] checksum = this.checksumChecker.generateChecksum(bufToChecksum);
                this.raf.pwrite(this.offsetBasicSettings + (long)encodedBasicSettings.length, bufToWrite, 0, bufToWrite.length);
                this.raf.pwrite(this.offsetBasicSettings + (long)encodedBasicSettings.length + (long)bufToWrite.length, checksum, 0, checksum.length);
                this.raf.pwrite(this.offsetBasicSettings + (long)encodedBasicSettings.length + (long)bufToWrite.length + (long)checksum.length, version, 0, version.length);
                baos = new ByteArrayOutputStream();
                dos = new DataOutputStream(baos);
                dos.writeLong(2932737918599345903L);
                byte[] buf = baos.toByteArray();
                this.raf.pwrite(totalLength - 8L, buf, 0, 8);
            }
        }
        finally {
            lock.unlock();
        }
        if (logMINOR) {
            Logger.minor(this, "Fetching " + thisKey + " on " + this + " for " + fetcher);
        }
    }

    public SplitFileFetcherStorage(LockableRandomAccessBuffer raf, boolean realTime, SplitFileFetcherStorageCallback callback, FetchContext origContext, RandomSource random, PersistentJobRunner exec, KeysFetchingLocally keysFetching, Ticker ticker, MemoryLimitedJobRunner memoryLimitedJobRunner, ChecksumChecker checker, boolean newSalt, KeySalter salt, boolean resumed, boolean completeViaTruncation) throws IOException, StorageFormatException, FetchException {
        this.persistent = true;
        this.raf = raf;
        this.fetcher = callback;
        this.ticker = ticker;
        this.jobRunner = exec;
        this.memoryLimitedJobRunner = memoryLimitedJobRunner;
        this.random = random;
        this.checksumChecker = checker;
        this.checksumLength = checker.checksumLength();
        this.maxRetries = origContext.maxSplitfileBlockRetries;
        this.cooldownTries = origContext.getCooldownRetries();
        this.cooldownLength = origContext.getCooldownTime();
        this.errors = new FailureCodeTracker(false);
        this.completeViaTruncation = completeViaTruncation;
        this.rafLength = raf.size();
        if (raf.size() < 8L) {
            throw new StorageFormatException("Too short");
        }
        byte[] buf = new byte[8];
        raf.pread(this.rafLength - 8L, buf, 0, 8);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
        if (dis.readLong() != 2932737918599345903L) {
            throw new StorageFormatException("Wrong magic bytes");
        }
        byte[] versionBuf = new byte[4];
        raf.pread(this.rafLength - 12L, versionBuf, 0, 4);
        dis = new DataInputStream(new ByteArrayInputStream(versionBuf));
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Wrong version " + version);
        }
        byte[] checksumTypeBuf = new byte[2];
        raf.pread(this.rafLength - 14L, checksumTypeBuf, 0, 2);
        dis = new DataInputStream(new ByteArrayInputStream(checksumTypeBuf));
        short checksumType = dis.readShort();
        if (checksumType != 1) {
            throw new StorageFormatException("Unknown checksum type " + checksumType);
        }
        byte[] flagsBuf = new byte[4];
        raf.pread(this.rafLength - 18L, flagsBuf, 0, 4);
        dis = new DataInputStream(new ByteArrayInputStream(flagsBuf));
        int flags = dis.readInt();
        if (flags != 0) {
            throw new StorageFormatException("Unknown flags: " + flags);
        }
        buf = new byte[14];
        raf.pread(this.rafLength - (long)(22 + this.checksumLength), buf, 0, 4);
        byte[] checksum = new byte[this.checksumLength];
        raf.pread(this.rafLength - (long)(18 + this.checksumLength), checksum, 0, this.checksumLength);
        System.arraycopy(flagsBuf, 0, buf, 4, 4);
        System.arraycopy(checksumTypeBuf, 0, buf, 8, 2);
        System.arraycopy(versionBuf, 0, buf, 10, 4);
        if (!this.checksumChecker.checkChecksum(buf, 0, 14, checksum)) {
            throw new StorageFormatException("Checksum failed on basic settings length and version");
        }
        dis = new DataInputStream(new ByteArrayInputStream(buf));
        int basicSettingsLength = dis.readInt();
        if (basicSettingsLength < 0 || (long)(basicSettingsLength + 12 + 4 + this.checksumLength) > raf.size() || basicSettingsLength > 0x100000) {
            throw new StorageFormatException("Bad basic settings length");
        }
        byte[] basicSettingsBuffer = new byte[basicSettingsLength];
        long basicSettingsOffset = this.rafLength - (long)(22 + this.checksumLength * 2 + basicSettingsLength);
        try {
            this.preadChecksummed(basicSettingsOffset, basicSettingsBuffer, 0, basicSettingsLength);
        }
        catch (ChecksumFailedException e) {
            throw new StorageFormatException("Basic settings checksum invalid");
        }
        dis = new DataInputStream(new ByteArrayInputStream(basicSettingsBuffer));
        try {
            short s = dis.readShort();
            try {
                this.splitfileType = Metadata.SplitfileAlgorithm.getByCode(s);
            }
            catch (IllegalArgumentException e) {
                throw new StorageFormatException("Invalid splitfile type " + s);
            }
            this.fecCodec = FECCodec.getInstance(this.splitfileType);
            this.splitfileSingleCryptoAlgorithm = dis.readByte();
            if (!Metadata.isValidSplitfileCryptoAlgorithm(this.splitfileSingleCryptoAlgorithm)) {
                throw new StorageFormatException("Invalid splitfile crypto algorithm " + (Object)((Object)this.splitfileType));
            }
            if (dis.readBoolean()) {
                this.splitfileSingleCryptoKey = new byte[32];
                dis.readFully(this.splitfileSingleCryptoKey);
            } else {
                this.splitfileSingleCryptoKey = null;
            }
            this.finalLength = dis.readLong();
            if (this.finalLength < 0L) {
                throw new StorageFormatException("Invalid final length " + this.finalLength);
            }
            this.decompressedLength = dis.readLong();
            if (this.decompressedLength < 0L) {
                throw new StorageFormatException("Invalid decompressed length " + this.decompressedLength);
            }
            try {
                this.clientMetadata = ClientMetadata.construct(dis);
            }
            catch (MetadataParseException e) {
                throw new StorageFormatException("Invalid MIME type");
            }
            int decompressorCount = dis.readInt();
            if (decompressorCount < 0) {
                throw new StorageFormatException("Invalid decompressor count " + decompressorCount);
            }
            this.decompressors = new ArrayList<Compressor.COMPRESSOR_TYPE>(decompressorCount);
            for (int i = 0; i < decompressorCount; ++i) {
                short type = dis.readShort();
                Compressor.COMPRESSOR_TYPE d = Compressor.COMPRESSOR_TYPE.getCompressorByMetadataID(type);
                if (d == null) {
                    throw new StorageFormatException("Invalid decompressor ID " + type);
                }
                this.decompressors.add(d);
            }
            this.offsetKeyList = dis.readLong();
            if (this.offsetKeyList < 0L || this.offsetKeyList > this.rafLength) {
                throw new StorageFormatException("Invalid offset (key list)");
            }
            this.offsetSegmentStatus = dis.readLong();
            if (this.offsetSegmentStatus < 0L || this.offsetSegmentStatus > this.rafLength) {
                throw new StorageFormatException("Invalid offset (segment status)");
            }
            this.offsetGeneralProgress = dis.readLong();
            if (this.offsetGeneralProgress < 0L || this.offsetGeneralProgress > this.rafLength) {
                throw new StorageFormatException("Invalid offset (general progress)");
            }
            this.offsetMainBloomFilter = dis.readLong();
            if (this.offsetMainBloomFilter < 0L || this.offsetMainBloomFilter > this.rafLength) {
                throw new StorageFormatException("Invalid offset (main bloom filter)");
            }
            this.offsetSegmentBloomFilters = dis.readLong();
            if (this.offsetSegmentBloomFilters < 0L || this.offsetSegmentBloomFilters > this.rafLength) {
                throw new StorageFormatException("Invalid offset (segment bloom filters)");
            }
            this.offsetOriginalMetadata = dis.readLong();
            if (this.offsetOriginalMetadata < 0L || this.offsetOriginalMetadata > this.rafLength) {
                throw new StorageFormatException("Invalid offset (original metadata)");
            }
            this.offsetOriginalDetails = dis.readLong();
            if (this.offsetOriginalDetails < 0L || this.offsetOriginalDetails > this.rafLength) {
                throw new StorageFormatException("Invalid offset (original metadata)");
            }
            this.offsetBasicSettings = dis.readLong();
            if (this.offsetBasicSettings != basicSettingsOffset) {
                throw new StorageFormatException("Invalid basic settings offset (not the same as computed)");
            }
            if (completeViaTruncation != dis.readBoolean()) {
                throw new StorageFormatException("Complete via truncation flag is wrong");
            }
            int compatMode = dis.readInt();
            if (compatMode < 0 || compatMode > InsertContext.CompatibilityMode.values().length) {
                throw new StorageFormatException("Invalid compatibility mode " + compatMode);
            }
            this.finalMinCompatMode = InsertContext.CompatibilityMode.values()[compatMode];
            int segmentCount = dis.readInt();
            if (segmentCount < 0) {
                throw new StorageFormatException("Invalid segment count " + segmentCount);
            }
            this.segments = new SplitFileFetcherSegmentStorage[segmentCount];
            this.randomSegmentIterator = new RandomArrayIterator<SplitFileFetcherSegmentStorage>(this.segments);
            long totalDataBlocks = dis.readInt();
            if (totalDataBlocks < 0L) {
                throw new StorageFormatException("Invalid total data blocks " + totalDataBlocks);
            }
            int totalCheckBlocks = dis.readInt();
            if (totalCheckBlocks < 0) {
                throw new StorageFormatException("Invalid total check blocks " + totalDataBlocks);
            }
            int totalCrossCheckBlocks = dis.readInt();
            if (totalCrossCheckBlocks < 0) {
                throw new StorageFormatException("Invalid total cross-check blocks " + totalDataBlocks);
            }
            long dataOffset = 0L;
            long crossCheckBlocksOffset = completeViaTruncation ? totalDataBlocks * 32768L : 0L;
            long segmentKeysOffset = this.offsetKeyList;
            long segmentStatusOffset = this.offsetSegmentStatus;
            int countDataBlocks = 0;
            int countCheckBlocks = 0;
            int countCrossCheckBlocks = 0;
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new SplitFileFetcherSegmentStorage(this, dis, i, this.maxRetries != -1, dataOffset, completeViaTruncation ? crossCheckBlocksOffset : -1L, segmentKeysOffset, segmentStatusOffset, keysFetching);
                int dataBlocks = this.segments[i].dataBlocks;
                countDataBlocks += dataBlocks;
                int checkBlocks = this.segments[i].checkBlocks;
                countCheckBlocks += checkBlocks;
                int crossCheckBlocks = this.segments[i].crossSegmentCheckBlocks;
                countCrossCheckBlocks += crossCheckBlocks;
                dataOffset += (long)(dataBlocks * 32768);
                if (completeViaTruncation) {
                    crossCheckBlocksOffset += (long)(crossCheckBlocks * 32768);
                } else {
                    dataOffset += (long)(crossCheckBlocks * 32768);
                }
                segmentKeysOffset += (long)SplitFileFetcherSegmentStorage.storedKeysLength(dataBlocks + crossCheckBlocks, checkBlocks, this.splitfileSingleCryptoKey != null, this.checksumLength);
                segmentStatusOffset += (long)SplitFileFetcherSegmentStorage.paddedStoredSegmentStatusLength(dataBlocks, checkBlocks, crossCheckBlocks, this.maxRetries != -1, this.checksumLength, true);
                if (dataOffset > this.rafLength) {
                    throw new StorageFormatException("Data offset past end of file " + dataOffset + " of " + this.rafLength);
                }
                if (this.segments[i].segmentCrossCheckBlockDataOffset > this.rafLength) {
                    throw new StorageFormatException("Cross-check blocks offset past end of file " + this.segments[i].segmentCrossCheckBlockDataOffset + " of " + this.rafLength);
                }
                if (!logDEBUG) continue;
                Logger.debug(this, "Segment " + i + ": data blocks offset " + this.segments[i].segmentBlockDataOffset + " cross-check blocks offset " + this.segments[i].segmentCrossCheckBlockDataOffset + " for segment " + i + " of " + this);
            }
            if ((long)countDataBlocks != totalDataBlocks) {
                throw new StorageFormatException("Total data blocks " + countDataBlocks + " but expected " + totalDataBlocks);
            }
            if (countCheckBlocks != totalCheckBlocks) {
                throw new StorageFormatException("Total check blocks " + countCheckBlocks + " but expected " + totalCheckBlocks);
            }
            if (countCrossCheckBlocks != totalCrossCheckBlocks) {
                throw new StorageFormatException("Total cross-check blocks " + countCrossCheckBlocks + " but expected " + totalCrossCheckBlocks);
            }
            int crossSegments = dis.readInt();
            this.crossSegments = crossSegments == 0 ? null : new SplitFileFetcherCrossSegmentStorage[crossSegments];
            for (int i = 0; i < crossSegments; ++i) {
                this.crossSegments[i] = new SplitFileFetcherCrossSegmentStorage(this, i, dis);
            }
            this.keyListener = new SplitFileFetcherKeyListener(this, this.fetcher, dis, false, newSalt);
        }
        catch (IOException e) {
            throw new StorageFormatException("Cannot read basic settings even though passed checksum: " + e, e);
        }
        SplitFileFetcherSegmentStorage[] arr$ = this.segments;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            SplitFileFetcherSegmentStorage segment = arr$[i$];
            boolean needsDecode = false;
            try {
                segment.readMetadata();
                if (segment.hasFailed()) {
                    raf.close();
                    raf.free();
                    throw new FetchException(FetchException.FetchExceptionMode.SPLITFILE_ERROR, this.errors);
                }
            }
            catch (ChecksumFailedException e) {
                Logger.error(this, "Progress for segment " + segment.segNo + " on " + this + " corrupted.");
                needsDecode = true;
            }
            if (segment.needsDecode()) {
                needsDecode = true;
            }
            if (!needsDecode) continue;
            if (this.segmentsToTryDecode == null) {
                this.segmentsToTryDecode = new ArrayList<SplitFileFetcherSegmentStorage>();
            }
            this.segmentsToTryDecode.add(segment);
        }
        for (int i = 0; i < this.segments.length; ++i) {
            SplitFileFetcherSegmentStorage segment = this.segments[i];
            try {
                segment.readSegmentKeys();
                continue;
            }
            catch (ChecksumFailedException e) {
                throw new StorageFormatException("Keys corrupted");
            }
        }
        if (this.crossSegments != null) {
            for (SplitFileFetcherCrossSegmentStorage crossSegment : this.crossSegments) {
                crossSegment.checkBlocks();
            }
        }
        this.readGeneralProgress();
    }

    private void readGeneralProgress() throws IOException {
        try {
            byte[] buf = this.preadChecksummedWithLength(this.offsetGeneralProgress);
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            DataInputStream dis = new DataInputStream(bais);
            long flags = dis.readLong();
            if ((flags & 1L) != 0L) {
                this.hasCheckedDatastore = true;
            }
            this.errors = new FailureCodeTracker(false, dis);
            dis.close();
        }
        catch (ChecksumFailedException e) {
            Logger.error(this, "Failed to read general progress: " + e);
            this.hasCheckedDatastore = false;
            this.errors = new FailureCodeTracker(false);
        }
        catch (StorageFormatException e) {
            Logger.error(this, "Failed to read general progress: " + e);
            this.hasCheckedDatastore = false;
            this.errors = new FailureCodeTracker(false);
        }
    }

    private byte[] encodeGeneralProgress() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            PrependLengthOutputStream ccos = this.checksumChecker.checksumWriterWithLength(baos, new ArrayBucketFactory());
            DataOutputStream dos = new DataOutputStream(ccos);
            long flags = 0L;
            if (this.hasCheckedDatastore) {
                flags |= 1L;
            }
            dos.writeLong(flags);
            this.errors.writeFixedLengthTo(dos);
            dos.close();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        byte[] ret = baos.toByteArray();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(boolean resume) {
        if (resume) {
            int splitfileDataBlocks = 0;
            int splitfileCheckBlocks = 0;
            int totalCrossCheckBlocks = 0;
            int succeededBlocks = 0;
            int failedBlocks = 0;
            for (SplitFileFetcherSegmentStorage segment : this.segments) {
                splitfileDataBlocks += segment.dataBlocks;
                splitfileCheckBlocks += segment.checkBlocks;
                totalCrossCheckBlocks += segment.crossSegmentCheckBlocks;
                succeededBlocks += segment.foundBlocks();
                failedBlocks += segment.failedBlocks();
            }
            this.fetcher.setSplitfileBlocks(splitfileDataBlocks + totalCrossCheckBlocks, splitfileCheckBlocks);
            this.fetcher.onResume(succeededBlocks, failedBlocks, this.clientMetadata, this.decompressedLength);
        }
        if (this.crossSegments != null) {
            for (SplitFileFetcherCrossSegmentStorage segment : this.crossSegments) {
                segment.restart();
            }
        }
        if (this.segmentsToTryDecode != null) {
            List<SplitFileFetcherSegmentStorage> brokenSegments;
            SplitFileFetcherStorage len$ = this;
            synchronized (len$) {
                brokenSegments = this.segmentsToTryDecode;
                this.segmentsToTryDecode = null;
            }
            if (brokenSegments != null) {
                for (SplitFileFetcherSegmentStorage segment : brokenSegments) {
                    segment.tryStartDecode();
                }
            }
        }
        if (this.keyListener.needsKeys()) {
            try {
                this.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        block8: {
                            System.out.println("Regenerating filters for " + SplitFileFetcherStorage.this);
                            Logger.error(this, "Regenerating filters for " + SplitFileFetcherStorage.this);
                            KeySalter salt = SplitFileFetcherStorage.this.fetcher.getSalter();
                            for (int i = 0; i < SplitFileFetcherStorage.this.segments.length; ++i) {
                                SplitFileFetcherSegmentStorage segment = SplitFileFetcherStorage.this.segments[i];
                                try {
                                    try {
                                        SplitFileSegmentKeys keys = segment.readSegmentKeys();
                                        for (int j = 0; j < keys.totalKeys(); ++j) {
                                            SplitFileFetcherStorage.this.keyListener.addKey(keys.getKey(j, null, false).getNodeKey(false), i, salt);
                                        }
                                        continue;
                                    }
                                    catch (IOException e) {
                                        SplitFileFetcherStorage.this.failOnDiskError(e);
                                        return false;
                                    }
                                }
                                catch (ChecksumFailedException e) {
                                    SplitFileFetcherStorage.this.failOnDiskError(e);
                                    return false;
                                }
                            }
                            SplitFileFetcherStorage.this.keyListener.addedAllKeys();
                            try {
                                SplitFileFetcherStorage.this.keyListener.initialWriteSegmentBloomFilters(SplitFileFetcherStorage.this.offsetSegmentBloomFilters);
                                SplitFileFetcherStorage.this.keyListener.innerWriteMainBloomFilter(SplitFileFetcherStorage.this.offsetMainBloomFilter);
                            }
                            catch (IOException e) {
                                if (!SplitFileFetcherStorage.this.persistent) break block8;
                                SplitFileFetcherStorage.this.failOnDiskError(e);
                            }
                        }
                        SplitFileFetcherStorage.this.fetcher.restartedAfterDataCorruption();
                        Logger.warning(this, "Finished regenerating filters for " + SplitFileFetcherStorage.this);
                        System.out.println("Finished regenerating filters for " + SplitFileFetcherStorage.this);
                        return false;
                    }
                }, NativeThread.LOW_PRIORITY + 1);
            }
            catch (PersistenceDisabledException persistenceDisabledException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    OutputStream checksumOutputStream(OutputStream os) {
        return this.checksumChecker.checksumWriter(os);
    }

    private byte[] encodeBasicSettings(int totalDataBlocks, int totalCheckBlocks, int totalCrossCheckBlocks) {
        return this.appendChecksum(this.innerEncodeBasicSettings(totalDataBlocks, totalCheckBlocks, totalCrossCheckBlocks));
    }

    private byte[] innerEncodeBasicSettings(int totalDataBlocks, int totalCheckBlocks, int totalCrossCheckBlocks) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(this.splitfileType.code);
            dos.writeByte(this.splitfileSingleCryptoAlgorithm);
            dos.writeBoolean(this.splitfileSingleCryptoKey != null);
            if (this.splitfileSingleCryptoKey != null) {
                assert (this.splitfileSingleCryptoKey.length == 32);
                dos.write(this.splitfileSingleCryptoKey);
            }
            dos.writeLong(this.finalLength);
            dos.writeLong(this.decompressedLength);
            this.clientMetadata.writeTo(dos);
            dos.writeInt(this.decompressors.size());
            for (Compressor.COMPRESSOR_TYPE c : this.decompressors) {
                dos.writeShort(c.metadataID);
            }
            dos.writeLong(this.offsetKeyList);
            dos.writeLong(this.offsetSegmentStatus);
            dos.writeLong(this.offsetGeneralProgress);
            dos.writeLong(this.offsetMainBloomFilter);
            dos.writeLong(this.offsetSegmentBloomFilters);
            dos.writeLong(this.offsetOriginalMetadata);
            dos.writeLong(this.offsetOriginalDetails);
            dos.writeLong(this.offsetBasicSettings);
            dos.writeBoolean(this.completeViaTruncation);
            dos.writeInt(this.finalMinCompatMode.ordinal());
            dos.writeInt(this.segments.length);
            dos.writeInt(totalDataBlocks);
            dos.writeInt(totalCheckBlocks);
            dos.writeInt(totalCrossCheckBlocks);
            for (SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage : this.segments) {
                splitFileFetcherSegmentStorage.writeFixedMetadata(dos);
            }
            if (this.crossSegments == null) {
                dos.writeInt(0);
            } else {
                dos.writeInt(this.crossSegments.length);
                for (SplitFileFetcherCrossSegmentStorage splitFileFetcherCrossSegmentStorage : this.crossSegments) {
                    splitFileFetcherCrossSegmentStorage.writeFixedMetadata(dos);
                }
            }
            this.keyListener.writeStaticSettings(dos);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return baos.toByteArray();
    }

    private byte[] encodeAndChecksumOriginalDetails(FreenetURI thisKey, FreenetURI origKey, byte[] clientDetails, boolean isFinalFetch) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(thisKey.toASCIIString());
        dos.writeUTF(origKey.toASCIIString());
        dos.writeBoolean(isFinalFetch);
        dos.writeInt(clientDetails.length);
        dos.write(clientDetails);
        dos.writeInt(this.maxRetries);
        dos.writeInt(this.cooldownTries);
        dos.writeLong(this.cooldownLength);
        return this.checksumChecker.appendChecksum(baos.toByteArray());
    }

    private void allocateCrossDataBlock(SplitFileFetcherCrossSegmentStorage segment, Random random) {
        int blockNum;
        SplitFileFetcherSegmentStorage seg;
        int i;
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = random.nextInt(this.segments.length);
            seg = this.segments[x];
            blockNum = seg.allocateCrossDataBlock(segment, random);
            if (blockNum < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        for (i = 0; i < this.segments.length; ++i) {
            if (++x == this.segments.length) {
                x = 0;
            }
            if ((blockNum = (seg = this.segments[x]).allocateCrossDataBlock(segment, random)) < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        throw new IllegalStateException("Unable to allocate cross data block!");
    }

    private void allocateCrossCheckBlock(SplitFileFetcherCrossSegmentStorage segment, Random random) {
        int blockNum;
        SplitFileFetcherSegmentStorage seg;
        int i;
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = random.nextInt(this.segments.length);
            seg = this.segments[x];
            blockNum = seg.allocateCrossCheckBlock(segment, random);
            if (blockNum < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        for (i = 0; i < this.segments.length; ++i) {
            if (++x == this.segments.length) {
                x = 0;
            }
            if ((blockNum = (seg = this.segments[x]).allocateCrossCheckBlock(segment, random)) < 0) continue;
            segment.addDataBlock(seg, blockNum);
            return;
        }
        throw new IllegalStateException("Unable to allocate cross data block!");
    }

    public short getPriorityClass() {
        return this.fetcher.getPriorityClass();
    }

    public void finishedSuccess(SplitFileFetcherSegmentStorage segment) {
        if (logMINOR) {
            Logger.minor(this, "finishedSuccess on " + this + " from " + segment + " for " + this.fetcher, (Throwable)new Exception("debug"));
        }
        if (!this.completeViaTruncation && !this.fetcher.wantBinaryBlob()) {
            this.maybeComplete();
        }
    }

    private void maybeComplete() {
        if (this.allSucceeded()) {
            this.callSuccessOffThread();
        } else if (this.allFinished() && !this.allSucceeded()) {
            this.fail(new FetchException(FetchException.FetchExceptionMode.SPLITFILE_ERROR, this.errors));
        }
    }

    private void callSuccessOffThread() {
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ClientContext context) {
                SplitFileFetcherStorage splitFileFetcherStorage = SplitFileFetcherStorage.this;
                synchronized (splitFileFetcherStorage) {
                    if (SplitFileFetcherStorage.this.succeeded) {
                        return false;
                    }
                    SplitFileFetcherStorage.this.succeeded = true;
                }
                SplitFileFetcherStorage.this.fetcher.onSuccess();
                return true;
            }
        });
    }

    private boolean allSucceeded() {
        for (SplitFileFetcherSegmentStorage segment : this.segments) {
            if (segment.hasSucceeded()) continue;
            return false;
        }
        return true;
    }

    public StreamGenerator streamGenerator() {
        return new StreamGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeTo(OutputStream os, ClientContext context) throws IOException {
                LockableRandomAccessBuffer.RAFLock lock = SplitFileFetcherStorage.this.raf.lockOpen();
                try {
                    for (SplitFileFetcherSegmentStorage segment : SplitFileFetcherStorage.this.segments) {
                        segment.writeToInner(os);
                    }
                    os.close();
                }
                catch (Throwable t) {
                    Logger.error(this, "Failed to write stream: " + t, t);
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public long size() {
                return SplitFileFetcherStorage.this.finalLength;
            }
        };
    }

    public void lazyWriteMetadata() {
        if (!this.persistent) {
            return;
        }
        if (LAZY_WRITE_METADATA_DELAY != 0L) {
            this.ticker.queueTimedJob(this.wrapLazyWriteMetadata, "Write metadata for splitfile", LAZY_WRITE_METADATA_DELAY, false, true);
        } else {
            this.jobRunner.queueNormalOrDrop(this.writeMetadataJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedFetcher() {
        SplitFileFetcherStorage splitFileFetcherStorage = this;
        synchronized (splitFileFetcherStorage) {
            if (this.finishedFetcher) {
                if (logMINOR) {
                    Logger.minor(this, "Already finishedFetcher");
                }
                return;
            }
            this.finishedFetcher = true;
            if (this.completeViaTruncation && !this.cancelled) {
                return;
            }
            if (!this.finishedEncoding) {
                return;
            }
        }
        this.closeOffThread();
    }

    private void closeOffThread() {
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                SplitFileFetcherStorage.this.close();
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedEncoding() {
        boolean lateCompletion = false;
        boolean waitingForFetcher = false;
        SplitFileFetcherStorage splitFileFetcherStorage = this;
        synchronized (splitFileFetcherStorage) {
            if (this.finishedEncoding) {
                if (logMINOR) {
                    Logger.minor(this, "Already finishedEncoding");
                }
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Finished encoding");
            }
            this.finishedEncoding = true;
            if (!this.cancelled) {
                if ((this.completeViaTruncation || this.fetcher.wantBinaryBlob()) && !this.succeeded) {
                    lateCompletion = true;
                } else {
                    waitingForFetcher = !this.finishedFetcher;
                }
            }
        }
        if (lateCompletion) {
            if (this.allFinished() && !this.allSucceeded()) {
                this.fail(new FetchException(FetchException.FetchExceptionMode.SPLITFILE_ERROR, this.errors));
            } else {
                if (this.completeViaTruncation) {
                    this.raf.close();
                }
                this.maybeComplete();
                return;
            }
        }
        if (waitingForFetcher) {
            return;
        }
        this.closeOffThread();
    }

    void close() {
        if (logMINOR) {
            Logger.minor(this, "Finishing " + this + " for " + this.fetcher, (Throwable)new Exception("debug"));
        }
        this.raf.close();
        this.raf.free();
        this.fetcher.onClosed();
    }

    void finishedEncoding(SplitFileFetcherSegmentStorage segment) {
        if (logMINOR) {
            Logger.minor(this, "Successfully decoded " + segment + " for " + this + " for " + this.fetcher);
        }
        if (!this.allFinished()) {
            return;
        }
        this.finishedEncoding();
    }

    void finishedEncoding(SplitFileFetcherCrossSegmentStorage segment) {
        if (logMINOR) {
            Logger.minor(this, "Successfully decoded " + segment + " for " + this + " for " + this.fetcher);
        }
        if (!this.allFinished()) {
            return;
        }
        this.finishedEncoding();
    }

    private boolean allFinished() {
        for (SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage : this.segments) {
            if (splitFileFetcherSegmentStorage.isFinished()) continue;
            return false;
        }
        if (this.crossSegments != null) {
            for (SplitFileFetcherCrossSegmentStorage splitFileFetcherCrossSegmentStorage : this.crossSegments) {
                if (!splitFileFetcherCrossSegmentStorage.isDecoding()) continue;
                return false;
            }
        }
        return true;
    }

    public void fail(final FetchException e) {
        if (logMINOR) {
            Logger.minor(this, "Failing " + this + " with error " + e + " and codes " + this.errors);
        }
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                SplitFileFetcherStorage.this.fetcher.fail(e);
                return true;
            }
        });
    }

    public void failOnSegment(SplitFileFetcherSegmentStorage segment) {
        this.fail(new FetchException(FetchException.FetchExceptionMode.SPLITFILE_ERROR, this.errors));
    }

    public void failOnDiskError(final IOException e) {
        Logger.error(this, "Failing on disk error: " + e, (Throwable)e);
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                SplitFileFetcherStorage.this.fetcher.failOnDiskError(e);
                return true;
            }
        });
    }

    public void failOnDiskError(final ChecksumFailedException e) {
        Logger.error(this, "Failing on unrecoverable corrupt data: " + e, (Throwable)e);
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                SplitFileFetcherStorage.this.fetcher.failOnDiskError(e);
                return true;
            }
        });
    }

    public long countUnfetchedKeys() {
        long total = 0L;
        for (SplitFileFetcherSegmentStorage segment : this.segments) {
            total += segment.countUnfetchedKeys();
        }
        return total;
    }

    public Key[] listUnfetchedKeys() {
        try {
            ArrayList<Key> keys = new ArrayList<Key>();
            for (SplitFileFetcherSegmentStorage segment : this.segments) {
                segment.getUnfetchedKeys(keys);
            }
            return keys.toArray(new Key[keys.size()]);
        }
        catch (IOException e) {
            this.failOnDiskError(e);
            return new Key[0];
        }
    }

    public long countSendableKeys() {
        long now = System.currentTimeMillis();
        long total = 0L;
        for (SplitFileFetcherSegmentStorage segment : this.segments) {
            total += segment.countSendableKeys(now, this.maxRetries);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MyKey chooseRandomKey() {
        Object object = this;
        synchronized (object) {
            if (this.finishedFetcher) {
                return null;
            }
        }
        object = this.randomSegmentIterator;
        synchronized (object) {
            this.randomSegmentIterator.reset(this.random);
            while (this.randomSegmentIterator.hasNext()) {
                SplitFileFetcherSegmentStorage segment = this.randomSegmentIterator.next();
                int ret = segment.chooseRandomKey();
                if (ret == -1) continue;
                return new MyKey(ret, segment.segNo, this);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        SplitFileFetcherStorage splitFileFetcherStorage = this;
        synchronized (splitFileFetcherStorage) {
            this.cancelled = true;
        }
        for (SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage : this.segments) {
            splitFileFetcherSegmentStorage.cancel();
        }
        if (this.crossSegments != null) {
            for (SplitFileFetcherCrossSegmentStorage splitFileFetcherCrossSegmentStorage : this.crossSegments) {
                splitFileFetcherCrossSegmentStorage.cancel();
            }
        }
    }

    public void finishedCheckingDatastoreOnLocalRequest(ClientContext context) {
        if (this.hasFinished()) {
            return;
        }
        this.errors.inc(FetchException.FetchExceptionMode.ALL_DATA_NOT_FOUND);
        for (SplitFileFetcherSegmentStorage segment : this.segments) {
            segment.onFinishedCheckingDatastoreNoFetch(context);
        }
        this.maybeComplete();
    }

    synchronized boolean hasFinished() {
        return this.cancelled || this.finishedFetcher;
    }

    synchronized boolean isFinishing() {
        return this.cancelled || this.finishedFetcher || this.finishedEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(MyKey key, FetchException fe) {
        if (logMINOR) {
            Logger.minor(this, "Failure: " + (Object)((Object)fe.mode) + " for block " + key.blockNumber + " for " + key.segmentNumber);
        }
        SplitFileFetcherStorage splitFileFetcherStorage = this;
        synchronized (splitFileFetcherStorage) {
            if (this.cancelled || this.finishedFetcher) {
                return;
            }
            this.dirtyGeneralProgress = true;
        }
        this.errors.inc(fe.getMode());
        SplitFileFetcherSegmentStorage segment = this.segments[key.segmentNumber];
        segment.onNonFatalFailure(key.blockNumber);
        this.lazyWriteMetadata();
    }

    public ClientKey getKey(MyKey key) {
        try {
            return this.segments[key.segmentNumber].getSegmentKeys().getKey(key.blockNumber, null, false);
        }
        catch (IOException e) {
            this.failOnDiskError(e);
            return null;
        }
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public void failedBlock() {
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                SplitFileFetcherStorage.this.fetcher.onFailedBlock();
                return false;
            }
        });
    }

    public boolean lastBlockMightNotBePadded() {
        return this.finalMinCompatMode == InsertContext.CompatibilityMode.COMPAT_UNKNOWN || this.finalMinCompatMode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1416.ordinal();
    }

    public void restartedAfterDataCorruption(boolean wasCorrupt) {
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                SplitFileFetcherStorage.this.maybeClearCooldown();
                SplitFileFetcherStorage.this.fetcher.restartedAfterDataCorruption();
                return false;
            }
        });
    }

    void increaseCooldown(SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage, final long cooldownTime) {
        this.jobRunner.queueNormalOrDrop(new PersistentJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ClientContext context) {
                long wakeupTime;
                long now = System.currentTimeMillis();
                Object object = SplitFileFetcherStorage.this.cooldownLock;
                synchronized (object) {
                    if (cooldownTime < now) {
                        return false;
                    }
                    long oldCooldownTime = SplitFileFetcherStorage.this.overallCooldownWakeupTime;
                    if (SplitFileFetcherStorage.this.overallCooldownWakeupTime > now) {
                        return false;
                    }
                    wakeupTime = Long.MAX_VALUE;
                    for (SplitFileFetcherSegmentStorage segment : SplitFileFetcherStorage.this.segments) {
                        long segmentTime = segment.getOverallCooldownTime();
                        if (segmentTime < now) {
                            return false;
                        }
                        wakeupTime = Math.min(segmentTime, wakeupTime);
                    }
                    SplitFileFetcherStorage.this.overallCooldownWakeupTime = wakeupTime;
                    if (SplitFileFetcherStorage.this.overallCooldownWakeupTime < oldCooldownTime) {
                        return false;
                    }
                }
                SplitFileFetcherStorage.this.fetcher.reduceCooldown(wakeupTime);
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeClearCooldown() {
        Object object = this.cooldownLock;
        synchronized (object) {
            if (this.overallCooldownWakeupTime == 0L || this.overallCooldownWakeupTime < System.currentTimeMillis()) {
                return;
            }
            this.overallCooldownWakeupTime = 0L;
        }
        this.fetcher.clearCooldown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCooldownWakeupTime(long now) {
        if (this.hasFinished()) {
            return -1L;
        }
        Object object = this.cooldownLock;
        synchronized (object) {
            if (this.overallCooldownWakeupTime < now) {
                this.overallCooldownWakeupTime = 0L;
            }
            return this.overallCooldownWakeupTime;
        }
    }

    private byte[] appendChecksum(byte[] data) {
        return this.checksumChecker.appendChecksum(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preadChecksummed(long fileOffset, byte[] buf, int offset, int length) throws IOException, ChecksumFailedException {
        byte[] checksumBuf = new byte[this.checksumLength];
        LockableRandomAccessBuffer.RAFLock lock = this.raf.lockOpen();
        try {
            this.raf.pread(fileOffset, buf, offset, length);
            this.raf.pread(fileOffset + (long)length, checksumBuf, 0, this.checksumLength);
        }
        finally {
            lock.unlock();
        }
        if (!this.checksumChecker.checkChecksum(buf, offset, length, checksumBuf)) {
            Arrays.fill(buf, offset, offset + length, (byte)0);
            throw new ChecksumFailedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] preadChecksummedWithLength(long fileOffset) throws IOException, ChecksumFailedException, StorageFormatException {
        byte[] buf;
        int length;
        byte[] checksumBuf = new byte[this.checksumLength];
        LockableRandomAccessBuffer.RAFLock lock = this.raf.lockOpen();
        byte[] lengthBuf = new byte[8];
        try {
            this.raf.pread(fileOffset, lengthBuf, 0, lengthBuf.length);
            long len = new DataInputStream(new ByteArrayInputStream(lengthBuf)).readLong();
            if (len + fileOffset > this.rafLength || len > Integer.MAX_VALUE || len < 0L) {
                throw new StorageFormatException("Bogus length " + len);
            }
            length = (int)len;
            buf = new byte[length];
            this.raf.pread(fileOffset + (long)lengthBuf.length, buf, 0, length);
            this.raf.pread(fileOffset + (long)length + (long)lengthBuf.length, checksumBuf, 0, this.checksumLength);
        }
        finally {
            lock.unlock();
        }
        if (!this.checksumChecker.checkChecksum(buf, 0, length, checksumBuf)) {
            Arrays.fill(buf, 0, length, (byte)0);
            throw new ChecksumFailedException();
        }
        return buf;
    }

    OutputStream writeChecksummedTo(final long fileOffset, final int length) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        OutputStream cos = this.checksumOutputStream(baos);
        return new FilterOutputStream(cos){

            @Override
            public void close() throws IOException {
                this.out.close();
                byte[] buf = baos.toByteArray();
                if (buf.length != length) {
                    throw new IllegalStateException("Wrote wrong number of bytes: " + buf.length + " should be " + length);
                }
                SplitFileFetcherStorage.this.raf.pwrite(fileOffset, buf, 0, length);
            }
        };
    }

    LockableRandomAccessBuffer.RAFLock lockRAFOpen() throws IOException {
        return this.raf.lockOpen();
    }

    void writeBlock(SplitFileFetcherSegmentStorage segment, int slotNumber, byte[] data) throws IOException {
        this.raf.pwrite(segment.blockOffset(slotNumber), data, 0, data.length);
    }

    byte[] readBlock(SplitFileFetcherSegmentStorage segment, int slotNumber) throws IOException {
        long offset = segment.blockOffset(slotNumber);
        if (logDEBUG) {
            Logger.minor(this, "Reading block " + slotNumber + " for " + segment.segNo + "/" + this.segments.length + " from " + offset + " RAF length is " + this.raf.size());
        }
        byte[] buf = new byte[32768];
        this.raf.pread(offset, buf, 0, buf.length);
        return buf;
    }

    LockableRandomAccessBuffer getRAF() {
        return this.raf;
    }

    public synchronized void setHasCheckedStore(ClientContext context) {
        this.hasCheckedDatastore = true;
        this.dirtyGeneralProgress = true;
        if (!this.persistent) {
            return;
        }
        this.writeMetadataJob.run(context);
    }

    private synchronized void writeGeneralProgress(boolean force) {
        if (!this.dirtyGeneralProgress && !force) {
            return;
        }
        this.dirtyGeneralProgress = false;
        byte[] generalProgress = this.encodeGeneralProgress();
        try {
            this.raf.pwrite(this.offsetGeneralProgress, generalProgress, 0, generalProgress.length);
        }
        catch (IOException e) {
            this.failOnDiskError(e);
        }
    }

    public synchronized boolean hasCheckedStore() {
        return this.hasCheckedDatastore;
    }

    void onShutdown(ClientContext context) {
        this.writeMetadataJob.run(context);
    }

    static {
        Logger.registerClass(SplitFileFetcherStorage.class);
        LAZY_WRITE_METADATA_DELAY = TimeUnit.MINUTES.toMillis(5L);
    }

    final class MyKey
    implements SendableRequestItem,
    SendableRequestItemKey {
        final int blockNumber;
        final int segmentNumber;
        final SplitFileFetcherStorage get;
        final int hashCode;

        public MyKey(int n, int segNo, SplitFileFetcherStorage storage) {
            this.blockNumber = n;
            this.segmentNumber = segNo;
            this.get = storage;
            this.hashCode = this.initialHashCode();
        }

        @Override
        public void dump() {
        }

        @Override
        public SendableRequestItemKey getKey() {
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MyKey)) {
                return false;
            }
            MyKey k = (MyKey)o;
            return k.blockNumber == this.blockNumber && k.segmentNumber == this.segmentNumber && k.get == this.get;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        private int initialHashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.blockNumber;
            result = 31 * result + (this.get == null ? 0 : this.get.hashCode());
            result = 31 * result + this.segmentNumber;
            return result;
        }

        public String toString() {
            return "MyKey:" + this.segmentNumber + ":" + this.blockNumber;
        }
    }
}

