/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.DataCarryingMessage;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPPluginConnection;
import freenet.clients.fcp.FCPPluginMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.pluginmanager.PluginTalker;
import freenet.support.SimpleFieldSet;
import java.io.IOException;

public class FCPPluginClientMessage
extends DataCarryingMessage {
    public static final String NAME = "FCPPluginMessage";
    public static final String PARAM_PREFIX = "Param";
    private final String identifier;
    private final String pluginname;
    private final long dataLength;
    private final SimpleFieldSet plugparams;
    private final Boolean success;
    private final String errorCode;
    private final String errorMessage;

    FCPPluginClientMessage(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "FCPPluginMessage must contain a Identifier field", null, false);
        }
        this.pluginname = fs.get("PluginName");
        if (this.pluginname == null) {
            throw new MessageInvalidException(5, "FCPPluginMessage must contain a PluginName field", this.identifier, false);
        }
        boolean havedata = "Data".equals(fs.getEndMarker());
        String dataLengthString = fs.get("DataLength");
        if (!havedata && dataLengthString != null) {
            throw new MessageInvalidException(8, "A nondata message can't have a DataLength field", this.identifier, false);
        }
        if (havedata) {
            if (dataLengthString == null) {
                throw new MessageInvalidException(5, "Need DataLength on a Datamessage", this.identifier, false);
            }
            try {
                this.dataLength = Long.parseLong(dataLengthString, 10);
            }
            catch (NumberFormatException e) {
                throw new MessageInvalidException(6, "Error parsing DataLength field: " + e.getMessage(), this.identifier, false);
            }
        } else {
            this.dataLength = -1L;
        }
        SimpleFieldSet maybePlugparams = fs.subset(PARAM_PREFIX);
        SimpleFieldSet simpleFieldSet = this.plugparams = maybePlugparams != null ? maybePlugparams : new SimpleFieldSet(true);
        if (fs.get("Success") != null) {
            try {
                this.success = fs.getBoolean("Success");
            }
            catch (FSParseException e) {
                throw new MessageInvalidException(8, "Success must be a boolean (yes, no, true or false)", this.identifier, false);
            }
        } else {
            this.success = null;
        }
        if (this.success != null && !this.success.booleanValue()) {
            this.errorCode = fs.get("ErrorCode");
            this.errorMessage = this.errorCode != null ? fs.get("ErrorMessage") : null;
        } else {
            this.errorMessage = null;
            this.errorCode = null;
        }
    }

    @Override
    String getIdentifier() {
        return this.identifier;
    }

    @Override
    boolean isGlobal() {
        return false;
    }

    @Override
    long dataLength() {
        return this.dataLength;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected FCPPluginMessage constructFCPPluginMessage() {
        return FCPPluginMessage.constructRawMessage(null, this.identifier, this.plugparams, this.bucket, this.success, this.errorCode, this.errorMessage);
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        PluginTalker pt;
        FCPPluginConnection serverConnection = null;
        try {
            serverConnection = handler.getFCPPluginConnection(this.pluginname);
        }
        catch (PluginNotFoundException e1) {
            // empty catch block
        }
        if (serverConnection != null) {
            FCPPluginMessage message = this.constructFCPPluginMessage();
            try {
                serverConnection.send(FCPPluginConnection.SendDirection.ToServer, message);
            }
            catch (IOException e) {
                throw new MessageInvalidException(32, this.pluginname + " not found or is not a FCPPlugin", this.identifier, false);
            }
            return;
        }
        try {
            pt = new PluginTalker(node, handler, this.pluginname, this.identifier, handler.hasFullAccess());
        }
        catch (PluginNotFoundException e) {
            throw new MessageInvalidException(32, this.pluginname + " not found or is not a FCPPlugin", this.identifier, false);
        }
        pt.send(this.plugparams, this.bucket);
    }
}

