/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.KeyGenUtils;
import freenet.crypt.MACType;
import freenet.crypt.UnsupportedTypeException;
import freenet.support.Fields;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.crypto.generators.Poly1305KeyGenerator;

public final class MessageAuthCode {
    private final MACType type;
    private final Mac mac;
    private final SecretKey key;
    private IvParameterSpec iv;

    private MessageAuthCode(MACType type, SecretKey key, boolean genIV, IvParameterSpec iv) throws InvalidKeyException {
        this.type = type;
        this.mac = type.get();
        this.key = key;
        try {
            if (type.ivlen != -1) {
                this.checkPoly1305Key(key.getEncoded());
                if (genIV) {
                    this.genIV();
                } else {
                    this.setIV(iv);
                }
                this.mac.init(key, this.iv);
            } else {
                this.mac.init(key);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public MessageAuthCode(MACType type, SecretKey cryptoKey) throws InvalidKeyException {
        this(type, cryptoKey, false, null);
    }

    public MessageAuthCode(MACType type, byte[] cryptoKey) throws InvalidKeyException {
        this(type, KeyGenUtils.getSecretKey(type.keyType, cryptoKey));
    }

    public MessageAuthCode(MACType type, ByteBuffer cryptoKey) throws InvalidKeyException {
        this(type, Fields.copyToArray(cryptoKey));
    }

    public MessageAuthCode(MACType type) throws InvalidKeyException {
        this(type, KeyGenUtils.genSecretKey(type.keyType), true, null);
    }

    public MessageAuthCode(MACType type, SecretKey key, IvParameterSpec iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this(type, key, false, iv);
    }

    public MessageAuthCode(MACType type, byte[] key, IvParameterSpec iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this(type, KeyGenUtils.getSecretKey(type.keyType, key), iv);
    }

    private final void checkPoly1305Key(byte[] encodedKey) {
        if (this.type != MACType.Poly1305AES) {
            throw new UnsupportedTypeException(this.type);
        }
        Poly1305KeyGenerator.checkKey((byte[])encodedKey);
    }

    public final void addByte(byte input) {
        this.mac.update(input);
    }

    public final void addBytes(byte[] ... input) {
        for (byte[] b : input) {
            if (b == null) {
                throw new NullPointerException();
            }
            this.mac.update(b);
        }
    }

    public final void addBytes(ByteBuffer input) {
        this.mac.update(input);
    }

    public final void addBytes(byte[] input, int offset, int len) {
        if (input == null) {
            throw new NullPointerException();
        }
        this.mac.update(input, offset, len);
    }

    public final ByteBuffer genMac() {
        return ByteBuffer.wrap(this.mac.doFinal());
    }

    public final ByteBuffer genMac(byte[] ... input) {
        this.mac.reset();
        this.addBytes(input);
        return this.genMac();
    }

    public final ByteBuffer genMac(ByteBuffer input) {
        this.mac.reset();
        this.addBytes(input);
        return this.genMac();
    }

    public static final boolean verify(byte[] mac1, byte[] mac2) {
        return MessageDigest.isEqual(mac1, mac2);
    }

    public static final boolean verify(ByteBuffer mac1, ByteBuffer mac2) {
        return MessageDigest.isEqual(Fields.copyToArray(mac1), Fields.copyToArray(mac2));
    }

    public final boolean verifyData(byte[] otherMac, byte[] ... data) {
        return MessageAuthCode.verify(Fields.copyToArray(this.genMac(data)), otherMac);
    }

    public final boolean verifyData(ByteBuffer otherMac, ByteBuffer data) {
        return MessageAuthCode.verify(this.genMac(data), otherMac);
    }

    public final SecretKey getKey() {
        return this.key;
    }

    public final IvParameterSpec getIv() {
        if (this.type.ivlen == -1) {
            throw new UnsupportedTypeException(this.type);
        }
        return this.iv;
    }

    public final void setIV(IvParameterSpec iv) throws InvalidAlgorithmParameterException {
        if (this.type.ivlen == -1) {
            throw new UnsupportedTypeException(this.type);
        }
        this.iv = iv;
        try {
            this.mac.init(this.key, iv);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public final IvParameterSpec genIV() {
        if (this.type.ivlen == -1) {
            throw new UnsupportedTypeException(this.type);
        }
        try {
            this.setIV(KeyGenUtils.genIV(this.type.ivlen));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException(e);
        }
        return this.iv;
    }
}

