/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutter;
import freenet.client.async.PersistenceDisabledException;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.NodeIPPortDetector;
import freenet.node.RequestClient;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.SimpleReadOnlyArrayBucket;
import freenet.support.api.Bucket;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;

public class NodeARKInserter
implements ClientPutCallback,
RequestClient {
    private final Node node;
    private final NodeCrypto crypto;
    private final String darknetOpennetString;
    private final NodeIPPortDetector detector;
    private static boolean logMINOR;
    private final boolean enabled;
    private ClientPutter inserter;
    private boolean shouldInsert;
    private Peer[] lastInsertedPeers;
    private boolean canStart;

    NodeARKInserter(Node node, NodeCrypto crypto, NodeIPPortDetector detector, boolean enableARKs) {
        this.node = node;
        this.crypto = crypto;
        this.detector = detector;
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        this.darknetOpennetString = crypto.isOpennet ? "Opennet" : "Darknet";
        this.enabled = enableARKs;
    }

    void start() {
        if (!this.enabled) {
            return;
        }
        this.canStart = true;
        this.innerUpdate();
    }

    public void update() {
        this.node.executor.execute(new Runnable(){

            @Override
            public void run() {
                NodeARKInserter.this.innerUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerUpdate() {
        NodeARKInserter nodeARKInserter;
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        if (logMINOR) {
            Logger.minor(this, "update()");
        }
        if (!this.checkIPUpdated()) {
            return;
        }
        SimpleFieldSet nfs = this.crypto.exportPublicFieldSet(false, false, true);
        String[] entries = nfs.getAll("physical.udp");
        if (entries != null) {
            SimpleFieldSet fs = new SimpleFieldSet(true);
            fs.putOverwrite("physical.udp", entries);
            if (logMINOR) {
                Logger.minor(this, this.darknetOpennetString + " ref's physical.udp is '" + fs.toString() + "'");
            }
            this.node.peers.locallyBroadcastDiffNodeRef(fs, !this.crypto.isOpennet, this.crypto.isOpennet);
        } else if (logMINOR) {
            Logger.minor(this, this.darknetOpennetString + " ref's physical.udp is null");
        }
        if (logMINOR) {
            Logger.minor(this, "Inserting " + this.darknetOpennetString + " ARK because peers list changed");
        }
        if (this.inserter != null) {
            nodeARKInserter = this;
            synchronized (nodeARKInserter) {
                this.shouldInsert = true;
            }
            return;
        }
        if (this.node.noConnectedPeers()) {
            nodeARKInserter = this;
            synchronized (nodeARKInserter) {
                this.shouldInsert = true;
            }
            return;
        }
        this.startInserter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIPUpdated() {
        Peer[] p = this.detector.detectPrimaryPeers();
        if (p == null) {
            if (logMINOR) {
                Logger.minor(this, "Not inserting " + this.darknetOpennetString + " ARK because no IP address");
            }
            return false;
        }
        NodeARKInserter nodeARKInserter = this;
        synchronized (nodeARKInserter) {
            if (this.lastInsertedPeers != null) {
                if (p.length != this.lastInsertedPeers.length) {
                    return true;
                }
                for (int i = 0; i < p.length; ++i) {
                    if (p[i].strictEquals(this.lastInsertedPeers[i])) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInserter() {
        byte[] buf;
        if (!this.canStart) {
            if (logMINOR) {
                Logger.minor(this, this.darknetOpennetString + " ARK inserter can't start yet");
            }
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "starting " + this.darknetOpennetString + " ARK inserter");
        }
        SimpleFieldSet fs = this.crypto.exportPublicFieldSet(false, false, true);
        fs.removeSubset("ark");
        fs.removeValue("location");
        fs.removeValue("sig");
        String s = fs.toString();
        try {
            buf = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        SimpleReadOnlyArrayBucket b = new SimpleReadOnlyArrayBucket(buf);
        long number = this.crypto.myARKNumber;
        InsertableClientSSK ark = this.crypto.myARK;
        FreenetURI uri = ark.getInsertURI().setKeyType("USK").setSuggestedEdition(number);
        if (logMINOR) {
            Logger.minor(this, "Inserting " + this.darknetOpennetString + " ARK: " + uri + "  contents:\n" + s);
        }
        InsertContext ctx = this.node.clientCore.makeClient((short)0, true, false).getInsertContext(true);
        this.inserter = new ClientPutter(this, b, uri, null, ctx, 1, false, null, false, this.node.clientCore.clientContext, null, -1L);
        try {
            this.node.clientCore.clientContext.start(this.inserter);
            NodeARKInserter nodeARKInserter = this;
            synchronized (nodeARKInserter) {
                if (fs.get("physical.udp") == null) {
                    this.lastInsertedPeers = null;
                } else {
                    try {
                        String[] all = fs.getAll("physical.udp");
                        Peer[] peers = new Peer[all.length];
                        for (int i = 0; i < all.length; ++i) {
                            peers[i] = new Peer(all[i], false);
                        }
                        this.lastInsertedPeers = peers;
                    }
                    catch (PeerParseException e1) {
                        Logger.error(this, "Error parsing own " + this.darknetOpennetString + " ref: " + e1 + " : " + fs.get("physical.udp"), (Throwable)e1);
                    }
                    catch (UnknownHostException e1) {
                        Logger.error(this, "Error parsing own " + this.darknetOpennetString + " ref: " + e1 + " : " + fs.get("physical.udp"), (Throwable)e1);
                    }
                }
            }
        }
        catch (InsertException e) {
            this.onFailure(e, this.inserter);
        }
        catch (PersistenceDisabledException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(BaseClientPutter state) {
        FreenetURI uri = state.getURI();
        if (logMINOR) {
            Logger.minor(this, this.darknetOpennetString + " ARK insert succeeded: " + uri);
        }
        NodeARKInserter nodeARKInserter = this;
        synchronized (nodeARKInserter) {
            this.inserter = null;
            if (!this.shouldInsert) {
                return;
            }
            this.shouldInsert = false;
        }
        this.startInserter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, BaseClientPutter state) {
        if (logMINOR) {
            Logger.minor(this, this.darknetOpennetString + " ARK insert failed: " + e);
        }
        NodeARKInserter nodeARKInserter = this;
        synchronized (nodeARKInserter) {
            this.lastInsertedPeers = null;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startInserter();
    }

    @Override
    public void onGeneratedURI(FreenetURI uri, BaseClientPutter state) {
        long l;
        if (logMINOR) {
            Logger.minor(this, "Generated URI for " + this.darknetOpennetString + " ARK: " + uri);
        }
        if ((l = uri.getSuggestedEdition()) < this.crypto.myARKNumber) {
            Logger.error(this, "Inserted " + this.darknetOpennetString + " ARK edition # lower than attempted: " + l + " expected " + this.crypto.myARKNumber);
        } else if (l > this.crypto.myARKNumber) {
            if (logMINOR) {
                Logger.minor(this, this.darknetOpennetString + " ARK number moving from " + this.crypto.myARKNumber + " to " + l);
            }
            this.crypto.myARKNumber = l;
            if (this.crypto.isOpennet) {
                this.node.writeOpennetFile();
            } else {
                this.node.writeNodeFile();
            }
            SimpleFieldSet fs = new SimpleFieldSet(true);
            fs.put("ark.number", this.crypto.myARKNumber);
            this.node.peers.locallyBroadcastDiffNodeRef(fs, !this.crypto.isOpennet, this.crypto.isOpennet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectedPeer() {
        if (!this.checkIPUpdated()) {
            return;
        }
        NodeARKInserter nodeARKInserter = this;
        synchronized (nodeARKInserter) {
            if (!this.shouldInsert) {
                return;
            }
        }
        if (this.inserter != null) {
            return;
        }
        nodeARKInserter = this;
        synchronized (nodeARKInserter) {
            this.shouldInsert = false;
        }
        this.startInserter();
    }

    @Override
    public void onFetchable(BaseClientPutter state) {
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean realTimeFlag() {
        return false;
    }

    @Override
    public void onGeneratedMetadata(Bucket metadata, BaseClientPutter state) {
        Logger.error(this, "Bogus onGeneratedMetadata() on " + this + " from " + state, (Throwable)new Exception("error"));
        metadata.free();
    }

    @Override
    public void onResume(ClientContext context) {
    }

    @Override
    public RequestClient getRequestClient() {
        return this;
    }
}

