/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import freenet.node.NodeClientCore;
import freenet.node.fcp.FCPClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.List;

public class FCPPersistentRoot {
    final long nodeDBHandle;
    final FCPClient globalForeverClient;
    private static volatile boolean logMINOR;

    protected FCPPersistentRoot() {
        throw new UnsupportedOperationException();
    }

    public static FCPPersistentRoot load(final long nodeDBHandle, ObjectContainer container) {
        ObjectSet set = container.query((Predicate)new Predicate<FCPPersistentRoot>(){
            private static final long serialVersionUID = -8615907687034212486L;

            public boolean match(FCPPersistentRoot root) {
                return root.nodeDBHandle == nodeDBHandle;
            }
        });
        System.err.println("Count of roots: " + set.size());
        if (set.hasNext()) {
            System.err.println("Loaded FCP persistent root.");
            FCPPersistentRoot root = (FCPPersistentRoot)set.next();
            container.activate((Object)root, 2);
            if (root.globalForeverClient == null) {
                System.err.println("AAAAAAAAAAAAARGH!!!!!!");
                System.err.println("FCPPersistentRoot exists but no globalForeverClient!");
                container.delete((Object)root);
            } else {
                return root;
            }
        }
        System.err.println("No FCPPersistentRoot found, not migrating old database");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public List<FCPClient> findNonGlobalClients(NodeClientCore core, ObjectContainer container) {
        ArrayList<FCPClient> results = new ArrayList<FCPClient>();
        Query query = container.query();
        query.constrain(FCPClient.class);
        ObjectSet set = query.execute();
        try {
            while (set.hasNext()) {
                FCPClient client = (FCPClient)set.next();
                try {
                    container.activate((Object)client, 1);
                    if (client.root != this) {
                        Logger.error(this, "Ignoring client with wrong FCPPersistentRoot");
                        continue;
                    }
                    if (client.isGlobalQueue) {
                        Logger.error(this, "Ignoring global queue");
                        continue;
                    }
                    Logger.error(this, "Will migrate client " + client.name);
                    results.add(client);
                }
                catch (Throwable t) {
                    Logger.error(this, "Failed to load client: " + t, t);
                }
            }
            return results;
        }
        catch (Throwable t) {
            Logger.error(this, "Failed to load clients: " + t, t);
            return results;
        }
    }

    public FCPClient getGlobalClient() {
        return this.globalForeverClient;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

