/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FailureCodeTracker;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.BinaryBlob;
import freenet.client.async.BinaryBlobFormatException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.ClientPutter;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.SimpleBlockSet;
import freenet.keys.CHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.SSKBlock;
import freenet.node.LowLevelPutException;
import freenet.node.RequestClient;
import freenet.node.SendableRequestItem;
import freenet.node.SimpleSendableInsert;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class BinaryBlobInserter
implements ClientPutState {
    final ClientPutter parent;
    final RequestClient clientContext;
    final MySendableInsert[] inserters;
    final FailureCodeTracker errors;
    final int maxRetries;
    final int consecutiveRNFsCountAsSuccess;
    private boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
    private int completedBlocks;
    private int succeededBlocks;
    private boolean fatal;
    final InsertContext ctx;
    final boolean realTimeFlag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BinaryBlobInserter(Bucket blob, ClientPutter parent, RequestClient clientContext, boolean tolerant, short prioClass, InsertContext ctx, ClientContext context) throws IOException, BinaryBlobFormatException {
        this.ctx = ctx;
        this.maxRetries = ctx.maxInsertRetries;
        this.consecutiveRNFsCountAsSuccess = ctx.consecutiveRNFsCountAsSuccess;
        this.parent = parent;
        this.clientContext = clientContext;
        this.errors = new FailureCodeTracker(true);
        this.realTimeFlag = clientContext.realTimeFlag();
        DataInputStream dis = new DataInputStream(blob.getInputStream());
        SimpleBlockSet blocks = new SimpleBlockSet();
        try {
            BinaryBlob.readBinaryBlob(dis, blocks, tolerant);
        }
        finally {
            dis.close();
        }
        ArrayList<MySendableInsert> myInserters = new ArrayList<MySendableInsert>();
        int x = 0;
        for (Key key : blocks.keys()) {
            KeyBlock block = blocks.get(key);
            MySendableInsert inserter = new MySendableInsert(x++, block, prioClass, this.getScheduler(block, context), clientContext);
            myInserters.add(inserter);
        }
        this.inserters = myInserters.toArray(new MySendableInsert[myInserters.size()]);
        parent.addMustSucceedBlocks(this.inserters.length);
        parent.notifyClients(context);
    }

    private ClientRequestScheduler getScheduler(KeyBlock block, ClientContext context) {
        if (block instanceof CHKBlock) {
            return context.getChkInsertScheduler(this.realTimeFlag);
        }
        if (block instanceof SSKBlock) {
            return context.getSskInsertScheduler(this.realTimeFlag);
        }
        throw new IllegalArgumentException("Unknown block type " + block.getClass() + " : " + block);
    }

    @Override
    public void cancel(ClientContext context) {
        for (MySendableInsert inserter : this.inserters) {
            if (inserter == null) continue;
            inserter.cancel(context);
        }
        this.parent.onFailure(new InsertException(InsertException.InsertExceptionMode.CANCELLED), this, context);
    }

    @Override
    public BaseClientPutter getParent() {
        return this.parent;
    }

    @Override
    public Object getToken() {
        return this.clientContext;
    }

    @Override
    public void schedule(ClientContext context) throws InsertException {
        for (MySendableInsert inserter : this.inserters) {
            inserter.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeFinish(ClientContext context) {
        boolean wasFatal;
        boolean success;
        BinaryBlobInserter binaryBlobInserter = this;
        synchronized (binaryBlobInserter) {
            if (this.completedBlocks != this.inserters.length) {
                return;
            }
            success = this.completedBlocks == this.succeededBlocks;
            wasFatal = this.fatal;
        }
        if (success) {
            this.parent.onSuccess(this, context);
        } else if (wasFatal) {
            this.parent.onFailure(new InsertException(InsertException.InsertExceptionMode.FATAL_ERRORS_IN_BLOCKS, this.errors, null), this, context);
        } else {
            this.parent.onFailure(new InsertException(InsertException.InsertExceptionMode.TOO_MANY_RETRIES_IN_BLOCKS, this.errors, null), this, context);
        }
    }

    @Override
    public void onResume(ClientContext context) throws InsertException {
        throw new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, "Persistence not supported yet", null);
    }

    @Override
    public void onShutdown(ClientContext context) {
    }

    class MySendableInsert
    extends SimpleSendableInsert {
        private static final long serialVersionUID = 1L;
        final int blockNum;
        private int consecutiveRNFs;
        private int retries;

        public MySendableInsert(int i, KeyBlock block, short prioClass, ClientRequestScheduler scheduler, RequestClient client) {
            super(block, prioClass, client, scheduler);
            this.blockNum = i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(SendableRequestItem keyNum, ClientKey key, ClientContext context) {
            MySendableInsert mySendableInsert = this;
            synchronized (mySendableInsert) {
                if (BinaryBlobInserter.this.inserters[this.blockNum] == null) {
                    return;
                }
                BinaryBlobInserter.this.inserters[this.blockNum] = null;
                BinaryBlobInserter.this.completedBlocks++;
                BinaryBlobInserter.this.succeededBlocks++;
            }
            BinaryBlobInserter.this.parent.completedBlock(false, context);
            BinaryBlobInserter.this.maybeFinish(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(LowLevelPutException e, SendableRequestItem keyNum, ClientContext context) {
            BinaryBlobInserter binaryBlobInserter = BinaryBlobInserter.this;
            synchronized (binaryBlobInserter) {
                if (BinaryBlobInserter.this.inserters[this.blockNum] == null) {
                    return;
                }
            }
            if (BinaryBlobInserter.this.parent.isCancelled()) {
                this.fail(new InsertException(InsertException.InsertExceptionMode.CANCELLED), true, context);
                return;
            }
            BinaryBlobInserter.this.logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)BinaryBlobInserter.this);
            switch (e.code) {
                case 5: {
                    this.fail(new InsertException(InsertException.InsertExceptionMode.COLLISION), false, context);
                    break;
                }
                case 1: {
                    BinaryBlobInserter.this.errors.inc(InsertException.InsertExceptionMode.INTERNAL_ERROR);
                    break;
                }
                case 3: {
                    BinaryBlobInserter.this.errors.inc(InsertException.InsertExceptionMode.REJECTED_OVERLOAD);
                    break;
                }
                case 2: {
                    BinaryBlobInserter.this.errors.inc(InsertException.InsertExceptionMode.ROUTE_NOT_FOUND);
                    break;
                }
                case 4: {
                    BinaryBlobInserter.this.errors.inc(InsertException.InsertExceptionMode.ROUTE_REALLY_NOT_FOUND);
                    break;
                }
                default: {
                    Logger.error(this, "Unknown LowLevelPutException code: " + e.code);
                    BinaryBlobInserter.this.errors.inc(InsertException.InsertExceptionMode.INTERNAL_ERROR);
                }
            }
            if (e.code == 2) {
                ++this.consecutiveRNFs;
                if (BinaryBlobInserter.this.logMINOR) {
                    Logger.minor(this, "Consecutive RNFs: " + this.consecutiveRNFs + " / " + BinaryBlobInserter.this.consecutiveRNFsCountAsSuccess);
                }
                if (this.consecutiveRNFs == BinaryBlobInserter.this.consecutiveRNFsCountAsSuccess) {
                    if (BinaryBlobInserter.this.logMINOR) {
                        Logger.minor(this, "Consecutive RNFs: " + this.consecutiveRNFs + " - counting as success");
                    }
                    this.onSuccess(keyNum, null, context);
                    return;
                }
            } else {
                this.consecutiveRNFs = 0;
            }
            if (BinaryBlobInserter.this.logMINOR) {
                Logger.minor(this, "Failed: " + e);
            }
            ++this.retries;
            if (this.retries > BinaryBlobInserter.this.maxRetries && BinaryBlobInserter.this.maxRetries != -1) {
                this.fail(InsertException.construct(BinaryBlobInserter.this.errors), false, context);
                return;
            }
            this.clearWakeupTime(context);
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(InsertException e, boolean fatal, ClientContext context) {
            BinaryBlobInserter binaryBlobInserter = BinaryBlobInserter.this;
            synchronized (binaryBlobInserter) {
                if (BinaryBlobInserter.this.inserters[this.blockNum] == null) {
                    return;
                }
                BinaryBlobInserter.this.inserters[this.blockNum] = null;
                BinaryBlobInserter.this.completedBlocks++;
                if (fatal) {
                    BinaryBlobInserter.this.fatal = true;
                }
            }
            if (fatal) {
                BinaryBlobInserter.this.parent.fatallyFailedBlock(context);
            } else {
                BinaryBlobInserter.this.parent.failedBlock(context);
            }
            BinaryBlobInserter.this.maybeFinish(context);
        }
    }
}

