/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientContext;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.client.async.PersistentJobRunner;
import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.io.NativeThread;
import java.util.ArrayList;
import java.util.List;

public abstract class PersistentJobRunnerImpl
implements PersistentJobRunner {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final Executor executor;
    final Ticker ticker;
    private int runningJobs;
    private boolean mustCheckpoint;
    private final List<QueuedJob> queuedJobs;
    private ClientContext context;
    private long lastCheckpointed;
    static final int WRITE_AT_PRIORITY;
    final long checkpointInterval;
    private Object sync = new Object();
    protected Object serializeCheckpoints = new Object();
    private boolean willCheck = false;
    private boolean loading = false;
    private boolean enableCheckpointing = false;
    private boolean loaded = false;
    private boolean writing = false;
    private boolean killed = false;

    public PersistentJobRunnerImpl(Executor executor, Ticker ticker, long interval) {
        this.executor = executor;
        this.ticker = ticker;
        this.queuedJobs = new ArrayList<QueuedJob>();
        this.lastCheckpointed = System.currentTimeMillis();
        this.checkpointInterval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClientContext context) {
        Object object = this.sync;
        synchronized (object) {
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(PersistentJob job, int threadPriority) throws PersistenceDisabledException {
        Object object = this.sync;
        synchronized (object) {
            if (!this.loading) {
                throw new PersistenceDisabledException();
            }
            if (this.killed) {
                throw new PersistenceDisabledException();
            }
            if (this.context == null) {
                throw new IllegalStateException();
            }
            if (this.mustCheckpoint && this.enableCheckpointing) {
                if (logDEBUG) {
                    Logger.debug(this, "Queueing job " + job);
                }
                this.queuedJobs.add(new QueuedJob(job, threadPriority));
            } else {
                if (logDEBUG) {
                    Logger.debug(this, "Running job " + job);
                }
                this.executor.execute(new JobRunnable(job, threadPriority, this.context));
                ++this.runningJobs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueInternal(PersistentJob job, int threadPriority) throws PersistenceDisabledException {
        Object object = this.sync;
        synchronized (object) {
            if (!this.loading) {
                throw new PersistenceDisabledException();
            }
            if (this.killed) {
                throw new PersistenceDisabledException();
            }
            if (this.context == null) {
                throw new IllegalStateException();
            }
            if (this.writing) {
                Logger.error(this, "Internal job must not be queued during writing! They should have finished before we start writing and cannot be started \"externally\"!", (Throwable)new Exception("error"));
                this.queuedJobs.add(new QueuedJob(job, threadPriority));
            } else {
                if (this.mustCheckpoint && logMINOR) {
                    Logger.minor(this, "Delaying checkpoint...");
                }
                ++this.runningJobs;
                if (logDEBUG) {
                    Logger.debug(this, "Running job " + job);
                }
                this.executor.execute(new JobRunnable(job, threadPriority, this.context));
            }
        }
    }

    @Override
    public void queueInternal(PersistentJob job) {
        try {
            this.queueInternal(job, NativeThread.NORM_PRIORITY);
        }
        catch (PersistenceDisabledException e) {
            Logger.error(this, "Dropping internal job because persistence has been turned off!: " + e, (Throwable)e);
        }
    }

    @Override
    public void queueNormalOrDrop(PersistentJob job) {
        try {
            this.queue(job, NativeThread.NORM_PRIORITY);
        }
        catch (PersistenceDisabledException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCompletion(boolean ret, int threadPriority) {
        Object object = this.sync;
        synchronized (object) {
            if (ret) {
                this.mustCheckpoint = true;
                if (logMINOR) {
                    Logger.minor(this, "Writing because asked to");
                }
            }
            --this.runningJobs;
            if (this.runningJobs == 0) {
                this.sync.notifyAll();
            }
            if (!this.enableCheckpointing) {
                if (logMINOR) {
                    Logger.minor(this, "Not enableCheckpointing yet");
                }
                return;
            }
            if (!this.mustCheckpoint && System.currentTimeMillis() - this.lastCheckpointed > this.checkpointInterval) {
                this.mustCheckpoint = true;
                if (logMINOR) {
                    Logger.minor(this, "Writing at interval");
                }
            }
            if (!this.mustCheckpoint) {
                this.delayedCheckpoint();
                return;
            }
            if (this.runningJobs != 0) {
                if (logDEBUG) {
                    Logger.debug(this, "Not writing yet");
                }
                return;
            }
            if (!this.killed) {
                this.writing = true;
                if (threadPriority < WRITE_AT_PRIORITY) {
                    this.checkpointOffThread();
                    return;
                }
            }
        }
        this.checkpoint(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpoint(boolean shutdown) {
        if (logMINOR) {
            Logger.minor(this, "Writing checkpoint...");
        }
        Object object = this.sync;
        synchronized (object) {
            if (!this.enableCheckpointing) {
                this.writing = false;
                this.sync.notifyAll();
                return;
            }
        }
        object = this.serializeCheckpoints;
        synchronized (object) {
            try {
                this.innerCheckpoint(shutdown);
            }
            catch (Throwable t) {
                Logger.error(this, "Unable to save: " + t, t);
            }
        }
        object = this.sync;
        synchronized (object) {
            this.mustCheckpoint = false;
            this.writing = false;
            QueuedJob[] jobs = this.queuedJobs.toArray(new QueuedJob[this.queuedJobs.size()]);
            if (logDEBUG) {
                Logger.debug(this, "Starting " + jobs.length + " queued jobs");
            }
            for (QueuedJob job : jobs) {
                ++this.runningJobs;
                this.executor.execute(new JobRunnable(job.job, job.threadPriority, this.context));
            }
            this.updateLastCheckpointed();
            this.queuedJobs.clear();
            this.sync.notifyAll();
        }
        if (logMINOR) {
            Logger.minor(this, "Completed writing checkpoint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayedCheckpoint() {
        Object object = this.sync;
        synchronized (object) {
            if (this.killed || !this.enableCheckpointing) {
                return;
            }
            if (this.willCheck) {
                return;
            }
            this.ticker.queueTimedJob(new PrioRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = PersistentJobRunnerImpl.this.sync;
                    synchronized (object) {
                        PersistentJobRunnerImpl.this.willCheck = false;
                        if (!PersistentJobRunnerImpl.this.mustCheckpoint && System.currentTimeMillis() - PersistentJobRunnerImpl.this.lastCheckpointed <= PersistentJobRunnerImpl.this.checkpointInterval) {
                            return;
                        }
                        if (PersistentJobRunnerImpl.this.killed || !PersistentJobRunnerImpl.this.enableCheckpointing) {
                            return;
                        }
                        if (PersistentJobRunnerImpl.this.runningJobs != 0) {
                            return;
                        }
                        PersistentJobRunnerImpl.this.writing = true;
                    }
                    PersistentJobRunnerImpl.this.checkpoint(false);
                }

                @Override
                public int getPriority() {
                    return WRITE_AT_PRIORITY;
                }
            }, this.checkpointInterval);
            this.willCheck = true;
        }
    }

    public void checkpointOffThread() {
        this.executor.execute(new PrioRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = PersistentJobRunnerImpl.this.sync;
                synchronized (object) {
                    if (PersistentJobRunnerImpl.this.killed || !PersistentJobRunnerImpl.this.enableCheckpointing) {
                        PersistentJobRunnerImpl.this.writing = false;
                        PersistentJobRunnerImpl.this.sync.notifyAll();
                        return;
                    }
                }
                PersistentJobRunnerImpl.this.checkpoint(false);
            }

            @Override
            public int getPriority() {
                return WRITE_AT_PRIORITY;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckpointASAP() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.enableCheckpointing) {
                return;
            }
            this.mustCheckpoint = true;
            if (this.runningJobs != 0) {
                return;
            }
        }
        this.checkpointOffThread();
    }

    protected void updateLastCheckpointed() {
        this.lastCheckpointed = System.currentTimeMillis();
    }

    protected abstract void innerCheckpoint(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLoading() {
        Object object = this.sync;
        synchronized (object) {
            this.loading = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStarted(boolean noWrite) {
        Object object = this.sync;
        synchronized (object) {
            this.loading = true;
            if (!noWrite) {
                this.enableCheckpointing = true;
            }
            this.loaded = true;
            this.updateLastCheckpointed();
            this.writing = true;
        }
        this.checkpointOffThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.sync;
        synchronized (object) {
            this.killed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shuttingDown() {
        Object object = this.sync;
        synchronized (object) {
            return this.killed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIdleAndCheckpoint() {
        Object object = this.sync;
        synchronized (object) {
            while (this.runningJobs > 0 || this.writing) {
                if (!this.enableCheckpointing) {
                    return;
                }
                System.out.println("Waiting to shutdown: " + this.runningJobs + " running" + (this.writing ? " (writing)" : ""));
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.checkpoint(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndCheckpoint() throws PersistenceDisabledException {
        Object object = this.sync;
        synchronized (object) {
            if (!this.enableCheckpointing) {
                return;
            }
            this.mustCheckpoint = true;
            while (this.runningJobs > 0) {
                if (!this.enableCheckpointing) {
                    return;
                }
                if (this.killed) {
                    throw new PersistenceDisabledException();
                }
                Logger.error(this, "Waiting for " + this.runningJobs + " to finish before checkpoint");
                try {
                    this.sync.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.writing) {
                while (this.writing) {
                    if (!this.enableCheckpointing) {
                        return;
                    }
                    if (this.killed) {
                        throw new PersistenceDisabledException();
                    }
                    try {
                        this.sync.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            this.writing = true;
        }
        this.checkpoint(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killAndWaitForNotWriting() {
        Object object = this.sync;
        synchronized (object) {
            this.killed = true;
            while (this.writing) {
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNotWriting() {
        Object object = this.sync;
        synchronized (object) {
            while (this.writing) {
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAndWaitForNotRunning() {
        Object object = this.sync;
        synchronized (object) {
            this.killed = true;
            while (this.runningJobs > 0 || this.writing) {
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKilledOrNotLoaded() {
        Object object = this.sync;
        synchronized (object) {
            return this.killed || !this.loaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLoaded() {
        Object object = this.sync;
        synchronized (object) {
            return this.loaded;
        }
    }

    protected ClientContext getClientContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentJobRunner.CheckpointLock lock() throws PersistenceDisabledException {
        Object object = this.sync;
        synchronized (object) {
            if (this.killed) {
                throw new PersistenceDisabledException();
            }
            while (this.writing || this.mustCheckpoint) {
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.killed) continue;
                throw new PersistenceDisabledException();
            }
            ++this.runningJobs;
        }
        return new PersistentJobRunner.CheckpointLock(){

            @Override
            public void unlock(boolean forceWrite, int threadPriority) {
                PersistentJobRunnerImpl.this.handleCompletion(forceWrite, threadPriority);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableWrite() {
        Object object = this.sync;
        synchronized (object) {
            this.enableCheckpointing = false;
        }
    }

    static {
        Logger.registerClass(PersistentJobRunnerImpl.class);
        WRITE_AT_PRIORITY = NativeThread.HIGH_PRIORITY - 1;
    }

    private class QueuedJob {
        final PersistentJob job;
        final int threadPriority;

        public QueuedJob(PersistentJob job, int threadPriority) {
            this.job = job;
            this.threadPriority = threadPriority;
        }
    }

    private class JobRunnable
    implements Runnable {
        private final int threadPriority;
        private final PersistentJob job;
        private final ClientContext context;

        public JobRunnable(PersistentJob job, int threadPriority, ClientContext context) {
            this.job = job;
            this.threadPriority = threadPriority;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean ret = false;
            try {
                if (logDEBUG) {
                    Logger.debug(this, "Starting " + this.job);
                }
                ret = this.job.run(this.context);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " running job " + this.job, t);
            }
            finally {
                if (logDEBUG) {
                    Logger.debug(this, "Completed " + this.job + " with mustCheckpoint=" + PersistentJobRunnerImpl.this.mustCheckpoint + " enableCheckpointing=" + PersistentJobRunnerImpl.this.enableCheckpointing + " runningJobs=" + PersistentJobRunnerImpl.this.runningJobs);
                }
                PersistentJobRunnerImpl.this.handleCompletion(ret, this.threadPriority);
            }
        }
    }
}

