/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ArchiveContext;
import freenet.client.ArchiveExtractCallback;
import freenet.client.ArchiveFailureException;
import freenet.client.ArchiveHandler;
import freenet.client.ArchiveManager;
import freenet.client.ArchiveRestartException;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertContext;
import freenet.client.Metadata;
import freenet.client.MetadataParseException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetWorkerThread;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.PersistentJob;
import freenet.client.async.SimpleSingleFileFetcher;
import freenet.client.async.SingleFileStreamGenerator;
import freenet.client.async.SnoopBucket;
import freenet.client.async.SnoopMetadata;
import freenet.client.async.SplitFileFetcher;
import freenet.client.async.StreamGenerator;
import freenet.client.async.USKFetcherTag;
import freenet.client.async.USKFetcherTagCallback;
import freenet.client.async.USKProxyCompletionCallback;
import freenet.crypt.HashResult;
import freenet.crypt.MultiHashInputStream;
import freenet.keys.BaseClientKey;
import freenet.keys.ClientCHK;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.Compressor;
import freenet.support.compress.DecompressorThreadManager;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.InsufficientDiskSpaceException;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class SingleFileFetcher
extends SimpleSingleFileFetcher {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    final FreenetURI uri;
    private final ArrayList<String> metaStrings;
    private int addedMetaStrings;
    final ClientMetadata clientMetadata;
    private Metadata metadata;
    private Metadata archiveMetadata;
    final ArchiveContext actx;
    private ArchiveHandler ah;
    private int recursionLevel;
    private FreenetURI thisKey;
    private final LinkedList<Compressor.COMPRESSOR_TYPE> decompressors;
    private final boolean dontTellClientGet;
    private final boolean isFinal;
    private final SnoopMetadata metaSnoop;
    private final SnoopBucket bucketSnoop;
    private boolean topDontCompress = false;
    private short topCompatibilityMode = 0;

    public SingleFileFetcher(ClientRequester parent, GetCompletionCallback cb, ClientMetadata metadata, ClientKey key, List<String> metaStrings, FreenetURI origURI, int addedMetaStrings, FetchContext ctx, boolean deleteFetchContext, boolean realTimeFlag, ArchiveContext actx, ArchiveHandler ah, Metadata archiveMetadata, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean isEssential, boolean isFinal, boolean topDontCompress, short topCompatibilityMode, ClientContext context, boolean hasInitialMetadata) throws FetchException {
        super(key, maxRetries, ctx, parent, cb, isEssential, false, l, context, deleteFetchContext, realTimeFlag);
        if (logMINOR) {
            Logger.minor(this, "Creating SingleFileFetcher for " + key + " from " + origURI + " meta=" + metaStrings.toString() + " persistent=" + this.persistent, (Throwable)new Exception("debug"));
        }
        this.isFinal = isFinal;
        this.cancelled = false;
        this.dontTellClientGet = dontTellClientGet;
        if (this.persistent && ah != null) {
            ah = ah.cloneHandler();
        }
        this.ah = ah;
        this.archiveMetadata = archiveMetadata;
        this.metaStrings = metaStrings instanceof ArrayList && !this.persistent ? (ArrayList<Object>)metaStrings : new ArrayList<String>(metaStrings);
        this.addedMetaStrings = addedMetaStrings;
        if (logMINOR) {
            Logger.minor(this, "Metadata: " + metadata);
        }
        this.clientMetadata = metadata != null ? metadata.clone() : new ClientMetadata();
        this.thisKey = hasInitialMetadata ? FreenetURI.EMPTY_CHK_URI : key.getURI();
        if (origURI == null) {
            throw new NullPointerException();
        }
        this.uri = this.persistent ? origURI.clone() : origURI;
        this.actx = actx;
        this.recursionLevel = recursionLevel + 1;
        if (recursionLevel > ctx.maxRecursionLevel) {
            throw new FetchException(FetchException.FetchExceptionMode.TOO_MUCH_RECURSION, "Too much recursion: " + recursionLevel + " > " + ctx.maxRecursionLevel);
        }
        this.decompressors = new LinkedList();
        this.topDontCompress = topDontCompress;
        this.topCompatibilityMode = topCompatibilityMode;
        if (parent instanceof ClientGetter) {
            this.metaSnoop = ((ClientGetter)parent).getMetaSnoop();
            this.bucketSnoop = ((ClientGetter)parent).getBucketSnoop();
        } else {
            this.metaSnoop = null;
            this.bucketSnoop = null;
        }
    }

    public SingleFileFetcher(SingleFileFetcher fetcher, boolean persistent, boolean deleteFetchContext, Metadata newMeta, GetCompletionCallback callback, FetchContext ctx2, ClientContext context) throws FetchException {
        super(persistent ? fetcher.key.cloneKey() : fetcher.key, fetcher.maxRetries, ctx2, fetcher.parent, callback, false, true, fetcher.token, context, deleteFetchContext, fetcher.realTimeFlag);
        if (logMINOR) {
            Logger.minor(this, "Creating SingleFileFetcher for " + fetcher.key + " meta=" + fetcher.metaStrings.toString(), (Throwable)new Exception("debug"));
        }
        this.isFinal = false;
        this.dontTellClientGet = fetcher.dontTellClientGet;
        this.actx = fetcher.actx;
        this.ah = fetcher.ah;
        if (persistent && this.ah != null) {
            this.ah = this.ah.cloneHandler();
        }
        this.archiveMetadata = null;
        this.clientMetadata = fetcher.clientMetadata != null ? fetcher.clientMetadata.clone() : new ClientMetadata();
        this.metadata = newMeta;
        this.metaStrings = new ArrayList();
        this.addedMetaStrings = 0;
        this.recursionLevel = fetcher.recursionLevel + 1;
        if (this.recursionLevel > this.ctx.maxRecursionLevel) {
            throw new FetchException(FetchException.FetchExceptionMode.TOO_MUCH_RECURSION);
        }
        this.thisKey = fetcher.thisKey;
        this.decompressors = new LinkedList();
        if (fetcher.uri == null) {
            throw new NullPointerException();
        }
        this.uri = persistent ? fetcher.uri.clone() : fetcher.uri;
        this.metaSnoop = fetcher.metaSnoop;
        this.bucketSnoop = fetcher.bucketSnoop;
        this.topDontCompress = fetcher.topDontCompress;
        this.topCompatibilityMode = fetcher.topCompatibilityMode;
    }

    @Override
    public void onSuccess(ClientKeyBlock block, boolean fromStore, Object token, ClientContext context) {
        if (this.parent instanceof ClientGetter) {
            ((ClientGetter)this.parent).addKeyToBinaryBlob(block, context);
        }
        this.parent.completedBlock(fromStore, context);
        if (block == null) {
            Logger.error(this, "block is null! fromStore=" + fromStore + ", token=" + token, (Throwable)new Exception("error"));
            return;
        }
        Bucket data = this.extract(block, context);
        if (this.key instanceof ClientSSK) {
            context.uskManager.checkUSK(this.uri, this.persistent, data != null && !block.isMetadata());
        }
        if (data == null) {
            if (logMINOR) {
                Logger.minor(this, "No data");
            }
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Block " + (block.isMetadata() ? "is metadata" : "is not metadata") + " on " + this);
        }
        if (this.bucketSnoop != null && this.bucketSnoop.snoopBucket(data, block.isMetadata(), context)) {
            this.cancel(context);
            data.free();
            return;
        }
        if (!block.isMetadata()) {
            this.onSuccess(new FetchResult(this.clientMetadata, data), context);
        } else {
            this.handleMetadata(data, context);
        }
    }

    void startWithMetadata(Bucket data, ClientContext context) {
        this.parent.completedBlock(true, context);
        this.handleMetadata(data, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMetadata(Bucket data, ClientContext context) {
        if (!this.ctx.followRedirects) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, "Told me not to follow redirects (splitfile block??)"), false, context);
            data.free();
            return;
        }
        if (this.parent.isCancelled()) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.CANCELLED), false, context);
            data.free();
            return;
        }
        if (data.size() > (long)this.ctx.maxMetadataSize) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.TOO_BIG_METADATA), false, context);
            data.free();
            return;
        }
        try {
            this.metadata = Metadata.construct(data);
            data.free();
            data = null;
            this.innerWrapHandleMetadata(false, context);
        }
        catch (MetadataParseException e) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, (Throwable)e), false, context);
        }
        catch (EOFException e) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, (Throwable)e), false, context);
        }
        catch (InsufficientDiskSpaceException e) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_DISK_SPACE), false, context);
        }
        catch (IOException e) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e), false, context);
        }
        finally {
            if (data != null) {
                data.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSuccess(final FetchResult result, ClientContext context) {
        SingleFileFetcher singleFileFetcher = this;
        synchronized (singleFileFetcher) {
            this.finished = true;
        }
        if (this.parent.isCancelled()) {
            if (logMINOR) {
                Logger.minor(this, "Parent is cancelled");
            }
            result.asBucket().free();
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.CANCELLED), false, context);
            return;
        }
        if (!this.ctx.ignoreTooManyPathComponents && !this.metaStrings.isEmpty() && this.isFinal) {
            if (this.addedMetaStrings > 0) {
                this.rcb.onFailure(new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, "Invalid metadata: too many path components in redirects", this.thisKey), this, context);
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Too many path components: for " + this.uri + " meta=" + this.metaStrings.toString());
                }
                FreenetURI tryURI = this.uri;
                tryURI = tryURI.dropLastMetaStrings(this.metaStrings.size());
                this.rcb.onFailure(new FetchException(FetchException.FetchExceptionMode.TOO_MANY_PATH_COMPONENTS, result.size(), this.rcb == this.parent, result.getMimeType(), tryURI), this, context);
            }
            result.asBucket().free();
            return;
        }
        if (result.size() > this.ctx.maxOutputLength) {
            this.rcb.onFailure(new FetchException(FetchException.FetchExceptionMode.TOO_BIG, result.size(), this.rcb == this.parent, result.getMimeType()), this, context);
            result.asBucket().free();
        } else {
            context.getJobRunner(this.persistent()).queueInternal(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    SingleFileFetcher.this.rcb.onSuccess(new SingleFileStreamGenerator(result.asBucket(), SingleFileFetcher.this.persistent), result.getMetadata(), SingleFileFetcher.this.decompressors, SingleFileFetcher.this, context);
                    return true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleMetadata(ClientContext context) throws FetchException, MetadataParseException, ArchiveFailureException, ArchiveRestartException {
        block91: {
            long uncompressedLen;
            String mimeType;
            if (this.uri == null) {
                throw new NullPointerException("uri = null on SFI?? " + this);
            }
            SingleFileFetcher singleFileFetcher = this;
            synchronized (singleFileFetcher) {
                if (this.cancelled) {
                    return;
                }
                this.finished = true;
            }
            while (true) {
                if (this.metaSnoop != null && this.metaSnoop.snoopMetadata(this.metadata, context)) {
                    this.cancel(context);
                    return;
                }
                if (this.metaStrings.size() == 0) {
                    HashResult[] hashes;
                    if (this.metadata.hasTopData()) {
                        if (this.metadata.topSize > this.ctx.maxOutputLength || this.metadata.topCompressedSize > this.ctx.maxTempLength) {
                            if (this.metadata.isSimpleRedirect() || this.metadata.isSplitfile()) {
                                this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                            }
                            throw new FetchException(FetchException.FetchExceptionMode.TOO_BIG, this.metadata.topSize, true, this.clientMetadata.getMIMEType());
                        }
                        this.rcb.onExpectedTopSize(this.metadata.topSize, this.metadata.topCompressedSize, this.metadata.topBlocksRequired, this.metadata.topBlocksTotal, context);
                        this.topCompatibilityMode = this.metadata.getTopCompatibilityCode();
                        this.topDontCompress = this.metadata.getTopDontCompress();
                    }
                    if ((hashes = this.metadata.getHashes()) != null) {
                        this.rcb.onHashes(hashes, context);
                    }
                }
                if (this.metadata.isSimpleManifest()) {
                    String oldName;
                    Metadata newMeta;
                    String name;
                    if (logMINOR) {
                        Logger.minor(this, "Is simple manifest");
                    }
                    if (this.metadata.countDocuments() == 1 && this.metadata.getDocument("") != null && this.metadata.getDocument("").isSimpleManifest()) {
                        Logger.error(this, "Manifest is called \"\" for " + this, (Throwable)new Exception("error"));
                        name = "";
                    } else {
                        if (this.metaStrings.isEmpty()) {
                            FreenetURI u = this.uri;
                            String last = u.lastMetaString();
                            u = last == null || !last.equals("") ? u.addMetaStrings(new String[]{""}) : null;
                            throw new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_PATH_COMPONENTS, -1L, false, null, u);
                        }
                        name = this.removeMetaString();
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Next meta-string: " + name + " length " + name.length() + " for " + this);
                    }
                    if (name == null) {
                        this.metadata = !this.persistent ? this.metadata.getDefaultDocument() : (newMeta = this.metadata.grabDefaultDocument());
                        if (this.metadata != null) continue;
                        throw new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_PATH_COMPONENTS, -1L, false, null, this.uri.addMetaStrings(new String[]{""}));
                    }
                    if (!this.persistent) {
                        Metadata origMd = this.metadata;
                        this.metadata = origMd.getDocument(name);
                        if (this.metadata != null && this.metadata.isSymbolicShortlink()) {
                            oldName = name;
                            if (oldName.equals(name = this.metadata.getSymbolicShortlinkTargetName())) {
                                throw new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, "redirect loop: " + name);
                            }
                            this.metadata = origMd.getDocument(name);
                        }
                        this.thisKey = this.thisKey.pushMetaString(name);
                    } else {
                        newMeta = this.metadata.grabDocument(name);
                        if (newMeta != null && newMeta.isSymbolicShortlink()) {
                            oldName = name;
                            if (oldName.equals(name = newMeta.getSymbolicShortlinkTargetName())) {
                                throw new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, "redirect loop: " + name);
                            }
                            newMeta = this.metadata.getDocument(name);
                        }
                        this.metadata = newMeta;
                        FreenetURI oldThisKey = this.thisKey;
                        this.thisKey = this.thisKey.pushMetaString(name);
                    }
                    if (this.metadata != null) continue;
                    throw new FetchException(FetchException.FetchExceptionMode.NOT_IN_ARCHIVE, "can't find " + name);
                }
                if (this.metadata.isArchiveManifest()) {
                    if (logMINOR) {
                        Logger.minor(this, "Is archive manifest (type=" + (Object)((Object)this.metadata.getArchiveType()) + " codec=" + this.metadata.getCompressionCodec() + ')');
                    }
                    if (this.metaStrings.isEmpty() && this.ctx.returnZIPManifests) {
                        this.metadata.setSimpleRedirect();
                        continue;
                    }
                    if (this.ah == null || !this.ah.getKey().equals(this.thisKey)) {
                        this.actx.doLoopDetection(this.thisKey);
                        this.ah = context.archiveManager.makeHandler(this.thisKey, this.metadata.getArchiveType(), this.metadata.getCompressionCodec(), this.parent instanceof ClientGetter ? ((ClientGetter)this.parent).collectingBinaryBlob() : false, this.persistent);
                    }
                    this.archiveMetadata = this.metadata;
                    this.metadata = null;
                    Bucket metadataBucket = this.ah.getMetadata(this.actx, context.archiveManager);
                    if (metadataBucket != null) {
                        try {
                            this.metadata = Metadata.construct(metadataBucket);
                            metadataBucket.free();
                        }
                        catch (InsufficientDiskSpaceException e) {
                            throw new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_DISK_SPACE);
                        }
                        catch (IOException e) {
                            throw new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e);
                        }
                    } else {
                        final boolean persistent = this.persistent;
                        this.fetchArchive(false, this.archiveMetadata, ".metadata", new ArchiveExtractCallback(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public void gotBucket(Bucket data, ClientContext context) {
                                if (logMINOR) {
                                    Logger.minor(this, "gotBucket on " + SingleFileFetcher.this + " persistent=" + persistent);
                                }
                                try {
                                    SingleFileFetcher.this.metadata = Metadata.construct(data);
                                    data.free();
                                    SingleFileFetcher.this.innerWrapHandleMetadata(true, context);
                                }
                                catch (MetadataParseException e) {
                                    SingleFileFetcher.this.onFailure(new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, (Throwable)e), false, context);
                                    return;
                                }
                                catch (IOException e) {
                                    SingleFileFetcher.this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e), false, context);
                                    return;
                                }
                            }

                            @Override
                            public void notInArchive(ClientContext context) {
                                SingleFileFetcher.this.onFailure(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "No metadata in container! Cannot happen as ArchiveManager should synthesise some!"), false, context);
                            }

                            @Override
                            public void onFailed(ArchiveRestartException e, ClientContext context) {
                                SingleFileFetcher.this.onFailure(new FetchException(e), false, context);
                            }

                            @Override
                            public void onFailed(ArchiveFailureException e, ClientContext context) {
                                SingleFileFetcher.this.onFailure(new FetchException(e), false, context);
                            }
                        }, context);
                        return;
                    }
                    metadataBucket.free();
                    continue;
                }
                if (this.metadata.isArchiveMetadataRedirect()) {
                    Bucket dataBucket;
                    if (logMINOR) {
                        Logger.minor(this, "Is archive-metadata");
                    }
                    if (this.ah == null) {
                        throw new FetchException(FetchException.FetchExceptionMode.UNKNOWN_METADATA, "Archive redirect not in an archive manifest");
                    }
                    String filename = this.metadata.getArchiveInternalName();
                    if (logMINOR) {
                        Logger.minor(this, "Fetching " + filename);
                    }
                    if ((dataBucket = this.ah.get(filename, this.actx, context.archiveManager)) != null) {
                        Metadata newMetadata;
                        if (logMINOR) {
                            Logger.minor(this, "Returning data");
                        }
                        try {
                            newMetadata = Metadata.construct(dataBucket);
                            dataBucket.free();
                        }
                        catch (InsufficientDiskSpaceException e) {
                            throw new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_DISK_SPACE);
                        }
                        catch (IOException e) {
                            throw new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR);
                        }
                        SingleFileFetcher e = this;
                        synchronized (e) {
                            this.metadata = newMetadata;
                        }
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Fetching archive (thisKey=" + this.thisKey + ')');
                    }
                    boolean persistent = this.persistent;
                    this.fetchArchive(true, this.archiveMetadata, filename, new ArchiveExtractCallback(){
                        private static final long serialVersionUID = 1L;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void gotBucket(Bucket data, ClientContext context) {
                            if (logMINOR) {
                                Logger.minor(this, "Returning data");
                            }
                            try {
                                Metadata newMetadata = Metadata.construct(data);
                                SingleFileFetcher singleFileFetcher = SingleFileFetcher.this;
                                synchronized (singleFileFetcher) {
                                    SingleFileFetcher.this.metadata = newMetadata;
                                }
                                SingleFileFetcher.this.innerWrapHandleMetadata(true, context);
                            }
                            catch (IOException e) {
                                SingleFileFetcher.this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR), false, context);
                            }
                            catch (MetadataParseException e) {
                                SingleFileFetcher.this.onFailure(new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA), false, context);
                            }
                            finally {
                                data.free();
                            }
                        }

                        @Override
                        public void notInArchive(ClientContext context) {
                            SingleFileFetcher.this.onFailure(new FetchException(FetchException.FetchExceptionMode.NOT_IN_ARCHIVE), false, context);
                        }

                        @Override
                        public void onFailed(ArchiveRestartException e, ClientContext context) {
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, context);
                        }

                        @Override
                        public void onFailed(ArchiveFailureException e, ClientContext context) {
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, context);
                        }
                    }, context);
                    return;
                }
                if (this.metadata.isArchiveInternalRedirect()) {
                    Bucket dataBucket;
                    if (logMINOR) {
                        Logger.minor(this, "Is archive-internal redirect");
                    }
                    this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                    String mime = this.clientMetadata.getMIMEType();
                    if (mime != null) {
                        this.rcb.onExpectedMIME(this.clientMetadata, context);
                    }
                    if (this.metaStrings.isEmpty() && this.isFinal && this.clientMetadata.getMIMETypeNoParams() != null && this.ctx.allowedMIMETypes != null && !this.ctx.allowedMIMETypes.contains(this.clientMetadata.getMIMETypeNoParams())) {
                        throw new FetchException(FetchException.FetchExceptionMode.WRONG_MIME_TYPE, -1L, false, this.clientMetadata.getMIMEType());
                    }
                    if (this.ah == null) {
                        throw new FetchException(FetchException.FetchExceptionMode.UNKNOWN_METADATA, "Archive redirect not in an archive manifest");
                    }
                    String filename = this.metadata.getArchiveInternalName();
                    if (logMINOR) {
                        Logger.minor(this, "Fetching " + filename);
                    }
                    if ((dataBucket = this.ah.get(filename, this.actx, context.archiveManager)) != null) {
                        Bucket out;
                        if (logMINOR) {
                            Logger.minor(this, "Returning data");
                        }
                        try {
                            if (this.persistent) {
                                out = context.persistentBucketFactory.makeBucket(dataBucket.size());
                                BucketTools.copy(dataBucket, out);
                                dataBucket.free();
                            } else {
                                out = dataBucket;
                            }
                        }
                        catch (InsufficientDiskSpaceException e) {
                            throw new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_DISK_SPACE);
                        }
                        catch (IOException e) {
                            throw new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR);
                        }
                        this.onSuccess(new FetchResult(this.clientMetadata, out), context);
                        return;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Fetching archive (thisKey=" + this.thisKey + ')');
                    }
                    boolean persistent = this.persistent;
                    this.fetchArchive(true, this.archiveMetadata, filename, new ArchiveExtractCallback(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void gotBucket(Bucket data, ClientContext context) {
                            if (logMINOR) {
                                Logger.minor(this, "Returning data");
                            }
                            SingleFileFetcher.this.onSuccess(new FetchResult(SingleFileFetcher.this.clientMetadata, data), context);
                        }

                        @Override
                        public void notInArchive(ClientContext context) {
                            SingleFileFetcher.this.onFailure(new FetchException(FetchException.FetchExceptionMode.NOT_IN_ARCHIVE), false, context);
                        }

                        @Override
                        public void onFailed(ArchiveRestartException e, ClientContext context) {
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, context);
                        }

                        @Override
                        public void onFailed(ArchiveFailureException e, ClientContext context) {
                            SingleFileFetcher.this.onFailure(new FetchException(e), false, context);
                        }
                    }, context);
                    return;
                }
                if (this.metadata.isMultiLevelMetadata()) {
                    if (logMINOR) {
                        Logger.minor(this, "Is multi-level metadata");
                    }
                    this.metadata.setSimpleRedirect();
                    final SingleFileFetcher f = new SingleFileFetcher(this, this.persistent, false, this.metadata, new MultiLevelMetadataCallback(), this.ctx, context);
                    this.metadata = null;
                    this.parent.onTransition(this, f, context);
                    context.getJobRunner(this.persistent).queueInternal(new PersistentJob(){

                        @Override
                        public boolean run(ClientContext context) {
                            f.innerWrapHandleMetadata(true, context);
                            return true;
                        }
                    });
                    return;
                }
                if (this.metadata.isSingleFileRedirect()) {
                    ClientKey redirectedKey;
                    if (logMINOR) {
                        Logger.minor(this, "Is single-file redirect");
                    }
                    this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                    if (this.clientMetadata != null && !this.clientMetadata.isTrivial()) {
                        this.rcb.onExpectedMIME(this.clientMetadata, context);
                        if (logMINOR) {
                            Logger.minor(this, "MIME type is " + this.clientMetadata);
                        }
                    }
                    if ((mimeType = this.clientMetadata.getMIMETypeNoParams()) != null && ArchiveManager.ARCHIVE_TYPE.isUsableArchiveType(mimeType) && this.metaStrings.size() > 0) {
                        this.metadata.setArchiveManifest();
                        this.clientMetadata.clear();
                        if (!logMINOR) continue;
                        Logger.minor(this, "Handling implicit container... (redirect)");
                        continue;
                    }
                    if (this.metaStrings.isEmpty() && this.isFinal && mimeType != null && this.ctx.allowedMIMETypes != null && !this.ctx.allowedMIMETypes.contains(mimeType)) {
                        throw new FetchException(FetchException.FetchExceptionMode.WRONG_MIME_TYPE, -1L, false, this.clientMetadata.getMIMEType());
                    }
                    FreenetURI newURI = this.metadata.getSingleTarget();
                    if (logMINOR) {
                        Logger.minor(this, "Redirecting to " + newURI);
                    }
                    try {
                        BaseClientKey k = BaseClientKey.getBaseKey(newURI);
                        if (!(k instanceof ClientKey)) {
                            throw new FetchException(FetchException.FetchExceptionMode.UNKNOWN_METADATA, "Redirect to a USK");
                        }
                        redirectedKey = (ClientKey)k;
                    }
                    catch (MalformedURLException e) {
                        throw new FetchException(FetchException.FetchExceptionMode.INVALID_URI, (Throwable)e);
                    }
                    ArrayList<String> newMetaStrings = newURI.listMetaStrings();
                    while (!newMetaStrings.isEmpty()) {
                        String o = newMetaStrings.remove(newMetaStrings.size() - 1);
                        this.metaStrings.add(0, o);
                        ++this.addedMetaStrings;
                    }
                    SingleFileFetcher f = new SingleFileFetcher(this.parent, this.rcb, this.clientMetadata, redirectedKey, this.metaStrings, this.uri, this.addedMetaStrings, this.ctx, this.deleteFetchContext, this.realTimeFlag, this.actx, this.ah, this.archiveMetadata, this.maxRetries, this.recursionLevel, false, this.token, true, this.isFinal, this.topDontCompress, this.topCompatibilityMode, context, false);
                    this.deleteFetchContext = false;
                    if (redirectedKey instanceof ClientCHK && !((ClientCHK)redirectedKey).isMetadata()) {
                        this.rcb.onBlockSetFinished(this, context);
                        byte[] redirectedCryptoKey = ((ClientCHK)redirectedKey).getCryptoKey();
                        if (this.key instanceof ClientCHK && !Arrays.equals(((ClientCHK)this.key).getCryptoKey(), redirectedCryptoKey)) {
                            redirectedCryptoKey = null;
                        }
                        this.rcb.onSplitfileCompatibilityMode(this.metadata.getMinCompatMode(), this.metadata.getMaxCompatMode(), redirectedCryptoKey, !((ClientCHK)redirectedKey).isCompressed(), true, true, context);
                    }
                    if (this.metadata.isCompressed()) {
                        Compressor.COMPRESSOR_TYPE codec = this.metadata.getCompressionCodec();
                        f.addDecompressor(codec);
                    }
                    this.parent.onTransition(this, f, context);
                    f.schedule(context);
                    this.archiveMetadata = null;
                    return;
                }
                if (!this.metadata.isSplitfile()) break block91;
                if (logMINOR) {
                    Logger.minor(this, "Fetching splitfile");
                }
                this.clientMetadata.mergeNoOverwrite(this.metadata.getClientMetadata());
                mimeType = this.clientMetadata.getMIMETypeNoParams();
                if (mimeType == null || !ArchiveManager.ARCHIVE_TYPE.isUsableArchiveType(mimeType) || this.metaStrings.size() <= 0) break;
                this.metadata.setArchiveManifest();
                this.clientMetadata.clear();
                if (!logMINOR) continue;
                Logger.minor(this, "Handling implicit container... (splitfile)");
            }
            if (this.clientMetadata != null && !this.clientMetadata.isTrivial()) {
                this.rcb.onExpectedMIME(this.clientMetadata, context);
            }
            if (this.metaStrings.isEmpty() && this.isFinal && mimeType != null && this.ctx.allowedMIMETypes != null && !this.ctx.allowedMIMETypes.contains(mimeType)) {
                long len = this.metadata.uncompressedDataLength();
                throw new FetchException(FetchException.FetchExceptionMode.WRONG_MIME_TYPE, len, false, this.clientMetadata.getMIMEType());
            }
            if (this.metadata.isCompressed()) {
                Compressor.COMPRESSOR_TYPE codec = this.metadata.getCompressionCodec();
                this.addDecompressor(codec);
            }
            if (this.isFinal && !this.ctx.ignoreTooManyPathComponents) {
                if (!this.metaStrings.isEmpty()) {
                    if (this.addedMetaStrings > 0) {
                        this.rcb.onFailure(new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, "Invalid metadata: too many path components in redirects", this.thisKey), this, context);
                    } else {
                        FreenetURI tryURI = this.uri;
                        tryURI = tryURI.dropLastMetaStrings(this.metaStrings.size());
                        this.rcb.onFailure(new FetchException(FetchException.FetchExceptionMode.TOO_MANY_PATH_COMPONENTS, this.metadata.uncompressedDataLength(), this.rcb == this.parent, this.clientMetadata.getMIMEType(), tryURI), this, context);
                    }
                    return;
                }
            } else if (logMINOR) {
                Logger.minor(this, "Not finished: rcb=" + this.rcb + " for " + this);
            }
            long len = this.metadata.dataLength();
            long l = uncompressedLen = this.metadata.isCompressed() ? this.metadata.uncompressedDataLength() : len;
            if (uncompressedLen > this.ctx.maxOutputLength || len > this.ctx.maxTempLength) {
                boolean compressed = this.metadata.isCompressed();
                throw new FetchException(FetchException.FetchExceptionMode.TOO_BIG, uncompressedLen, this.isFinal && this.decompressors.size() <= (compressed ? 1 : 0), this.clientMetadata.getMIMEType());
            }
            boolean reallyFinal = this.isFinal;
            if (this.isFinal && !this.parent.isCurrentState(this)) {
                Logger.error(this, "isFinal but not the current state for " + this, (Throwable)new Exception("error"));
                reallyFinal = false;
            }
            SplitFileFetcher sf = new SplitFileFetcher(this.metadata, this.rcb, this.parent, this.ctx, this.realTimeFlag, this.decompressors, this.clientMetadata, this.token, this.topDontCompress, this.topCompatibilityMode, this.persistent, this.thisKey, reallyFinal, context);
            this.deleteFetchContext = false;
            this.parent.onTransition(this, sf, context);
            try {
                sf.schedule(context);
            }
            catch (KeyListenerConstructionException e) {
                this.onFailure(e.getFetchException(), false, context);
                return;
            }
            this.rcb.onBlockSetFinished(this, context);
            return;
        }
        Logger.error(this, "Don't know what to do with metadata: " + this.metadata);
        throw new FetchException(FetchException.FetchExceptionMode.UNKNOWN_METADATA);
    }

    private String removeMetaString() {
        String name = this.metaStrings.remove(0);
        if (this.addedMetaStrings > 0) {
            --this.addedMetaStrings;
        }
        return name;
    }

    private void addDecompressor(Compressor.COMPRESSOR_TYPE codec) {
        if (logMINOR) {
            Logger.minor(this, "Adding decompressor: " + codec + " on " + this, (Throwable)new Exception("debug"));
        }
        this.decompressors.add(codec);
    }

    private void fetchArchive(boolean forData, Metadata meta, String element, ArchiveExtractCallback callback, ClientContext context) throws FetchException, MetadataParseException, ArchiveFailureException, ArchiveRestartException {
        if (logMINOR) {
            Logger.minor(this, "fetchArchive()");
        }
        Metadata newMeta = (Metadata)meta.clone();
        newMeta.setSimpleRedirect();
        final SingleFileFetcher f = new SingleFileFetcher(this, this.persistent, true, newMeta, new ArchiveFetcherCallback(forData, element, callback), new FetchContext(this.ctx, 4, true, null), context);
        if (logMINOR) {
            Logger.minor(this, "fetchArchive(): " + f);
        }
        this.parent.onTransition(this, f, context);
        context.getJobRunner(this.persistent).queueInternal(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                f.innerWrapHandleMetadata(true, context);
                return true;
            }
        });
    }

    protected void innerWrapHandleMetadata(boolean notFinalizedSize, ClientContext context) {
        try {
            this.handleMetadata(context);
        }
        catch (MetadataParseException e) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, (Throwable)e), false, context);
        }
        catch (FetchException e) {
            if (notFinalizedSize) {
                e.setNotFinalizedSize();
            }
            this.onFailure(e, false, context);
        }
        catch (ArchiveFailureException e) {
            this.onFailure(new FetchException(e), false, context);
        }
        catch (ArchiveRestartException e) {
            this.onFailure(new FetchException(e), false, context);
        }
    }

    public static ClientGetState create(ClientRequester requester, GetCompletionCallback cb, FreenetURI uri, FetchContext ctx, ArchiveContext actx, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean isEssential, boolean isFinal, ClientContext context, boolean realTimeFlag, boolean hasInitialMetadata) throws MalformedURLException, FetchException {
        BaseClientKey key = null;
        if (!hasInitialMetadata) {
            key = BaseClientKey.getBaseKey(uri);
        }
        if (!(uri.hasMetaStrings() || ctx.allowSplitfiles || ctx.followRedirects || !(key instanceof ClientKey) || hasInitialMetadata)) {
            return new SimpleSingleFileFetcher((ClientKey)key, maxRetries, ctx, requester, cb, isEssential, false, l, context, false, realTimeFlag);
        }
        if (key instanceof ClientKey || hasInitialMetadata) {
            return new SingleFileFetcher(requester, cb, null, (ClientKey)key, new ArrayList<String>(uri.listMetaStrings()), uri, 0, ctx, false, realTimeFlag, actx, null, null, maxRetries, recursionLevel, dontTellClientGet, l, isEssential, isFinal, false, 0, context, hasInitialMetadata);
        }
        return SingleFileFetcher.uskCreate(requester, realTimeFlag, cb, (USK)key, new ArrayList<String>(uri.listMetaStrings()), ctx, actx, maxRetries, recursionLevel, dontTellClientGet, l, isEssential, isFinal, context);
    }

    private static ClientGetState uskCreate(ClientRequester requester, boolean realTimeFlag, GetCompletionCallback cb, USK usk, ArrayList<String> metaStrings, FetchContext ctx, ArchiveContext actx, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean isEssential, boolean isFinal, ClientContext context) throws FetchException {
        if (usk.suggestedEdition >= 0L) {
            long edition = context.uskManager.lookupKnownGood(usk);
            if (edition <= usk.suggestedEdition) {
                context.uskManager.startTemporaryBackgroundFetcher(usk, context, ctx, true, realTimeFlag);
                edition = context.uskManager.lookupKnownGood(usk);
                if (edition > usk.suggestedEdition) {
                    if (logMINOR) {
                        Logger.minor(SingleFileFetcher.class, "Redirecting to edition " + edition);
                    }
                    cb.onFailure(new FetchException(FetchException.FetchExceptionMode.PERMANENT_REDIRECT, usk.copy(edition).getURI().addMetaStrings(metaStrings)), null, context);
                    return null;
                }
                if (edition == -1L && context.uskManager.lookupLatestSlot(usk) == -1L) {
                    USKFetcherTag tag = context.uskManager.getFetcher(usk.copy(usk.suggestedEdition), ctx, false, requester.persistent(), realTimeFlag, new MyUSKFetcherCallback(requester, cb, usk, metaStrings, ctx, actx, realTimeFlag, maxRetries, recursionLevel, dontTellClientGet, l, requester.persistent(), true), false, context, true);
                    if (isEssential) {
                        requester.addMustSucceedBlocks(1);
                    }
                    return tag;
                }
                USKProxyCompletionCallback myCB = new USKProxyCompletionCallback(usk, cb, requester.persistent());
                SingleFileFetcher sf = new SingleFileFetcher(requester, myCB, null, usk.getSSK(), metaStrings, usk.getURI().addMetaStrings(metaStrings), 0, ctx, false, realTimeFlag, actx, null, null, maxRetries, recursionLevel, dontTellClientGet, l, isEssential, isFinal, false, 0, context, false);
                return sf;
            }
            cb.onFailure(new FetchException(FetchException.FetchExceptionMode.PERMANENT_REDIRECT, usk.copy(edition).getURI().addMetaStrings(metaStrings)), null, context);
            return null;
        }
        USKFetcherTag tag = context.uskManager.getFetcher(usk.copy(-usk.suggestedEdition), ctx, false, requester.persistent(), realTimeFlag, new MyUSKFetcherCallback(requester, cb, usk, metaStrings, ctx, actx, realTimeFlag, maxRetries, recursionLevel, dontTellClientGet, l, requester.persistent(), false), false, context, false);
        if (isEssential) {
            requester.addMustSucceedBlocks(1);
        }
        return tag;
    }

    static /* synthetic */ ArchiveHandler access$500(SingleFileFetcher x0) {
        return x0.ah;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static class MyUSKFetcherCallback
    implements USKFetcherTagCallback,
    Serializable {
        private static final long serialVersionUID = 1L;
        final ClientRequester parent;
        final GetCompletionCallback cb;
        final USK usk;
        final ArrayList<String> metaStrings;
        final FetchContext ctx;
        final ArchiveContext actx;
        final int maxRetries;
        final int recursionLevel;
        final boolean dontTellClientGet;
        final long token;
        final boolean persistent;
        final boolean realTimeFlag;
        final boolean datastoreOnly;
        final int hashCode;
        private USKFetcherTag tag;

        @Override
        public void setTag(USKFetcherTag tag, ClientContext context) {
            this.tag = tag;
        }

        public MyUSKFetcherCallback(ClientRequester requester, GetCompletionCallback cb, USK usk, ArrayList<String> metaStrings, FetchContext ctx, ArchiveContext actx, boolean realTimeFlag, int maxRetries, int recursionLevel, boolean dontTellClientGet, long l, boolean persistent, boolean datastoreOnly) {
            this.parent = requester;
            this.cb = cb;
            this.usk = usk;
            this.metaStrings = metaStrings;
            this.ctx = ctx;
            this.actx = actx;
            this.maxRetries = maxRetries;
            this.recursionLevel = recursionLevel;
            this.dontTellClientGet = dontTellClientGet;
            this.token = l;
            this.persistent = persistent;
            this.datastoreOnly = datastoreOnly;
            this.hashCode = super.hashCode();
            this.realTimeFlag = realTimeFlag;
            if (logMINOR) {
                Logger.minor(this, "Created " + this + " for " + usk + " and " + cb + " datastore only = " + datastoreOnly);
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public void onFoundEdition(long l, USK newUSK, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
            if (l < this.usk.suggestedEdition && this.datastoreOnly) {
                l = this.usk.suggestedEdition;
            }
            ClientSSK key = this.usk.getSSK(l);
            try {
                if (l == this.usk.suggestedEdition) {
                    SingleFileFetcher sf = new SingleFileFetcher(this.parent, this.cb, null, key, this.metaStrings, key.getURI().addMetaStrings(this.metaStrings), 0, this.ctx, false, this.realTimeFlag, this.actx, null, null, this.maxRetries, this.recursionLevel + 1, this.dontTellClientGet, this.token, false, true, false, 0, context, false);
                    if (this.tag != null) {
                        this.cb.onTransition(this.tag, sf, context);
                    }
                    sf.schedule(context);
                } else {
                    this.cb.onFailure(new FetchException(FetchException.FetchExceptionMode.PERMANENT_REDIRECT, newUSK.getURI().addMetaStrings(this.metaStrings)), null, context);
                }
            }
            catch (FetchException e) {
                this.cb.onFailure(e, null, context);
            }
        }

        @Override
        public void onFailure(ClientContext context) {
            FetchException e = null;
            if (this.datastoreOnly) {
                try {
                    this.onFoundEdition(this.usk.suggestedEdition, this.usk, context, false, (short)-1, null, false, false);
                    return;
                }
                catch (Throwable t) {
                    e = new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, t);
                }
            }
            if (e == null) {
                e = new FetchException(FetchException.FetchExceptionMode.DATA_NOT_FOUND, "No USK found");
            }
            if (logMINOR) {
                Logger.minor(this, "Failing USK with " + e, (Throwable)e);
            }
            if (this.cb == null) {
                throw new NullPointerException("Callback is null in " + this + " for usk " + this.usk + " with datastoreOnly=" + this.datastoreOnly);
            }
            this.cb.onFailure(e, null, context);
        }

        @Override
        public void onCancelled(ClientContext context) {
            this.cb.onFailure(new FetchException(FetchException.FetchExceptionMode.CANCELLED, (String)null), null, context);
        }

        @Override
        public short getPollingPriorityNormal() {
            return this.parent.getPriorityClass();
        }

        @Override
        public short getPollingPriorityProgress() {
            return this.parent.getPriorityClass();
        }
    }

    class MultiLevelMetadataCallback
    implements GetCompletionCallback,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean persistent;
        private final FetchContext ctx;

        MultiLevelMetadataCallback() {
            this.persistent = SingleFileFetcher.this.persistent;
            this.ctx = SingleFileFetcher.this.ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, ClientGetState state, ClientContext context) {
            RandomAccessBucket finalData;
            PipedOutputStream pipeOut;
            PipedInputStream pipeIn;
            OutputStream output;
            block18: {
                output = null;
                pipeIn = new PipedInputStream();
                pipeOut = new PipedOutputStream();
                finalData = null;
                long maxLen = Math.min(this.ctx.maxTempLength, this.ctx.maxOutputLength);
                try {
                    finalData = context.getBucketFactory(this.persistent).makeBucket(maxLen);
                    output = finalData.getOutputStream();
                    if (decompressors != null) {
                        if (logMINOR) {
                            Logger.minor(this, "decompressing...");
                        }
                        pipeIn.connect(pipeOut);
                        DecompressorThreadManager decompressorManager = new DecompressorThreadManager(pipeIn, decompressors, maxLen);
                        pipeIn = decompressorManager.execute();
                        ClientGetWorkerThread worker = new ClientGetWorkerThread(new BufferedInputStream(pipeIn), output, null, null, null, false, null, null, null, context.linkFilterExceptionProvider);
                        worker.start();
                        streamGenerator.writeTo(pipeOut, context);
                        decompressorManager.waitFinished();
                        worker.waitFinished();
                        break block18;
                    }
                    streamGenerator.writeTo(output, context);
                    output.close();
                }
                catch (Throwable t) {
                    try {
                        Logger.error(this, "Caught " + t, t);
                        this.onFailure(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, t), state, context);
                    }
                    catch (Throwable throwable) {
                        Closer.close(pipeOut);
                        Closer.close(pipeIn);
                        Closer.close(output);
                        throw throwable;
                    }
                    Closer.close(pipeOut);
                    Closer.close(pipeIn);
                    Closer.close(output);
                    return;
                }
            }
            Closer.close(pipeOut);
            Closer.close(pipeIn);
            Closer.close(output);
            try {
                SingleFileFetcher.this.parent.onTransition(state, SingleFileFetcher.this, context);
                Metadata meta = Metadata.construct(finalData);
                SingleFileFetcher singleFileFetcher = SingleFileFetcher.this;
                synchronized (singleFileFetcher) {
                    SingleFileFetcher.this.metadata = meta;
                }
                SingleFileFetcher.this.innerWrapHandleMetadata(true, context);
            }
            catch (MetadataParseException e) {
                SingleFileFetcher.this.onFailure(new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, (Throwable)e), false, context);
                return;
            }
            catch (InsufficientDiskSpaceException e) {
                SingleFileFetcher.this.onFailure(new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_DISK_SPACE), false, context);
                return;
            }
            catch (IOException e) {
                SingleFileFetcher.this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e), false, context);
                return;
            }
            finally {
                finalData.free();
            }
        }

        @Override
        public void onFailure(FetchException e, ClientGetState state, ClientContext context) {
            SingleFileFetcher.this.parent.onTransition(state, SingleFileFetcher.this, context);
            SingleFileFetcher.this.onFailure(e, true, context);
        }

        @Override
        public void onBlockSetFinished(ClientGetState state, ClientContext context) {
        }

        @Override
        public void onTransition(ClientGetState oldState, ClientGetState newState, ClientContext context) {
        }

        @Override
        public void onExpectedMIME(ClientMetadata mime, ClientContext context) {
        }

        @Override
        public void onExpectedSize(long size, ClientContext context) {
            SingleFileFetcher.this.rcb.onExpectedSize(size, context);
        }

        @Override
        public void onFinalizedMetadata() {
        }

        @Override
        public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ClientContext context) {
        }

        @Override
        public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] splitfileKey, boolean dontCompress, boolean bottomLayer, boolean definitiveAnyway, ClientContext context) {
            SingleFileFetcher.this.rcb.onSplitfileCompatibilityMode(min, max, splitfileKey, dontCompress, false, definitiveAnyway, context);
        }

        @Override
        public void onHashes(HashResult[] hashes, ClientContext context) {
        }
    }

    class ArchiveFetcherCallback
    implements GetCompletionCallback,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean wasFetchingFinalData;
        private final String element;
        private final ArchiveExtractCallback callback;
        private final boolean persistent;
        private HashResult[] hashes;
        private final FetchContext ctx;

        ArchiveFetcherCallback(boolean wasFetchingFinalData, String element, ArchiveExtractCallback cb) {
            this.wasFetchingFinalData = wasFetchingFinalData;
            this.element = element;
            this.callback = cb;
            this.persistent = SingleFileFetcher.this.persistent;
            this.ctx = SingleFileFetcher.this.ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, ClientGetState state, ClientContext context) {
            OutputStream output = null;
            PipedInputStream pipeIn = new PipedInputStream();
            PipedOutputStream pipeOut = new PipedOutputStream();
            RandomAccessBucket data = null;
            long maxLen = Math.min(this.ctx.maxTempLength, this.ctx.maxOutputLength);
            try {
                data = context.getBucketFactory(this.persistent).makeBucket(maxLen);
                output = data.getOutputStream();
                if (decompressors != null) {
                    if (logMINOR) {
                        Logger.minor(this, "decompressing...");
                    }
                    pipeOut.connect(pipeIn);
                    DecompressorThreadManager decompressorManager = new DecompressorThreadManager(pipeIn, decompressors, maxLen);
                    pipeIn = decompressorManager.execute();
                    ClientGetWorkerThread worker = new ClientGetWorkerThread(new BufferedInputStream(pipeIn), output, null, null, null, false, null, null, null, context.linkFilterExceptionProvider);
                    worker.start();
                    streamGenerator.writeTo(pipeOut, context);
                    decompressorManager.waitFinished();
                    worker.waitFinished();
                } else {
                    streamGenerator.writeTo(output, context);
                }
                output.close();
                output = null;
                pipeOut.close();
                pipeOut = null;
                pipeIn.close();
                pipeIn = null;
            }
            catch (Throwable t) {
                try {
                    Logger.error(this, "Caught " + t, t);
                    this.onFailure(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, t), state, context);
                }
                catch (Throwable throwable) {
                    Closer.close(pipeOut);
                    Closer.close(pipeIn);
                    Closer.close(output);
                    throw throwable;
                }
                Closer.close(pipeOut);
                Closer.close(pipeIn);
                Closer.close(output);
                return;
            }
            Closer.close(pipeOut);
            Closer.close(pipeIn);
            Closer.close(output);
            if (SingleFileFetcher.this.key instanceof ClientSSK) {
                context.uskManager.checkUSK(SingleFileFetcher.this.uri, this.persistent, false);
            }
            SingleFileFetcher.this.parent.onTransition(state, SingleFileFetcher.this, context);
            this.innerSuccess(data, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void innerSuccess(Bucket data, ClientContext context) {
            block19: {
                try {
                    if (this.hashes != null) {
                        is = null;
                        try {
                            is = data.getInputStream();
                            hasher = new MultiHashInputStream(is, HashResult.makeBitmask(this.hashes));
                            buf = new byte[32768];
                            while (hasher.read(buf) > 0) {
                            }
                            hasher.close();
                            is = null;
                            results = hasher.getResults();
                            if (HashResult.strictEquals(results, this.hashes)) ** GOTO lbl22
                            this.onFailure(new FetchException(FetchException.FetchExceptionMode.CONTENT_HASH_FAILED), SingleFileFetcher.this, context);
                            return;
                        }
                        catch (InsufficientDiskSpaceException e) {
                            this.onFailure(new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_DISK_SPACE), SingleFileFetcher.this, context);
                        }
                        catch (IOException e) {
                            this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e), SingleFileFetcher.this, context);
                            return;
                        }
                    }
lbl22:
                    // 4 sources

                    SingleFileFetcher.access$500(SingleFileFetcher.this).extractToCache(data, SingleFileFetcher.this.actx, this.element, this.callback, context.archiveManager, context);
                    break block19;
                }
                catch (ArchiveFailureException e) {
                    SingleFileFetcher.this.onFailure(new FetchException(e), false, context);
                    return;
                }
                catch (ArchiveRestartException e) {}
                {
                    finally {
                        Closer.close(is);
                    }
                }
                {
                    SingleFileFetcher.this.onFailure(new FetchException(e), false, context);
                    return;
                }
                finally {
                    data.free();
                }
            }
            if (this.callback != null) {
                return;
            }
            SingleFileFetcher.this.innerWrapHandleMetadata(true, context);
        }

        @Override
        public void onFailure(FetchException e, ClientGetState state, ClientContext context) {
            SingleFileFetcher.this.onFailure(e, true, context);
        }

        @Override
        public void onBlockSetFinished(ClientGetState state, ClientContext context) {
            if (this.wasFetchingFinalData) {
                SingleFileFetcher.this.rcb.onBlockSetFinished(SingleFileFetcher.this, context);
            }
        }

        @Override
        public void onTransition(ClientGetState oldState, ClientGetState newState, ClientContext context) {
        }

        @Override
        public void onExpectedMIME(ClientMetadata metadata, ClientContext context) {
        }

        @Override
        public void onExpectedSize(long size, ClientContext context) {
            SingleFileFetcher.this.rcb.onExpectedSize(size, context);
        }

        @Override
        public void onFinalizedMetadata() {
        }

        @Override
        public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ClientContext context) {
        }

        @Override
        public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] splitfileKey, boolean dontCompress, boolean bottomLayer, boolean definitiveAnyway, ClientContext context) {
            SingleFileFetcher.this.rcb.onSplitfileCompatibilityMode(min, max, splitfileKey, dontCompress, false, false, context);
        }

        @Override
        public void onHashes(HashResult[] hashes, ClientContext context) {
            this.hashes = hashes;
        }
    }
}

