/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.InsertException;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJobRunner;
import freenet.client.async.SplitFileInserterCrossSegmentStorage;
import freenet.client.async.SplitFileInserterSegmentBlockChooser;
import freenet.client.async.SplitFileInserterStorage;
import freenet.crypt.ChecksumChecker;
import freenet.crypt.ChecksumFailedException;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.node.KeysFetchingLocally;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestItemKey;
import freenet.support.Logger;
import freenet.support.MemoryLimitedChunk;
import freenet.support.MemoryLimitedJob;
import freenet.support.MemoryLimitedJobRunner;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.io.CountedOutputStream;
import freenet.support.io.NullOutputStream;
import freenet.support.io.StorageFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public class SplitFileInserterSegmentStorage {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final SplitFileInserterStorage parent;
    final int segNo;
    final int dataBlockCount;
    final int crossCheckBlockCount;
    final int checkBlockCount;
    final int totalBlockCount;
    private boolean encoded;
    private boolean encoding;
    private final int statusLength;
    private final int keyLength;
    private final SplitFileInserterCrossSegmentStorage[] crossSegmentBlockSegments;
    private final int[] crossSegmentBlockNumbers;
    private final boolean[] blocksHaveKeys;
    private int blocksWithKeysCounter;
    private final transient boolean[] crossDataBlocksAllocated;
    private transient int crossDataBlocksAllocatedCount;
    private transient int crossCheckBlocksAllocatedCount;
    private final byte[] splitfileCryptoKey;
    private final byte splitfileCryptoAlgorithm;
    private final SplitFileInserterSegmentBlockChooser blockChooser;
    private boolean metadataDirty;
    private boolean cancelled;

    public SplitFileInserterSegmentStorage(SplitFileInserterStorage parent, int segNo, boolean persistent, int dataBlocks, int checkBlocks, int crossCheckBlocks, int keyLength, byte splitfileCryptoAlgorithm, byte[] splitfileCryptoKey, Random random, int maxRetries, int consecutiveRNFsCountAsSuccess, KeysFetchingLocally keysFetching) {
        this.parent = parent;
        this.segNo = segNo;
        this.dataBlockCount = dataBlocks;
        this.checkBlockCount = checkBlocks;
        this.crossCheckBlockCount = crossCheckBlocks;
        this.totalBlockCount = this.dataBlockCount + this.crossCheckBlockCount + this.checkBlockCount;
        this.keyLength = keyLength;
        this.crossSegmentBlockSegments = new SplitFileInserterCrossSegmentStorage[crossCheckBlocks];
        this.crossSegmentBlockNumbers = new int[crossCheckBlocks];
        this.blocksHaveKeys = new boolean[this.totalBlockCount];
        this.splitfileCryptoAlgorithm = splitfileCryptoAlgorithm;
        this.splitfileCryptoKey = splitfileCryptoKey;
        this.crossDataBlocksAllocated = new boolean[dataBlocks + crossCheckBlocks];
        this.blockChooser = new SplitFileInserterSegmentBlockChooser(this, this.totalBlockCount, random, maxRetries, keysFetching, consecutiveRNFsCountAsSuccess);
        try {
            CountedOutputStream cos = new CountedOutputStream(new NullOutputStream());
            DataOutputStream dos = new DataOutputStream(cos);
            this.innerStoreStatus(dos);
            dos.close();
            this.statusLength = (int)cos.written() + parent.checker.checksumLength();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public SplitFileInserterSegmentStorage(SplitFileInserterStorage parent, DataInputStream dis, int segNo, int keyLength, byte splitfileCryptoAlgorithm, byte[] splitfileCryptoKey, Random random, int maxRetries, int consecutiveRNFsCountAsSuccess, KeysFetchingLocally keysFetching) throws IOException, StorageFormatException {
        this.parent = parent;
        this.segNo = segNo;
        this.keyLength = keyLength;
        this.dataBlockCount = dis.readInt();
        if (this.dataBlockCount < 0) {
            throw new StorageFormatException("Bogus data block count");
        }
        this.crossCheckBlockCount = dis.readInt();
        if (this.crossCheckBlockCount < 0) {
            throw new StorageFormatException("Bogus cross-check block count");
        }
        if (this.crossCheckBlockCount == 0 != (parent.crossSegments == null)) {
            throw new StorageFormatException("Cross-check block count inconsistent with parent");
        }
        this.checkBlockCount = dis.readInt();
        if (this.checkBlockCount < 0) {
            throw new StorageFormatException("Bogus check block count");
        }
        this.totalBlockCount = this.dataBlockCount + this.crossCheckBlockCount + this.checkBlockCount;
        if (this.totalBlockCount > 256) {
            throw new StorageFormatException("Bogus total block count");
        }
        this.statusLength = dis.readInt();
        if (this.statusLength < 0) {
            throw new StorageFormatException("Bogus status length");
        }
        this.crossSegmentBlockSegments = new SplitFileInserterCrossSegmentStorage[this.crossCheckBlockCount];
        this.crossSegmentBlockNumbers = new int[this.crossCheckBlockCount];
        this.blocksHaveKeys = new boolean[this.totalBlockCount];
        this.splitfileCryptoAlgorithm = splitfileCryptoAlgorithm;
        this.splitfileCryptoKey = splitfileCryptoKey;
        this.crossDataBlocksAllocated = new boolean[this.dataBlockCount + this.crossCheckBlockCount];
        this.blockChooser = new SplitFileInserterSegmentBlockChooser(this, this.totalBlockCount, random, maxRetries, keysFetching, consecutiveRNFsCountAsSuccess);
        try {
            CountedOutputStream cos = new CountedOutputStream(new NullOutputStream());
            DataOutputStream dos = new DataOutputStream(cos);
            this.innerStoreStatus(dos);
            dos.close();
            int minStatusLength = (int)cos.written() + parent.checker.checksumLength();
            if (minStatusLength > this.statusLength) {
                throw new StorageFormatException("Bad status length (too short)");
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    int allocateCrossDataBlock(SplitFileInserterCrossSegmentStorage seg, Random random) {
        int i;
        int size = this.dataBlockCount;
        if (this.crossDataBlocksAllocatedCount == size) {
            return -1;
        }
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = random.nextInt(size);
            if (this.crossDataBlocksAllocated[x]) continue;
            this.crossDataBlocksAllocated[x] = true;
            ++this.crossDataBlocksAllocatedCount;
            return x;
        }
        for (i = 0; i < size; ++i) {
            if (++x == size) {
                x = 0;
            }
            if (this.crossDataBlocksAllocated[x]) continue;
            this.crossDataBlocksAllocated[x] = true;
            ++this.crossDataBlocksAllocatedCount;
            return x;
        }
        throw new IllegalStateException("Unable to allocate cross data block even though have not used all slots up???");
    }

    int allocateCrossCheckBlock(SplitFileInserterCrossSegmentStorage seg, Random random, int crossSegmentBlockNumber) {
        if (this.crossCheckBlocksAllocatedCount == this.crossCheckBlockCount) {
            return -1;
        }
        int x = this.crossCheckBlockCount - (1 + random.nextInt(this.crossCheckBlockCount));
        for (int i = 0; i < this.crossCheckBlockCount; ++i) {
            if (++x == this.crossCheckBlockCount) {
                x = 0;
            }
            if (this.crossSegmentBlockSegments[x] != null) continue;
            this.crossSegmentBlockSegments[x] = seg;
            this.crossSegmentBlockNumbers[x] = crossSegmentBlockNumber;
            ++this.crossCheckBlocksAllocatedCount;
            return x + this.dataBlockCount;
        }
        throw new IllegalStateException("Unable to allocate cross check block even though have not used all slots up???");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeStatus(boolean force) {
        if (!this.parent.persistent) {
            return;
        }
        if (this.parent.hasFinished()) {
            return;
        }
        try {
            DataOutputStream dos;
            SplitFileInserterSegmentStorage splitFileInserterSegmentStorage = this;
            synchronized (splitFileInserterSegmentStorage) {
                if (!force && !this.metadataDirty) {
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                try {
                    dos = new DataOutputStream(this.parent.writeChecksummedTo(this.parent.segmentStatusOffset(this.segNo), this.statusLength));
                    this.innerStoreStatus(dos);
                }
                catch (IOException e) {
                    Logger.error(this, "Impossible: " + e, (Throwable)e);
                    return;
                }
                this.metadataDirty = false;
            }
            dos.close();
        }
        catch (IOException e) {
            Logger.error(this, "I/O error writing segment status?: " + e, (Throwable)e);
            this.parent.failOnDiskError(e);
        }
    }

    private void innerStoreStatus(DataOutputStream dos) throws IOException {
        dos.writeInt(this.segNo);
        dos.writeBoolean(this.encoded);
        this.blockChooser.write(dos);
    }

    public void readStatus() throws IOException, ChecksumFailedException, StorageFormatException {
        byte[] data = new byte[this.statusLength - this.parent.checker.checksumLength()];
        this.parent.preadChecksummed(this.parent.getOffsetSegmentStatus(this.segNo), data, 0, data.length);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        if (dis.readInt() != this.segNo) {
            throw new StorageFormatException("Bad segment number");
        }
        this.encoded = dis.readBoolean();
        this.blockChooser.read(dis);
    }

    public long storedStatusLength() {
        return this.statusLength;
    }

    public void writeFixedSettings(DataOutputStream dos) throws IOException {
        dos.writeInt(this.dataBlockCount);
        dos.writeInt(this.crossCheckBlockCount);
        dos.writeInt(this.checkBlockCount);
        dos.writeInt(this.statusLength);
    }

    static int getKeyLength(SplitFileInserterStorage parent) {
        return SplitFileInserterSegmentStorage.encodeKey(1, 1, ClientCHK.TEST_KEY, parent.hasSplitfileKey(), parent.checker, parent).length;
    }

    private static byte[] encodeKey(int segNo, int blockNumber, ClientCHK key, boolean hasSplitfileKey, ChecksumChecker checker, SplitFileInserterStorage parent) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(segNo);
            dos.writeInt(blockNumber);
            dos.writeByte(1);
            SplitFileInserterSegmentStorage.innerWriteKey(key, dos, hasSplitfileKey);
            dos.close();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        byte[] fullBuf = baos.toByteArray();
        byte[] bufNoKeyNumber = Arrays.copyOfRange(fullBuf, 8, fullBuf.length);
        byte[] ret = checker.appendChecksum(bufNoKeyNumber);
        return ret;
    }

    static void innerWriteKey(ClientCHK key, DataOutputStream dos, boolean hasSplitfileKey) throws IOException {
        if (hasSplitfileKey) {
            dos.write(key.getRoutingKey());
        } else {
            key.writeRawBinaryKey(dos);
        }
    }

    void clearKeys() throws IOException {
        byte[] buf = new byte[this.keyLength];
        for (int i = 0; i < this.totalBlockCount; ++i) {
            this.parent.innerWriteSegmentKey(this.segNo, i, buf);
        }
    }

    void setKey(int blockNumber, ClientCHK key) throws IOException {
        if (logMINOR) {
            Logger.minor(this, "Setting key " + key + " for block " + blockNumber + " on " + this, (Throwable)new Exception("debug"));
        }
        try {
            ClientCHK oldKey = this.readKey(blockNumber);
            if (!oldKey.equals(key)) {
                throw new IOException("Key for block has changed! Data corruption or bugs in SplitFileInserter code");
            }
        }
        catch (MissingKeyException e) {
            this.writeKey(blockNumber, key);
        }
        this.setHasKey(blockNumber);
    }

    void writeKey(int blockNumber, ClientCHK key) throws IOException {
        byte[] buf = SplitFileInserterSegmentStorage.encodeKey(this.segNo, blockNumber, key, this.parent.hasSplitfileKey(), this.parent.checker, this.parent);
        this.parent.innerWriteSegmentKey(this.segNo, blockNumber, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHasKey(int blockNumber) {
        SplitFileInserterSegmentStorage splitFileInserterSegmentStorage = this;
        synchronized (splitFileInserterSegmentStorage) {
            if (this.blocksHaveKeys[blockNumber]) {
                return;
            }
            this.blocksHaveKeys[blockNumber] = true;
            ++this.blocksWithKeysCounter;
            if (this.blocksWithKeysCounter != this.totalBlockCount) {
                return;
            }
        }
        this.parent.onHasKeys(this);
    }

    public synchronized boolean hasKeys() {
        return this.blocksWithKeysCounter == this.totalBlockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkKeys() {
        SplitFileInserterSegmentStorage splitFileInserterSegmentStorage = this;
        synchronized (splitFileInserterSegmentStorage) {
            if (!this.encoded) {
                return;
            }
        }
        try {
            for (int i = 0; i < this.totalBlockCount; ++i) {
                this.readKey(i);
            }
        }
        catch (IOException e) {
            this.parent.failOnDiskError(e);
            return;
        }
        catch (MissingKeyException e) {
            Logger.error(this, "Missing key even though segment encoded. Recovering by re-encoding...");
            SplitFileInserterSegmentStorage splitFileInserterSegmentStorage2 = this;
            synchronized (splitFileInserterSegmentStorage2) {
                this.encoded = false;
            }
            return;
        }
    }

    public int storedKeysLength() {
        return this.keyLength * this.totalBlockCount;
    }

    public byte[] readDataBlock(int blockNo) throws IOException {
        assert (blockNo >= 0 && blockNo < this.dataBlockCount);
        return this.parent.readSegmentDataBlock(this.segNo, blockNo);
    }

    private void writeCheckBlock(int checkBlockNo, byte[] buf) throws IOException {
        this.parent.writeSegmentCheckBlock(this.segNo, checkBlockNo, buf);
    }

    public byte[] readCheckBlock(int checkBlockNo) throws IOException {
        assert (checkBlockNo >= 0 && checkBlockNo < this.checkBlockCount);
        return this.parent.readSegmentCheckBlock(this.segNo, checkBlockNo);
    }

    public synchronized void startEncode(final short prio) {
        if (this.encoded) {
            return;
        }
        if (this.encoding) {
            return;
        }
        this.encoding = true;
        int totalBlockCount = this.dataBlockCount + this.checkBlockCount + this.crossCheckBlockCount;
        long limit = (long)(totalBlockCount * 32768) + Math.max(this.parent.codec.maxMemoryOverheadDecode(this.dataBlockCount, this.crossCheckBlockCount), this.parent.codec.maxMemoryOverheadEncode(this.dataBlockCount, this.crossCheckBlockCount));
        this.parent.memoryLimitedJobRunner.queueJob(new MemoryLimitedJob(limit){

            @Override
            public int getPriority() {
                return prio;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean start(MemoryLimitedChunk chunk) {
                boolean shutdown = false;
                PersistentJobRunner.CheckpointLock lock = null;
                try {
                    lock = SplitFileInserterSegmentStorage.this.parent.jobRunner.lock();
                    SplitFileInserterSegmentStorage.this.innerEncode(chunk);
                }
                catch (PersistenceDisabledException e) {
                    shutdown = true;
                }
                finally {
                    block23: {
                        chunk.release();
                        try {
                            if (shutdown) break block23;
                            SplitFileInserterSegmentStorage splitFileInserterSegmentStorage = SplitFileInserterSegmentStorage.this;
                            synchronized (splitFileInserterSegmentStorage) {
                                SplitFileInserterSegmentStorage.this.encoding = false;
                            }
                            SplitFileInserterSegmentStorage.this.parent.onFinishedEncoding(SplitFileInserterSegmentStorage.this);
                        }
                        finally {
                            if (lock != null) {
                                lock.unlock(false, MemoryLimitedJobRunner.THREAD_PRIORITY);
                            }
                        }
                    }
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void innerEncode(MemoryLimitedChunk chunk) {
        LockableRandomAccessBuffer.RAFLock lock = null;
        try {
            int i;
            SplitFileInserterSegmentStorage splitFileInserterSegmentStorage = this;
            synchronized (splitFileInserterSegmentStorage) {
                if (this.cancelled) {
                    return;
                }
            }
            lock = this.parent.lockRAF();
            if (logMINOR) {
                Logger.minor(this, "Encoding " + this + " for " + this.parent);
            }
            byte[][] dataBlocks = this.readDataAndCrossCheckBlocks();
            this.generateKeys(dataBlocks, 0);
            byte[][] checkBlocks = new byte[this.checkBlockCount][];
            for (i = 0; i < checkBlocks.length; ++i) {
                checkBlocks[i] = new byte[32768];
            }
            if (dataBlocks == null) return;
            if (checkBlocks == null) {
                return;
            }
            this.parent.codec.encode(dataBlocks, checkBlocks, new boolean[checkBlocks.length], 32768);
            for (i = 0; i < checkBlocks.length; ++i) {
                this.writeCheckBlock(i, checkBlocks[i]);
            }
            this.generateKeys(checkBlocks, this.dataBlockCount + this.crossCheckBlockCount);
            SplitFileInserterSegmentStorage splitFileInserterSegmentStorage2 = this;
            synchronized (splitFileInserterSegmentStorage2) {
                this.encoded = true;
            }
            if (!logMINOR) return;
            Logger.minor(this, "Encoded " + this + " for " + this.parent);
            return;
        }
        catch (IOException e) {
            this.parent.failOnDiskError(e);
            return;
        }
        catch (Throwable t) {
            Logger.error(this, "Failed: " + t, t);
            this.parent.fail(new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, t, null));
            return;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private void generateKeys(byte[][] dataBlocks, int offset) throws IOException {
        for (int i = 0; i < dataBlocks.length; ++i) {
            this.setKey(i + offset, this.encodeBlock(dataBlocks[i]).getClientKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] readDataAndCrossCheckBlocks() throws IOException {
        int i;
        byte[][] data = new byte[this.dataBlockCount + this.crossCheckBlockCount][];
        LockableRandomAccessBuffer.RAFLock lock = this.parent.lockUnderlying();
        try {
            for (i = 0; i < this.dataBlockCount; ++i) {
                data[i] = this.readDataBlock(i);
            }
        }
        finally {
            lock.unlock();
        }
        for (i = 0; i < this.crossCheckBlockCount; ++i) {
            data[i + this.dataBlockCount] = this.readCrossCheckBlock(i);
        }
        return data;
    }

    private byte[] readCrossCheckBlock(int blockNo) throws IOException {
        return this.crossSegmentBlockSegments[blockNo].readCheckBlock(this.crossSegmentBlockNumbers[blockNo], this.segNo, blockNo + this.dataBlockCount);
    }

    public synchronized boolean isFinishedEncoding() {
        return this.encoded;
    }

    synchronized boolean isEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientCHKBlock encodeBlock(int blockNo) throws IOException {
        if (this.parent.isFinishing()) {
            throw new IOException("Already finishing reading block " + blockNo + " for " + this + " for " + this.parent);
        }
        SplitFileInserterSegmentStorage splitFileInserterSegmentStorage = this;
        synchronized (splitFileInserterSegmentStorage) {
            if (this.blockChooser.hasSucceeded(blockNo)) {
                Logger.error(this, "Already inserted block " + blockNo + " for " + this + " for " + this.parent);
                throw new IOException("Already inserted block " + blockNo + " for " + this + " for " + this.parent);
            }
        }
        byte[] buf = this.readBlock(blockNo);
        return this.encodeBlock(buf);
    }

    private byte[] readBlock(int blockNo) throws IOException {
        assert (blockNo >= 0 && blockNo < this.totalBlockCount);
        if (blockNo < this.dataBlockCount) {
            return this.readDataBlock(blockNo);
        }
        if (blockNo < this.dataBlockCount + this.crossCheckBlockCount) {
            return this.readCrossCheckBlock(blockNo - this.dataBlockCount);
        }
        return this.readCheckBlock(blockNo - (this.dataBlockCount + this.crossCheckBlockCount));
    }

    ClientCHKBlock encodeBlock(byte[] buf) {
        ClientCHKBlock block;
        assert (buf.length == 32768);
        try {
            block = ClientCHKBlock.encodeSplitfileBlock(buf, this.splitfileCryptoKey, this.splitfileCryptoAlgorithm);
        }
        catch (CHKEncodeException e) {
            throw new Error(e);
        }
        return block;
    }

    private ClientCHK innerReadKey(DataInputStream dis) throws IOException {
        if (this.splitfileCryptoKey != null) {
            byte[] routingKey = new byte[32];
            dis.readFully(routingKey);
            return new ClientCHK(routingKey, this.splitfileCryptoKey, false, this.splitfileCryptoAlgorithm, -1);
        }
        return new ClientCHK(dis);
    }

    ClientCHK readKey(int blockNumber) throws IOException, MissingKeyException {
        byte[] buf = this.parent.innerReadSegmentKey(this.segNo, blockNumber);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(this.segNo);
        dos.writeInt(blockNumber);
        dos.close();
        byte[] prefix = baos.toByteArray();
        byte[] checkBuf = new byte[prefix.length + buf.length];
        System.arraycopy(prefix, 0, checkBuf, 0, prefix.length);
        int checksumLength = this.parent.checker.checksumLength();
        System.arraycopy(buf, 0, checkBuf, prefix.length, buf.length - checksumLength);
        byte[] checksum = Arrays.copyOfRange(buf, buf.length - checksumLength, buf.length);
        if (this.parent.checker.checkChecksum(checkBuf, 0, checkBuf.length, checksum)) {
            throw new MissingKeyException();
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
        byte b = dis.readByte();
        if (b != 1) {
            throw new MissingKeyException();
        }
        ClientCHK key = this.innerReadKey(dis);
        this.setHasKey(blockNumber);
        if (logDEBUG) {
            Logger.debug(this, "Returning " + key);
        }
        return key;
    }

    public synchronized boolean hasSucceeded() {
        if (this.cancelled) {
            return false;
        }
        return this.blockChooser.hasSucceededAll();
    }

    public synchronized boolean hasEncoded() {
        return this.encoded;
    }

    public void onInsertedBlock(int blockNo, ClientCHK key) {
        try {
            if (this.parent.hasFinished()) {
                return;
            }
            this.setKey(blockNo, key);
            if (this.blockChooser.onSuccess(blockNo)) {
                this.parent.callback.onInsertedBlock();
            }
            this.lazyWriteMetadata();
        }
        catch (IOException e) {
            if (this.parent.hasFinished()) {
                return;
            }
            this.parent.failOnDiskError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onInsertedAllBlocks() {
        if (logMINOR) {
            Logger.minor(this, "Inserted all blocks in segment " + this);
        }
        SplitFileInserterSegmentStorage splitFileInserterSegmentStorage = this;
        synchronized (splitFileInserterSegmentStorage) {
            if (!this.encoded) {
                return;
            }
        }
        this.parent.segmentSucceeded(this);
    }

    public void onFailure(int blockNo, InsertException e) {
        if (logMINOR) {
            Logger.minor(this, "Failed block " + blockNo + " with " + e + " for " + this + " for " + this.parent);
        }
        if (this.parent.hasFinished()) {
            return;
        }
        this.parent.addFailure(e);
        if (e.isFatal()) {
            this.parent.failFatalErrorInBlock();
        } else {
            if (e.mode == InsertException.InsertExceptionMode.ROUTE_NOT_FOUND && this.blockChooser.consecutiveRNFsCountAsSuccess > 0) {
                try {
                    this.readKey(blockNo);
                    this.blockChooser.onRNF(blockNo);
                    this.parent.clearCooldown();
                    return;
                }
                catch (MissingKeyException e1) {
                    Logger.error(this, "RNF but no key on block " + blockNo + " on " + this);
                }
                catch (IOException e1) {
                    if (this.parent.hasFinished()) {
                        return;
                    }
                    this.parent.failOnDiskError(e1);
                    return;
                }
            } else if (this.blockChooser.consecutiveRNFsCountAsSuccess > 0 && this.blockChooser.pushRNFs(blockNo)) {
                this.parent.failTooManyRetriesInBlock();
                return;
            }
            if (this.blockChooser.onNonFatalFailure(blockNo)) {
                this.parent.failTooManyRetriesInBlock();
            } else {
                if (this.blockChooser.maxRetries >= 0) {
                    this.lazyWriteMetadata();
                }
                this.parent.clearCooldown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyWriteMetadata() {
        SplitFileInserterSegmentStorage splitFileInserterSegmentStorage = this;
        synchronized (splitFileInserterSegmentStorage) {
            this.metadataDirty = true;
        }
        this.parent.lazyWriteMetadata();
    }

    public synchronized boolean hasCompletedOrFailed() {
        if (this.encoded) {
            return true;
        }
        if (this.encoding) {
            return false;
        }
        if (this.cancelled) {
            return true;
        }
        return this.blockChooser.hasSucceededAll();
    }

    public synchronized boolean cancel() {
        if (this.cancelled) {
            return false;
        }
        this.cancelled = true;
        return this.hasCompletedOrFailed();
    }

    public synchronized BlockInsert chooseBlock() {
        int chosenBlock = this.innerChooseBlock();
        if (chosenBlock == -1) {
            return null;
        }
        return new BlockInsert(this, chosenBlock);
    }

    synchronized int innerChooseBlock() {
        if (this.cancelled) {
            return -1;
        }
        return this.blockChooser.chooseKey();
    }

    void setCrossCheckBlock(SplitFileInserterCrossSegmentStorage crossSegment, int segmentBlockNumber, int crossSegmentBlockNumber) {
        this.crossSegmentBlockSegments[segmentBlockNumber - this.dataBlockCount] = crossSegment;
        this.crossSegmentBlockNumbers[segmentBlockNumber - this.dataBlockCount] = crossSegmentBlockNumber;
    }

    public int countSendableKeys() {
        return this.blockChooser.countFetchable();
    }

    public String toString() {
        return super.toString() + ":" + this.parent;
    }

    static {
        Logger.registerClass(SplitFileInserterSegmentStorage.class);
    }

    static final class BlockInsert
    implements SendableRequestItemKey,
    SendableRequestItem {
        final SplitFileInserterSegmentStorage segment;
        final int blockNumber;
        final int hashCode;

        BlockInsert(SplitFileInserterSegmentStorage segment, int blockNumber) {
            this.segment = segment;
            this.blockNumber = blockNumber;
            this.hashCode = this.computeHashCode();
        }

        private int computeHashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.blockNumber;
            result = 31 * result + (this.segment == null ? 0 : this.segment.hashCode());
            return result;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BlockInsert)) {
                return false;
            }
            BlockInsert other = (BlockInsert)obj;
            if (this.blockNumber != other.blockNumber) {
                return false;
            }
            return this.segment == other.segment;
        }

        @Override
        public void dump() {
        }

        @Override
        public SendableRequestItemKey getKey() {
            return this;
        }

        public String toString() {
            return "BlockInsert:" + this.segment + ":" + this.blockNumber + "@memory:" + super.hashCode();
        }
    }

    public class MissingKeyException
    extends Exception {
    }
}

