/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.SimpleFieldSet;

public class PeerMessage
extends FCPMessage {
    static final String name = "Peer";
    final PeerNode pn;
    final boolean withMetadata;
    final boolean withVolatile;
    final String identifier;

    public PeerMessage(PeerNode pn, boolean withMetadata, boolean withVolatile, String identifier) {
        this.pn = pn;
        this.withMetadata = withMetadata;
        this.withVolatile = withVolatile;
        this.identifier = identifier;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet vol;
        SimpleFieldSet meta;
        SimpleFieldSet fs = this.pn.exportFieldSet();
        if (this.withMetadata && !(meta = this.pn.exportMetadataFieldSet(System.currentTimeMillis())).isEmpty()) {
            fs.put("metadata", meta);
        }
        if (this.withVolatile && !(vol = this.pn.exportVolatileFieldSet()).isEmpty()) {
            fs.put("volatile", vol);
        }
        if (this.identifier != null) {
            fs.putSingle("Identifier", this.identifier);
        }
        return fs;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "Peer goes from server to client not the other way around", null, false);
    }
}

