/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.AsyncMessageCallback;

public abstract class MultiMessageCallback {
    private int waiting;
    private int waitingForSend;
    private boolean armed;
    private boolean someFailed;

    abstract void finish(boolean var1);

    abstract void sent(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncMessageCallback make() {
        MultiMessageCallback multiMessageCallback = this;
        synchronized (multiMessageCallback) {
            AsyncMessageCallback cb = new AsyncMessageCallback(){
                private boolean finished;
                private boolean sent;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sent() {
                    boolean success;
                    MultiMessageCallback multiMessageCallback = MultiMessageCallback.this;
                    synchronized (multiMessageCallback) {
                        if (this.finished || this.sent || !MultiMessageCallback.this.armed) {
                            return;
                        }
                        this.sent = true;
                        MultiMessageCallback.this.waitingForSend--;
                        if (MultiMessageCallback.this.waitingForSend > 0) {
                            return;
                        }
                        success = !MultiMessageCallback.this.someFailed;
                    }
                    MultiMessageCallback.this.sent(success);
                }

                @Override
                public void acknowledged() {
                    this.complete(true);
                }

                @Override
                public void disconnected() {
                    this.complete(false);
                }

                @Override
                public void fatalError() {
                    this.complete(false);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void complete(boolean success) {
                    boolean callSent = false;
                    MultiMessageCallback multiMessageCallback = MultiMessageCallback.this;
                    synchronized (multiMessageCallback) {
                        if (this.finished) {
                            return;
                        }
                        if (!this.sent) {
                            this.sent = true;
                            MultiMessageCallback.this.waitingForSend--;
                            if (MultiMessageCallback.this.waitingForSend == 0) {
                                callSent = true;
                            }
                        }
                        if (!success) {
                            MultiMessageCallback.this.someFailed = true;
                        }
                        this.finished = true;
                        MultiMessageCallback.this.waiting--;
                        if (!MultiMessageCallback.this.finished()) {
                            return;
                        }
                        if (MultiMessageCallback.this.someFailed) {
                            success = false;
                        }
                    }
                    if (callSent) {
                        MultiMessageCallback.this.sent(success);
                    }
                    MultiMessageCallback.this.finish(success);
                }
            };
            ++this.waiting;
            ++this.waitingForSend;
            return cb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arm() {
        boolean success;
        boolean callSent = false;
        boolean complete = false;
        MultiMessageCallback multiMessageCallback = this;
        synchronized (multiMessageCallback) {
            this.armed = true;
            boolean bl = complete = this.waiting == 0;
            if (this.waitingForSend == 0) {
                callSent = true;
            }
            success = !this.someFailed;
        }
        if (callSent) {
            this.sent(success);
        }
        if (complete) {
            this.finish(success);
        }
    }

    protected final synchronized boolean finished() {
        return this.armed && this.waiting == 0;
    }
}

