/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.InsertContext;
import freenet.client.async.ClientContext;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.PutFailedMessage;
import freenet.support.api.Bucket;

public abstract class ClientPutBase
extends ClientRequest {
    final InsertContext ctx;
    final boolean getCHKOnly;
    protected boolean succeeded;
    protected PutFailedMessage putFailedMessage;
    protected FreenetURI generatedURI;
    protected FCPMessage progressMessage;
    protected final boolean earlyEncode;
    protected final FreenetURI publicURI;
    protected Bucket generatedMetadata;
    public static final String SALT = "Salt";
    public static final String FILE_HASH = "FileHash";

    protected ClientPutBase() {
        throw new UnsupportedOperationException();
    }

    static FreenetURI checkEmptySSK(FreenetURI uri, String filename, ClientContext context) {
        if ("SSK".equals(uri.getKeyType()) && uri.getDocName() == null && uri.getRoutingKey() == null) {
            if (filename == null || filename.equals("")) {
                filename = "key";
            }
            InsertableClientSSK key = InsertableClientSSK.createRandom(context.random, "");
            return key.getInsertURI().setDocName(filename);
        }
        return uri;
    }

    public FreenetURI getGeneratedURI(ObjectContainer container) {
        if (this.generatedURI == null) {
            return null;
        }
        container.activate((Object)this.generatedURI, Integer.MAX_VALUE);
        FreenetURI ret = this.generatedURI.clone();
        container.deactivate((Object)this.generatedURI, 1);
        return ret;
    }

    protected abstract String getTypeName();
}

