/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class OutputStreamLogger
extends OutputStream {
    final Logger.LogLevel prio;
    final String prefix;
    final String charset;

    public OutputStreamLogger(Logger.LogLevel prio, String prefix, String charset) {
        this.prio = prio;
        this.prefix = prefix;
        this.charset = charset;
    }

    @Override
    public void write(int b) {
        Logger.logStatic((Object)this, this.prefix + (char)b, this.prio);
    }

    @Override
    public void write(byte[] buf, int offset, int length) {
        try {
            Logger.logStatic((Object)this, this.prefix + new String(buf, offset, length, this.charset), this.prio);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    @Override
    public void write(byte[] buf) {
        this.write(buf, 0, buf.length);
    }
}

