/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.NodeStats;
import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.ExecutorIdleCallback;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;

public class PrioritizedSerialExecutor
implements Executor {
    private static volatile boolean logMINOR;
    private final ArrayDeque<Runnable>[] jobs;
    private final int priority;
    private final int defaultPriority;
    private boolean waiting;
    private final boolean invertOrder;
    private String name;
    private Executor realExecutor;
    private boolean running;
    private final ExecutorIdleCallback callback;
    private static final long DEFAULT_JOB_TIMEOUT;
    private final long jobTimeout;
    private final Runner runner = new Runner();
    private final NodeStats statistics;

    public PrioritizedSerialExecutor(int priority, int internalPriorityCount, int defaultPriority, boolean invertOrder, long jobTimeout, ExecutorIdleCallback callback, NodeStats statistics) {
        ArrayDeque[] jobs = new ArrayDeque[internalPriorityCount];
        for (int i = 0; i < jobs.length; ++i) {
            jobs[i] = new ArrayDeque();
        }
        this.jobs = jobs;
        this.priority = priority;
        this.defaultPriority = defaultPriority;
        this.invertOrder = invertOrder;
        this.jobTimeout = jobTimeout;
        this.callback = callback;
        this.statistics = statistics;
    }

    public PrioritizedSerialExecutor(int priority, int internalPriorityCount, int defaultPriority, boolean invertOrder) {
        this(priority, internalPriorityCount, defaultPriority, invertOrder, DEFAULT_JOB_TIMEOUT, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Executor realExecutor, String name) {
        this.realExecutor = realExecutor;
        this.name = name;
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            boolean empty = true;
            for (ArrayDeque<Runnable> l : this.jobs) {
                if (l.isEmpty()) continue;
                empty = false;
                break;
            }
            if (!empty) {
                this.reallyStart();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyStart() {
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            if (this.running) {
                Logger.error(this, "Not reallyStart()ing: ALREADY RUNNING", (Throwable)new Exception("error"));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.running = true;
            if (logMINOR) {
                Logger.minor(this, "Starting thread... " + this.name + " : " + this.runner, (Throwable)new Exception("debug"));
            }
            this.realExecutor.execute(this.runner, this.name);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void execute(Runnable job) {
        this.execute(job, "<noname>");
    }

    @Override
    public void execute(Runnable job, String jobName) {
        int prio = this.defaultPriority;
        if (job instanceof PrioRunnable) {
            prio = ((PrioRunnable)job).getPriority();
        }
        this.execute(job, prio, jobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable job, int prio, String jobName) {
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            if (logMINOR) {
                Logger.minor(this, "Queueing " + jobName + " : " + job + " priority " + prio + ", executor state: running=" + this.running + " waiting=" + this.waiting);
            }
            this.jobs[prio].addLast(job);
            this.jobs.notifyAll();
            if (!this.running && this.realExecutor != null) {
                this.reallyStart();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeNoDupes(Runnable job, int prio, String jobName) {
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            if (this.jobs[prio].contains(job)) {
                if (logMINOR) {
                    Logger.minor(this, "Not queueing job: Job already queued: " + job);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Queueing " + jobName + " : " + job + " priority " + prio + ", executor state: running=" + this.running + " waiting=" + this.waiting);
            }
            this.jobs[prio].addLast(job);
            this.jobs.notifyAll();
            if (!this.running && this.realExecutor != null) {
                this.reallyStart();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void execute(Runnable job, String jobName, boolean fromTicker) {
        this.execute(job, jobName);
    }

    @Override
    public int[] runningThreads() {
        int[] retval = new int[10];
        if (this.running) {
            retval[this.priority] = 1;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] waitingThreads() {
        int[] retval = new int[10];
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            if (this.waiting) {
                retval[this.priority] = 1;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onThread() {
        Thread running = Thread.currentThread();
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            if (this.runner == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.runner.current == running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getQueuedJobsCountByPriority() {
        int[] retval = new int[this.jobs.length];
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = this.jobs[i].size();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable[][] getQueuedJobsByPriority() {
        Runnable[][] ret = new Runnable[this.jobs.length][];
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            for (int i = 0; i < this.jobs.length; ++i) {
                ret[i] = this.jobs[i].toArray(new Runnable[this.jobs[i].size()]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize(int priority) {
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.jobs[priority].size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWaitingThreadsCount() {
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.waiting ? 1 : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anyQueued() {
        ArrayDeque<Runnable>[] arrayDequeArray = this.jobs;
        synchronized (this.jobs) {
            for (int i = 0; i < this.jobs.length; ++i) {
                if (this.jobs[i].size() <= 0) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        DEFAULT_JOB_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    }

    class Runner
    implements PrioRunnable {
        Thread current;

        Runner() {
        }

        @Override
        public int getPriority() {
            return PrioritizedSerialExecutor.this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Runnable job;
            boolean calledIdleCallback;
            ArrayDeque[] arrayDequeArray = PrioritizedSerialExecutor.this.jobs;
            // MONITORENTER : arrayDequeArray
            if (this.current != null && this.current.isAlive()) {
                Logger.error(this, "Already running a thread for " + this + " !!", (Throwable)new Exception("error"));
                // MONITOREXIT : arrayDequeArray
                return;
            }
            this.current = Thread.currentThread();
            // MONITOREXIT : arrayDequeArray
            try {
                calledIdleCallback = false;
                while (true) {
                    job = null;
                    ArrayDeque[] arrayDequeArray2 = PrioritizedSerialExecutor.this.jobs;
                    // MONITORENTER : arrayDequeArray2
                    job = this.checkQueue();
                    if (job != null) break block23;
                    PrioritizedSerialExecutor.this.waiting = true;
                    try {
                        PrioritizedSerialExecutor.this.jobs.wait(PrioritizedSerialExecutor.this.jobTimeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    PrioritizedSerialExecutor.this.waiting = false;
                    job = this.checkQueue();
                    if (job != null || !calledIdleCallback && PrioritizedSerialExecutor.this.callback != null) break block23;
                    PrioritizedSerialExecutor.this.running = false;
                    this.current = null;
                    // MONITOREXIT : arrayDequeArray2
                    break;
                }
            }
            catch (Throwable throwable) {
                ArrayDeque[] arrayDequeArray3 = PrioritizedSerialExecutor.this.jobs;
                // MONITORENTER : arrayDequeArray3
                this.current = null;
                PrioritizedSerialExecutor.this.running = false;
                // MONITOREXIT : arrayDequeArray3
                throw throwable;
            }
            {
                block23: {
                    ArrayDeque[] arrayDequeArray4 = PrioritizedSerialExecutor.this.jobs;
                    // MONITORENTER : arrayDequeArray4
                    this.current = null;
                    PrioritizedSerialExecutor.this.running = false;
                    // MONITOREXIT : arrayDequeArray4
                    return;
                }
                // MONITOREXIT : arrayDequeArray2
                if (job == null) {
                    try {
                        PrioritizedSerialExecutor.this.callback.onIdle();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Idle callback failed: " + t, t);
                    }
                    calledIdleCallback = true;
                    continue;
                }
                calledIdleCallback = false;
                try {
                    if (logMINOR) {
                        Logger.minor(this, "Running job " + job);
                    }
                    long start = System.currentTimeMillis();
                    job.run();
                    long end = System.currentTimeMillis();
                    if (logMINOR) {
                        Logger.minor(this, "Job " + job + " took " + (end - start) + "ms");
                    }
                    if (PrioritizedSerialExecutor.this.statistics == null) continue;
                    PrioritizedSerialExecutor.this.statistics.reportDatabaseJob(job.toString(), end - start);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t, t);
                    Logger.error(this, "While running " + job + " on " + this);
                }
                continue;
            }
        }

        private Runnable checkQueue() {
            if (!PrioritizedSerialExecutor.this.invertOrder) {
                for (int i = 0; i < PrioritizedSerialExecutor.this.jobs.length; ++i) {
                    if (PrioritizedSerialExecutor.this.jobs[i].isEmpty()) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Chosen job at priority " + i);
                    }
                    return (Runnable)PrioritizedSerialExecutor.this.jobs[i].removeFirst();
                }
            } else {
                for (int i = PrioritizedSerialExecutor.this.jobs.length - 1; i >= 0; --i) {
                    if (PrioritizedSerialExecutor.this.jobs[i].isEmpty()) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Chosen job at priority " + i);
                    }
                    return (Runnable)PrioritizedSerialExecutor.this.jobs[i].removeFirst();
                }
            }
            return null;
        }
    }
}

