/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.LibraryLoader;
import freenet.support.Logger;

public class NativeThread
extends Thread {
    public static final boolean _loadNative;
    private static boolean _disabled;
    public static final int JAVA_PRIORITY_RANGE = 9;
    private static final int NATIVE_PRIORITY_BASE;
    public static final int NATIVE_PRIORITY_RANGE;
    private int currentPriority = 10;
    private boolean dontCheckRenice = false;
    public static final boolean HAS_THREE_NICE_LEVELS;
    public static final boolean HAS_ENOUGH_NICE_LEVELS;
    public static final boolean HAS_PLENTY_NICE_LEVELS;
    public static final int ENOUGH_NICE_LEVELS;
    public static final int MIN_PRIORITY;
    public static final int LOW_PRIORITY;
    public static final int NORM_PRIORITY;
    public static final int HIGH_PRIORITY;
    public static final int MAX_PRIORITY;

    public NativeThread(String name, int priority, boolean dontCheckRenice) {
        super(name);
        this.currentPriority = priority;
        this.dontCheckRenice = dontCheckRenice;
    }

    public NativeThread(Runnable r, String name, int priority, boolean dontCheckRenice) {
        super(r, name);
        this.currentPriority = priority;
        this.dontCheckRenice = dontCheckRenice;
    }

    public NativeThread(ThreadGroup g, Runnable r, String name, int priority, boolean dontCheckRenice) {
        super(g, r, name);
        this.currentPriority = priority;
        this.dontCheckRenice = dontCheckRenice;
    }

    private static native boolean setLinuxPriority(int var0);

    private static native int getLinuxPriority();

    @Override
    public final void run() {
        if (!this.setNativePriority(this.currentPriority)) {
            System.err.println("setNativePriority(" + this.currentPriority + ") has failed!");
        }
        super.run();
        this.realRun();
    }

    public void realRun() {
    }

    private boolean setNativePriority(int prio) {
        Logger.minor(this, "setNativePriority(" + prio + ")");
        this.setPriority(prio);
        if (!_loadNative) {
            Logger.minor(this, "_loadNative is false");
            return true;
        }
        int realPrio = NativeThread.getLinuxPriority();
        if (_disabled) {
            Logger.normal(this, "Not setting native priority as disabled due to renicing");
            return false;
        }
        if (NATIVE_PRIORITY_BASE != realPrio && !this.dontCheckRenice) {
            _disabled = true;
            Logger.error(this, "Freenet has detected it has been reniced : THAT'S BAD, DON'T DO IT! Nice level detected statically: " + NATIVE_PRIORITY_BASE + " actual nice level: " + realPrio + " on " + this);
            System.err.println("Freenet has detected it has been reniced : THAT'S BAD, DON'T DO IT! Nice level detected statically: " + NATIVE_PRIORITY_BASE + " actual nice level: " + realPrio + " on " + this);
            new NullPointerException().printStackTrace();
            return false;
        }
        int linuxPriority = NATIVE_PRIORITY_BASE + NATIVE_PRIORITY_RANGE - NATIVE_PRIORITY_RANGE * (prio - MIN_PRIORITY) / 9;
        if (linuxPriority == realPrio) {
            return true;
        }
        if (prio < this.currentPriority) {
            throw new IllegalStateException("You're trying to set a thread priority above the current value!! It's not possible if you aren't root and shouldn't ever occur in our code. (asked=" + prio + ':' + linuxPriority + " currentMax=" + this.currentPriority + ':' + NATIVE_PRIORITY_BASE + ") SHOUDLN'T HAPPEN, please report!");
        }
        Logger.minor(this, "Setting native priority to " + linuxPriority + " (base=" + NATIVE_PRIORITY_BASE + ") for " + this);
        return NativeThread.setLinuxPriority(linuxPriority);
    }

    public int getNativePriority() {
        return this.currentPriority;
    }

    public static boolean usingNativeCode() {
        return _loadNative && !_disabled;
    }

    public static String normalizeName(String name) {
        if (name.indexOf(" for ") != -1) {
            name = name.substring(0, name.indexOf(" for "));
        }
        if (name.indexOf(64) != -1) {
            name = name.substring(0, name.indexOf(64));
        }
        if (name.indexOf(40) != -1) {
            name = name.substring(0, name.indexOf(40));
        }
        return name.trim();
    }

    public String getNormalizedName() {
        return NativeThread.normalizeName(this.getName());
    }

    static {
        ENOUGH_NICE_LEVELS = PriorityLevel.values().length;
        MIN_PRIORITY = PriorityLevel.MIN_PRIORITY.value;
        LOW_PRIORITY = PriorityLevel.LOW_PRIORITY.value;
        NORM_PRIORITY = PriorityLevel.NORM_PRIORITY.value;
        HIGH_PRIORITY = PriorityLevel.HIGH_PRIORITY.value;
        MAX_PRIORITY = PriorityLevel.MAX_PRIORITY.value;
        Logger.minor(NativeThread.class, "Running init()");
        boolean maybeLoadNative = "Linux".equalsIgnoreCase(System.getProperty("os.name"));
        Logger.debug(NativeThread.class, "Run init(): should loadNative=" + maybeLoadNative);
        if (maybeLoadNative && LibraryLoader.loadNative("/freenet/support/io/", "NativeThread")) {
            NATIVE_PRIORITY_BASE = NativeThread.getLinuxPriority();
            NATIVE_PRIORITY_RANGE = 20 - NATIVE_PRIORITY_BASE;
            System.out.println("Using the NativeThread implementation (base nice level is " + NATIVE_PRIORITY_BASE + ')');
            HAS_THREE_NICE_LEVELS = NATIVE_PRIORITY_RANGE >= 3;
            HAS_ENOUGH_NICE_LEVELS = NATIVE_PRIORITY_RANGE >= ENOUGH_NICE_LEVELS;
            boolean bl = HAS_PLENTY_NICE_LEVELS = NATIVE_PRIORITY_RANGE >= 9;
            if (!HAS_ENOUGH_NICE_LEVELS || !HAS_THREE_NICE_LEVELS) {
                System.err.println("WARNING!!! The JVM has been niced down to a level which won't allow it to schedule threads properly! LOWER THE NICE LEVEL!!");
            }
            _loadNative = true;
        } else {
            NATIVE_PRIORITY_BASE = 0;
            NATIVE_PRIORITY_RANGE = 19;
            HAS_THREE_NICE_LEVELS = true;
            HAS_ENOUGH_NICE_LEVELS = true;
            HAS_PLENTY_NICE_LEVELS = true;
            _loadNative = false;
        }
        Logger.minor(NativeThread.class, "Run init(): _loadNative = " + _loadNative);
    }

    public static enum PriorityLevel {
        MIN_PRIORITY(1),
        LOW_PRIORITY(3),
        NORM_PRIORITY(5),
        HIGH_PRIORITY(7),
        MAX_PRIORITY(10);

        public final int value;

        private PriorityLevel(int myValue) {
            this.value = myValue;
        }

        public static PriorityLevel fromValue(int value) {
            for (PriorityLevel level : PriorityLevel.values()) {
                if (level.value != value) continue;
                return level;
            }
            throw new IllegalArgumentException();
        }
    }
}

