/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidParameterException;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import javax.net.ssl.SSLException;

public class Sha1Test {
    static final int BUFFERSIZE = 4096;
    static final String BASE_URL = "https://downloads.freenetproject.org/latest/";
    static final int DHKEYSIZE = 2048;
    static boolean useSecureMode = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File TMP_KEYSTORE = null;
        String uri = args[0];
        String path = (args.length < 2 ? "." : args[1]) + "/";
        if (uri == null) {
            System.exit(2);
        }
        try {
            KeyPairGenerator.getInstance("DH").initialize(2048);
        }
        catch (NoSuchAlgorithmException f) {
            System.err.println("Failed to find Diffie Helman key pair generator: " + f.getMessage());
            System.exit(2);
        }
        catch (InvalidParameterException e) {
            System.err.println("Failed to initialize a DH key pair: '" + e.getMessage() + "'");
            System.err.println("A key size of 2048 is required for https://downloads.freenetproject.org/latest/");
            System.err.println("The key size limit was increased to 2048 in OpenJDK 8 and IcedTea >= 2.5.3.");
            System.err.println("Please upgrade your JVM.");
            System.exit(2);
        }
        if (args.length > 2) {
            useSecureMode = true;
            FileInputStream fis = null;
            try {
                TMP_KEYSTORE = File.createTempFile("keystore", ".tmp");
                TMP_KEYSTORE.deleteOnExit();
                System.out.println("Importing " + args[2] + " into " + TMP_KEYSTORE);
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(null, new char[0]);
                fis = new FileInputStream(args[2]);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> c = cf.generateCertificates(fis);
                for (Certificate certificate : c) {
                    ks.setCertificateEntry(certificate.getPublicKey().toString(), certificate);
                }
                ks.store(new FileOutputStream(TMP_KEYSTORE), new char[0]);
                System.out.println("The CA has been imported into the trustStore");
            }
            catch (Exception e) {
                System.err.println("Error while handling the CA :" + e.getMessage());
                e.printStackTrace();
                System.exit(3);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {}
            }
            System.setProperty("javax.net.ssl.trustStore", TMP_KEYSTORE.toString());
        }
        try {
            Sha1Test.realMain(uri, path);
        }
        finally {
            TMP_KEYSTORE.delete();
        }
    }

    private static void realMain(String uri, String path) {
        int count = 0;
        String filename = new File(uri).getName();
        System.out.println("Fetching " + filename);
        while (count < 10) {
            if (count > 0) {
                System.out.println("Attempt " + count);
            }
            try {
                Sha1Test.get(uri, path + filename, true);
                if (Sha1Test.sha1test(path + filename)) {
                    System.exit(0);
                }
                Sha1Test.get(uri, path + filename, false);
                if (Sha1Test.sha1test(path + filename)) {
                    System.exit(0);
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("Not found, let's ignore that mirror.");
            }
            catch (SSLException ssle) {
                System.err.println("An SSL exception has occurred: " + ssle.getMessage());
                Throwable cause = ssle.getCause();
                if (cause != null) {
                    while (cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                    System.err.println("Cause: " + cause.getMessage());
                }
                System.exit(5);
            }
            ++count;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {}
        }
        System.err.println("No mirror is available at the moment, please try again later");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sha1test(String file) {
        File shaFile = new File(file + ".sha1");
        File realFile = new File(file);
        if (!(shaFile.exists() && realFile.exists() && realFile.canRead() && shaFile.canRead())) {
            return false;
        }
        try {
            byte[] buffer;
            MessageDigest hash = MessageDigest.getInstance("SHA-1");
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            String result = "";
            try {
                fis = new FileInputStream(realFile);
                bis = new BufferedInputStream(fis);
                int len = 0;
                buffer = new byte[4096];
                while ((len = bis.read(buffer)) > -1) {
                    hash.update(buffer, 0, len);
                }
            }
            finally {
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException e) {}
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {}
            }
            try {
                fis = new FileInputStream(shaFile);
                bis = new BufferedInputStream(fis);
                int len = 0;
                buffer = new byte[4096];
                while ((len = bis.read(buffer)) > -1) {
                    result = result + new String(buffer, 0, len);
                }
            }
            finally {
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException e) {}
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {}
            }
            byte[] digest = hash.digest();
            int i = result.indexOf(32);
            result = result.substring(0, i);
            return result.equalsIgnoreCase(Sha1Test.bytesToHex(digest));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final String bytesToHex(byte[] bs) {
        StringBuilder sb = new StringBuilder(bs.length * 2);
        for (int i = 0; i < bs.length; ++i) {
            sb.append(Character.forDigit(bs[i] >>> 4 & 0xF, 16));
            sb.append(Character.forDigit(bs[i] & 0xF, 16));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(String file, String filename, boolean checksum) throws FileNotFoundException, SSLException {
        InputStream is = null;
        FilterOutputStream os = null;
        try {
            URL url = new URL(BASE_URL + file + (checksum ? ".sha1" : ""));
            System.out.println(url);
            URLConnection connection = url.openConnection();
            is = Sha1Test.openConnectionCheckRedirects(connection);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            File f = new File(filename + (checksum ? ".sha1" : ""));
            os = new BufferedOutputStream(new FileOutputStream(f));
            int length = 0;
            byte[] buffer = new byte[4096];
            while ((length = dis.read(buffer)) > -1) {
                ((BufferedOutputStream)os).write(buffer, 0, length);
            }
            ((BufferedOutputStream)os).flush();
        }
        catch (MalformedURLException mue) {
            System.err.println("Ouch - a MalformedURLException happened ; please report it.");
            mue.printStackTrace();
            System.exit(2);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (SSLException sslE) {
            throw sslE;
        }
        catch (IOException ioe) {
            System.err.println("Caught :" + ioe.getMessage());
            ioe.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private static InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") && !target.getProtocol().equals("ftp") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }
}

