/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constructor
extends SafeConstructor {
    private final Map<String, Class<? extends Object>> typeTags;
    private final Map<Class<? extends Object>, TypeDescription> typeDefinitions;

    public Constructor() {
        this(Object.class);
    }

    public Constructor(Class<? extends Object> theRoot) {
        if (theRoot == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        this.yamlConstructors.put(null, new ConstructYamlObject());
        this.rootType = theRoot;
        this.typeTags = new HashMap<String, Class<? extends Object>>();
        this.typeDefinitions = new HashMap<Class<? extends Object>, TypeDescription>();
    }

    public Constructor(String theRoot) throws ClassNotFoundException {
        this(Class.forName(Constructor.check(theRoot)));
    }

    private static final String check(String s) {
        if (s == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        if (s.trim().length() == 0) {
            throw new YAMLException("Root type must be provided.");
        }
        return s;
    }

    public TypeDescription addTypeDescription(TypeDescription definition) {
        if (definition == null) {
            throw new NullPointerException("TypeDescription is required.");
        }
        if (this.rootType == Object.class && definition.isRoot()) {
            this.rootType = definition.getType();
        }
        String tag = definition.getTag();
        this.typeTags.put(tag, definition.getType());
        return this.typeDefinitions.put(definition.getType(), definition);
    }

    @Override
    protected Object callConstructor(Node node) {
        Object result;
        if (Object.class.equals(node.getType()) || "tag:yaml.org,2002:null".equals(node.getTag())) {
            return super.callConstructor(node);
        }
        switch (node.getNodeId()) {
            case scalar: {
                result = this.constructJavaBeanScalarNode((ScalarNode)node);
                break;
            }
            case sequence: {
                SequenceNode snode = (SequenceNode)node;
                if (node.isTwoStepsConstruction()) {
                    result = this.createDefaultList(snode.getValue().size());
                    break;
                }
                result = this.constructSequence(snode);
                break;
            }
            default: {
                if (Map.class.isAssignableFrom(node.getType())) {
                    if (node.isTwoStepsConstruction()) {
                        result = this.createDefaultMap();
                        break;
                    }
                    result = this.constructMapping((MappingNode)node);
                    break;
                }
                if (Set.class.isAssignableFrom(node.getType())) {
                    if (node.isTwoStepsConstruction()) {
                        result = this.createDefaultSet();
                        break;
                    }
                    result = this.constructSet((MappingNode)node);
                    break;
                }
                result = node.isTwoStepsConstruction() ? this.createJavaBeanNode(node) : this.constructJavaBeanNode((MappingNode)node);
            }
        }
        return result;
    }

    @Override
    protected void callPostCreate(Node node, Object object) {
        if (!node.isTwoStepsConstruction()) {
            throw new YAMLException("Inexpected recursive structure. Node: " + node);
        }
        if (Object.class.equals(node.getType()) || "tag:yaml.org,2002:null".equals(node.getTag())) {
            super.callPostCreate(node, object);
        } else {
            switch (node.getNodeId()) {
                case scalar: {
                    throw new YAMLException("Scalars cannot be recursive. Node: " + node);
                }
                case sequence: {
                    this.constructSequenceStep2((SequenceNode)node, (List)object);
                    break;
                }
                default: {
                    if (Map.class.isAssignableFrom(node.getType())) {
                        this.constructMapping2ndStep((MappingNode)node, (Map)object);
                        break;
                    }
                    if (Set.class.isAssignableFrom(node.getType())) {
                        this.constructSet2ndStep((MappingNode)node, (Set)object);
                        break;
                    }
                    this.constructJavaBeanNode2ndStep((MappingNode)node, object);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object constructJavaBeanScalarNode(ScalarNode node) {
        Class<? extends Object> type = node.getType();
        if (type.isPrimitive() || type == String.class || Number.class.isAssignableFrom(type) || type == Boolean.class || Date.class.isAssignableFrom(type) || type == Character.class || type == BigInteger.class || Enum.class.isAssignableFrom(type)) {
            Object result;
            if (type == String.class) {
                Construct stringConstructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:str");
                return stringConstructor.construct(node);
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                Construct boolConstructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:bool");
                return boolConstructor.construct(node);
            }
            if (type == Character.class || type == Character.TYPE) {
                Construct charConstructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:str");
                String ch = (String)charConstructor.construct(node);
                if (ch.length() == 1) return new Character(ch.charAt(0));
                throw new YAMLException("Invalid node Character: '" + ch + "'; length: " + ch.length());
            }
            if (Date.class.isAssignableFrom(type)) {
                Construct dateConstructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:timestamp");
                Date date = (Date)dateConstructor.construct(node);
                if (type == Date.class) {
                    return date;
                }
                try {
                    java.lang.reflect.Constructor<? extends Object> constr = type.getConstructor(Long.TYPE);
                    return constr.newInstance(date.getTime());
                }
                catch (Exception e) {
                    throw new YAMLException("Cannot construct: '" + type + "'");
                }
            }
            if (type == Float.class || type == Double.class || type == Float.TYPE || type == Double.TYPE || type == BigDecimal.class) {
                Construct doubleConstructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:float");
                result = doubleConstructor.construct(node);
                if (type == Float.class) return new Float((Double)result);
                if (type == Float.TYPE) {
                    return new Float((Double)result);
                }
                if (type != BigDecimal.class) return result;
                return new BigDecimal((Double)result);
            }
            if (type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == BigInteger.class || type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE) {
                Construct intConstructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:int");
                result = intConstructor.construct(node);
                if (type == Byte.class) return new Byte(result.toString());
                if (type == Byte.TYPE) {
                    return new Byte(result.toString());
                }
                if (type == Short.class) return new Short(result.toString());
                if (type == Short.TYPE) {
                    return new Short(result.toString());
                }
                if (type == Integer.class) return new Integer(result.toString());
                if (type == Integer.TYPE) {
                    return new Integer(result.toString());
                }
                if (type == Long.class) return new Long(result.toString());
                if (type != Long.TYPE) return new BigInteger(result.toString());
                return new Long(result.toString());
            }
            if (!Enum.class.isAssignableFrom(type)) throw new YAMLException("Unsupported class: " + type);
            String tag = "tag:yaml.org,2002:" + type.getName();
            node.setTag(tag);
            return super.callConstructor(node);
        }
        try {
            Object value = super.callConstructor(node);
            if (type.isArray()) {
                return value;
            }
            java.lang.reflect.Constructor<? extends Object> javaConstructor = type.getConstructor(value.getClass());
            return javaConstructor.newInstance(value);
        }
        catch (Exception e) {
            throw new YAMLException(e);
        }
    }

    private Object createJavaBeanNode(Node node) {
        try {
            Class<? extends Object> type = node.getType();
            if (Modifier.isAbstract(type.getModifiers())) {
                node.setType(this.getClassForNode(node));
            }
            return node.getType().newInstance();
        }
        catch (InstantiationException e) {
            throw new YAMLException(e);
        }
        catch (IllegalAccessException e) {
            throw new YAMLException(e);
        }
        catch (ClassNotFoundException e) {
            throw new YAMLException(e);
        }
    }

    private Object constructJavaBeanNode(MappingNode node) {
        return this.constructJavaBeanNode2ndStep(node, this.createJavaBeanNode(node));
    }

    private Object constructJavaBeanNode2ndStep(MappingNode node, Object object) {
        Class<? extends Object> beanType = node.getType();
        Object nodeValue = node.getValue();
        Iterator i$ = nodeValue.iterator();
        while (i$.hasNext()) {
            Node[] tuple = (Node[])i$.next();
            if (!(tuple[0] instanceof ScalarNode)) {
                throw new YAMLException("Keys must be scalars but found: " + tuple[0]);
            }
            ScalarNode keyNode = (ScalarNode)tuple[0];
            Node valueNode = tuple[1];
            keyNode.setType(String.class);
            String key = (String)this.constructObject(keyNode);
            boolean isArray = false;
            try {
                Property property = this.getProperty(beanType, key);
                valueNode.setType(property.getType());
                TypeDescription memberDescription = this.typeDefinitions.get(beanType);
                if (memberDescription != null) {
                    switch (valueNode.getNodeId()) {
                        case sequence: {
                            SequenceNode snode = (SequenceNode)valueNode;
                            Class<? extends Object> memberType = memberDescription.getListPropertyType(key);
                            if (memberType != null) {
                                snode.setListType(memberType);
                                break;
                            }
                            if (!property.getType().isArray()) break;
                            isArray = true;
                            snode.setListType(property.getType().getComponentType());
                            break;
                        }
                        case mapping: {
                            MappingNode mnode = (MappingNode)valueNode;
                            Class<? extends Object> keyType = memberDescription.getMapKeyType(key);
                            if (keyType == null) break;
                            mnode.setKeyType(keyType);
                            mnode.setValueType(memberDescription.getMapValueType(key));
                        }
                    }
                }
                Object[] value = this.constructObject(valueNode);
                if (isArray) {
                    List list = (List)value;
                    value = list.toArray(this.createArray(property.getType()));
                }
                property.set(object, value);
            }
            catch (Exception e) {
                throw new YAMLException(e);
            }
        }
        return object;
    }

    private <T> T[] createArray(Class<T> type) {
        return (Object[])Array.newInstance(type.getComponentType(), 0);
    }

    private Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
        for (PropertyDescriptor property : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
            if (!property.getName().equals(name)) continue;
            if (property.getWriteMethod() != null) {
                return new MethodProperty(property);
            }
            throw new YAMLException("Property '" + name + "' on JavaBean: " + type.getName() + " does not have the write method");
        }
        for (Field field : type.getFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || !field.getName().equals(name)) continue;
            return new FieldProperty(field);
        }
        throw new YAMLException("Unable to find property '" + name + "' on class: " + type.getName());
    }

    protected Class<?> getClassForNode(Node node) throws ClassNotFoundException {
        Class<? extends Object> customTag = this.typeTags.get(node.getTag());
        if (customTag == null) {
            if (node.getTag().length() < "tag:yaml.org,2002:".length()) {
                throw new YAMLException("Unknown tag: " + node.getTag());
            }
            String name = node.getTag().substring("tag:yaml.org,2002:".length());
            Class<?> cl = Class.forName(name);
            this.typeTags.put(node.getTag(), cl);
            return cl;
        }
        return customTag;
    }

    private class ConstructYamlObject
    extends AbstractConstruct {
        private ConstructYamlObject() {
        }

        public Object construct(Node node) {
            Object result = null;
            try {
                Class<?> cl = Constructor.this.getClassForNode(node);
                switch (node.getNodeId()) {
                    case mapping: {
                        node.setType(cl);
                        if (node.isTwoStepsConstruction()) {
                            result = Constructor.this.createJavaBeanNode(node);
                            break;
                        }
                        result = Constructor.this.constructJavaBeanNode((MappingNode)node);
                        break;
                    }
                    case sequence: {
                        SequenceNode seqNode = (SequenceNode)node;
                        List<? extends Object> values = Constructor.this.constructSequence(seqNode);
                        Class[] parameterTypes = new Class[values.size()];
                        int index = 0;
                        for (Object object : values) {
                            parameterTypes[index] = object.getClass();
                            ++index;
                        }
                        java.lang.reflect.Constructor<?> javaConstructor = cl.getConstructor(parameterTypes);
                        Object[] initargs = values.toArray();
                        result = javaConstructor.newInstance(initargs);
                        break;
                    }
                    default: {
                        ScalarNode scalarNode = (ScalarNode)node;
                        Object value = Constructor.this.constructScalar(scalarNode);
                        if (Enum.class.isAssignableFrom(cl)) {
                            String enumValueName = (String)node.getValue();
                            try {
                                result = Enum.valueOf(cl, enumValueName);
                                break;
                            }
                            catch (Exception ex) {
                                throw new YAMLException("Unable to find enum value '" + enumValueName + "' for enum class: " + cl.getName());
                            }
                        }
                        java.lang.reflect.Constructor<?> javaConstructor = cl.getConstructor(value.getClass());
                        result = javaConstructor.newInstance(value);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new ConstructorException(null, null, "Can't construct a java object for " + node.getTag() + "; exception=" + e.getMessage(), node.getStartMark(), e);
            }
            return result;
        }
    }
}

