/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.io.serial;

import java.util.Map;
import java.util.WeakHashMap;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.util.CompositeIterable;
import plugins.Library.util.exec.Progress;
import plugins.Library.util.exec.TaskInProgressException;

public class ProgressTracker<T, P extends Progress> {
    protected final WeakHashMap<Serialiser.PullTask<T>, P> pullProgress = new WeakHashMap();
    protected final WeakHashMap<Serialiser.PushTask<T>, P> pushProgress = new WeakHashMap();
    protected final Class<? extends P> progressClass;

    public ProgressTracker(Class<? extends P> cc) {
        try {
            if (cc != null) {
                cc.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate class. Make sure it has a nullary constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot instantiate class. Make sure you have access to it.", e);
        }
        this.progressClass = cc;
    }

    protected P newProgress() {
        if (this.progressClass == null) {
            throw new IllegalStateException("ProgressTracker cannot create progress: No class was given to the constructor, but newElement() was not overriden.");
        }
        try {
            return (P)((Progress)this.progressClass.newInstance());
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public P getPullProgressFor(Object meta) {
        return this.getPullProgress(new Serialiser.PullTask(meta));
    }

    public P getPushProgressFor(T data) {
        return this.getPushProgress(new Serialiser.PushTask<T>(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P getPullProgress(Serialiser.PullTask<T> task) {
        WeakHashMap<Serialiser.PullTask<T>, P> weakHashMap = this.pullProgress;
        synchronized (weakHashMap) {
            return (P)((Progress)this.pullProgress.get(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P getPushProgress(Serialiser.PushTask<T> task) {
        WeakHashMap<Serialiser.PushTask<T>, P> weakHashMap = this.pushProgress;
        synchronized (weakHashMap) {
            return (P)((Progress)this.pushProgress.get(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P addPullProgress(Serialiser.PullTask<T> task) throws TaskInProgressException {
        WeakHashMap<Serialiser.PullTask<T>, P> weakHashMap = this.pullProgress;
        synchronized (weakHashMap) {
            Progress p = (Progress)this.pullProgress.get(task);
            if (p != null) {
                throw new TaskInProgressException(p);
            }
            p = this.newProgress();
            this.pullProgress.put(task, p);
            return (P)p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P addPushProgress(Serialiser.PushTask<T> task) throws TaskInProgressException {
        WeakHashMap<Serialiser.PushTask<T>, P> weakHashMap = this.pushProgress;
        synchronized (weakHashMap) {
            Progress p = (Progress)this.pushProgress.get(task);
            if (p != null) {
                throw new TaskInProgressException(p);
            }
            p = this.newProgress();
            this.pushProgress.put(task, p);
            return (P)p;
        }
    }

    public static <T, P extends Progress> Iterable<P> makePullProgressIterable(final ProgressTracker<T, P> tracker, Iterable<Serialiser.PullTask<T>> tasks) {
        return new CompositeIterable<Serialiser.PullTask<T>, P>(tasks, true){

            @Override
            public P nextFor(Serialiser.PullTask<T> next) {
                return tracker.getPullProgress(next);
            }
        };
    }

    public static <T, P extends Progress> Iterable<P> makePushProgressIterable(final ProgressTracker<T, P> tracker, Iterable<Serialiser.PushTask<T>> tasks) {
        return new CompositeIterable<Serialiser.PushTask<T>, P>(tasks, true){

            @Override
            public P nextFor(Serialiser.PushTask<T> next) {
                return tracker.getPushProgress(next);
            }
        };
    }

    public static <T, P extends Progress> Iterable<P> makePullProgressIterable(Map<Serialiser.PullTask<T>, ProgressTracker<T, ? extends P>> ids) {
        return new CompositeIterable<Map.Entry<Serialiser.PullTask<T>, ProgressTracker<T, ? extends P>>, P>(ids.entrySet(), true){

            @Override
            public P nextFor(Map.Entry<Serialiser.PullTask<T>, ProgressTracker<T, ? extends P>> next) {
                return next.getValue().getPullProgress(next.getKey());
            }
        };
    }

    public static <T, P extends Progress> Iterable<P> makePushProgressIterable(Map<Serialiser.PushTask<T>, ProgressTracker<T, ? extends P>> ids) {
        return new CompositeIterable<Map.Entry<Serialiser.PushTask<T>, ProgressTracker<T, ? extends P>>, P>(ids.entrySet(), true){

            @Override
            public P nextFor(Map.Entry<Serialiser.PushTask<T>, ProgressTracker<T, ? extends P>> next) {
                return next.getValue().getPushProgress(next.getKey());
            }
        };
    }
}

