/*
 * Decompiled with CFR 0.152.
 */
package plugins.UPnP.org.cybergarage.upnp.ssdp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import plugins.UPnP.org.cybergarage.http.HTTPHeader;
import plugins.UPnP.org.cybergarage.upnp.device.MAN;
import plugins.UPnP.org.cybergarage.upnp.device.NT;
import plugins.UPnP.org.cybergarage.upnp.device.NTS;
import plugins.UPnP.org.cybergarage.upnp.device.ST;
import plugins.UPnP.org.cybergarage.upnp.device.USN;
import plugins.UPnP.org.cybergarage.upnp.ssdp.SSDP;

public class SSDPPacket {
    private DatagramPacket dgmPacket = null;
    private String localAddr = "";
    private long timeStamp;
    public byte[] packetBytes = null;

    public SSDPPacket(byte[] buf, int length) {
        this.dgmPacket = new DatagramPacket(buf, length);
    }

    public DatagramPacket getDatagramPacket() {
        return this.dgmPacket;
    }

    public void setLocalAddress(String addr) {
        this.localAddr = addr;
    }

    public String getLocalAddress() {
        return this.localAddr;
    }

    public void setTimeStamp(long value) {
        this.timeStamp = value;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public InetAddress getRemoteInetAddress() {
        return this.getDatagramPacket().getAddress();
    }

    public String getRemoteAddress() {
        return this.getDatagramPacket().getAddress().getHostAddress();
    }

    public int getRemotePort() {
        return this.getDatagramPacket().getPort();
    }

    public byte[] getData() {
        if (this.packetBytes != null) {
            return this.packetBytes;
        }
        DatagramPacket packet = this.getDatagramPacket();
        int packetLen = packet.getLength();
        String packetData = new String(packet.getData(), 0, packetLen);
        this.packetBytes = packetData.getBytes();
        return this.packetBytes;
    }

    public String getHost() {
        return HTTPHeader.getValue(this.getData(), "HOST");
    }

    public String getCacheControl() {
        return HTTPHeader.getValue(this.getData(), "Cache-Control");
    }

    public String getLocation() {
        return HTTPHeader.getValue(this.getData(), "Location");
    }

    public String getMAN() {
        return HTTPHeader.getValue(this.getData(), "MAN");
    }

    public String getST() {
        return HTTPHeader.getValue(this.getData(), "ST");
    }

    public String getNT() {
        return HTTPHeader.getValue(this.getData(), "NT");
    }

    public String getNTS() {
        return HTTPHeader.getValue(this.getData(), "NTS");
    }

    public String getServer() {
        return HTTPHeader.getValue(this.getData(), "Server");
    }

    public String getUSN() {
        return HTTPHeader.getValue(this.getData(), "USN");
    }

    public int getMX() {
        return HTTPHeader.getIntegerValue(this.getData(), "MX");
    }

    public InetAddress getHostInetAddress() {
        String addrStr = "127.0.0.1";
        String host = this.getHost();
        int canmaIdx = host.lastIndexOf(":");
        if (0 <= canmaIdx) {
            addrStr = host.substring(0, canmaIdx);
            if (addrStr.charAt(0) == '[') {
                addrStr = addrStr.substring(1, addrStr.length());
            }
            if (addrStr.charAt(addrStr.length() - 1) == ']') {
                addrStr = addrStr.substring(0, addrStr.length() - 1);
            }
        }
        InetSocketAddress isockaddr = new InetSocketAddress(addrStr, 0);
        return isockaddr.getAddress();
    }

    public boolean isRootDevice() {
        if (NT.isRootDevice(this.getNT())) {
            return true;
        }
        if (ST.isRootDevice(this.getST())) {
            return true;
        }
        return USN.isRootDevice(this.getUSN());
    }

    public boolean isDiscover() {
        return MAN.isDiscover(this.getMAN());
    }

    public boolean isAlive() {
        return NTS.isAlive(this.getNTS());
    }

    public boolean isByeBye() {
        return NTS.isByeBye(this.getNTS());
    }

    public int getLeaseTime() {
        return SSDP.getLeaseTime(this.getCacheControl());
    }

    public String toString() {
        return new String(this.getData());
    }
}

