/*
 * Decompiled with CFR 0.152.
 */
package plugins.ThawIndexBrowser;

import com.db4o.ObjectContainer;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DatabaseDisabledException;
import freenet.clients.http.InfoboxNode;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.keys.FreenetURI;
import freenet.l10n.BaseL10n;
import freenet.node.fcp.FCPServer;
import freenet.node.fcp.NotAllowedException;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginHTTP;
import freenet.pluginmanager.FredPluginL10n;
import freenet.pluginmanager.FredPluginRealVersioned;
import freenet.pluginmanager.FredPluginThreadless;
import freenet.pluginmanager.FredPluginVersioned;
import freenet.pluginmanager.PluginHTTPException;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.HTTPRequest;
import freenet.support.io.NativeThread;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.Enumeration;
import plugins.ThawIndexBrowser.Version;
import plugins.ThawIndexBrowser.nanoxml.XMLElement;
import plugins.ThawIndexBrowser.nanoxml.XMLParseException;

public class ThawIndexBrowser
implements FredPlugin,
FredPluginThreadless,
FredPluginHTTP,
FredPluginVersioned,
FredPluginRealVersioned,
FredPluginL10n {
    public static String SELF_URI = "/plugins/plugins.ThawIndexBrowser.ThawIndexBrowser/";
    private PluginRespirator pr;
    private PageMaker pm;
    private HighLevelSimpleClient client;
    private FCPServer fcp;

    public void runPlugin(PluginRespirator pr2) {
        Logger.error((Object)this, (String)"Start");
        this.pr = pr2;
        this.pm = this.pr.getPageMaker();
        this.client = this.pr.getHLSimpleClient();
        this.fcp = this.pr.getNode().clientCore.getFCPServer();
    }

    public void terminate() {
    }

    private HTMLNode createErrorBox(String title, String errmsg) {
        InfoboxNode infobox = this.pm.getInfobox("infobox-alert", title);
        HTMLNode errorBox = infobox.content;
        errorBox.addChild("#", errmsg);
        return infobox.outer;
    }

    public String handleHTTPGet(HTTPRequest request) throws PluginHTTPException {
        String uri = request.getParam("key");
        if (uri.trim().length() == 0) {
            return this.makeUriPage();
        }
        return this.makeIndexPage(uri, false);
    }

    public String handleHTTPPost(HTTPRequest request) throws PluginHTTPException {
        String pass = request.getPartAsString("formPassword", 32);
        if (pass.length() == 0 || !pass.equals(this.pr.getNode().clientCore.formPassword)) {
            return this.makeErrorPage("Buh! Invalid form password");
        }
        String uri = request.getPartAsString("key", 1024);
        if (uri.trim().length() == 0) {
            return this.makeUriPage();
        }
        if (request.getPartAsString("add", 128).length() > 0) {
            String downloadkey = request.getPartAsString("uri", 1024);
            try {
                this.tryAddToQueue(new FreenetURI(downloadkey));
            }
            catch (MalformedURLException e) {
                Logger.error((Object)this, (String)"TODO", (Throwable)e);
            }
            return this.makeIndexPage(uri, false);
        }
        return this.makeIndexPage(uri, request.getPartAsString("addall", 128).length() > 0);
    }

    private String makeUriPage() {
        PageNode page = this.getPageNode();
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        contentNode.addChild(this.createUriBox());
        return pageNode.generate();
    }

    private String makeErrorPage(String error) {
        return this.makeErrorPage("ERROR", error);
    }

    private String makeErrorPage(String title, String error) {
        PageNode page = this.getPageNode();
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        contentNode.addChild(this.createErrorBox(title, error));
        contentNode.addChild(this.createUriBox());
        return pageNode.generate();
    }

    private String makeErrorPage(String title, String error, String newUri) {
        PageNode page = this.getPageNode();
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode errorBox = this.createErrorBox(title, error);
        errorBox.addChild("BR");
        errorBox.addChild(new HTMLNode("a", "href", SELF_URI + "?key=" + newUri, newUri));
        contentNode.addChild(errorBox);
        contentNode.addChild(this.createUriBox());
        return pageNode.generate();
    }

    private PageNode getPageNode() {
        return this.pm.getPageNode("Thaw-Index Browser", null);
    }

    private String makeIndexPage(String index, boolean add) {
        try {
            FreenetURI uri = new FreenetURI(index);
            FetchResult content = this.client.fetch(uri, 90000L);
            String mime = content.getMimeType();
            if (!"application/x-freenet-index".equals(mime)) {
                return this.makeErrorPage("Wrong mime type: " + mime, "Expected mime type \"application/x-freenet-index\", but found \"" + mime + "\".");
            }
            XMLElement xmldoc = new XMLElement();
            xmldoc.parseFromReader(new InputStreamReader(content.asBucket().getInputStream()));
            return this.printIndexPage(uri, xmldoc, add);
        }
        catch (MalformedURLException e) {
            Logger.error((Object)this, (String)("Invalid URI: " + index), (Throwable)e);
            return this.makeErrorPage("Invalid URI: " + index, "The given freenet key is invalid");
        }
        catch (FetchException e) {
            Logger.error((Object)this, (String)("Fetch failed for: " + index), (Throwable)e);
            switch (e.mode) {
                case 11: 
                case 27: {
                    return this.makeErrorPage("Fetch failed for: " + index, "(Code: " + e.mode + ") " + e.getLocalizedMessage(), e.newURI.toString());
                }
                case 13: 
                case 14: 
                case 15: 
                case 28: {
                    return this.makeErrorPage("Fetch failed for: " + index, "(Code: " + e.mode + ") " + e.getLocalizedMessage(), index);
                }
            }
            return this.makeErrorPage("Fetch failed for: " + index, "(Code: " + e.mode + ") " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            Logger.error((Object)this, (String)"IOError", (Throwable)e);
            return this.makeErrorPage("IOError", "IOError while processing " + index + ": " + e.getLocalizedMessage());
        }
        catch (XMLParseException e) {
            Logger.error((Object)this, (String)"DEBUG", (Throwable)e);
            return this.makeErrorPage("Parser error", "Error while processing " + index + ": " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            Logger.error((Object)this, (String)"DEBUG", (Throwable)e);
            return this.makeErrorPage("Error while processing " + index + ": " + e.getLocalizedMessage());
        }
    }

    private HTMLNode createUriBox() {
        InfoboxNode infobox = this.pm.getInfobox("Open an Index");
        HTMLNode browseBox = infobox.outer;
        HTMLNode browseContent = infobox.content;
        HTMLNode browseForm = this.pr.addFormChild(browseContent, SELF_URI, "uriForm");
        browseForm.addChild("#", "Index to explore: \u00a0 ");
        browseForm.addChild("input", new String[]{"type", "name", "size"}, new String[]{"text", "key", "70"});
        browseForm.addChild("#", "\u00a0");
        browseForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "debug", "Explore!"});
        return browseBox;
    }

    private String printIndexPage(FreenetURI uri, XMLElement doc, boolean add) {
        PageNode page = this.getPageNode();
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        XMLElement root = doc;
        InfoboxNode title = this.pm.getInfobox("Index: " + uri);
        HTMLNode titleBox = title.content;
        InfoboxNode index = this.pm.getInfobox("Index: " + uri);
        HTMLNode indexBox = index.content;
        InfoboxNode fileInfobox = this.pm.getInfobox("Files:");
        HTMLNode fileBox = fileInfobox.content;
        HTMLNode table = new HTMLNode("table", "class", "requests");
        HTMLNode headerRow = table.addChild("tr", "class", "table-header");
        headerRow.addChild("th");
        headerRow.addChild("th", "Key/Name");
        headerRow.addChild("th", "Mimetype");
        headerRow.addChild("th", "Size");
        boolean hasfiles = false;
        Enumeration<XMLElement> rootchilds = root.enumerateChildren();
        while (rootchilds.hasMoreElements()) {
            XMLElement rc = rootchilds.nextElement();
            String name = rc.getName();
            if ("header".equals(name)) {
                Enumeration<XMLElement> headerchilds = rc.enumerateChildren();
                String titel = null;
                String clientname = null;
                String date = null;
                String category = null;
                while (headerchilds.hasMoreElements()) {
                    XMLElement he = headerchilds.nextElement();
                    String hename = he.getName();
                    if ("title".equals(hename)) {
                        titel = he.getContent();
                        continue;
                    }
                    if ("client".equals(hename)) {
                        clientname = he.getContent();
                        continue;
                    }
                    if ("date".equals(hename)) {
                        date = he.getContent();
                        continue;
                    }
                    if ("category".equals(hename)) {
                        category = he.getContent();
                        continue;
                    }
                    Logger.error((Object)this, (String)("Unexpected xml element '" + hename + "' at line: " + rc.getLineNr()), (Throwable)new Error("DEBUG"));
                }
                if (titel != null) {
                    titleBox.addChild("#", "Titel: \u00a0 " + titel);
                    titleBox.addChild("BR");
                }
                if (clientname != null) {
                    titleBox.addChild("#", "Client: \u00a0 " + clientname);
                    titleBox.addChild("BR");
                }
                if (date != null) {
                    titleBox.addChild("#", "Date: \u00a0 " + date);
                    titleBox.addChild("BR");
                }
                if (category == null) continue;
                titleBox.addChild("#", "Category: \u00a0 " + category);
                titleBox.addChild("BR");
                continue;
            }
            if ("indexes".equals(name)) {
                Enumeration<XMLElement> indexchilds = rc.enumerateChildren();
                while (indexchilds.hasMoreElements()) {
                    XMLElement ie = indexchilds.nextElement();
                    indexBox.addChild(new HTMLNode("a", "href", SELF_URI + "?key=" + ie.getStringAttribute("key"), ie.getStringAttribute("key")));
                    indexBox.addChild("BR");
                }
                continue;
            }
            if ("files".equals(name)) {
                Enumeration<XMLElement> filechilds = rc.enumerateChildren();
                boolean bl = hasfiles = rc.countChildren() > 0;
                while (filechilds.hasMoreElements()) {
                    XMLElement fe = filechilds.nextElement();
                    HTMLNode fileRow = table.addChild("tr");
                    String s = fe.getStringAttribute("key");
                    try {
                        String s1;
                        FreenetURI u = new FreenetURI(s);
                        if (add) {
                            this.tryAddToQueue(u);
                        }
                        if (s.length() > 100) {
                            s1 = s.substring(0, 12);
                            s1 = s1 + "...";
                            s1 = s1 + s.substring(85);
                        } else {
                            s1 = s;
                        }
                        fileRow.addChild(this.createAddCell(s, uri.toString()));
                        fileRow.addChild(this.createCell(new HTMLNode("a", "href", "/?key=" + s, s1)));
                    }
                    catch (MalformedURLException e1) {
                        fileRow.addChild(new HTMLNode("td"));
                        fileRow.addChild(this.createCell(new HTMLNode("#", s)));
                    }
                    fileRow.addChild(this.createCell(new HTMLNode("#", fe.getStringAttribute("mime"))));
                    fileRow.addChild(this.createCell(new HTMLNode("#", fe.getStringAttribute("size"))));
                }
                HTMLNode allRow = table.addChild("tr");
                allRow.addChild(this.createAddAllCell(uri.toString()));
                fileBox.addChild(table);
                continue;
            }
            if ("comments".equals(name)) continue;
            Logger.error((Object)this, (String)("Unexpected xml element '" + name + "' at line: " + rc.getLineNr()), (Throwable)new Error("DEBUG"));
        }
        contentNode.addChild(title.outer);
        contentNode.addChild(index.outer);
        if (hasfiles) {
            contentNode.addChild(fileInfobox.outer);
        }
        contentNode.addChild(this.createUriBox());
        return pageNode.generate();
    }

    private void tryAddToQueue(final FreenetURI fetchURI) {
        try {
            this.pr.getNode().clientCore.clientContext.jobRunner.queue(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    try {
                        ThawIndexBrowser.this.fcp.makePersistentGlobalRequest(fetchURI, false, null, "forever", "disk", false, container, ((ThawIndexBrowser)ThawIndexBrowser.this).pr.getNode().clientCore.getDownloadsDir());
                    }
                    catch (NotAllowedException e) {
                        Logger.normal((Object)this, (String)("Failed to make persistent request: " + (Object)((Object)e)), (Throwable)e);
                    }
                    catch (IOException e) {
                        Logger.normal((Object)this, (String)("Failed to make persistent request: " + e), (Throwable)e);
                    }
                    catch (Throwable t) {
                        Logger.error((Object)this, (String)("Failed to make persistent request: " + t), (Throwable)t);
                    }
                    return true;
                }
            }, NativeThread.HIGH_PRIORITY, false);
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
    }

    private HTMLNode createAddCell(String key, String uri) {
        HTMLNode deleteNode = new HTMLNode("td");
        HTMLNode deleteForm = this.pr.addFormChild(deleteNode, SELF_URI, "addForm-" + key.hashCode());
        deleteForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "uri", key});
        deleteForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", uri});
        deleteForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "add", "Download"});
        return deleteNode;
    }

    private HTMLNode createAddAllCell(String uri) {
        HTMLNode deleteNode = new HTMLNode("td");
        HTMLNode deleteForm = this.pr.addFormChild(deleteNode, SELF_URI, "addForm-all");
        deleteForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", uri});
        deleteForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "addall", "Download all"});
        return deleteNode;
    }

    private HTMLNode createCell(HTMLNode node) {
        HTMLNode cell = new HTMLNode("td");
        cell.addChild(node);
        return cell;
    }

    public String getVersion() {
        return "0.1 r" + Version.getSvnRevision();
    }

    public long getRealVersion() {
        return Version.getVersion();
    }

    public static void main(String[] args) {
        ThawIndexBrowser tib = new ThawIndexBrowser();
        System.out.println("=====");
        System.out.println(tib.getVersion());
        System.out.println("=====");
    }

    public String getString(String key) {
        return key;
    }

    public void setLanguage(BaseL10n.LANGUAGE newLanguage) {
    }
}

