/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.util.io.spikes;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.io.IoAdapter;
import com.db4o.util.io.NIOFileAdapter;
import com.db4o.util.io.spikes.TestDummy;
import com.db4o.util.io.win32.Win32IoAdapter;
import java.io.File;

public class SimpleIoBenchmark {
    private static final String DBFILENAME = "SimpleIoBenchmark.yap";
    private static final int ITERATIONS = 10000;

    public static void main(String[] args) {
        for (int i = 0; i < 3; ++i) {
            System.out.println("*******************");
            SimpleIoBenchmark.test("Default IO adapter", null);
            SimpleIoBenchmark.test("NIOFileadapter", new NIOFileAdapter(32768, 16));
            SimpleIoBenchmark.test("Win32IoAdapter", new Win32IoAdapter());
        }
    }

    private static void test(String name, IoAdapter adapter) {
        if (null != adapter) {
            Db4o.configure().io(adapter);
        }
        long start = System.currentTimeMillis();
        SimpleIoBenchmark.store();
        SimpleIoBenchmark.query();
        long elapsed = System.currentTimeMillis() - start;
        System.gc();
        System.out.println(name);
        System.out.println("\t" + elapsed + "ms");
        File file = new File(DBFILENAME);
        System.out.println("\tFile size is " + file.length() + " bytes.");
        System.out.println("\t" + file.length() / elapsed + " bytes/ms");
        if (!file.delete()) {
            System.err.println("Unable to delete 'SimpleIoBenchmark.yap'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void query() {
        ObjectContainer db = Db4o.openFile(DBFILENAME);
        try {
            ObjectSet set = db.queryByExample(TestDummy.class);
            if (10000 != set.size()) {
                System.err.println("Expected: 10000, actual: " + set.size());
            }
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void store() {
        ObjectContainer db = Db4o.openFile(DBFILENAME);
        try {
            for (int i = 0; i < 10000; ++i) {
                db.store(new TestDummy("Dummy " + i));
                if (0 != i % 10) continue;
                db.commit();
            }
        }
        finally {
            db.close();
        }
    }
}

