/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.IdentifierCollisionMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.SubscribeUSK;
import freenet.clients.fcp.SubscribedUSKMessage;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;
import java.net.MalformedURLException;

public class SubscribeUSKMessage
extends FCPMessage {
    public static final String NAME = "SubscribeUSK";
    final USK key;
    final boolean dontPoll;
    final String identifier;
    final short prio;
    final short prioProgress;
    final boolean realTimeFlag;
    final boolean sparsePoll;
    final boolean ignoreUSKDatehints;

    public SubscribeUSKMessage(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "No Identifier!", null, false);
        }
        String suri = fs.get("URI");
        if (suri == null) {
            throw new MessageInvalidException(5, "Expected a URI on SubscribeUSK", this.identifier, false);
        }
        try {
            FreenetURI uri = new FreenetURI(suri);
            this.key = USK.create(uri);
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(8, "Could not parse URI: " + e, this.identifier, false);
        }
        this.dontPoll = fs.getBoolean("DontPoll", false);
        this.sparsePoll = !this.dontPoll ? fs.getBoolean("SparsePoll", false) : false;
        this.prio = fs.getShort("PriorityClass", (short)4);
        this.prioProgress = fs.getShort("PriorityClassProgress", (short)Math.max(0, this.prio - 1));
        this.realTimeFlag = fs.getBoolean("RealTimeFlag", false);
        this.ignoreUSKDatehints = fs.getBoolean("IgnoreUSKDatehints", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("URI", this.key.getURI().toString());
        fs.put("DontPoll", this.dontPoll);
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        try {
            new SubscribeUSK(this, node.clientCore, handler);
        }
        catch (IdentifierCollisionException e) {
            handler.outputHandler.queue(new IdentifierCollisionMessage(this.identifier, false));
            return;
        }
        SubscribedUSKMessage reply = new SubscribedUSKMessage(this);
        handler.outputHandler.queue(reply);
    }
}

