/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.l10n.NodeL10n;
import freenet.node.AnnounceSender;
import freenet.node.AnnouncementCallback;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.PeerNode;
import freenet.node.PeerTooOldException;
import freenet.node.SeedServerPeerNode;
import freenet.node.useralerts.AbstractUserEvent;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.UserEvent;
import freenet.support.ByteArrayWrapper;
import freenet.support.HTMLNode;
import freenet.support.ListUtils;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.io.Closer;
import freenet.support.transport.ip.IPUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Announcer {
    private static boolean logMINOR;
    private final Node node;
    private final OpennetManager om;
    private static final int STATUS_LOADING = 0;
    private static final int STATUS_CONNECTING_SEEDNODES = 1;
    private static final int STATUS_NO_SEEDNODES = -1;
    private int runningAnnouncements;
    private static final int WANT_ANNOUNCEMENTS = 5;
    private int sentAnnouncements;
    private long startTime;
    private long timeAddedSeeds;
    private static final long MIN_ADDED_SEEDS_INTERVAL;
    static final long COOLING_OFF_PERIOD;
    private final HashSet<ByteArrayWrapper> announcedToIdentities;
    private final HashSet<InetAddress> announcedToIPs;
    private static final int CONNECT_AT_ONCE = 15;
    private static final int MIN_OPENNET_CONNECTED_PEERS = 10;
    private static final long NOT_ALL_CONNECTED_DELAY;
    public static final String SEEDNODES_FILENAME = "seednodes.fref";
    private static final long RETRY_MISSING_SEEDNODES_DELAY;
    private int announcementAddedNodes;
    private int announcementNotWantedNodes;
    private long timeGotEnoughPeers = -1L;
    private final Object timeGotEnoughPeersLock = new Object();
    private boolean killedAnnouncementTooOld;
    private SimpleUserAlert announcementDisabledAlert = new SimpleUserAlert(false, this.l10n("announceDisabledTooOldTitle"), this.l10n("announceDisabledTooOld"), this.l10n("announceDisabledTooOldShort"), 0){

        @Override
        public HTMLNode getHTMLText() {
            HTMLNode div = new HTMLNode("div");
            div.addChild("#", Announcer.this.l10n("announceDisabledTooOld"));
            if (!((Announcer)Announcer.this).node.nodeUpdater.isEnabled()) {
                div.addChild("#", " ");
                NodeL10n.getBase().addL10nSubstitution(div, "Announcer.announceDisabledTooOldUpdateDisabled", new String[]{"config"}, new HTMLNode[]{HTMLNode.link("/config/node.updater")});
            }
            return div;
        }

        @Override
        public String getText() {
            StringBuilder sb = new StringBuilder();
            sb.append(Announcer.this.l10n("announceDisabledTooOld"));
            sb.append(" ");
            if (!((Announcer)Announcer.this).node.nodeUpdater.isEnabled()) {
                sb.append(Announcer.this.l10n("announceDisabledTooOldUpdateDisabled", new String[]{"config", "/config"}, new String[]{"", ""}));
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isValid() {
            if (((Announcer)Announcer.this).node.nodeUpdater.isEnabled()) {
                return false;
            }
            Announcer announcer = Announcer.this;
            synchronized (announcer) {
                return Announcer.this.killedAnnouncementTooOld;
            }
        }
    };
    private static final long FINAL_DELAY;
    static final long RETRY_DELAY;
    private boolean started = false;
    private final Runnable checker = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int running;
            Announcer announcer = Announcer.this;
            synchronized (announcer) {
                running = Announcer.this.runningAnnouncements;
            }
            if (Announcer.this.enoughPeers()) {
                for (SeedServerPeerNode pn : ((Announcer)Announcer.this).node.peers.getConnectedSeedServerPeersVector(null)) {
                    ((Announcer)Announcer.this).node.peers.disconnectAndRemove(pn, true, true, false);
                }
                Announcer.this.node.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        Announcer.this.maybeSendAnnouncement();
                    }
                }, "Check whether we need to announce", RETRY_DELAY, false, true);
            } else {
                Announcer.this.node.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        Announcer.this.maybeSendAnnouncement();
                    }
                }, "Check whether we need to announce", RETRY_DELAY, false, true);
                if (running != 0) {
                    Announcer.this.maybeSendAnnouncement();
                }
            }
        }
    };

    Announcer(OpennetManager om) {
        this.om = om;
        this.node = om.node;
        this.announcedToIdentities = new HashSet();
        this.announcedToIPs = new HashSet();
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        int oldOpenPeers;
        int openPeers;
        if (!this.node.isOpennetEnabled()) {
            return;
        }
        int darkPeers = this.node.peers.getDarknetPeers().length;
        if (darkPeers + (openPeers = this.node.peers.getOpennetPeers().length) + (oldOpenPeers = this.om.countOldOpennetPeers()) == 0) {
            System.err.println("Attempting announcement to seednodes...");
            Announcer announcer = this;
            synchronized (announcer) {
                this.registerEvent(0);
                this.started = true;
            }
            this.connectSomeSeednodes();
        } else {
            System.out.println("Not attempting immediate announcement: dark peers=" + darkPeers + " open peers=" + openPeers + " old open peers=" + oldOpenPeers + " - will wait 1 minute...");
            this.node.getTicker().queueTimedJob(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Announcer announcer = Announcer.this;
                    synchronized (announcer) {
                        Announcer.this.started = true;
                    }
                    try {
                        Announcer.this.maybeSendAnnouncement();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t + " trying to send announcements", t);
                    }
                }
            }, MIN_ADDED_SEEDS_INTERVAL);
        }
    }

    private void registerEvent(int eventStatus) {
        this.node.clientCore.alerts.register(new AnnouncementUserEvent(eventStatus));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectSomeSeednodes() {
        if (!this.node.isOpennetEnabled()) {
            return;
        }
        boolean announceNow = false;
        if (logMINOR) {
            Logger.minor(this, "Connecting some seednodes...");
        }
        List<SimpleFieldSet> seeds = Announcer.readSeednodes(this.node.nodeDir().file(SEEDNODES_FILENAME));
        System.out.println("Trying to connect to " + seeds.size() + " seednodes...");
        long now = System.currentTimeMillis();
        Announcer announcer = this;
        synchronized (announcer) {
            if (now - this.timeAddedSeeds < MIN_ADDED_SEEDS_INTERVAL) {
                return;
            }
            this.timeAddedSeeds = now;
            if (seeds.size() == 0) {
                this.registerEvent(-1);
                this.node.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        Announcer.this.maybeSendAnnouncement();
                    }
                }, RETRY_MISSING_SEEDNODES_DELAY);
                return;
            }
            this.registerEvent(1);
        }
        int count = this.connectSomeNodesInner(seeds);
        boolean stillConnecting = false;
        List<SeedServerPeerNode> tryingSeeds = this.node.peers.getSeedServerPeersVector();
        Announcer announcer2 = this;
        synchronized (announcer2) {
            for (SeedServerPeerNode seed : tryingSeeds) {
                if (this.announcedToIdentities.contains(new ByteArrayWrapper(seed.peerECDSAPubKeyHash))) continue;
                stillConnecting = true;
                break;
            }
            if (logMINOR) {
                Logger.minor(this, "count = " + count + " announced = " + this.announcedToIdentities.size() + " running = " + this.runningAnnouncements + " still connecting " + stillConnecting);
            }
            if (count == 0 && this.runningAnnouncements == 0) {
                if (stillConnecting) {
                    if (logMINOR) {
                        Logger.minor(this, "Will clear announced-to in 1 minute...");
                    }
                    this.node.getTicker().queueTimedJob(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (logMINOR) {
                                Logger.minor(this, "Clearing old announced-to list");
                            }
                            Announcer announcer = Announcer.this;
                            synchronized (announcer) {
                                if (Announcer.this.runningAnnouncements != 0) {
                                    return;
                                }
                                Announcer.this.announcedToIdentities.clear();
                                Announcer.this.announcedToIPs.clear();
                            }
                            Announcer.this.maybeSendAnnouncement();
                        }
                    }, NOT_ALL_CONNECTED_DELAY);
                } else {
                    this.announcedToIdentities.clear();
                    this.announcedToIPs.clear();
                    announceNow = true;
                }
            }
        }
        this.node.dnsr.forceRun();
        this.node.getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                try {
                    Announcer.this.maybeSendAnnouncement();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " trying to send announcements", t);
                }
            }
        }, announceNow ? 0L : MIN_ADDED_SEEDS_INTERVAL);
    }

    private synchronized int connectSomeNodesInner(List<SimpleFieldSet> seeds) {
        if (logMINOR) {
            Logger.minor(this, "Connecting some seednodes from " + seeds.size());
        }
        int count = 0;
        while (count < 15 && !seeds.isEmpty()) {
            SimpleFieldSet fs = ListUtils.removeRandomBySwapLastSimple(this.node.random, seeds);
            try {
                SeedServerPeerNode seed = new SeedServerPeerNode(fs, this.node, this.om.crypto, false);
                if (this.node.wantAnonAuth(true) && Arrays.equals(this.node.getOpennetPubKeyHash(), seed.peerECDSAPubKeyHash)) {
                    if (!logMINOR) continue;
                    Logger.minor("Not adding: I am a seednode attempting to connect to myself!", seed.userToString());
                    continue;
                }
                if (this.announcedToIdentities.contains(new ByteArrayWrapper(seed.peerECDSAPubKeyHash))) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not adding: already announced-to: " + seed.userToString());
                    continue;
                }
                if (logMINOR) {
                    Logger.minor(this, "Trying to connect to seednode " + seed);
                }
                if (this.node.peers.addPeer(seed)) {
                    ++count;
                    if (!logMINOR) continue;
                    Logger.minor(this, "Connecting to seednode " + seed);
                    continue;
                }
                if (!logMINOR) continue;
                Logger.minor(this, "Not connecting to seednode " + seed);
            }
            catch (FSParseException e) {
                Logger.error(this, "Invalid seed in file: " + e + " for\n" + fs, (Throwable)e);
            }
            catch (PeerParseException e) {
                Logger.error(this, "Invalid seed in file: " + e + " for\n" + fs, (Throwable)e);
            }
            catch (ReferenceSignatureVerificationException e) {
                Logger.error(this, "Invalid seed in file: " + e + " for\n" + fs, (Throwable)e);
            }
            catch (PeerTooOldException e) {
                Logger.error(this, "Invalid seed in file: " + e + " for\n" + fs, (Throwable)e);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "connectSomeNodesInner() returning " + count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SimpleFieldSet> readSeednodes(File file) {
        ArrayList<SimpleFieldSet> list = new ArrayList<SimpleFieldSet>();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            InputStreamReader isr = new InputStreamReader((InputStream)bis, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            try {
                while (true) {
                    SimpleFieldSet fs;
                    if ((fs = new SimpleFieldSet(br, false, false, true, false)).isEmpty()) {
                        continue;
                    }
                    list.add(fs);
                }
            }
            catch (EOFException e) {
                ArrayList<SimpleFieldSet> arrayList = list;
                Closer.close(fis);
                return arrayList;
            }
        }
        catch (IOException e) {
            ArrayList<SimpleFieldSet> arrayList;
            try {
                arrayList = list;
            }
            catch (Throwable throwable) {
                Closer.close(fis);
                throw throwable;
            }
            Closer.close(fis);
            return arrayList;
        }
    }

    protected void stop() {
    }

    public int getAnnouncementThreshold() {
        int target = Math.min(10, this.om.getNumberOfConnectedPeersToAimIncludingDarknet() / 2);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enoughPeers() {
        Object object;
        int target;
        if (this.om.stopping()) {
            return true;
        }
        int opennetCount = this.node.peers.countConnectedPeers();
        if (opennetCount >= (target = this.getAnnouncementThreshold())) {
            if (logMINOR) {
                Logger.minor(this, "We have enough opennet peers: " + opennetCount + " > " + target + " since " + (System.currentTimeMillis() - this.timeGotEnoughPeers) + " ms");
            }
            Object object2 = this.timeGotEnoughPeersLock;
            synchronized (object2) {
                if (this.timeGotEnoughPeers <= 0L) {
                    this.timeGotEnoughPeers = System.currentTimeMillis();
                }
            }
            return true;
        }
        boolean killAnnouncement = false;
        if (!this.node.nodeUpdater.isEnabled() || this.node.nodeUpdater.canUpdateNow() && !this.node.nodeUpdater.isArmed()) {
            object = this;
            synchronized (object) {
                if (this.killedAnnouncementTooOld) {
                    return true;
                }
            }
            if (this.node.peers.getPeerNodeStatusSize(3, false) > 10) {
                object = this;
                synchronized (object) {
                    if (this.killedAnnouncementTooOld) {
                        return true;
                    }
                    this.killedAnnouncementTooOld = true;
                    killAnnouncement = true;
                }
                Logger.error(this, "Shutting down announcement as we are older than the current mandatory build and auto-update is disabled or waiting for user input.");
                System.err.println("Shutting down announcement as we are older than the current mandatory build and auto-update is disabled or waiting for user input.");
                if (this.node.clientCore != null) {
                    this.node.clientCore.alerts.register(this.announcementDisabledAlert);
                }
            }
        }
        if (killAnnouncement) {
            this.node.executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (OpennetPeerNode pn : ((Announcer)Announcer.this).node.peers.getOpennetPeers()) {
                        ((Announcer)Announcer.this).node.peers.disconnectAndRemove(pn, true, true, true);
                    }
                    for (SeedServerPeerNode pn : ((Announcer)Announcer.this).node.peers.getSeedServerPeersVector()) {
                        ((Announcer)Announcer.this).node.peers.disconnectAndRemove(pn, true, true, true);
                    }
                }
            });
            return true;
        }
        object = this;
        synchronized (object) {
            this.killedAnnouncementTooOld = false;
        }
        if (this.node.clientCore != null) {
            this.node.clientCore.alerts.unregister(this.announcementDisabledAlert);
        }
        if (this.node.nodeUpdater.isEnabled() && this.node.nodeUpdater.isArmed() && this.node.nodeUpdater.uom.fetchingFromTwo() && this.node.peers.getPeerNodeStatusSize(3, false) > 5) {
            return true;
        }
        object = this.timeGotEnoughPeersLock;
        synchronized (object) {
            this.timeGotEnoughPeers = -1L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long timeGotEnoughPeers() {
        Object object = this.timeGotEnoughPeersLock;
        synchronized (object) {
            return this.timeGotEnoughPeers;
        }
    }

    public void maybeSendAnnouncementOffThread() {
        if (this.enoughPeers()) {
            return;
        }
        this.node.getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                Announcer.this.maybeSendAnnouncement();
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeSendAnnouncement() {
        Announcer announcer = this;
        synchronized (announcer) {
            if (!this.started) {
                return;
            }
        }
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        if (logMINOR) {
            Logger.minor(this, "maybeSendAnnouncement()");
        }
        long now = System.currentTimeMillis();
        if (!this.node.isOpennetEnabled()) {
            return;
        }
        if (this.enoughPeers()) {
            this.node.getTicker().queueTimedJob(this.checker, "Announcement checker", FINAL_DELAY, false, true);
            return;
        }
        Announcer announcer2 = this;
        synchronized (announcer2) {
            if (this.enoughPeers()) {
                this.node.getTicker().queueTimedJob(this.checker, "Announcement checker", FINAL_DELAY, false, true);
                return;
            }
            if (this.runningAnnouncements > 5) {
                if (logMINOR) {
                    Logger.minor(this, "Running announcements already");
                }
                return;
            }
            if (System.currentTimeMillis() < this.startTime) {
                if (logMINOR) {
                    Logger.minor(this, "In cooling-off period for next " + TimeUtil.formatTime(this.startTime - System.currentTimeMillis()));
                }
                return;
            }
            if (this.sentAnnouncements >= 5) {
                if (logMINOR) {
                    Logger.minor(this, "Sent enough announcements");
                }
                return;
            }
            List<SeedServerPeerNode> seeds = this.node.peers.getConnectedSeedServerPeersVector(this.announcedToIdentities);
            while (this.sentAnnouncements < 5) {
                if (seeds.isEmpty()) {
                    if (!logMINOR) break;
                    Logger.minor(this, "No more seednodes, announcedTo = " + this.announcedToIdentities.size());
                    break;
                }
                SeedServerPeerNode seed = ListUtils.removeRandomBySwapLastSimple(this.node.random, seeds);
                InetAddress[] addrs = seed.getInetAddresses();
                if (!this.newAnnouncedIPs(addrs)) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not announcing to " + seed + " because already used those IPs");
                    continue;
                }
                this.addAnnouncedIPs(addrs);
                if (!this.sendAnnouncement(seed)) continue;
                ++this.sentAnnouncements;
                ++this.runningAnnouncements;
                this.announcedToIdentities.add(new ByteArrayWrapper(seed.peerECDSAPubKeyHash));
            }
            if (this.runningAnnouncements >= 5) {
                if (logMINOR) {
                    Logger.minor(this, "Running " + this.runningAnnouncements + " announcements");
                }
                return;
            }
            if (now - this.timeAddedSeeds < MIN_ADDED_SEEDS_INTERVAL) {
                Logger.minor(this, "Waiting for MIN_ADDED_SEEDS_INTERVAL");
                this.node.getTicker().queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Announcer.this.maybeSendAnnouncement();
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Caught " + t + " trying to send announcements", t);
                        }
                    }
                }, this.timeAddedSeeds + MIN_ADDED_SEEDS_INTERVAL - now);
                return;
            }
        }
        this.connectSomeSeednodes();
    }

    private synchronized void addAnnouncedIPs(InetAddress[] addrs) {
        for (InetAddress addr : addrs) {
            this.announcedToIPs.add(addr);
        }
    }

    private synchronized boolean newAnnouncedIPs(InetAddress[] addrs) {
        boolean hasNonLocalAddresses = false;
        for (InetAddress addr : addrs) {
            if (!IPUtil.isValidAddress(addr, false)) continue;
            hasNonLocalAddresses = true;
            if (this.announcedToIPs.contains(addr)) continue;
            return true;
        }
        return !hasNonLocalAddresses;
    }

    protected boolean sendAnnouncement(final SeedServerPeerNode seed) {
        if (!this.node.isOpennetEnabled()) {
            if (logMINOR) {
                Logger.minor(this, "Not announcing to " + seed + " because opennet is disabled");
            }
            return false;
        }
        System.out.println("Announcement to " + seed.userToString() + " starting...");
        if (logMINOR) {
            Logger.minor(this, "Announcement to " + seed.userToString() + " starting...");
        }
        AnnounceSender sender = new AnnounceSender(this.node.getLocation(), this.om, this.node, new AnnouncementCallback(){
            private int totalAdded;
            private int totalNotWanted;
            private boolean acceptedSomewhere;

            @Override
            public synchronized void acceptedSomewhere() {
                this.acceptedSomewhere = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addedNode(PeerNode pn) {
                Announcer announcer = Announcer.this;
                synchronized (announcer) {
                    Announcer.this.announcementAddedNodes++;
                    ++this.totalAdded;
                }
                Logger.normal(this, "Announcement to " + seed.userToString() + " added node " + pn + " for a total of " + Announcer.this.announcementAddedNodes + " (" + this.totalAdded + " from this announcement)");
                System.out.println("Announcement to " + seed.userToString() + " added node " + pn.userToString() + '.');
            }

            @Override
            public void bogusNoderef(String reason) {
                Logger.normal(this, "Announcement to " + seed.userToString() + " got bogus noderef: " + reason, (Throwable)new Exception("debug"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed() {
                boolean announceNow = false;
                Announcer announcer = Announcer.this;
                synchronized (announcer) {
                    Announcer.this.runningAnnouncements--;
                    Logger.normal(this, "Announcement to " + seed.userToString() + " completed, now running " + Announcer.this.runningAnnouncements + " announcements");
                    if (Announcer.this.runningAnnouncements == 0 && Announcer.this.announcementAddedNodes > 0) {
                        Announcer.this.startTime = System.currentTimeMillis() + COOLING_OFF_PERIOD;
                        Announcer.this.sentAnnouncements = 0;
                        Announcer.this.node.getTicker().queueTimedJob(new Runnable(){

                            @Override
                            public void run() {
                                Announcer.this.maybeSendAnnouncement();
                            }
                        }, COOLING_OFF_PERIOD);
                    } else if (Announcer.this.runningAnnouncements == 0) {
                        Announcer.this.sentAnnouncements = 0;
                        announceNow = true;
                    }
                }
                ((Announcer)Announcer.this).node.peers.disconnectAndRemove(seed, true, false, false);
                int shallow = Announcer.this.node.maxHTL() - (this.totalAdded + this.totalNotWanted);
                if (this.acceptedSomewhere) {
                    System.out.println("Announcement to " + seed.userToString() + " completed (" + this.totalAdded + " added, " + this.totalNotWanted + " not wanted, " + shallow + " shallow)");
                } else {
                    System.out.println("Announcement to " + seed.userToString() + " not accepted (version " + seed.getVersionNumber() + ") .");
                }
                if (announceNow) {
                    Announcer.this.maybeSendAnnouncement();
                }
            }

            @Override
            public void nodeFailed(PeerNode pn, String reason) {
                Logger.normal(this, "Announcement to node " + pn.userToString() + " failed: " + reason);
            }

            @Override
            public void noMoreNodes() {
                Logger.normal(this, "Announcement to " + seed.userToString() + " ran out of nodes (route not found)");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void nodeNotWanted() {
                Announcer announcer = Announcer.this;
                synchronized (announcer) {
                    Announcer.this.announcementNotWantedNodes++;
                    ++this.totalNotWanted;
                }
                Logger.normal(this, "Announcement to " + seed.userToString() + " returned node not wanted for a total of " + Announcer.this.announcementNotWantedNodes + " (" + this.totalNotWanted + " from this announcement)");
            }

            @Override
            public void nodeNotAdded() {
                Logger.normal(this, "Announcement to " + seed.userToString() + " : node not wanted (maybe already have it, opennet just turned off, etc)");
            }

            @Override
            public void relayedNoderef() {
                Logger.error(this, "Announcement to " + seed.userToString() + " : RELAYED ?!?!?!");
            }
        }, seed);
        this.node.executor.execute(sender, "Announcer to " + seed);
        return true;
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("Announcer." + key);
    }

    protected String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("Announcer." + key, patterns, values);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("Announcer." + key, pattern, value);
    }

    public void reannounce() {
        System.out.println("Re-announcing...");
        this.maybeSendAnnouncementOffThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWaitingForUpdater() {
        Announcer announcer = this;
        synchronized (announcer) {
            return this.killedAnnouncementTooOld;
        }
    }

    static {
        MIN_ADDED_SEEDS_INTERVAL = TimeUnit.SECONDS.toMillis(60L);
        COOLING_OFF_PERIOD = TimeUnit.SECONDS.toMillis(30L);
        NOT_ALL_CONNECTED_DELAY = TimeUnit.SECONDS.toMillis(60L);
        RETRY_MISSING_SEEDNODES_DELAY = TimeUnit.SECONDS.toMillis(30L);
        FINAL_DELAY = TimeUnit.SECONDS.toMillis(60L);
        RETRY_DELAY = TimeUnit.SECONDS.toMillis(60L);
    }

    class AnnouncementUserEvent
    extends AbstractUserEvent {
        private final int status;

        public AnnouncementUserEvent(int status) {
            this.status = status;
        }

        @Override
        public String dismissButtonText() {
            return NodeL10n.getBase().getString("UserAlert.hide");
        }

        @Override
        public HTMLNode getHTMLText() {
            return new HTMLNode("#", this.getText());
        }

        @Override
        public short getPriorityClass() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getText() {
            StringBuilder sb = new StringBuilder();
            sb.append(Announcer.this.l10n("announceAlertIntro"));
            if (this.status == -1) {
                return Announcer.this.l10n("announceAlertNoSeednodes");
            }
            if (this.status == 0) {
                return Announcer.this.l10n("announceLoading");
            }
            if (((Announcer)Announcer.this).node.clientCore.isAdvancedModeEnabled()) {
                int runningAnnouncements;
                int recentSentAnnouncements;
                int refusedNodes;
                int addedNodes;
                sb.append(' ');
                int connectedSeednodes = 0;
                int disconnectedSeednodes = 0;
                long coolingOffSeconds = Math.max(0L, Announcer.this.startTime - System.currentTimeMillis()) / 1000L;
                AnnouncementUserEvent announcementUserEvent = this;
                synchronized (announcementUserEvent) {
                    addedNodes = Announcer.this.announcementAddedNodes;
                    refusedNodes = Announcer.this.announcementNotWantedNodes;
                    recentSentAnnouncements = Announcer.this.sentAnnouncements;
                    runningAnnouncements = Announcer.this.runningAnnouncements;
                }
                List<SeedServerPeerNode> nodes = ((Announcer)Announcer.this).node.peers.getSeedServerPeersVector();
                for (SeedServerPeerNode seed : nodes) {
                    if (seed.isConnected()) {
                        ++connectedSeednodes;
                        continue;
                    }
                    ++disconnectedSeednodes;
                }
                sb.append(Announcer.this.l10n("announceDetails", new String[]{"addedNodes", "refusedNodes", "recentSentAnnouncements", "runningAnnouncements", "connectedSeednodes", "disconnectedSeednodes"}, new String[]{Integer.toString(addedNodes), Integer.toString(refusedNodes), Integer.toString(recentSentAnnouncements), Integer.toString(runningAnnouncements), Integer.toString(connectedSeednodes), Integer.toString(disconnectedSeednodes)}));
                if (coolingOffSeconds > 0L) {
                    sb.append(' ');
                    sb.append(Announcer.this.l10n("coolingOff", "time", Long.toString(coolingOffSeconds)));
                }
            }
            return sb.toString();
        }

        @Override
        public String getTitle() {
            return Announcer.this.l10n("announceAlertTitle");
        }

        @Override
        public boolean isValid() {
            return !Announcer.this.enoughPeers() && Announcer.this.node.isOpennetEnabled();
        }

        @Override
        public void isValid(boolean validity) {
        }

        @Override
        public void onDismiss() {
        }

        @Override
        public boolean shouldUnregisterOnDismiss() {
            return true;
        }

        @Override
        public boolean userCanDismiss() {
            return true;
        }

        @Override
        public String anchor() {
            return "announcer:" + this.hashCode();
        }

        @Override
        public String getShortText() {
            return Announcer.this.l10n("announceAlertShort");
        }

        @Override
        public boolean isEventNotification() {
            return false;
        }

        @Override
        public UserEvent.Type getEventType() {
            return UserEvent.Type.Announcer;
        }
    }
}

