/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.HTMLEntities;
import java.util.Map;

public class HTMLDecoder {
    static Map<String, Character> charTable = HTMLEntities.decodeMap;

    public static String decode(String s) {
        int maxPos = s.length();
        StringBuilder sb = new StringBuilder(maxPos);
        int curPos = 0;
        while (curPos < maxPos) {
            int tmpPos;
            char c;
            if ((c = s.charAt(curPos++)) == '&' && (tmpPos = curPos) < maxPos) {
                String t;
                char d;
                if ((d = s.charAt(tmpPos++)) == '#') {
                    if (tmpPos < maxPos) {
                        int i;
                        if ((d = s.charAt(tmpPos++)) == 'x' || d == 'X') {
                            if (tmpPos < maxPos && HTMLDecoder.isHexDigit(d = s.charAt(tmpPos++))) {
                                while (tmpPos < maxPos) {
                                    if (HTMLDecoder.isHexDigit(d = s.charAt(tmpPos++))) continue;
                                    if (d != ';') break;
                                    t = s.substring(curPos + 2, tmpPos - 1);
                                    try {
                                        i = Integer.parseInt(t, 16);
                                        if (i >= 0 && i < 65536) {
                                            c = (char)i;
                                            curPos = tmpPos;
                                        }
                                    }
                                    catch (NumberFormatException e) {}
                                    break;
                                }
                            }
                        } else if (HTMLDecoder.isDigit(d)) {
                            while (tmpPos < maxPos) {
                                if (HTMLDecoder.isDigit(d = s.charAt(tmpPos++))) continue;
                                if (d != ';') break;
                                t = s.substring(curPos + 1, tmpPos - 1);
                                try {
                                    i = Integer.parseInt(t);
                                    if (i >= 0 && i < 65536) {
                                        c = (char)i;
                                        curPos = tmpPos;
                                    }
                                }
                                catch (NumberFormatException e) {}
                                break;
                            }
                        }
                    }
                } else if (HTMLDecoder.isLetter(d)) {
                    while (tmpPos < maxPos) {
                        Character ch;
                        if (HTMLDecoder.isLetterOrDigit(d = s.charAt(tmpPos++))) continue;
                        if (d != ';' || (ch = charTable.get(t = s.substring(curPos, tmpPos - 1))) == null) break;
                        c = ch.charValue();
                        curPos = tmpPos;
                        break;
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isLetterOrDigit(char c) {
        return HTMLDecoder.isLetter(c) || HTMLDecoder.isDigit(c);
    }

    private static boolean isHexDigit(char c) {
        return HTMLDecoder.isHexLetter(c) || HTMLDecoder.isDigit(c);
    }

    private static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isHexLetter(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static String compact(String s) {
        int maxPos = s.length();
        StringBuilder sb = new StringBuilder(maxPos);
        int curPos = 0;
        while (curPos < maxPos) {
            int c;
            if (HTMLDecoder.isWhitespace((char)(c = s.charAt(curPos++)))) {
                while (curPos < maxPos && HTMLDecoder.isWhitespace(s.charAt(curPos))) {
                    ++curPos;
                }
                c = 32;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t' || ch == '\f' || ch == '\u200b';
    }
}

