/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class SerialExecutor
implements Executor {
    private static volatile boolean logMINOR;
    private final LinkedBlockingQueue<Runnable> jobs;
    private final Object syncLock;
    private final int priority;
    private volatile boolean threadWaiting;
    private volatile boolean threadStarted;
    private String name;
    private Executor realExecutor;
    private static final long NEWJOB_TIMEOUT;
    private Thread runningThread;
    private final Runnable runner = new PrioRunnable(){

        @Override
        public int getPriority() {
            return SerialExecutor.this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object e2;
            Object object = SerialExecutor.this.syncLock;
            synchronized (object) {
                SerialExecutor.this.runningThread = Thread.currentThread();
            }
            try {
                while (true) {
                    object = SerialExecutor.this.syncLock;
                    synchronized (object) {
                        SerialExecutor.this.threadWaiting = true;
                    }
                    Runnable job = null;
                    try {
                        job = (Runnable)SerialExecutor.this.jobs.poll(NEWJOB_TIMEOUT, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    e2 = SerialExecutor.this.syncLock;
                    synchronized (e2) {
                        SerialExecutor.this.threadWaiting = false;
                    }
                    if (job == null) {
                        e2 = SerialExecutor.this.syncLock;
                        synchronized (e2) {
                            SerialExecutor.this.threadStarted = false;
                        }
                        return;
                    }
                    try {
                        job.run();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t, t);
                        Logger.error(this, "While running " + job + " on " + this);
                    }
                }
            }
            finally {
                e2 = SerialExecutor.this.syncLock;
                synchronized (e2) {
                    SerialExecutor.this.runningThread = null;
                }
            }
        }
    };

    public SerialExecutor(int priority) {
        this(priority, 0);
    }

    public SerialExecutor(int priority, int bound) {
        this.jobs = bound > 0 ? new LinkedBlockingQueue(bound) : new LinkedBlockingQueue();
        this.priority = priority;
        this.syncLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Executor realExecutor, String name) {
        assert (realExecutor != this);
        this.realExecutor = realExecutor;
        this.name = name;
        Object object = this.syncLock;
        synchronized (object) {
            if (!this.jobs.isEmpty()) {
                this.reallyStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyStart() {
        Object object = this.syncLock;
        synchronized (object) {
            this.threadStarted = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Starting thread... " + this.name + " : " + this.runner);
        }
        this.realExecutor.execute(this.runner, this.name);
    }

    @Override
    public void execute(Runnable job) {
        this.execute(job, "<noname>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable job, String jobName) {
        if (logMINOR) {
            Logger.minor(this, "Running " + jobName + " : " + job + " started=" + this.threadStarted + " waiting=" + this.threadWaiting);
        }
        this.jobs.offer(job);
        Object object = this.syncLock;
        synchronized (object) {
            if (!this.threadStarted && this.realExecutor != null) {
                this.reallyStart();
            }
        }
    }

    @Override
    public void execute(Runnable job, String jobName, boolean fromTicker) {
        this.execute(job, jobName);
    }

    @Override
    public int[] runningThreads() {
        int[] retval = new int[10];
        if (this.threadStarted && !this.threadWaiting) {
            retval[this.priority] = 1;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] waitingThreads() {
        int[] retval = new int[10];
        Object object = this.syncLock;
        synchronized (object) {
            if (this.threadStarted && this.threadWaiting) {
                retval[this.priority] = 1;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWaitingThreadsCount() {
        Object object = this.syncLock;
        synchronized (object) {
            return this.threadStarted && this.threadWaiting ? 1 : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onThread() {
        Object object = this.syncLock;
        synchronized (object) {
            return Thread.currentThread() == this.runningThread;
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        NEWJOB_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    }
}

