/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.crypt.EncryptedRandomAccessBucket;
import freenet.crypt.MasterSecret;
import freenet.crypt.RandomSource;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.DelayedFree;
import freenet.support.io.DelayedFreeRandomAccessBucket;
import freenet.support.io.DiskSpaceChecker;
import freenet.support.io.FileUtil;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PaddedRandomAccessBucket;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.PersistentTempFileBucket;
import freenet.support.io.TempBucketFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

public class PersistentTempBucketFactory
implements BucketFactory,
PersistentFileTracker {
    private HashSet<File> originalFiles;
    public final FilenameGenerator fg;
    private transient RandomSource strongPRNG;
    private transient Random weakPRNG;
    private final ArrayList<DelayedFree> bucketsToFree;
    private final Object encryptLock = new Object();
    private boolean encrypt;
    private MasterSecret secret;
    private DiskSpaceChecker checker;
    private long commitID;
    static final int BLOB_SIZE = 32768;
    private static volatile boolean logMINOR;

    public PersistentTempBucketFactory(File dir, final String prefix, RandomSource strongPRNG, Random weakPRNG, boolean encrypt) throws IOException {
        File[] files;
        this.strongPRNG = strongPRNG;
        this.weakPRNG = weakPRNG;
        this.encrypt = encrypt;
        this.fg = new FilenameGenerator(weakPRNG, false, dir, prefix);
        if (!dir.exists()) {
            dir.mkdir();
            if (!dir.exists()) {
                throw new IOException("Directory does not exist and cannot be created: " + dir);
            }
        }
        if (!dir.isDirectory()) {
            throw new IOException("Directory is not a directory: " + dir);
        }
        this.originalFiles = new HashSet();
        for (File f : files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.exists() || pathname.isDirectory()) {
                    return false;
                }
                String name = pathname.getName();
                return name.startsWith(prefix);
            }
        })) {
            f = FileUtil.getCanonicalFile(f);
            if (logMINOR) {
                Logger.minor(this, "Found " + f);
            }
            this.originalFiles.add(f);
        }
        this.bucketsToFree = new ArrayList();
        this.commitID = 1L;
    }

    public void setDiskSpaceChecker(DiskSpaceChecker checker) {
        this.checker = checker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterSecret(MasterSecret secret) {
        Object object = this.encryptLock;
        synchronized (object) {
            this.secret = secret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(File file) {
        PersistentTempBucketFactory persistentTempBucketFactory = this;
        synchronized (persistentTempBucketFactory) {
            if (this.originalFiles == null) {
                throw new IllegalStateException("completed Init has already been called!");
            }
            file = FileUtil.getCanonicalFile(file);
            if (logMINOR) {
                Logger.minor(this, "Preserving " + file, (Throwable)new Exception("debug"));
            }
            if (!this.originalFiles.remove(file)) {
                Logger.error(this, "Preserving " + file + " but it wasn't found!", (Throwable)new Exception("error"));
            }
        }
    }

    public synchronized void completedInit() {
        if (this.originalFiles == null) {
            Logger.error(this, "Completed init called twice", (Throwable)new Exception("error"));
            return;
        }
        for (File f : this.originalFiles) {
            if (Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this)) {
                Logger.minor(this, "Deleting old tempfile " + f);
            }
            f.delete();
        }
        this.originalFiles = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomAccessBucket makeBucket(long size) throws IOException {
        RandomAccessBucket rawBucket = null;
        boolean mustWrap = true;
        if (rawBucket == null) {
            rawBucket = new PersistentTempFileBucket(this.fg.makeRandomFilename(), this.fg, this);
        }
        Object object = this.encryptLock;
        synchronized (object) {
            if (this.encrypt) {
                rawBucket = new PaddedRandomAccessBucket(rawBucket);
                rawBucket = new EncryptedRandomAccessBucket(TempBucketFactory.CRYPT_TYPE, rawBucket, this.secret);
            }
        }
        if (mustWrap) {
            rawBucket = new DelayedFreeRandomAccessBucket(this, rawBucket);
        }
        return rawBucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delayedFree(DelayedFree b, long createdCommitID) {
        PersistentTempBucketFactory persistentTempBucketFactory = this;
        synchronized (persistentTempBucketFactory) {
            if (createdCommitID != this.commitID) {
                this.bucketsToFree.add(b);
                return;
            }
        }
        b.realFree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelayedFree[] grabBucketsToFree() {
        PersistentTempBucketFactory persistentTempBucketFactory = this;
        synchronized (persistentTempBucketFactory) {
            if (this.bucketsToFree.isEmpty()) {
                return null;
            }
            DelayedFree[] buckets = this.bucketsToFree.toArray(new DelayedFree[this.bucketsToFree.size()]);
            this.bucketsToFree.clear();
            ++this.commitID;
            return buckets;
        }
    }

    @Override
    public synchronized long commitID() {
        return this.commitID;
    }

    @Override
    public File getDir() {
        return this.fg.getDir();
    }

    @Override
    public FilenameGenerator getGenerator() {
        return this.fg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEncrypting() {
        Object object = this.encryptLock;
        synchronized (object) {
            return this.encrypt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncryption(boolean encrypt) {
        Object object = this.encryptLock;
        synchronized (object) {
            this.encrypt = encrypt;
        }
    }

    public void finishDelayedFree(DelayedFree[] buckets) {
        if (buckets != null) {
            for (DelayedFree bucket : buckets) {
                try {
                    if (!bucket.toFree()) continue;
                    bucket.realFree();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " freeing bucket " + bucket + " after transaction commit", t);
                }
            }
        }
    }

    @Override
    public boolean checkDiskSpace(File file, int toWrite, int bufferSize) {
        return this.checker.checkDiskSpace(file, toWrite, bufferSize);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

