/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index;

import freenet.keys.FreenetURI;
import freenet.support.SortedIntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import plugins.Library.index.TermEntry;

public class TermPageEntry
extends TermEntry {
    public final FreenetURI page;
    public final Set<Integer> positions;
    public final Map<Integer, String> posFragments;
    public final String title;

    public TermPageEntry(String s, float r, FreenetURI u, Map<Integer, String> p) {
        this(s, r, u, null, p);
    }

    public TermPageEntry(String s, float r, FreenetURI u, String t, Map<Integer, String> p) {
        super(s, r);
        if (u == null) {
            throw new IllegalArgumentException("can't have a null page");
        }
        this.page = u.intern();
        String string = this.title = t == null ? null : t.intern();
        if (p == null) {
            this.posFragments = null;
            this.positions = null;
        } else {
            this.posFragments = Collections.unmodifiableMap(p);
            int[] pos = new int[p.size()];
            int x = 0;
            for (Integer i : p.keySet()) {
                pos[x++] = i;
            }
            Arrays.sort(pos);
            this.positions = new SortedIntSet(pos);
        }
    }

    public TermPageEntry(String s, float r, FreenetURI u, String t, Set<Integer> pos, Map<Integer, String> frags) {
        super(s, r);
        if (u == null) {
            throw new IllegalArgumentException("can't have a null page");
        }
        this.page = u.intern();
        this.title = t;
        if (pos != null) {
            if (pos instanceof SortedIntSet) {
                this.positions = (SortedIntSet)pos;
            } else {
                Integer[] p = pos.toArray(new Integer[pos.size()]);
                int[] pp = new int[p.length];
                for (int i = 0; i < pp.length; ++i) {
                    pp[i] = p[i];
                }
                if (!(pos instanceof SortedSet)) {
                    Arrays.sort(pp);
                }
                this.positions = new SortedIntSet(pp);
            }
        } else {
            this.positions = null;
        }
        if (frags != null) {
            boolean allNulls = true;
            for (String i : frags.values()) {
                if (i == null || i.equals("")) continue;
                allNulls = false;
                break;
            }
            this.posFragments = allNulls ? null : frags;
        } else {
            this.posFragments = null;
        }
    }

    public TermPageEntry(TermPageEntry t, float newRel) {
        super(t, newRel);
        this.page = t.page;
        this.posFragments = t.posFragments;
        this.positions = t.positions;
        this.title = t.title;
    }

    @Override
    public TermEntry.EntryType entryType() {
        assert (this.getClass() == TermPageEntry.class);
        return TermEntry.EntryType.PAGE;
    }

    @Override
    public int compareTo(TermEntry o) {
        int a = super.compareTo(o);
        if (a != 0) {
            return a;
        }
        return this.page.toString().compareTo(((TermPageEntry)o).page.toString());
    }

    @Override
    public boolean equals(Object o) {
        return o == this || super.equals(o) && this.page.equals((Object)((TermPageEntry)o).page);
    }

    @Override
    public boolean equalsTarget(TermEntry entry) {
        return entry == this || entry instanceof TermPageEntry && this.page.equals((Object)((TermPageEntry)entry).page);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.page.hashCode();
    }

    public boolean hasPositions() {
        return this.positions != null;
    }

    public Map<Integer, String> positionsMap() {
        if (this.positions == null) {
            return null;
        }
        if (this.posFragments != null) {
            return this.posFragments;
        }
        HashMap<Integer, String> ret = new HashMap<Integer, String>(this.positions.size());
        if (this.positions instanceof SortedIntSet) {
            int[] array;
            for (int x : array = ((SortedIntSet)this.positions).toArrayRaw()) {
                ret.put(x, null);
            }
            return ret;
        }
        Object[] array = this.positions.toArray(new Integer[this.positions.size()]);
        if (!(this.positions instanceof SortedSet)) {
            Arrays.sort(array);
        }
        Object[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int x = (Integer)arr$[i$];
            ret.put(x, null);
        }
        return ret;
    }

    public boolean hasPosition(int i) {
        return this.positions.contains(i);
    }

    public ArrayList<Integer> positions() {
        if (this.positions instanceof SortedIntSet) {
            int[] array = ((SortedIntSet)this.positions).toArrayRaw();
            ArrayList<Integer> pos = new ArrayList<Integer>(array.length);
            for (int x : array) {
                pos.add(x);
            }
            return pos;
        }
        Object[] array = this.positions.toArray(new Integer[this.positions.size()]);
        if (!(this.positions instanceof SortedSet)) {
            Arrays.sort(array);
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(this.positions.size());
        for (int i = 0; i < array.length; ++i) {
            ret.add((Integer)array[i]);
        }
        return ret;
    }

    public int[] positionsRaw() {
        if (this.positions instanceof SortedIntSet) {
            return ((SortedIntSet)this.positions).toArrayRaw();
        }
        int[] ret = new int[this.positions.size()];
        Integer[] r = new Integer[this.positions.size()];
        r = this.positions.toArray(r);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = r[i];
        }
        if (!(this.positions instanceof SortedSet)) {
            Arrays.sort(ret);
        }
        return ret;
    }

    public int positionsSize() {
        if (this.positions == null) {
            return 0;
        }
        return this.positions.size();
    }

    public boolean hasFragments() {
        return this.posFragments != null;
    }
}

