/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util.exec;

import java.util.Collections;
import plugins.Library.util.exec.CompositeProgress;
import plugins.Library.util.exec.Progress;
import plugins.Library.util.exec.ProgressParts;
import plugins.Library.util.exec.TaskAbortException;

public class BaseCompositeProgress
implements CompositeProgress {
    protected String subject = "??";
    protected Iterable<? extends Progress> subprogress = Collections.emptyList();
    protected int esttype = -2;

    public void setSubProgress(Iterable<? extends Progress> subs) {
        if (subs == null) {
            throw new IllegalArgumentException("Can't set a null progress iterable");
        }
        this.subprogress = subs;
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public void setEstimate(int est) {
        this.esttype = est;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getStatus() {
        try {
            return this.getParts().toString();
        }
        catch (TaskAbortException e) {
            assert (e.isError());
            return "Aborted: " + e.getMessage();
        }
    }

    @Override
    public ProgressParts getParts() throws TaskAbortException {
        return ProgressParts.getParts(this.subprogress, this.esttype);
    }

    @Override
    public Iterable<? extends Progress> getSubProgress() {
        return this.subprogress;
    }

    @Override
    public boolean isStarted() {
        for (Progress progress : this.subprogress) {
            if (progress == null || !progress.isStarted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDone() throws TaskAbortException {
        for (Progress progress : this.subprogress) {
            if (progress != null && progress.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPartiallyDone() {
        for (Progress progress : this.subprogress) {
            try {
                if (progress == null || progress.isDone()) continue;
                return true;
            }
            catch (TaskAbortException e) {
            }
        }
        return false;
    }

    @Override
    public void join() throws InterruptedException, TaskAbortException {
        int s = 1;
        while (true) {
            boolean foundnull = false;
            for (Progress progress : this.subprogress) {
                if (progress == null) {
                    foundnull = true;
                    continue;
                }
                progress.join();
            }
            if (!foundnull) break;
            Thread.sleep(s * 1000);
            if (s == 1 || Math.random() < 1.0 / Math.log(s) / 4.0) {
                ++s;
                continue;
            }
            s = 1;
        }
    }
}

