/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ArchiveContext;
import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertContext;
import freenet.client.async.BaseClientGetter;
import freenet.client.async.ClientBaseCallback;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetWorkerThread;
import freenet.client.async.SingleFileFetcher;
import freenet.client.async.StreamGenerator;
import freenet.client.async.USKCallback;
import freenet.client.async.USKFetcher;
import freenet.client.async.USKManager;
import freenet.client.async.USKRetrieverCallback;
import freenet.crypt.HashResult;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.PrioRunnable;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.Compressor;
import freenet.support.compress.DecompressorThreadManager;
import freenet.support.io.Closer;
import freenet.support.io.InsufficientDiskSpaceException;
import freenet.support.io.NativeThread;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.util.List;

public class USKRetriever
extends BaseClientGetter
implements USKCallback {
    final FetchContext ctx;
    final USKRetrieverCallback cb;
    final USK origUSK;
    private USKCallback proxy;
    private USKFetcher fetcher;
    private static volatile boolean logMINOR;

    public USKRetriever(FetchContext fctx, short prio, final RequestClient client, USKRetrieverCallback cb, USK origUSK) {
        super(prio, new ClientBaseCallback(){

            @Override
            public void onResume(ClientContext context) {
                throw new IllegalStateException();
            }

            @Override
            public RequestClient getRequestClient() {
                return client;
            }
        });
        if (client.persistent()) {
            throw new UnsupportedOperationException("USKRetriever cannot be persistent");
        }
        this.ctx = fctx;
        this.cb = cb;
        this.origUSK = origUSK;
        this.proxy = this;
    }

    @Override
    public void onFoundEdition(long l, USK key, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        if (l < 0L) {
            Logger.error(this, "Found negative edition: " + l + " for " + key + " !!!");
            return;
        }
        if (l < this.origUSK.suggestedEdition) {
            Logger.warning(this, "Found edition prior to that specified by the client: " + l + " < " + this.origUSK.suggestedEdition);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Found edition " + l + " for " + this + " - fetching...");
        }
        FreenetURI uri = key.getSSK(l).getURI();
        try {
            SingleFileFetcher getter = (SingleFileFetcher)SingleFileFetcher.create(this, this, uri, this.ctx, new ArchiveContext(this.ctx.maxTempLength, this.ctx.maxArchiveLevels), this.ctx.maxNonSplitfileRetries, 0, true, l, true, false, context, this.realTimeFlag, false);
            getter.schedule(context);
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Impossible: " + e, (Throwable)e);
        }
        catch (FetchException e) {
            Logger.error(this, "Could not start fetcher for " + uri + " : " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, final ClientGetState state, ClientContext context) {
        PipedOutputStream pipeOut;
        RandomAccessBucket finalResult;
        OutputStream output;
        block13: {
            if (logMINOR) {
                Logger.minor(this, "Success on " + this + " from " + state + " : length " + streamGenerator.size() + "mime type " + clientMetadata.getMIMEType());
            }
            DecompressorThreadManager decompressorManager = null;
            output = null;
            finalResult = null;
            long maxLen = Math.max(this.ctx.maxTempLength, this.ctx.maxOutputLength);
            try {
                finalResult = context.getBucketFactory(this.persistent()).makeBucket(maxLen);
            }
            catch (InsufficientDiskSpaceException e) {
                this.onFailure(new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_DISK_SPACE), state, context);
                return;
            }
            catch (IOException e) {
                Logger.error(this, "Caught " + e, (Throwable)e);
                this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e), state, context);
                return;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                this.onFailure(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, t), state, context);
                return;
            }
            PipedInputStream pipeIn = null;
            pipeOut = null;
            try {
                output = finalResult.getOutputStream();
                if (decompressors != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Decompressing...");
                    }
                    pipeIn = new PipedInputStream();
                    pipeOut = new PipedOutputStream(pipeIn);
                    decompressorManager = new DecompressorThreadManager(pipeIn, decompressors, maxLen);
                    pipeIn = decompressorManager.execute();
                    ClientGetWorkerThread worker = new ClientGetWorkerThread(new BufferedInputStream(pipeIn), output, null, null, null, false, null, null, null, context.linkFilterExceptionProvider);
                    worker.start();
                    streamGenerator.writeTo(pipeOut, context);
                    worker.waitFinished();
                    pipeOut.close();
                    pipeOut = null;
                    break block13;
                }
                streamGenerator.writeTo(output, context);
                output.close();
                output = null;
            }
            catch (IOException e) {
                Logger.error(this, "Caught " + e, (Throwable)e);
                this.onFailure(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, (Throwable)e), state, context);
                Closer.close(output);
                Closer.close(pipeOut);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                this.onFailure(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, t), state, context);
                {
                    catch (Throwable throwable) {
                        Closer.close(output);
                        Closer.close(pipeOut);
                        throw throwable;
                    }
                }
                Closer.close(output);
                Closer.close(pipeOut);
                return;
            }
        }
        Closer.close(output);
        Closer.close(pipeOut);
        final FetchResult result = new FetchResult(clientMetadata, (Bucket)finalResult);
        context.uskManager.updateKnownGood(this.origUSK, state.getToken(), context);
        context.mainExecutor.execute(new PrioRunnable(){

            @Override
            public void run() {
                USKRetriever.this.cb.onFound(USKRetriever.this.origUSK, state.getToken(), result);
            }

            @Override
            public int getPriority() {
                return NativeThread.NORM_PRIORITY;
            }
        });
    }

    @Override
    public void onFailure(FetchException e, ClientGetState state, ClientContext context) {
        switch (e.mode) {
            case NOT_ENOUGH_PATH_COMPONENTS: 
            case PERMANENT_REDIRECT: {
                context.uskManager.updateKnownGood(this.origUSK, state.getToken(), context);
                return;
            }
        }
        Logger.warning(this, "Found edition " + state.getToken() + " but failed to fetch edition: " + e, (Throwable)e);
    }

    @Override
    public void onBlockSetFinished(ClientGetState state, ClientContext context) {
    }

    public USK getOriginalUSK() {
        return this.origUSK;
    }

    @Override
    public FreenetURI getURI() {
        return this.origUSK.getURI();
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    protected void innerNotifyClients(ClientContext context) {
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ClientContext context) {
    }

    @Override
    public void onExpectedMIME(ClientMetadata meta, ClientContext context) {
    }

    @Override
    public void onExpectedSize(long size, ClientContext context) {
    }

    @Override
    public void onFinalizedMetadata() {
    }

    @Override
    public short getPollingPriorityNormal() {
        return this.cb.getPollingPriorityNormal();
    }

    @Override
    public short getPollingPriorityProgress() {
        return this.cb.getPollingPriorityProgress();
    }

    @Override
    public void cancel(ClientContext context) {
        super.cancel();
    }

    @Override
    protected void innerToNetwork(ClientContext context) {
    }

    @Override
    public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ClientContext context) {
    }

    @Override
    public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] splitfileKey, boolean compressed, boolean bottomLayer, boolean definitiveAnyway, ClientContext context) {
    }

    @Override
    public void onHashes(HashResult[] hashes, ClientContext context) {
    }

    synchronized void setProxy(USKCallback cb) {
        this.proxy = cb;
    }

    synchronized USKCallback getProxy() {
        return this.proxy;
    }

    synchronized void setFetcher(USKFetcher f) {
        this.fetcher = f;
    }

    synchronized USKFetcher getFetcher() {
        return this.fetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(USKManager manager) {
        USKCallback p;
        USKFetcher f;
        USKRetriever uSKRetriever = this;
        synchronized (uSKRetriever) {
            f = this.fetcher;
            p = this.proxy;
        }
        if (f != null) {
            f.cancel(manager.getContext());
        }
        if (p != null) {
            manager.unsubscribe(this.origUSK, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeUSKPollParameters(long time, int tries, ClientContext context) {
        USKFetcher f;
        USKRetriever uSKRetriever = this;
        synchronized (uSKRetriever) {
            f = this.fetcher;
        }
        if (f == null) {
            throw new IllegalStateException();
        }
        f.changeUSKPollParameters(time, tries, context);
    }

    @Override
    public void innerOnResume(ClientContext context) {
        Logger.error(this, "Cannot be persistent");
    }

    @Override
    protected ClientBaseCallback getCallback() {
        return null;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

