/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.pluginmanager.AccessDeniedPluginHTTPException;
import freenet.pluginmanager.DownloadPluginHTTPException;
import freenet.pluginmanager.NotFoundPluginHTTPException;
import freenet.pluginmanager.OfficialPlugins;
import freenet.pluginmanager.PluginHTTPException;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.pluginmanager.PluginManager;
import freenet.pluginmanager.RedirectPluginHTTPException;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.TimeUtil;
import freenet.support.api.HTTPRequest;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PproxyToadlet
extends Toadlet {
    private static final int MAX_PLUGIN_NAME_LENGTH = 1024;
    private static final long MAX_THREADED_UNLOAD_WAIT_TIME = TimeUnit.SECONDS.toMillis(60L);
    private final Node node;
    private static volatile boolean logMINOR;
    public static final String PATH = "/plugins/";

    public PproxyToadlet(HighLevelSimpleClient client, Node node) {
        super(client);
        this.node = node;
    }

    @Override
    public boolean allowPOSTWithoutPassword() {
        return true;
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("plugins/")) {
            path = path.substring("plugins/".length());
        }
        if (logMINOR) {
            Logger.minor(this, "Pproxy received POST on " + path);
        }
        final PluginManager pm = this.node.pluginManager;
        if (path.length() > 0) {
            try {
                String plugin = null;
                int to = path.indexOf(47);
                plugin = to == -1 ? path : path.substring(0, to);
                this.writeHTMLReply(ctx, 200, "OK", pm.handleHTTPPost(plugin, request));
            }
            catch (RedirectPluginHTTPException e) {
                this.writeTemporaryRedirect(ctx, e.message, e.newLocation);
            }
            catch (NotFoundPluginHTTPException e) {
                this.sendErrorPage(ctx, 404, e.message, e.location);
            }
            catch (AccessDeniedPluginHTTPException e) {
                this.sendErrorPage(ctx, 403, e.message, e.location);
            }
            catch (DownloadPluginHTTPException e) {
                MultiValueTable<String, String> head = new MultiValueTable<String, String>();
                head.put("Content-Disposition", "attachment; filename=\"" + e.filename + '\"');
                ctx.sendReplyHeaders(200, "Found", head, e.mimeType, e.data.length);
                ctx.writeData(e.data);
            }
            catch (PluginHTTPException e) {
                this.sendErrorPage(ctx, 400, e.message, e.location);
            }
            catch (Throwable t) {
                this.writeInternalError(t, ctx);
            }
        } else {
            if (!ctx.checkFormPassword(request)) {
                return;
            }
            PageMaker pageMaker = ctx.getPageMaker();
            if (request.isPartSet("submit-official")) {
                final String pluginName = request.getPartAsStringFailsafe("plugin-name", 40);
                final String pluginSource = request.getPartAsStringFailsafe("pluginSource", 10);
                this.node.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        pm.startPluginOfficial(pluginName, true, true, "https".equals(pluginSource));
                    }
                });
                headers.put("Location", ".");
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            if (request.isPartSet("submit-other")) {
                final String pluginName = request.getPartAsStringFailsafe("plugin-url", 200);
                final boolean fileonly = "on".equalsIgnoreCase(request.getPartAsStringFailsafe("fileonly", 20));
                this.node.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (fileonly) {
                            pm.startPluginFile(pluginName, true);
                        } else {
                            pm.startPluginURL(pluginName, true);
                        }
                    }
                });
                headers.put("Location", ".");
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            if (request.isPartSet("submit-freenet")) {
                final String pluginName = request.getPartAsStringFailsafe("plugin-uri", 300);
                this.node.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        pm.startPluginFreenet(pluginName, true);
                    }
                });
                headers.put("Location", ".");
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            if (request.isPartSet("cancel")) {
                headers.put("Location", PATH);
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            if (request.getPartAsStringFailsafe("unloadconfirm", 1024).length() > 0) {
                String pluginThreadName = request.getPartAsStringFailsafe("unloadconfirm", 1024);
                String pluginSpecification = this.getPluginSpecification(pm, pluginThreadName);
                pm.killPlugin(pluginThreadName, MAX_THREADED_UNLOAD_WAIT_TIME, false);
                if (request.isPartSet("purge")) {
                    pm.removeCachedCopy(pluginSpecification);
                }
                PageNode page = pageMaker.getPageNode(this.l10n("plugins"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-success");
                infobox.addChild("div", "class", "infobox-header", this.l10n("pluginUnloaded"));
                HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                infoboxContent.addChild("#", this.l10n("pluginUnloadedWithName", "name", pluginThreadName));
                infoboxContent.addChild("br");
                infoboxContent.addChild("a", "href", PATH, this.l10n("returnToPluginPage"));
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.getPartAsStringFailsafe("unload", 1024).length() > 0) {
                PageNode page = pageMaker.getPageNode(this.l10n("plugins"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-query");
                infobox.addChild("div", "class", "infobox-header", this.l10n("unloadPluginTitle"));
                HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                infoboxContent.addChild("#", this.l10n("unloadPluginWithName", "name", request.getPartAsStringFailsafe("unload", 1024)));
                HTMLNode unloadForm = ctx.addFormChild(infoboxContent, PATH, "unloadPluginConfirmForm");
                unloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "unloadconfirm", request.getPartAsStringFailsafe("unload", 1024)});
                HTMLNode tempNode = unloadForm.addChild("p");
                tempNode.addChild("input", new String[]{"type", "name"}, new String[]{"checkbox", "purge"});
                tempNode.addChild("#", this.l10n("unloadPurge"));
                tempNode = unloadForm.addChild("p");
                tempNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "confirm", this.l10n("unload")});
                tempNode.addChild("#", " ");
                tempNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", NodeL10n.getBase().getString("Toadlet.cancel")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.getPartAsStringFailsafe("reload", 1024).length() > 0) {
                HTMLNode tempNode;
                PageNode page = pageMaker.getPageNode(this.l10n("plugins"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode reloadContent = pageMaker.getInfobox("infobox infobox-query", this.l10n("reloadPluginTitle"), contentNode, "plugin-reload", true);
                reloadContent.addChild("p", this.l10n("reloadExplanation"));
                reloadContent.addChild("p", this.l10n("reloadWarning"));
                HTMLNode reloadForm = ctx.addFormChild(reloadContent, PATH, "reloadPluginConfirmForm");
                String pluginIdentifier = request.getPartAsStringFailsafe("reload", 1024);
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "reloadconfirm", pluginIdentifier});
                if (!this.pluginWasLoadedFromLocalDisk(pm, pluginIdentifier)) {
                    tempNode = reloadForm.addChild("p");
                    tempNode.addChild("input", new String[]{"type", "name"}, new String[]{"checkbox", "purge"});
                    tempNode.addChild("#", this.l10n("reloadPurgeWarning"));
                }
                tempNode = reloadForm.addChild("p");
                tempNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "confirm", this.l10n("reload")});
                tempNode.addChild("#", " ");
                tempNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", NodeL10n.getBase().getString("Toadlet.cancel")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.getPartAsStringFailsafe("update", 1024).length() > 0) {
                String pluginFilename = request.getPartAsStringFailsafe("update", 1024);
                if (!pm.isPluginLoaded(pluginFilename)) {
                    this.sendErrorPage(ctx, 404, this.l10n("pluginNotFoundUpdatingTitle"), this.l10n("pluginNotFoundUpdating", "name", pluginFilename));
                } else {
                    this.node.nodeUpdater.deployPluginWhenReady(pluginFilename);
                    headers.put("Location", ".");
                    ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                }
                return;
            }
            if (request.getPartAsStringFailsafe("reloadconfirm", 1024).length() > 0) {
                boolean purge = request.isPartSet("purge");
                String pluginThreadName = request.getPartAsStringFailsafe("reloadconfirm", 1024);
                final String fn = this.getPluginSpecification(pm, pluginThreadName);
                if (fn == null) {
                    this.sendErrorPage(ctx, 404, this.l10n("pluginNotFoundReloadTitle"), this.l10n("pluginNotFoundReload"));
                } else {
                    pm.killPlugin(pluginThreadName, MAX_THREADED_UNLOAD_WAIT_TIME, true);
                    if (purge) {
                        pm.removeCachedCopy(fn);
                    }
                    this.node.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            pm.startPluginAuto(fn, true);
                        }
                    });
                    headers.put("Location", ".");
                    ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                }
                return;
            }
            headers.put("Location", ".");
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
        }
    }

    private boolean pluginWasLoadedFromLocalDisk(PluginManager pluginManager, String pluginIdentifier) {
        for (PluginInfoWrapper pluginInfoWrapper : pluginManager.getPlugins()) {
            File pluginFile;
            if (!pluginInfoWrapper.getThreadName().equals(pluginIdentifier) || !(pluginFile = new File(pluginInfoWrapper.getFilename())).exists() || !pluginFile.isFile()) continue;
            return true;
        }
        return false;
    }

    private String getPluginSpecification(PluginManager pluginManager, String pluginThreadName) {
        for (PluginInfoWrapper pi : pluginManager.getPlugins()) {
            if (!pi.getThreadName().equals(pluginThreadName)) continue;
            return pi.getFilename();
        }
        return null;
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("PproxyToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("PproxyToadlet." + key);
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("plugins/")) {
            path = path.substring("plugins/".length());
        }
        PluginManager pm = this.node.pluginManager;
        if (logMINOR) {
            Logger.minor(this, "Pproxy fetching " + path);
        }
        try {
            if (path.equals("")) {
                if (!ctx.checkFullAccess(this)) {
                    return;
                }
                Iterator<PluginManager.PluginProgress> loadingPlugins = pm.getStartingPlugins().iterator();
                PageNode page = ctx.getPageMaker().getPageNode(this.l10n("plugins"), ctx);
                boolean advancedModeEnabled = ctx.isAdvancedModeEnabled();
                HTMLNode pageNode = page.outer;
                if (loadingPlugins.hasNext()) {
                    page.headNode.addChild("meta", new String[]{"http-equiv", "content"}, new String[]{"refresh", "10; url="});
                }
                HTMLNode contentNode = page.content;
                contentNode.addChild(ctx.getAlertManager().createSummary());
                List<OfficialPlugins.OfficialPluginDescription> availablePlugins = pm.findAvailablePlugins();
                for (PluginInfoWrapper pluginInfoWrapper : pm.getPlugins()) {
                    String pluginName = pluginInfoWrapper.getPluginClassName();
                    String shortPluginName = pluginName.substring(pluginName.lastIndexOf(46) + 1);
                    if (shortPluginName.equals("FreemailPlugin")) {
                        shortPluginName = "Freemail";
                    }
                    availablePlugins.remove(pm.isOfficialPlugin(shortPluginName));
                }
                while (loadingPlugins.hasNext()) {
                    PluginManager.PluginProgress pluginProgress = loadingPlugins.next();
                    String pluginName = pluginProgress.getName();
                    availablePlugins.remove(pm.isOfficialPlugin(pluginName));
                }
                TreeMap<String, List<OfficialPlugins.OfficialPluginDescription>> groupedAvailablePlugins = new TreeMap<String, List<OfficialPlugins.OfficialPluginDescription>>();
                for (OfficialPlugins.OfficialPluginDescription pluginDescription : availablePlugins) {
                    if (!advancedModeEnabled && (pluginDescription.advanced || pluginDescription.experimental || pluginDescription.deprecated)) continue;
                    String translatedGroup = this.l10n("pluginGroup." + pluginDescription.group);
                    if (!groupedAvailablePlugins.containsKey(translatedGroup)) {
                        groupedAvailablePlugins.put(translatedGroup, new ArrayList());
                    }
                    ((List)groupedAvailablePlugins.get(translatedGroup)).add(pluginDescription);
                }
                for (List pluginDescriptions : groupedAvailablePlugins.values()) {
                    Collections.sort(pluginDescriptions, new Comparator<OfficialPlugins.OfficialPluginDescription>(){

                        @Override
                        public int compare(OfficialPlugins.OfficialPluginDescription o1, OfficialPlugins.OfficialPluginDescription o2) {
                            return o1.name.compareTo(o2.name);
                        }
                    });
                }
                this.showStartingPlugins(pm, contentNode);
                this.showPluginList(ctx, pm, contentNode, advancedModeEnabled);
                this.showOfficialPluginLoader(ctx, contentNode, groupedAvailablePlugins, pm, advancedModeEnabled);
                this.showUnofficialPluginLoader(ctx, contentNode);
                this.showFreenetPluginLoader(ctx, contentNode);
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            } else {
                int to = path.indexOf(47);
                String plugin = to == -1 ? path : path.substring(0, to);
                this.writeHTMLReply(ctx, 200, "OK", pm.handleHTTPGet(plugin, request));
            }
        }
        catch (RedirectPluginHTTPException e) {
            this.writeTemporaryRedirect(ctx, e.message, e.newLocation);
        }
        catch (NotFoundPluginHTTPException e) {
            this.sendErrorPage(ctx, 404, e.message, e.location);
        }
        catch (AccessDeniedPluginHTTPException e) {
            this.sendErrorPage(ctx, 403, e.message, e.location);
        }
        catch (DownloadPluginHTTPException e) {
            MultiValueTable<String, String> head = new MultiValueTable<String, String>();
            head.put("Content-Disposition", "attachment; filename=\"" + e.filename + '\"');
            ctx.sendReplyHeaders(200, "Found", head, e.mimeType, e.data.length);
            ctx.writeData(e.data);
        }
        catch (PluginHTTPException e) {
            this.sendErrorPage(ctx, 400, e.message, e.location);
        }
        catch (SocketException e) {
            ctx.forceDisconnect();
        }
        catch (Throwable t) {
            ctx.forceDisconnect();
            Logger.error(this, "Caught: " + t, t);
            this.writeInternalError(t, ctx);
        }
    }

    private void showStartingPlugins(PluginManager pluginManager, HTMLNode contentNode) {
        Set<PluginManager.PluginProgress> startingPlugins = pluginManager.getStartingPlugins();
        if (!startingPlugins.isEmpty()) {
            HTMLNode startingPluginsBox = contentNode.addChild("div", "class", "infobox infobox-normal");
            startingPluginsBox.addChild("div", "class", "infobox-header", this.l10n("startingPluginsTitle"));
            HTMLNode startingPluginsContent = startingPluginsBox.addChild("div", "class", "infobox-content");
            HTMLNode startingPluginsTable = startingPluginsContent.addChild("table");
            HTMLNode startingPluginsHeader = startingPluginsTable.addChild("tr");
            startingPluginsHeader.addChild("th", this.l10n("startingPluginName"));
            startingPluginsHeader.addChild("th", this.l10n("startingPluginStatus"));
            startingPluginsHeader.addChild("th", this.l10n("startingPluginTime"));
            for (PluginManager.PluginProgress pluginProgress : startingPlugins) {
                HTMLNode startingPluginsRow = startingPluginsTable.addChild("tr");
                startingPluginsRow.addChild("td", pluginProgress.getLocalisedPluginName());
                startingPluginsRow.addChild(pluginProgress.toLocalisedHTML());
                startingPluginsRow.addChild("td", "aligh", "right", TimeUtil.formatTime(pluginProgress.getTime()));
            }
        }
    }

    private void showPluginList(ToadletContext ctx, PluginManager pm, HTMLNode contentNode, boolean advancedMode) throws ToadletContextClosedException, IOException {
        HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        infobox.addChild("div", "class", "infobox-header", NodeL10n.getBase().getString("PluginToadlet.pluginListTitle"));
        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
        if (pm.getPlugins().isEmpty()) {
            infoboxContent.addChild("div", this.l10n("noPlugins"));
        } else {
            HTMLNode pluginTable = infoboxContent.addChild("table", "class", "plugins");
            HTMLNode headerRow = pluginTable.addChild("tr");
            headerRow.addChild("th", this.l10n("pluginFilename"));
            if (advancedMode) {
                headerRow.addChild("th", this.l10n("classNameTitle"));
            }
            headerRow.addChild("th", this.l10n("versionTitle"));
            if (advancedMode) {
                headerRow.addChild("th", this.l10n("internalIDTitle"));
                headerRow.addChild("th", this.l10n("startedAtTitle"));
            }
            headerRow.addChild("th");
            headerRow.addChild("th");
            headerRow.addChild("th");
            for (PluginInfoWrapper pi : pm.getPlugins()) {
                long ver;
                HTMLNode pluginRow = pluginTable.addChild("tr");
                pluginRow.addChild("td", pi.getLocalisedPluginName());
                if (advancedMode) {
                    pluginRow.addChild("td", pi.getPluginClassName());
                }
                if ((ver = pi.getPluginLongVersion()) != -1L) {
                    pluginRow.addChild("td", pi.getPluginVersion() + " (" + ver + ")");
                } else {
                    pluginRow.addChild("td", pi.getPluginVersion());
                }
                if (advancedMode) {
                    pluginRow.addChild("td", pi.getThreadName());
                    pluginRow.addChild("td", new Date(pi.getStarted()).toString());
                }
                if (pi.isStopping()) {
                    pluginRow.addChild("td", this.l10n("pluginStopping"));
                    pluginRow.addChild("td");
                    pluginRow.addChild("td");
                    continue;
                }
                if (pi.isPproxyPlugin()) {
                    HTMLNode visitForm = pluginRow.addChild("td").addChild("form", new String[]{"method", "action", "target"}, new String[]{"get", pi.getPluginClassName(), "_blank"});
                    visitForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", ctx.getFormPassword()});
                    visitForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", NodeL10n.getBase().getString("PluginToadlet.visit")});
                } else {
                    pluginRow.addChild("td");
                }
                HTMLNode unloadForm = ctx.addFormChild(pluginRow.addChild("td"), ".", "unloadPluginForm");
                unloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "unload", pi.getThreadName()});
                unloadForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", this.l10n("unload")});
                HTMLNode reloadForm = ctx.addFormChild(pluginRow.addChild("td"), ".", "reloadPluginForm");
                reloadForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "reload", pi.getThreadName()});
                reloadForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", this.l10n("reload")});
            }
        }
    }

    private void showOfficialPluginLoader(ToadletContext toadletContext, HTMLNode contentNode, Map<String, List<OfficialPlugins.OfficialPluginDescription>> availablePlugins, PluginManager pm, boolean advancedModeEnabled) {
        HTMLNode addOfficialPluginBox = contentNode.addChild("div", "class", "infobox infobox-normal");
        addOfficialPluginBox.addChild("div", "class", "infobox-header", this.l10n("loadOfficialPlugin"));
        HTMLNode addOfficialPluginContent = addOfficialPluginBox.addChild("div", "class", "infobox-content");
        HTMLNode addOfficialForm = toadletContext.addFormChild(addOfficialPluginContent, ".", "addOfficialPluginForm");
        HTMLNode p = addOfficialForm.addChild("p");
        p.addChild("#", this.l10n("loadOfficialPluginText"));
        p.addChild("#", " " + this.l10n("pluginSourceChoice"));
        boolean loadFromWeb = pm.loadOfficialPluginsFromWeb();
        HTMLNode input = addOfficialForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", "pluginSource", "freenet"});
        if (!loadFromWeb) {
            input.addAttribute("checked", "true");
        }
        addOfficialForm.addChild("#", this.l10n("pluginSourceFreenet"));
        addOfficialForm.addChild("br");
        input = addOfficialForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", "pluginSource", "https"});
        if (loadFromWeb) {
            input.addAttribute("checked", "true");
        }
        addOfficialForm.addChild("#", this.l10n("pluginSourceHTTPS"));
        addOfficialForm.addChild("#", " ");
        if (this.node.getOpennet() == null) {
            addOfficialForm.addChild("b").addChild("font", "color", "red", this.l10n("pluginSourceHTTPSWarning"));
        } else {
            addOfficialForm.addChild("b", this.l10n("pluginSourceHTTPSWarning"));
        }
        p = addOfficialForm.addChild("p");
        p.addChild("#", this.l10n("loadOfficialPluginLabel") + ": ");
        for (Map.Entry<String, List<OfficialPlugins.OfficialPluginDescription>> groupPlugins : availablePlugins.entrySet()) {
            List<OfficialPlugins.OfficialPluginDescription> notLoadedPlugins = this.getNotLoadedPlugins(pm, groupPlugins.getValue());
            if (notLoadedPlugins.isEmpty()) continue;
            HTMLNode pluginGroupNode = addOfficialForm.addChild("div", "class", "plugin-group");
            pluginGroupNode.addChild("div", "class", "plugin-group-title", this.l10n("pluginGroupTitle", "pluginGroup", groupPlugins.getKey()));
            for (OfficialPlugins.OfficialPluginDescription pluginDescription : notLoadedPlugins) {
                if (pluginDescription.unsupported) continue;
                HTMLNode pluginNode = pluginGroupNode.addChild("div", "class", "plugin");
                HTMLNode option = pluginNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", "plugin-name", pluginDescription.name});
                option.addChild("i", pluginDescription.getLocalisedPluginName());
                if (pluginDescription.deprecated) {
                    option.addChild("b", " (" + this.l10n("loadLabelDeprecated") + ")");
                }
                if (pluginDescription.experimental) {
                    option.addChild("b", " (" + this.l10n("loadLabelExperimental") + ")");
                }
                if (advancedModeEnabled && pluginDescription.minimumVersion >= 0L) {
                    option.addChild("#", " (" + this.l10n("pluginVersion") + " " + pluginDescription.recommendedVersion + ")");
                }
                option.addChild("#", " - " + pluginDescription.getLocalisedPluginDescription());
            }
        }
        addOfficialForm.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "submit-official", this.l10n("Load")});
    }

    private List<OfficialPlugins.OfficialPluginDescription> getNotLoadedPlugins(PluginManager pluginManager, List<OfficialPlugins.OfficialPluginDescription> plugins) {
        ArrayList<OfficialPlugins.OfficialPluginDescription> notLoadedPlugins = new ArrayList<OfficialPlugins.OfficialPluginDescription>();
        for (OfficialPlugins.OfficialPluginDescription plugin : plugins) {
            if (pluginManager.isPluginLoaded(plugin.name)) continue;
            notLoadedPlugins.add(plugin);
        }
        return notLoadedPlugins;
    }

    private void showUnofficialPluginLoader(ToadletContext toadletContext, HTMLNode contentNode) {
        HTMLNode addOtherPluginBox = contentNode.addChild("div", "class", "infobox infobox-normal");
        addOtherPluginBox.addChild("div", "class", "infobox-header", this.l10n("loadOtherPlugin"));
        HTMLNode addOtherPluginContent = addOtherPluginBox.addChild("div", "class", "infobox-content");
        HTMLNode addOtherForm = toadletContext.addFormChild(addOtherPluginContent, ".", "addOtherPluginForm");
        addOtherForm.addChild("div", this.l10n("loadOtherPluginText"));
        addOtherForm.addChild("#", this.l10n("loadOtherURLLabel") + ": ");
        addOtherForm.addChild("input", new String[]{"type", "name", "size"}, new String[]{"text", "plugin-url", "80"});
        addOtherForm.addChild("#", " ");
        addOtherForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "submit-other", this.l10n("Load")});
        addOtherForm.addChild("br");
        addOtherForm.addChild("input", new String[]{"type", "name", "checked"}, new String[]{"checkbox", "fileonly", "checked"});
        addOtherForm.addChild("#", " " + this.l10n("fileonly"));
    }

    private void showFreenetPluginLoader(ToadletContext toadletContext, HTMLNode contentNode) {
        HTMLNode addFreenetPluginBox = contentNode.addChild("div", "class", "infobox infobox-normal");
        addFreenetPluginBox.addChild("div", "class", "infobox-header", this.l10n("loadFreenetPlugin"));
        HTMLNode addFreenetPluginContent = addFreenetPluginBox.addChild("div", "class", "infobox-content");
        HTMLNode addFreenetForm = toadletContext.addFormChild(addFreenetPluginContent, ".", "addFreenetPluginForm");
        addFreenetForm.addChild("div", this.l10n("loadFreenetPluginText"));
        addFreenetForm.addChild("#", this.l10n("loadFreenetURLLabel") + ": ");
        addFreenetForm.addChild("input", new String[]{"type", "name", "size"}, new String[]{"text", "plugin-uri", "80"});
        addFreenetForm.addChild("#", " ");
        addFreenetForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "submit-freenet", this.l10n("Load")});
    }

    @Override
    public String path() {
        return PATH;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

