/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.HTMLEncoder;
import freenet.support.XMLCharacterClasses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class HTMLNode
implements XMLCharacterClasses,
Cloneable {
    private static final Pattern namePattern = Pattern.compile("^[A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u00ff\u0100-\u0131\u0134-\u013e\u0141-\u0148\u014a-\u017e\u0180-\u01c3\u01cd-\u01f0\u01f4-\u01f5\u01fa-\u0217\u0250-\u02a8\u02bb-\u02c1\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03ce\u03d0-\u03d6\u03da\u03dc\u03de\u03e0\u03e2-\u03f3\u0401-\u040c\u040e-\u044f\u0451-\u045c\u045e-\u0481\u0490-\u04c4\u04c7-\u04c8\u04cb-\u04cc\u04d0-\u04eb\u04ee-\u04f5\u04f8-\u04f9\u0531-\u0556\u0559\u0561-\u0586\u05d0-\u05ea\u05f0-\u05f2\u0621-\u063a\u0641-\u064a\u0671-\u06b7\u06ba-\u06be\u06c0-\u06ce\u06d0-\u06d3\u06d5\u06e5-\u06e6\u0905-\u0939\u093d\u0958-\u0961\u0985-\u098c\u098f-\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09dc-\u09dd\u09df-\u09e1\u09f0-\u09f1\u0a05-\u0a0a\u0a0f-\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32-\u0a33\u0a35-\u0a36\u0a38-\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8b\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2-\u0ab3\u0ab5-\u0ab9\u0abd\u0ae0\u0b05-\u0b0c\u0b0f-\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32-\u0b33\u0b36-\u0b39\u0b3d\u0b5c-\u0b5d\u0b5f-\u0b61\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99-\u0b9a\u0b9c\u0b9e-\u0b9f\u0ba3-\u0ba4\u0ba8-\u0baa\u0bae-\u0bb5\u0bb7-\u0bb9\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c60-\u0c61\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cde\u0ce0-\u0ce1\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d28\u0d2a-\u0d39\u0d60-\u0d61\u0e01-\u0e2e\u0e30\u0e32-\u0e33\u0e40-\u0e45\u0e81-\u0e82\u0e84\u0e87-\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa-\u0eab\u0ead-\u0eae\u0eb0\u0eb2-\u0eb3\u0ebd\u0ec0-\u0ec4\u0f40-\u0f47\u0f49-\u0f69\u10a0-\u10c5\u10d0-\u10f6\u1100\u1102-\u1103\u1105-\u1107\u1109\u110b-\u110c\u110e-\u1112\u113c\u113e\u1140\u114c\u114e\u1150\u1154-\u1155\u1159\u115f-\u1161\u1163\u1165\u1167\u1169\u116d-\u116e\u1172-\u1173\u1175\u119e\u11a8\u11ab\u11ae-\u11af\u11b7-\u11b8\u11ba\u11bc-\u11c2\u11eb\u11f0\u11f9\u1e00-\u1e9b\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2126\u212a-\u212b\u212e\u2180-\u2182\u3041-\u3094\u30a1-\u30fa\u3105-\u312c\uac00-\ud7a3\u4e00-\u9fa5\u3007\u3021-\u3029_:][-A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u00ff\u0100-\u0131\u0134-\u013e\u0141-\u0148\u014a-\u017e\u0180-\u01c3\u01cd-\u01f0\u01f4-\u01f5\u01fa-\u0217\u0250-\u02a8\u02bb-\u02c1\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03ce\u03d0-\u03d6\u03da\u03dc\u03de\u03e0\u03e2-\u03f3\u0401-\u040c\u040e-\u044f\u0451-\u045c\u045e-\u0481\u0490-\u04c4\u04c7-\u04c8\u04cb-\u04cc\u04d0-\u04eb\u04ee-\u04f5\u04f8-\u04f9\u0531-\u0556\u0559\u0561-\u0586\u05d0-\u05ea\u05f0-\u05f2\u0621-\u063a\u0641-\u064a\u0671-\u06b7\u06ba-\u06be\u06c0-\u06ce\u06d0-\u06d3\u06d5\u06e5-\u06e6\u0905-\u0939\u093d\u0958-\u0961\u0985-\u098c\u098f-\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09dc-\u09dd\u09df-\u09e1\u09f0-\u09f1\u0a05-\u0a0a\u0a0f-\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32-\u0a33\u0a35-\u0a36\u0a38-\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8b\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2-\u0ab3\u0ab5-\u0ab9\u0abd\u0ae0\u0b05-\u0b0c\u0b0f-\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32-\u0b33\u0b36-\u0b39\u0b3d\u0b5c-\u0b5d\u0b5f-\u0b61\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99-\u0b9a\u0b9c\u0b9e-\u0b9f\u0ba3-\u0ba4\u0ba8-\u0baa\u0bae-\u0bb5\u0bb7-\u0bb9\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c60-\u0c61\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cde\u0ce0-\u0ce1\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d28\u0d2a-\u0d39\u0d60-\u0d61\u0e01-\u0e2e\u0e30\u0e32-\u0e33\u0e40-\u0e45\u0e81-\u0e82\u0e84\u0e87-\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa-\u0eab\u0ead-\u0eae\u0eb0\u0eb2-\u0eb3\u0ebd\u0ec0-\u0ec4\u0f40-\u0f47\u0f49-\u0f69\u10a0-\u10c5\u10d0-\u10f6\u1100\u1102-\u1103\u1105-\u1107\u1109\u110b-\u110c\u110e-\u1112\u113c\u113e\u1140\u114c\u114e\u1150\u1154-\u1155\u1159\u115f-\u1161\u1163\u1165\u1167\u1169\u116d-\u116e\u1172-\u1173\u1175\u119e\u11a8\u11ab\u11ae-\u11af\u11b7-\u11b8\u11ba\u11bc-\u11c2\u11eb\u11f0\u11f9\u1e00-\u1e9b\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2126\u212a-\u212b\u212e\u2180-\u2182\u3041-\u3094\u30a1-\u30fa\u3105-\u312c\uac00-\ud7a3\u4e00-\u9fa5\u3007\u3021-\u30290-9\u0660-\u0669\u06f0-\u06f9\u0966-\u096f\u09e6-\u09ef\u0a66-\u0a6f\u0ae6-\u0aef\u0b66-\u0b6f\u0be7-\u0bef\u0c66-\u0c6f\u0ce6-\u0cef\u0d66-\u0d6f\u0e50-\u0e59\u0ed0-\u0ed9\u0f20-\u0f29._:\u0300-\u0345\u0360-\u0361\u0483-\u0486\u0591-\u05a1\u05a3-\u05b9\u05bb-\u05bd\u05bf\u05c1-\u05c2\u05c4\u064b-\u0652\u0670\u06d6-\u06dc\u06dd-\u06df\u06e0-\u06e4\u06e7-\u06e8\u06ea-\u06ed\u0901-\u0903\u093c\u093e-\u094c\u094d\u0951-\u0954\u0962-\u0963\u0981-\u0983\u09bc\u09be\u09bf\u09c0-\u09c4\u09c7-\u09c8\u09cb-\u09cd\u09d7\u09e2-\u09e3\u0a02\u0a3c\u0a3e\u0a3f\u0a40-\u0a42\u0a47-\u0a48\u0a4b-\u0a4d\u0a70-\u0a71\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0b01-\u0b03\u0b3c\u0b3e-\u0b43\u0b47-\u0b48\u0b4b-\u0b4d\u0b56-\u0b57\u0b82-\u0b83\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0c01-\u0c03\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55-\u0c56\u0c82-\u0c83\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5-\u0cd6\u0d02-\u0d03\u0d3e-\u0d43\u0d46-\u0d48\u0d4a-\u0d4d\u0d57\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0eb9\u0ebb-\u0ebc\u0ec8-\u0ecd\u0f18-\u0f19\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f71-\u0f84\u0f86-\u0f8b\u0f90-\u0f95\u0f97\u0f99-\u0fad\u0fb1-\u0fb7\u0fb9\u20d0-\u20dc\u20e1\u302a-\u302f\u3099\u309a\u00b7\u02d0\u02d1\u0387\u0640\u0e46\u0ec6\u3005\u3031-\u3035\u309d-\u309e\u30fc-\u30fe]*$");
    private static final Pattern simpleNamePattern = Pattern.compile("^[A-Za-z][A-Za-z0-9]*$");
    public static HTMLNode STRONG = new HTMLNode("strong").setReadOnly();
    protected final String name;
    private boolean readOnly;
    private String content;
    private final Map<String, String> attributes = new HashMap<String, String>();
    protected final List<HTMLNode> children = new ArrayList<HTMLNode>();
    private static final ArrayList<String> EmptyTag = new ArrayList(10);
    private static final ArrayList<String> OpenTags = new ArrayList(12);
    private static final ArrayList<String> CloseTags = new ArrayList(12);

    public HTMLNode setReadOnly() {
        this.readOnly = true;
        return this;
    }

    public HTMLNode(String name) {
        this(name, null);
    }

    private Boolean isEmptyElement(String name) {
        return EmptyTag.contains(name);
    }

    Boolean newlineOpen(String name) {
        return OpenTags.contains(name);
    }

    private Boolean newlineClose(String name) {
        return this.newlineOpen(name) != false || CloseTags.contains(name);
    }

    private String OpenSuffix(String name) {
        if (this.isEmptyElement(name).booleanValue()) {
            return " />";
        }
        return ">";
    }

    private String CloseTag(String name) {
        if (this.isEmptyElement(name).booleanValue()) {
            return "";
        }
        return "</" + name + ">";
    }

    private String indentString(int indentDepth) {
        StringBuffer indentLine = new StringBuffer();
        int indentCount = indentDepth + 1;
        for (int indentIndex = 0; indentIndex < indentCount; ++indentIndex) {
            indentLine.append('\t');
        }
        return indentLine.toString();
    }

    public HTMLNode(String name, String content) {
        this(name, (String[])null, (String[])null, content);
    }

    public HTMLNode(String name, String attributeName, String attributeValue) {
        this(name, attributeName, attributeValue, null);
    }

    public HTMLNode(String name, String attributeName, String attributeValue, String content) {
        this(name, new String[]{attributeName}, new String[]{attributeValue}, content);
    }

    public HTMLNode(String name, String[] attributeNames, String[] attributeValues) {
        this(name, attributeNames, attributeValues, null);
    }

    protected HTMLNode(HTMLNode node, boolean clearReadOnly) {
        this.attributes.putAll(node.attributes);
        this.children.addAll(node.children);
        this.content = node.content;
        this.name = node.name;
        this.readOnly = clearReadOnly ? false : node.readOnly;
    }

    public HTMLNode clone() {
        return new HTMLNode(this, true);
    }

    protected boolean checkNamePattern(String str) {
        if (str.length() < 1) {
            return false;
        }
        char c = str.charAt(0);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            boolean simpleMatch = true;
            for (int i = 1; i < str.length(); ++i) {
                c = str.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
                simpleMatch = false;
                break;
            }
            if (simpleMatch) {
                return true;
            }
        }
        return simpleNamePattern.matcher(str).matches() || namePattern.matcher(str).matches();
    }

    public HTMLNode(String name, String[] attributeNames, String[] attributeValues, String content) {
        if (name == null || !"#".equals(name) && !"%".equals(name) && !this.checkNamePattern(name)) {
            throw new IllegalArgumentException("element name is not legal");
        }
        if (attributeNames != null && attributeValues != null) {
            if (attributeNames.length != attributeValues.length) {
                throw new IllegalArgumentException("attribute names and values differ in length");
            }
            int attributeCount = attributeNames.length;
            for (int attributeIndex = 0; attributeIndex < attributeCount; ++attributeIndex) {
                if (attributeNames[attributeIndex] == null || !this.checkNamePattern(attributeNames[attributeIndex])) {
                    throw new IllegalArgumentException("attributeName is not legal");
                }
                this.addAttribute(attributeNames[attributeIndex], attributeValues[attributeIndex]);
            }
        }
        this.name = name.toLowerCase(Locale.ENGLISH);
        if (content != null && !"#".equals(name) && !"%".equals(name)) {
            this.addChild(new HTMLNode("#", content));
            this.content = null;
        } else {
            this.content = content;
        }
    }

    public String getContent() {
        return this.content;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        if (this.readOnly) {
            throw new IllegalArgumentException("Read only");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Cannot add an attribute with a null name");
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException("Cannot add an attribute with a null value");
        }
        this.attributes.put(attributeName, attributeValue);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public HTMLNode addChild(HTMLNode childNode) {
        if (this.readOnly) {
            throw new IllegalArgumentException("Read only");
        }
        if (childNode == null) {
            throw new NullPointerException();
        }
        if (childNode == this) {
            throw new IllegalArgumentException("A HTMLNode cannot be child of himself");
        }
        if (this.children.contains(childNode)) {
            throw new IllegalArgumentException("Cannot add twice the same HTMLNode as child");
        }
        this.children.add(childNode);
        return childNode;
    }

    public void addChildren(HTMLNode[] childNodes) {
        this.addChildren(Arrays.asList(childNodes));
    }

    public void addChildren(List<HTMLNode> childNodes) {
        if (this.readOnly) {
            throw new IllegalArgumentException("Read only");
        }
        for (HTMLNode childNode : childNodes) {
            this.addChild(childNode);
        }
    }

    public HTMLNode addChild(String nodeName) {
        return this.addChild(nodeName, null);
    }

    public HTMLNode addChild(String nodeName, String content) {
        return this.addChild(nodeName, (String[])null, (String[])null, content);
    }

    public HTMLNode addChild(String nodeName, String attributeName, String attributeValue) {
        return this.addChild(nodeName, attributeName, attributeValue, null);
    }

    public HTMLNode addChild(String nodeName, String attributeName, String attributeValue, String content) {
        return this.addChild(nodeName, new String[]{attributeName}, new String[]{attributeValue}, content);
    }

    public HTMLNode addChild(String nodeName, String[] attributeNames, String[] attributeValues) {
        return this.addChild(nodeName, attributeNames, attributeValues, null);
    }

    public HTMLNode addChild(String nodeName, String[] attributeNames, String[] attributeValues, String content) {
        return this.addChild(new HTMLNode(nodeName, attributeNames, attributeValues, content));
    }

    public String getFirstTag() {
        if (!"#".equals(this.name)) {
            return this.name;
        }
        int childCount = this.children.size();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            HTMLNode childNode = this.children.get(childIndex);
            String tag = childNode.getFirstTag();
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    public String generate() {
        StringBuilder tagBuffer = new StringBuilder();
        return this.generate(tagBuffer).toString();
    }

    public StringBuilder generate(StringBuilder tagBuffer) {
        return this.generate(tagBuffer, 0);
    }

    public StringBuilder generate(StringBuilder tagBuffer, int indentDepth) {
        if ("#".equals(this.name)) {
            if (this.content != null) {
                HTMLEncoder.encodeToBuffer(this.content, tagBuffer);
                return tagBuffer;
            }
            int childCount = this.children.size();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                HTMLNode childNode = this.children.get(childIndex);
                childNode.generate(tagBuffer);
            }
            return tagBuffer;
        }
        if ("%".equals(this.name)) {
            tagBuffer.append(this.content);
            return tagBuffer;
        }
        tagBuffer.append('<').append(this.name);
        Set<Map.Entry<String, String>> attributeSet = this.attributes.entrySet();
        for (Map.Entry<String, String> attributeEntry : attributeSet) {
            String attributeName = attributeEntry.getKey();
            String attributeValue = attributeEntry.getValue();
            tagBuffer.append(' ');
            HTMLEncoder.encodeToBuffer(attributeName, tagBuffer);
            tagBuffer.append("=\"");
            HTMLEncoder.encodeToBuffer(attributeValue, tagBuffer);
            tagBuffer.append('\"');
        }
        tagBuffer.append(this.OpenSuffix(this.name));
        if (this.children.size() == 0) {
            if (this.content != null) {
                HTMLEncoder.encodeToBuffer(this.content, tagBuffer);
            }
        } else {
            if (this.newlineOpen(this.name).booleanValue()) {
                tagBuffer.append('\n');
                tagBuffer.append(this.indentString(indentDepth + 1));
            }
            int childCount = this.children.size();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                HTMLNode childNode = this.children.get(childIndex);
                childNode.generate(tagBuffer, indentDepth + 1);
            }
        }
        if (this.newlineOpen(this.name).booleanValue()) {
            tagBuffer.append('\n');
            tagBuffer.append(this.indentString(indentDepth));
        }
        tagBuffer.append(this.CloseTag(this.name));
        if (this.newlineClose(this.name).booleanValue()) {
            tagBuffer.append('\n');
            tagBuffer.append(this.indentString(indentDepth));
        }
        return tagBuffer;
    }

    public String generateChildren() {
        if (this.content != null) {
            return this.content;
        }
        StringBuilder tagBuffer = new StringBuilder();
        int childCount = this.children.size();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            HTMLNode childNode = this.children.get(childIndex);
            childNode.generate(tagBuffer);
        }
        return tagBuffer.toString();
    }

    public void setContent(String newContent) {
        if (this.readOnly) {
            throw new IllegalArgumentException("Read only");
        }
        this.content = newContent;
    }

    public List<HTMLNode> getChildren() {
        return this.children;
    }

    public static HTMLNode link(String path) {
        return new HTMLNode("a", "href", path);
    }

    public static HTMLNode linkInNewWindow(String path) {
        return new HTMLNode("a", new String[]{"href", "target"}, new String[]{path, "_blank"});
    }

    public static HTMLNode text(String text) {
        return new HTMLNode("#", text);
    }

    public static HTMLNode text(int count) {
        return new HTMLNode("#", Integer.toString(count));
    }

    public static HTMLNode text(long count) {
        return new HTMLNode("#", Long.toString(count));
    }

    public static HTMLNode text(short count) {
        return new HTMLNode("#", Short.toString(count));
    }

    public void removeChildren() {
        if (this.readOnly) {
            throw new IllegalArgumentException("Read only");
        }
        this.children.clear();
    }

    static {
        EmptyTag.add("area");
        EmptyTag.add("base");
        EmptyTag.add("br");
        EmptyTag.add("col");
        EmptyTag.add("hr");
        EmptyTag.add("img");
        EmptyTag.add("input");
        EmptyTag.add("link");
        EmptyTag.add("meta");
        EmptyTag.add("param");
        OpenTags.add("body");
        OpenTags.add("div");
        OpenTags.add("form");
        OpenTags.add("head");
        OpenTags.add("html");
        OpenTags.add("input");
        OpenTags.add("ol");
        OpenTags.add("script");
        OpenTags.add("table");
        OpenTags.add("td");
        OpenTags.add("tr");
        OpenTags.add("ul");
        CloseTags.add("h1");
        CloseTags.add("h2");
        CloseTags.add("h3");
        CloseTags.add("h4");
        CloseTags.add("h5");
        CloseTags.add("h6");
        CloseTags.add("li");
        CloseTags.add("link");
        CloseTags.add("meta");
        CloseTags.add("noscript");
        CloseTags.add("option");
        CloseTags.add("title");
    }

    public static class HTMLDoctype
    extends HTMLNode {
        private final String systemUri;

        public HTMLDoctype(String doctype, String systemUri) {
            super(doctype);
            this.systemUri = systemUri;
        }

        @Override
        public StringBuilder generate(StringBuilder tagBuffer) {
            tagBuffer.append("<!DOCTYPE ").append(this.name).append(" PUBLIC \"").append(this.systemUri).append("\">\n");
            return ((HTMLNode)this.children.get(0)).generate(tagBuffer);
        }
    }
}

