/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JVMVersion {
    public static final String REQUIRED = "1.7";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^0*(\\d+)\\.0*(\\d+)(?:\\.0*(\\d+)(?:_0*(\\d+))?)?(?:-.*)?$");

    public static boolean isTooOld() {
        return JVMVersion.isTooOld(JVMVersion.getCurrent());
    }

    public static String getCurrent() {
        return System.getProperty("java.version");
    }

    static boolean isTooOld(String version) {
        if (version == null) {
            return false;
        }
        return JVMVersion.compareVersion(version, REQUIRED) < 0;
    }

    public static final boolean is32Bit() {
        boolean is32bitOS = System.getProperty("os.arch").equalsIgnoreCase("x86");
        String prop = System.getProperty("sun.arch.data.model");
        if (prop != null) {
            return prop.startsWith("32") || is32bitOS;
        }
        return is32bitOS;
    }

    static int[] parse(String version) {
        int[] parsed = new int[4];
        if (version == null) {
            return parsed;
        }
        Matcher m = VERSION_PATTERN.matcher(version);
        if (m.matches()) {
            for (int i = 0; i < 4; ++i) {
                String component = m.group(i + 1);
                if (component == null) continue;
                parsed[i] = Integer.parseInt(component);
            }
        }
        return parsed;
    }

    static int compareVersion(String version1, String version2) {
        int[] parsed1 = JVMVersion.parse(version1);
        int[] parsed2 = JVMVersion.parse(version2);
        for (int i = 0; i < 4; ++i) {
            if (parsed1[i] < parsed2[i]) {
                return -1;
            }
            if (parsed1[i] <= parsed2[i]) continue;
            return 1;
        }
        return 0;
    }
}

