/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.client;

import freenet.client.ClientMetadata;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutter;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.SplitfileProgressEvent;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.support.Base64;
import freenet.support.Logger;
import freenet.support.SizeUtil;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import freenet.support.io.ResumeFailedException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import plugins.Library.Library;
import plugins.Library.io.ObjectStreamReader;
import plugins.Library.io.ObjectStreamWriter;
import plugins.Library.io.serial.LiveArchiver;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.util.exec.ProgressParts;
import plugins.Library.util.exec.SimpleProgress;
import plugins.Library.util.exec.TaskAbortException;

public class FreenetArchiver<T>
implements LiveArchiver<T, SimpleProgress> {
    protected final NodeClientCore core;
    protected final ObjectStreamReader reader;
    protected final ObjectStreamWriter writer;
    protected final String default_mime;
    protected final int expected_bytes;
    public final short priorityClass;
    public final boolean realTimeFlag;
    private static File cacheDir;
    static final boolean SEMI_ASYNC_PUSH = true;
    private final HashSet<PushCallback> semiAsyncPushes = new HashSet();
    private final ArrayList<InsertException> pushesFailed = new ArrayList();
    private long totalBytesPushing;

    public static void setCacheDir(File dir) {
        cacheDir = dir;
    }

    public static File getCacheDir() {
        return cacheDir;
    }

    public FreenetArchiver(NodeClientCore c, ObjectStreamReader r, ObjectStreamWriter w, String mime, int size, short priority) {
        if (c == null) {
            throw new IllegalArgumentException("Can't create a FreenetArchiver with a null NodeClientCore!");
        }
        this.priorityClass = priority;
        this.realTimeFlag = this.priorityClass <= 2;
        this.core = c;
        this.reader = r;
        this.writer = w;
        this.default_mime = mime;
        this.expected_bytes = size;
    }

    public <S extends ObjectStreamWriter & ObjectStreamReader> FreenetArchiver(NodeClientCore c, S rw, String mime, int size, short priority) {
        this(c, rw, rw, mime, size, priority);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void pullLive(Serialiser.PullTask<T> task, SimpleProgress progress) throws TaskAbortException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushLive(Serialiser.PushTask<T> task, SimpleProgress progress) throws TaskAbortException {
        HighLevelSimpleClient hlsc = this.core.makeClient(this.priorityClass, false, false);
        RandomAccessBucket tempB = null;
        OutputStream os = null;
        try {
            ClientPutter putter = null;
            PushCallback cb = null;
            try {
                FreenetURI target;
                boolean insertAsMetadata;
                tempB = this.core.tempBucketFactory.makeBucket((long)this.expected_bytes, 2.0f);
                os = tempB.getOutputStream();
                this.writer.writeObject(task.data, os);
                os.close();
                os = null;
                tempB.setReadOnly();
                if (task.meta instanceof FreenetURI) {
                    insertAsMetadata = false;
                    target = (FreenetURI)task.meta;
                } else {
                    insertAsMetadata = true;
                    target = FreenetURI.EMPTY_CHK_URI;
                }
                InsertBlock ib = new InsertBlock(tempB, new ClientMetadata(this.default_mime), target);
                System.out.println("Inserting block for FreenetArchiver...");
                long startTime = System.currentTimeMillis();
                ProgressParts prog_old = null;
                if (progress != null) {
                    prog_old = progress.getParts();
                }
                InsertContext ctx = hlsc.getInsertContext(false);
                ctx.maxInsertRetries = -1;
                ctx.earlyEncode = true;
                String cacheKey = null;
                if (progress != null) {
                    progress.addPartKnown(1, true);
                }
                cb = new PushCallback(progress, ib);
                putter = new ClientPutter((ClientPutCallback)cb, ib.getData(), FreenetURI.EMPTY_CHK_URI, ib.clientMetadata, ctx, this.priorityClass, false, null, false, this.core.clientContext, null, insertAsMetadata ? 32768L : -1L);
                cb.setPutter(putter);
                long tStart = System.currentTimeMillis();
                try {
                    this.core.clientContext.start(putter);
                }
                catch (PersistenceDisabledException e) {
                    // empty catch block
                }
                WAIT_STATUS status = cb.waitFor();
                if (status == WAIT_STATUS.FAILED) {
                    cb.throwError();
                } else if (status == WAIT_STATUS.GENERATED_URI) {
                    FreenetURI uri = cb.getURI();
                    task.meta = uri;
                    cacheKey = uri.toString(false, true);
                    System.out.println("Got URI for asynchronous insert: " + uri + " size " + tempB.size() + " in " + (System.currentTimeMillis() - cb.startTime));
                } else {
                    Bucket data = cb.getGeneratedMetadata();
                    byte[] buf = BucketTools.toByteArray((Bucket)data);
                    data.free();
                    task.meta = buf;
                    cacheKey = Base64.encode((byte[])SHA256.digest((byte[])buf));
                    System.out.println("Got generated metadata (" + buf.length + " bytes) for asynchronous insert size " + tempB.size() + " in " + (System.currentTimeMillis() - cb.startTime));
                }
                if (progress != null) {
                    progress.addPartDone();
                }
                if (progress != null) {
                    ProgressParts prog_new = progress.getParts();
                    if (prog_old.known - prog_old.done != prog_new.known - prog_new.done) {
                        Logger.error((Object)this, (String)("Inconsistency when tracking split file progress (pushing): " + prog_old.known + " of " + prog_old.done + " -> " + prog_new.known + " of " + prog_new.done));
                        System.err.println("Inconsistency when tracking split file progress (pushing): " + prog_old.known + " of " + prog_old.done + " -> " + prog_new.known + " of " + prog_new.done);
                    }
                }
                task.data = null;
                if (cacheKey != null && cacheDir != null && cacheDir.exists() && cacheDir.canRead()) {
                    File cached = new File(cacheDir, cacheKey);
                    FileBucket cachedBucket = new FileBucket(cached, false, false, false, false);
                    BucketTools.copy((Bucket)tempB, (Bucket)cachedBucket);
                }
                tempB = null;
            }
            catch (InsertException e) {
                if (cb != null) {
                    FreenetArchiver freenetArchiver = this;
                    synchronized (freenetArchiver) {
                        if (this.semiAsyncPushes.remove(cb)) {
                            this.totalBytesPushing -= cb.size();
                        }
                    }
                }
                throw new TaskAbortException("Failed to insert content", e, true);
            }
            catch (IOException e) {
                throw new TaskAbortException("Failed to write content to local tempbucket", e, true);
            }
            catch (RuntimeException e) {
                throw new TaskAbortException("Failed to complete task: ", e);
            }
        }
        catch (TaskAbortException e) {
            try {
                if (progress != null) {
                    progress.abort(e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                Closer.close(os);
                Closer.close(tempB);
                throw throwable;
            }
        }
        Closer.close((Closeable)os);
        Closer.close((Bucket)tempB);
    }

    @Override
    public void pull(Serialiser.PullTask<T> task) throws TaskAbortException {
        this.pullLive(task, (SimpleProgress)null);
    }

    @Override
    public void push(Serialiser.PushTask<T> task) throws TaskAbortException {
        this.pushLive(task, (SimpleProgress)null);
    }

    public void waitForAsyncInserts() throws TaskAbortException {
        FreenetArchiver freenetArchiver = this;
        synchronized (freenetArchiver) {
            while (true) {
                if (!this.pushesFailed.isEmpty()) {
                    throw new TaskAbortException("Failed to insert content", this.pushesFailed.remove(0), true);
                }
                if (this.semiAsyncPushes.isEmpty()) {
                    System.out.println("Asynchronous inserts completed.");
                    return;
                }
                System.out.println("Waiting for " + this.semiAsyncPushes.size() + " asynchronous inserts (" + SizeUtil.formatSize((long)this.totalBytesPushing) + ")...");
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class SimpleProgressUpdater
    implements ClientEventListener {
        final int[] splitfile_blocks = new int[2];
        final SimpleProgress progress;

        public SimpleProgressUpdater(SimpleProgress prog) {
            this.progress = prog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(ClientEvent ce, ClientContext context) {
            this.progress.setStatus(ce.getDescription());
            if (!(ce instanceof SplitfileProgressEvent)) {
                return;
            }
            SplitfileProgressEvent evt = (SplitfileProgressEvent)ce;
            int new_succeeded = evt.succeedBlocks;
            int new_total = evt.minSuccessfulBlocks;
            if (new_succeeded > new_total) {
                Logger.normal((Object)this, (String)("Received SplitfileProgressEvent greater than 100%: " + evt.getDescription()));
                new_succeeded = new_total;
            }
            int[] nArray = this.splitfile_blocks;
            synchronized (this.splitfile_blocks) {
                int old_succeeded = this.splitfile_blocks[0];
                int old_total = this.splitfile_blocks[1];
                try {
                    this.progress.addPartKnown(new_total - old_total, evt.finalizedTotal);
                    int n = new_succeeded - old_succeeded;
                    if (n == 1) {
                        this.progress.addPartDone();
                    } else if (n != 0) {
                        Logger.normal((Object)this, (String)("Received SplitfileProgressEvent out-of-order: " + evt.getDescription()));
                        for (int i = 0; i < n; ++i) {
                            this.progress.addPartDone();
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    Logger.normal((Object)this, (String)("Received SplitfileProgressEvent out-of-order: " + evt.getDescription()), (Throwable)e);
                }
                this.splitfile_blocks[0] = new_succeeded;
                this.splitfile_blocks[1] = new_total;
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
        }
    }

    public class PushCallback
    implements ClientPutCallback {
        public final long startTime = System.currentTimeMillis();
        private ClientPutter putter;
        private FreenetURI generatedURI;
        private Bucket generatedMetadata;
        private InsertException failed;
        private final long size;
        private final InsertBlock ib;

        public PushCallback(SimpleProgress progress, InsertBlock ib) {
            this.ib = ib;
            this.size = ib.getData().size();
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setPutter(ClientPutter put) {
            this.putter = put;
            FreenetArchiver freenetArchiver = FreenetArchiver.this;
            synchronized (freenetArchiver) {
                if (FreenetArchiver.this.semiAsyncPushes.add(this)) {
                    FreenetArchiver.this.totalBytesPushing += this.size;
                }
                System.out.println("Pushing " + FreenetArchiver.this.totalBytesPushing + " bytes on " + FreenetArchiver.this.semiAsyncPushes.size() + " inserters");
            }
        }

        public synchronized WAIT_STATUS waitFor() {
            while (this.generatedURI == null && this.generatedMetadata == null && this.failed == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.failed != null) {
                return WAIT_STATUS.FAILED;
            }
            if (this.generatedURI != null) {
                return WAIT_STATUS.GENERATED_URI;
            }
            return WAIT_STATUS.GENERATED_METADATA;
        }

        public synchronized void throwError() throws InsertException {
            if (this.failed != null) {
                throw this.failed;
            }
        }

        public synchronized FreenetURI getURI() {
            return this.generatedURI;
        }

        public synchronized Bucket getGeneratedMetadata() {
            return this.generatedMetadata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(InsertException e, BaseClientPutter state) {
            System.out.println("Failed background insert (" + this.generatedURI + "), now running: " + FreenetArchiver.this.semiAsyncPushes.size() + " (" + SizeUtil.formatSize((long)FreenetArchiver.this.totalBytesPushing) + ").");
            Object object = this;
            synchronized (object) {
                this.failed = e;
                this.notifyAll();
            }
            object = FreenetArchiver.this;
            synchronized (object) {
                if (FreenetArchiver.this.semiAsyncPushes.remove(this)) {
                    FreenetArchiver.this.totalBytesPushing -= this.size;
                }
                FreenetArchiver.this.pushesFailed.add(e);
                FreenetArchiver.this.notifyAll();
            }
            if (this.ib != null) {
                this.ib.free();
            }
        }

        public void onFetchable(BaseClientPutter state) {
        }

        public synchronized void onGeneratedURI(FreenetURI uri, BaseClientPutter state) {
            this.generatedURI = uri;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(BaseClientPutter state) {
            FreenetArchiver freenetArchiver = FreenetArchiver.this;
            synchronized (freenetArchiver) {
                if (FreenetArchiver.this.semiAsyncPushes.remove(this)) {
                    FreenetArchiver.this.totalBytesPushing -= this.size;
                }
                System.out.println("Completed background insert (" + this.generatedURI + ") in " + (System.currentTimeMillis() - this.startTime) + "ms, now running: " + FreenetArchiver.this.semiAsyncPushes.size() + " (" + SizeUtil.formatSize((long)FreenetArchiver.this.totalBytesPushing) + ").");
                FreenetArchiver.this.notifyAll();
            }
            if (this.ib != null) {
                this.ib.free();
            }
        }

        public synchronized void onGeneratedMetadata(Bucket metadata, BaseClientPutter state) {
            this.generatedMetadata = metadata;
            this.notifyAll();
        }

        public void onResume(ClientContext context) throws ResumeFailedException {
        }

        public RequestClient getRequestClient() {
            return Library.REQUEST_CLIENT;
        }
    }

    static enum WAIT_STATUS {
        FAILED,
        GENERATED_URI,
        GENERATED_METADATA;

    }
}

