/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index;

import freenet.keys.FreenetURI;
import freenet.support.Logger;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import plugins.Library.Index;
import plugins.Library.index.ProtoIndexComponentSerialiser;
import plugins.Library.index.TermEntry;
import plugins.Library.index.TermPageEntry;
import plugins.Library.index.URIEntry;
import plugins.Library.index.URIKey;
import plugins.Library.io.serial.ProgressTracker;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.util.DataNotLoadedException;
import plugins.Library.util.Skeleton;
import plugins.Library.util.SkeletonBTreeMap;
import plugins.Library.util.SkeletonBTreeSet;
import plugins.Library.util.concurrent.Executors;
import plugins.Library.util.exec.AbstractExecution;
import plugins.Library.util.exec.ChainedProgress;
import plugins.Library.util.exec.Execution;
import plugins.Library.util.exec.Progress;
import plugins.Library.util.exec.ProgressParts;
import plugins.Library.util.exec.TaskAbortException;

public final class ProtoIndex
implements Index {
    static final long serialVersionUID = -510524472690844873L;
    public static final String MIME_TYPE = "text/yaml";
    public static final String DEFAULT_FILE = "index.yml";
    public static int BTREE_NODE_MIN = 1024;
    public static final int BTREE_ENT_MAX = (BTREE_NODE_MIN << 1) - 1;
    protected static Executor exec = Executors.DEFAULT_EXECUTOR;
    protected FreenetURI reqID;
    protected FreenetURI insID;
    protected String name;
    protected String indexOwnerName;
    protected String indexOwnerEmail;
    protected long totalPages;
    protected Date modified;
    protected final Map<String, Object> extra;
    public final SkeletonBTreeMap<String, SkeletonBTreeSet<TermEntry>> ttab;
    protected final SkeletonBTreeMap<URIKey, SkeletonBTreeMap<FreenetURI, URIEntry>> utab;
    protected int serialFormatUID;
    protected ProtoIndexComponentSerialiser serialiser;
    private Map<String, Execution<Set<TermEntry>>> getTermEntriesProgress = new HashMap<String, Execution<Set<TermEntry>>>();

    public static void setExecutor(Executor e) {
        exec = e;
    }

    public ProtoIndex(FreenetURI id, String n, String owner, String ownerEmail, long pages) {
        this(id, n, owner, ownerEmail, pages, new Date(), new HashMap<String, Object>(), new SkeletonBTreeMap<URIKey, SkeletonBTreeMap<FreenetURI, URIEntry>>(BTREE_NODE_MIN), new SkeletonBTreeMap<String, SkeletonBTreeSet<TermEntry>>(BTREE_NODE_MIN));
    }

    protected ProtoIndex(FreenetURI id, String n, String owner, String ownerEmail, long pages, Date m, Map<String, Object> x, SkeletonBTreeMap<URIKey, SkeletonBTreeMap<FreenetURI, URIEntry>> u, SkeletonBTreeMap<String, SkeletonBTreeSet<TermEntry>> t) {
        this.reqID = id;
        this.name = n == null ? "" : n;
        this.modified = m;
        this.extra = x;
        this.indexOwnerName = owner;
        this.indexOwnerEmail = ownerEmail;
        this.totalPages = pages;
        this.ttab = t;
        this.utab = u;
    }

    public ProtoIndexComponentSerialiser getSerialiser() {
        return this.serialiser;
    }

    public void setSerialiser(ProtoIndexComponentSerialiser srl) {
        this.serialFormatUID = srl.serialFormatUID;
        this.serialiser = srl;
    }

    @Override
    public Execution<Set<TermEntry>> getTermEntries(String term) {
        getTermEntriesHandler request = this.getTermEntriesProgress.get(term);
        if (request == null) {
            request = new getTermEntriesHandler(term);
            this.getTermEntriesProgress.put(term, request);
            exec.execute(request);
        }
        return request;
    }

    @Override
    public Execution<URIEntry> getURIEntry(FreenetURI uri) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setName(String indexName) {
        this.name = indexName;
    }

    public void setTotalPages(long total) {
        this.totalPages = total;
    }

    public void setOwner(String owner) {
        this.indexOwnerName = owner;
    }

    public void setOwnerEmail(String address) {
        this.indexOwnerEmail = address;
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerEmail() {
        return this.indexOwnerEmail;
    }

    public String getOwner() {
        return this.indexOwnerName;
    }

    public long getTotalPages() {
        return this.totalPages;
    }

    public class getTermEntriesHandler
    extends AbstractExecution<Set<TermEntry>>
    implements Runnable,
    ChainedProgress {
        final Map<Object, ProgressTracker> trackers;
        Object current_meta;
        ProgressTracker current_tracker;
        Progress last;

        protected getTermEntriesHandler(String t) {
            super(t);
            this.trackers = new LinkedHashMap<Object, ProgressTracker>();
            this.last = null;
        }

        @Override
        public ProgressParts getParts() throws TaskAbortException {
            int started;
            Set result = (Set)this.getResult();
            int known = started = this.trackers.size();
            int done = started - 1;
            if (this.last != null) {
                ++started;
                ++done;
                ++known;
            }
            if (done < 0) {
                done = 0;
            }
            int estimate = result != null ? -1 : Math.max(ProtoIndex.this.ttab.heightEstimate() + 1, known);
            return new ProgressParts(done, started, known, estimate);
        }

        @Override
        public String getStatus() {
            Progress cur = this.getCurrentProgress();
            return cur == null ? "Starting next stage..." : cur.getSubject() + ": " + cur.getStatus();
        }

        @Override
        public Progress getCurrentProgress() {
            return this.last != null ? this.last : (this.current_tracker == null ? null : this.current_tracker.getPullProgressFor(this.current_meta));
        }

        @Override
        public void run() {
            try {
                SkeletonBTreeSet root;
                while (true) {
                    try {
                        root = (SkeletonBTreeSet)ProtoIndex.this.ttab.get(this.subject);
                    }
                    catch (DataNotLoadedException d) {
                        Skeleton p = d.getParent();
                        this.current_meta = d.getValue();
                        this.current_tracker = ((Serialiser.Trackable)p.getSerialiser()).getTracker();
                        this.trackers.put(this.current_meta, this.current_tracker);
                        p.inflate(d.getKey());
                        continue;
                    }
                    break;
                }
                if (root == null) {
                    throw new TaskAbortException("Index does not contain term " + this.subject, new Exception("Index does not contain term " + this.subject));
                }
                this.last = root.getProgressInflate();
                root.inflate();
                double multiplier = 1.0;
                if (ProtoIndex.this.totalPages > 0L) {
                    long total = ProtoIndex.this.totalPages;
                    long specific = root.size();
                    multiplier = Math.log((double)total / (double)specific);
                    if (multiplier < 0.0) {
                        Logger.error((Object)this, (String)("Negative multiplier!: " + multiplier + " total = " + total + " specific = " + root.size()));
                        multiplier = 1.0;
                    } else {
                        Logger.normal((Object)this, (String)("Correcting results: " + multiplier));
                    }
                }
                Set<TermEntry> entries = this.wrapper(root, multiplier);
                this.setResult(entries);
            }
            catch (TaskAbortException e) {
                this.setError(e);
                return;
            }
        }

        private Set<TermEntry> wrapper(final SkeletonBTreeSet<TermEntry> root, final double relAdjustment) {
            return new AbstractSet<TermEntry>(){

                @Override
                public boolean add(TermEntry arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends TermEntry> arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean contains(Object arg0) {
                    return root.contains(arg0);
                }

                @Override
                public boolean containsAll(Collection<?> arg0) {
                    return root.containsAll(arg0);
                }

                @Override
                public boolean isEmpty() {
                    return root.isEmpty();
                }

                @Override
                public Iterator<TermEntry> iterator() {
                    final Iterator entries = root.iterator();
                    return new Iterator<TermEntry>(){

                        @Override
                        public boolean hasNext() {
                            return entries.hasNext();
                        }

                        @Override
                        public TermEntry next() {
                            TermEntry t = (TermEntry)entries.next();
                            if (t instanceof TermPageEntry && relAdjustment != 1.0) {
                                return new TermPageEntry((TermPageEntry)t, (float)(relAdjustment * (double)t.rel));
                            }
                            return t;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public boolean remove(Object arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int size() {
                    return root.size();
                }
            };
        }
    }
}

