/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index;

import freenet.keys.FreenetURI;
import java.io.File;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import plugins.Library.Library;
import plugins.Library.client.FreenetArchiver;
import plugins.Library.index.ProtoIndex;
import plugins.Library.index.ProtoIndexComponentSerialiser;
import plugins.Library.index.TermEntry;
import plugins.Library.index.URIEntry;
import plugins.Library.index.URIKey;
import plugins.Library.io.DataFormatException;
import plugins.Library.io.serial.Archiver;
import plugins.Library.io.serial.FileArchiver;
import plugins.Library.io.serial.LiveArchiver;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.io.serial.Translator;
import plugins.Library.util.SkeletonBTreeMap;
import plugins.Library.util.SkeletonBTreeSet;
import plugins.Library.util.exec.SimpleProgress;
import plugins.Library.util.exec.TaskAbortException;

public class ProtoIndexSerialiser
implements Archiver<ProtoIndex>,
Serialiser.Composite<Archiver<Map<String, Object>>>,
Serialiser.Translate<ProtoIndex, Map<String, Object>> {
    public static final String MIME_TYPE = "text/yaml";
    public static final String FILE_EXTENSION = ".yml";
    protected final Translator<ProtoIndex, Map<String, Object>> trans;
    protected final LiveArchiver<Map<String, Object>, SimpleProgress> subsrl;

    public ProtoIndexSerialiser(LiveArchiver<Map<String, Object>, SimpleProgress> s) {
        this.subsrl = s;
        this.trans = new IndexTranslator(this.subsrl);
    }

    public static ProtoIndexSerialiser forIndex(Object o, short priorityClass) {
        if (o instanceof FreenetURI) {
            return ProtoIndexSerialiser.forIndex((FreenetURI)o, priorityClass);
        }
        if (o instanceof File) {
            return ProtoIndexSerialiser.forIndex((File)o);
        }
        throw new UnsupportedOperationException("Don't know how to retrieve index for object " + o);
    }

    public static ProtoIndexSerialiser forIndex(FreenetURI uri, short priorityClass) {
        FreenetArchiver<Map<String, Object>> arx = Library.makeArchiver(ProtoIndexComponentSerialiser.yamlrw, MIME_TYPE, 128 * ProtoIndex.BTREE_NODE_MIN, priorityClass);
        return new ProtoIndexSerialiser(arx);
    }

    public static ProtoIndexSerialiser forIndex(File prefix) {
        return new ProtoIndexSerialiser(new FileArchiver<Map<String, Object>>(ProtoIndexComponentSerialiser.yamlrw, true, FILE_EXTENSION, "", "", prefix));
    }

    @Override
    public LiveArchiver<Map<String, Object>, SimpleProgress> getChildSerialiser() {
        return this.subsrl;
    }

    @Override
    public Translator<ProtoIndex, Map<String, Object>> getTranslator() {
        return this.trans;
    }

    @Override
    public void pull(Serialiser.PullTask<ProtoIndex> task) throws TaskAbortException {
        Serialiser.PullTask serialisable = new Serialiser.PullTask(task.meta);
        this.subsrl.pull(serialisable);
        task.meta = serialisable.meta;
        if (task.meta instanceof FreenetURI) {
            ((Map)serialisable.data).put("reqID", task.meta);
        }
        try {
            task.data = this.trans.rev((Map<String, Object>)serialisable.data);
        }
        catch (DataFormatException e) {
            throw new TaskAbortException("Could not construct index from data", e);
        }
    }

    @Override
    public void push(Serialiser.PushTask<ProtoIndex> task) throws TaskAbortException {
        Serialiser.PushTask<Map<String, Object>> serialisable = new Serialiser.PushTask<Map<String, Object>>(this.trans.app((ProtoIndex)task.data));
        serialisable.meta = ((Map)serialisable.data).remove("insID");
        this.subsrl.push(serialisable);
        task.meta = serialisable.meta;
    }

    public static class IndexTranslator
    implements Translator<ProtoIndex, Map<String, Object>> {
        Translator<SkeletonBTreeMap<String, SkeletonBTreeSet<TermEntry>>, Map<String, Object>> ttrans = new SkeletonBTreeMap.TreeTranslator<String, SkeletonBTreeSet<TermEntry>>(null, new ProtoIndexComponentSerialiser.TreeMapTranslator(null));
        Translator<SkeletonBTreeMap<URIKey, SkeletonBTreeMap<FreenetURI, URIEntry>>, Map<String, Object>> utrans = new SkeletonBTreeMap.TreeTranslator<URIKey, SkeletonBTreeMap<FreenetURI, URIEntry>>(null, new ProtoIndexComponentSerialiser.TreeMapTranslator(null));
        private LiveArchiver<Map<String, Object>, SimpleProgress> subsrl;

        public IndexTranslator(LiveArchiver<Map<String, Object>, SimpleProgress> subsrl) {
            this.subsrl = subsrl;
        }

        @Override
        public Map<String, Object> app(ProtoIndex idx) {
            if (!idx.ttab.isBare() || !idx.utab.isBare()) {
                throw new IllegalArgumentException("Data structure is not bare. Try calling deflate() first.");
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("serialVersionUID", -510524472690844873L);
            map.put("serialFormatUID", idx.serialFormatUID);
            map.put("insID", idx.insID);
            map.put("name", idx.name);
            map.put("ownerName", idx.indexOwnerName);
            map.put("ownerEmail", idx.indexOwnerEmail);
            map.put("totalPages", new Long(idx.totalPages));
            map.put("modified", idx.modified);
            map.put("extra", idx.extra);
            map.put("utab", this.utrans.app(idx.utab));
            map.put("ttab", this.ttrans.app(idx.ttab));
            return map;
        }

        @Override
        public ProtoIndex rev(Map<String, Object> map) throws DataFormatException {
            long magic = (Long)map.get("serialVersionUID");
            if (magic == -510524472690844873L) {
                try {
                    ProtoIndexComponentSerialiser cmpsrl = ProtoIndexComponentSerialiser.get((Integer)map.get("serialFormatUID"), this.subsrl);
                    FreenetURI reqID = (FreenetURI)map.get("reqID");
                    String name = (String)map.get("name");
                    String ownerName = (String)map.get("ownerName");
                    String ownerEmail = (String)map.get("ownerEmail");
                    Object o = map.get("totalPages");
                    long totalPages = o instanceof Long ? (Long)o : (long)((Integer)o).intValue();
                    Date modified = (Date)map.get("modified");
                    Map extra = (Map)map.get("extra");
                    SkeletonBTreeMap<URIKey, SkeletonBTreeMap<FreenetURI, URIEntry>> utab = this.utrans.rev((Map)map.get("utab"));
                    SkeletonBTreeMap<String, SkeletonBTreeSet<TermEntry>> ttab = this.ttrans.rev((Map)map.get("ttab"));
                    return cmpsrl.setSerialiserFor(new ProtoIndex(reqID, name, ownerName, ownerEmail, totalPages, modified, extra, utab, ttab));
                }
                catch (ClassCastException e) {
                    throw new DataFormatException("Badly formatted data", e, null);
                }
                catch (UnsupportedOperationException e) {
                    throw new DataFormatException("Unrecognised format ID", e, map.get("serialFormatUID"), map, "serialFormatUID");
                }
            }
            throw new DataFormatException("Unrecognised serial ID", null, magic, map, "serialVersionUID");
        }
    }
}

