/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.io;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ObjectBlueprint<T> {
    protected final Class<T> cls;
    protected final Map<String, String> properties;
    protected final Map<String, Field> prop_fields = new HashMap<String, Field>();
    protected final Map<String, Method> prop_methods = new HashMap<String, Method>();
    protected final Map<String, Class<?>> param_type = new LinkedHashMap();
    protected final Constructor<T> constructor;
    private static final Map<Class<?>, Class<?>> boxes = new IdentityHashMap();

    public ObjectBlueprint(Class<T> c, Map<String, String> blueprint, Iterable<String> ctor_params) throws NoSuchFieldException, NoSuchMethodException {
        if (c == null || blueprint == null) {
            throw new NullPointerException();
        }
        this.cls = c;
        this.properties = blueprint;
        this.setProperties();
        if (ctor_params == null) {
            this.constructor = this.cls.getConstructor(this.param_type.values().toArray(new Class[this.param_type.size()]));
        } else {
            ArrayList types = new ArrayList();
            for (String property : ctor_params) {
                types.add(this.param_type.get(property));
            }
            this.constructor = this.cls.getConstructor(types.toArray(new Class[types.size()]));
        }
    }

    public ObjectBlueprint(Class<T> c, Map<String, String> blueprint) throws NoSuchFieldException, NoSuchMethodException {
        this(c, blueprint, (Iterable<String>)null);
    }

    public ObjectBlueprint(Class<T> c, Collection<String> fields) throws NoSuchFieldException, NoSuchMethodException {
        this(c, ObjectBlueprint.makePropertiesFromFields(fields));
    }

    private static Map<String, String> makePropertiesFromFields(Collection<String> fields) {
        LinkedHashMap<String, String> blueprint = new LinkedHashMap<String, String>();
        for (String s : fields) {
            blueprint.put(s, null);
        }
        return blueprint;
    }

    public ObjectBlueprint(Class<T> c, Map<String, String> blueprint, Constructor<T> ctor) throws NoSuchFieldException, NoSuchMethodException {
        if (c == null || blueprint == null) {
            throw new NullPointerException();
        }
        this.cls = c;
        this.properties = blueprint;
        this.setProperties();
        this.constructor = ctor;
    }

    private void setProperties() throws NoSuchFieldException, NoSuchMethodException {
        assert (this.properties != null);
        this.prop_fields.clear();
        this.prop_methods.clear();
        this.param_type.clear();
        for (Map.Entry<String, String> en : this.properties.entrySet()) {
            String property = en.getKey();
            String method_name = en.getValue();
            if (method_name == null || method_name.length() == 0) {
                Field f = this.cls.getField(property);
                this.prop_fields.put(property, f);
                this.param_type.put(property, f.getType());
                continue;
            }
            Method m = this.cls.getMethod(method_name, new Class[0]);
            if (m.getParameterTypes().length > 0) {
                throw new IllegalArgumentException("Bad blueprint: getter method " + method_name + " for property " + property + " takes more than 0 arguments");
            }
            this.prop_methods.put(property, m);
            this.param_type.put(property, m.getReturnType());
        }
    }

    public static <T> Builder<T> init(Class<T> cls) {
        return new Builder<T>(cls);
    }

    public Class<T> getObjectClass() {
        return this.cls;
    }

    public Constructor<T> getObjectConstructor() {
        return this.constructor;
    }

    public T newInstance(Object ... initargs) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.constructor.newInstance(initargs);
    }

    protected static <T> Object boxCast(Class<T> cls, Object val) throws ClassCastException {
        Class<?> tcls = boxes.get(cls);
        if (tcls == null) {
            throw new IllegalArgumentException("Input class must be a primitive type.");
        }
        return tcls.cast(val);
    }

    public T objectFromMap(Map<?, ?> map) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object[] initargs = new Object[this.param_type.size()];
        int i = 0;
        for (Map.Entry<String, Class<?>> en : this.param_type.entrySet()) {
            String property = en.getKey();
            Class<?> type = en.getValue();
            Object value = map.get(property);
            try {
                value = type.isPrimitive() ? ObjectBlueprint.boxCast(type, value) : type.cast(value);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Parameter for property " + property + " is not of the correct type should be " + type + " but is " + value.getClass(), e);
            }
            initargs[i++] = value;
        }
        return this.constructor.newInstance(initargs);
    }

    public Map<String, Object> objectAsMap(final T object) {
        return new AbstractMap<String, Object>(){
            private final Set<Map.Entry<String, Object>> entrySet = new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public int size() {
                    return ObjectBlueprint.this.properties.size();
                }

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    return new Iterator<Map.Entry<String, Object>>(){
                        final Iterator<Map.Entry<String, String>> props;
                        {
                            this.props = ObjectBlueprint.this.properties.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.props.hasNext();
                        }

                        @Override
                        public Map.Entry<String, Object> next() {
                            Map.Entry<String, String> en = this.props.next();
                            final String property = en.getKey();
                            final String method_name = en.getValue();
                            return new Map.Entry<String, Object>(){

                                @Override
                                public String getKey() {
                                    return property;
                                }

                                @Override
                                public Object getValue() {
                                    return this.get(property, method_name);
                                }

                                @Override
                                public Object setValue(Object o) {
                                    throw new UnsupportedOperationException("Cannot modify an object in this way.");
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Cannot modify an object in this way.");
                        }
                    };
                }
            };

            @Override
            public int size() {
                return ObjectBlueprint.this.properties.size();
            }

            @Override
            public boolean containsKey(Object property) {
                return ObjectBlueprint.this.properties.containsKey(property);
            }

            @Override
            public Object get(Object property) {
                return this.get((String)property, ObjectBlueprint.this.properties.get(property));
            }

            protected Object get(String property, String method_name) {
                try {
                    if (method_name == null || method_name.length() == 0) {
                        return ObjectBlueprint.this.prop_fields.get(property).get(object);
                    }
                    return ObjectBlueprint.this.prop_methods.get(method_name).invoke(object, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return this.entrySet;
            }
        };
    }

    static {
        boxes.put(Boolean.TYPE, Boolean.class);
        boxes.put(Byte.TYPE, Byte.class);
        boxes.put(Character.TYPE, Character.class);
        boxes.put(Short.TYPE, Short.class);
        boxes.put(Integer.TYPE, Integer.class);
        boxes.put(Long.TYPE, Long.class);
        boxes.put(Float.TYPE, Float.class);
        boxes.put(Double.TYPE, Double.class);
    }

    protected static class Builder<T> {
        public final Class<T> cls;
        protected Iterable<String> ctor_params;
        protected Constructor<T> constructor;
        protected boolean use_ctor;
        protected final Map<String, String> props = new LinkedHashMap<String, String>();

        public Builder(Class<T> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.cls = c;
        }

        public Builder<T> addMethod(String property, String method_name) {
            this.props.put(property, method_name);
            return this;
        }

        public Builder<T> addField(String field) {
            this.props.put(field, null);
            return this;
        }

        public Builder<T> addMethods(Map<String, String> properties) {
            this.props.putAll(properties);
            return this;
        }

        public Builder<T> addFields(Collection<String> fields) {
            for (String field : fields) {
                this.props.put(field, null);
            }
            return this;
        }

        public Builder<T> addFields(String ... fields) {
            for (String field : fields) {
                this.props.put(field, null);
            }
            return this;
        }

        public Builder<T> setConstructor(Constructor<T> ctor) {
            this.use_ctor = true;
            this.constructor = ctor;
            return this;
        }

        public Builder<T> setCtorParams(Iterable<String> params) {
            this.use_ctor = false;
            this.ctor_params = params;
            return this;
        }

        public ObjectBlueprint<T> build() throws NoSuchFieldException, NoSuchMethodException {
            if (this.use_ctor) {
                return new ObjectBlueprint<T>(this.cls, this.props, this.constructor);
            }
            return new ObjectBlueprint<T>(this.cls, this.props, this.ctor_params);
        }
    }
}

