/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.io;

import freenet.keys.FreenetURI;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.yaml.snakeyaml.Dumper;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;
import plugins.Library.index.TermEntry;
import plugins.Library.index.TermIndexEntry;
import plugins.Library.index.TermPageEntry;
import plugins.Library.index.TermTermEntry;
import plugins.Library.io.DataFormatException;
import plugins.Library.io.ObjectBlueprint;
import plugins.Library.io.ObjectStreamReader;
import plugins.Library.io.ObjectStreamWriter;
import plugins.Library.io.serial.Packer;

public class YamlReaderWriter
implements ObjectStreamReader,
ObjectStreamWriter {
    public static final String MIME_TYPE = "text/yaml";
    public static final String FILE_EXTENSION = ".yml";
    static final int MAX_PARALLEL = 1;
    static final Semaphore parallelLimiter = new Semaphore(1);
    public static final ObjectBlueprint<TermTermEntry> tebp_term;
    public static final ObjectBlueprint<TermIndexEntry> tebp_index;
    public static final ObjectBlueprint<TermPageEntry> tebp_page;

    public Object readObject(InputStream is) throws IOException {
        parallelLimiter.acquireUninterruptibly();
        try {
            Object object = this.makeYAML().load(new InputStreamReader(is, "UTF-8"));
            return object;
        }
        catch (YAMLException e) {
            throw new DataFormatException("Yaml could not process the stream: " + is, e, is, null, null);
        }
        finally {
            parallelLimiter.release();
        }
    }

    public void writeObject(Object o, OutputStream os) throws IOException {
        parallelLimiter.acquireUninterruptibly();
        try {
            this.makeYAML().dump(o, new OutputStreamWriter(os, "UTF-8"));
        }
        catch (YAMLException e) {
            throw new DataFormatException("Yaml could not process the object", e, o, null, null);
        }
        finally {
            parallelLimiter.release();
        }
    }

    private Yaml makeYAML() {
        DumperOptions opt = new DumperOptions();
        opt.setWidth(Integer.MAX_VALUE);
        opt.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml(new Loader(new ExtendedConstructor()), new Dumper(new ExtendedRepresenter(), opt));
    }

    static {
        try {
            tebp_term = new ObjectBlueprint<TermTermEntry>(TermTermEntry.class, Arrays.asList("subj", "rel", "term"));
            tebp_index = new ObjectBlueprint<TermIndexEntry>(TermIndexEntry.class, Arrays.asList("subj", "rel", "index"));
            tebp_page = new ObjectBlueprint<TermPageEntry>(TermPageEntry.class, Arrays.asList("subj", "rel", "page", "title", "positions", "posFragments"));
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static class ConstructorException
    extends org.yaml.snakeyaml.constructor.ConstructorException {
        public ConstructorException(String context, Mark contextMark, String problem, Mark problemMark) {
            super(context, contextMark, problem, problemMark);
        }

        public ConstructorException(String context, Mark contextMark, String problem, Mark problemMark, Throwable cause) {
            super(context, contextMark, problem, problemMark, cause);
        }
    }

    public static class ExtendedConstructor
    extends Constructor {
        public ExtendedConstructor() {
            this.yamlConstructors.put("!FreenetURI", new AbstractConstruct(){

                @Override
                public Object construct(Node node) {
                    String uri = (String)ExtendedConstructor.this.constructScalar((ScalarNode)node);
                    try {
                        return new FreenetURI(uri);
                    }
                    catch (MalformedURLException e) {
                        throw new ConstructorException("while constructing a FreenetURI", node.getStartMark(), "found malformed URI " + uri, null);
                    }
                }
            });
            this.yamlConstructors.put("!BinInfo", new AbstractConstruct(){

                @Override
                public Object construct(Node node) {
                    Map map = ExtendedConstructor.this.constructMapping((MappingNode)node);
                    if (map.size() != 1) {
                        throw new ConstructorException("while constructing a Packer.BinInfo", node.getStartMark(), "found incorrectly sized map data " + map, null);
                    }
                    Iterator i$ = map.entrySet().iterator();
                    if (i$.hasNext()) {
                        Map.Entry en = i$.next();
                        return new Packer.BinInfo(en.getKey(), (Integer)en.getValue());
                    }
                    throw new AssertionError();
                }
            });
            this.yamlConstructors.put("!TermTermEntry", new ConstructTermEntry<TermTermEntry>(tebp_term));
            this.yamlConstructors.put("!TermIndexEntry", new ConstructTermEntry<TermIndexEntry>(tebp_index));
            this.yamlConstructors.put("!TermPageEntry", new ConstructTermEntry<TermPageEntry>(tebp_page));
        }

        public class ConstructTermEntry<T extends TermEntry>
        extends AbstractConstruct {
            final ObjectBlueprint<T> blueprint;

            public ConstructTermEntry(ObjectBlueprint<T> bp) {
                this.blueprint = bp;
            }

            @Override
            public Object construct(Node node) {
                Map map = ExtendedConstructor.this.constructMapping((MappingNode)node);
                map.put("rel", new Float(((Double)map.get("rel")).floatValue()));
                try {
                    return this.blueprint.objectFromMap(map);
                }
                catch (Exception e) {
                    throw new ConstructorException("while constructing a " + this.blueprint.getObjectClass().getSimpleName(), node.getStartMark(), "could not instantiate map " + map, null, e);
                }
            }
        }
    }

    public static class ExtendedRepresenter
    extends Representer {
        public ExtendedRepresenter() {
            this.representers.put(FreenetURI.class, new Represent(){

                @Override
                public Node representData(Object data) {
                    return ExtendedRepresenter.this.representScalar("!FreenetURI", ((FreenetURI)data).toString());
                }
            });
            this.representers.put(Packer.BinInfo.class, new Represent(){

                @Override
                public Node representData(Object data) {
                    Packer.BinInfo inf = (Packer.BinInfo)data;
                    Map<Object, Integer> map = Collections.singletonMap(inf.getID(), inf.getWeight());
                    return ExtendedRepresenter.this.representMapping("!BinInfo", map, true);
                }
            });
            this.representers.put(TermTermEntry.class, new RepresentTermEntry<TermTermEntry>(tebp_term));
            this.representers.put(TermIndexEntry.class, new RepresentTermEntry<TermIndexEntry>(tebp_index));
            this.representers.put(TermPageEntry.class, new RepresentTermEntry<TermPageEntry>(tebp_page));
        }

        public class RepresentTermEntry<T extends TermEntry>
        implements Represent {
            final ObjectBlueprint<T> blueprint;
            final String tag;

            public RepresentTermEntry(ObjectBlueprint<T> bp) {
                this.blueprint = bp;
                this.tag = "!" + bp.getObjectClass().getSimpleName();
            }

            @Override
            public Node representData(Object data) {
                return ExtendedRepresenter.this.representMapping(this.tag, this.blueprint.objectAsMap((TermEntry)data), true);
            }
        }
    }
}

