/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.io.serial;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import plugins.Library.io.serial.IterableSerialiser;
import plugins.Library.io.serial.LiveArchiver;
import plugins.Library.io.serial.ProgressTracker;
import plugins.Library.io.serial.ScheduledSerialiser;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.util.TaskAbortExceptionConvertor;
import plugins.Library.util.concurrent.Executors;
import plugins.Library.util.concurrent.ObjectProcessor;
import plugins.Library.util.exec.Progress;
import plugins.Library.util.exec.TaskAbortException;
import plugins.Library.util.exec.TaskCompleteException;
import plugins.Library.util.exec.TaskInProgressException;
import plugins.Library.util.func.SafeClosure;
import plugins.Library.util.func.Tuples;

public abstract class ParallelSerialiser<T, P extends Progress>
implements IterableSerialiser<T>,
ScheduledSerialiser<T>,
LiveArchiver<T, P>,
Serialiser.Trackable<T> {
    protected static final ThreadPoolExecutor exec = new ThreadPoolExecutor(0, 64, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    protected final ProgressTracker<T, P> tracker;

    public ParallelSerialiser(ProgressTracker<T, P> k) {
        if (k == null) {
            throw new IllegalArgumentException("ParallelSerialiser must have a progress tracker.");
        }
        this.tracker = k;
    }

    @Override
    public ProgressTracker<T, ? extends Progress> getTracker() {
        return this.tracker;
    }

    protected <K extends Serialiser.Task> Runnable createJoinRunnable(final K task, final TaskInProgressException e, final SafeClosure<Tuples.X2<K, TaskAbortException>> post) {
        return new Runnable(){

            @Override
            public void run() {
                TaskAbortException ex;
                try {
                    Progress p = e.getProgress();
                    p.join();
                    ex = new TaskCompleteException("Task complete: " + p.getSubject());
                }
                catch (InterruptedException e2) {
                    ex = new TaskAbortException("Progress join was interrupted", e2, true);
                }
                catch (RuntimeException e3) {
                    ex = new TaskAbortException("failed", e3);
                }
                catch (TaskAbortException a) {
                    ex = a;
                }
                if (post != null) {
                    post.invoke(Tuples.X2(task, ex));
                }
            }
        };
    }

    protected Runnable createPullJob(final Serialiser.PullTask<T> task, SafeClosure<Tuples.X2<Serialiser.PullTask<T>, TaskAbortException>> post) {
        try {
            P prog = post != null ? this.tracker.addPullProgress(task) : this.tracker.getPullProgress(task);
            return new Runnable((Progress)prog, post){
                final /* synthetic */ Progress val$prog;
                final /* synthetic */ SafeClosure val$post;
                {
                    this.val$prog = progress;
                    this.val$post = safeClosure;
                }

                @Override
                public void run() {
                    TaskAbortException ex = null;
                    try {
                        ParallelSerialiser.this.pullLive(task, this.val$prog);
                    }
                    catch (RuntimeException e) {
                        ex = new TaskAbortException("failed", e);
                    }
                    catch (TaskAbortException e) {
                        ex = e;
                    }
                    if (this.val$post != null) {
                        this.val$post.invoke(Tuples.X2(task, ex));
                    }
                }
            };
        }
        catch (TaskInProgressException e) {
            return this.createJoinRunnable(task, e, post);
        }
    }

    protected Runnable createPushJob(final Serialiser.PushTask<T> task, SafeClosure<Tuples.X2<Serialiser.PushTask<T>, TaskAbortException>> post) {
        try {
            P prog = post != null ? this.tracker.addPushProgress(task) : this.tracker.getPushProgress(task);
            return new Runnable((Progress)prog, post){
                final /* synthetic */ Progress val$prog;
                final /* synthetic */ SafeClosure val$post;
                {
                    this.val$prog = progress;
                    this.val$post = safeClosure;
                }

                @Override
                public void run() {
                    TaskAbortException ex = null;
                    try {
                        ParallelSerialiser.this.pushLive(task, this.val$prog);
                    }
                    catch (RuntimeException e) {
                        ex = new TaskAbortException("failed", e);
                    }
                    catch (TaskAbortException e) {
                        ex = e;
                    }
                    if (this.val$post != null) {
                        this.val$post.invoke(Tuples.X2(task, ex));
                    }
                }
            };
        }
        catch (TaskInProgressException e) {
            return this.createJoinRunnable(task, e, post);
        }
    }

    @Override
    public void pull(Serialiser.PullTask<T> task) throws TaskAbortException {
        try {
            try {
                P p = this.tracker.addPullProgress(task);
                exec.execute(this.createPullJob(task, null));
                p.join();
            }
            catch (TaskInProgressException e) {
                throw e.join();
            }
        }
        catch (InterruptedException e) {
            throw new TaskAbortException("Task pull was interrupted", e, true);
        }
    }

    @Override
    public void push(Serialiser.PushTask<T> task) throws TaskAbortException {
        try {
            try {
                P p = this.tracker.addPushProgress(task);
                exec.execute(this.createPushJob(task, null));
                p.join();
            }
            catch (TaskInProgressException e) {
                throw e.join();
            }
        }
        catch (InterruptedException e) {
            throw new TaskAbortException("Task push was interrupted", e, true);
        }
    }

    @Override
    public void pull(Iterable<Serialiser.PullTask<T>> tasks) throws TaskAbortException {
        ArrayList<Object> progs = new ArrayList<Object>();
        try {
            Iterator<Serialiser.PullTask<T>> it = tasks.iterator();
            while (it.hasNext()) {
                Serialiser.PullTask<T> pullTask = it.next();
                try {
                    progs.add(this.tracker.addPullProgress(pullTask));
                    exec.execute(this.createPullJob(pullTask, null));
                }
                catch (TaskInProgressException e) {
                    it.remove();
                    progs.add(e.getProgress());
                }
            }
            for (Progress progress : progs) {
                progress.join();
            }
        }
        catch (InterruptedException e) {
            throw new TaskAbortException("ParallelSerialiser pull was interrupted", e, true);
        }
    }

    @Override
    public void push(Iterable<Serialiser.PushTask<T>> tasks) throws TaskAbortException {
        ArrayList<Object> progs = new ArrayList<Object>();
        try {
            Iterator<Serialiser.PushTask<T>> it = tasks.iterator();
            while (it.hasNext()) {
                Serialiser.PushTask<T> pushTask = it.next();
                try {
                    progs.add(this.tracker.addPushProgress(pushTask));
                    exec.execute(this.createPushJob(pushTask, null));
                }
                catch (TaskInProgressException e) {
                    it.remove();
                    progs.add(e.getProgress());
                }
            }
            for (Progress progress : progs) {
                progress.join();
            }
        }
        catch (InterruptedException e) {
            throw new TaskAbortException("ParallelSerialiser pull was interrupted", e, true);
        }
    }

    @Override
    public <E> ObjectProcessor<Serialiser.PullTask<T>, E, TaskAbortException> pullSchedule(BlockingQueue<Serialiser.PullTask<T>> input, BlockingQueue<Tuples.X2<Serialiser.PullTask<T>, TaskAbortException>> output, Map<Serialiser.PullTask<T>, E> deposit) {
        return new ObjectProcessor<Serialiser.PullTask<T>, E, TaskAbortException>(input, output, deposit, null, Executors.DEFAULT_EXECUTOR, new TaskAbortExceptionConvertor()){

            @Override
            protected Runnable createJobFor(Serialiser.PullTask<T> task) {
                return ParallelSerialiser.this.createPullJob(task, this.postProcess);
            }
        }.autostart();
    }

    @Override
    public <E> ObjectProcessor<Serialiser.PushTask<T>, E, TaskAbortException> pushSchedule(BlockingQueue<Serialiser.PushTask<T>> input, BlockingQueue<Tuples.X2<Serialiser.PushTask<T>, TaskAbortException>> output, Map<Serialiser.PushTask<T>, E> deposit) {
        return new ObjectProcessor<Serialiser.PushTask<T>, E, TaskAbortException>(input, output, deposit, null, Executors.DEFAULT_EXECUTOR, new TaskAbortExceptionConvertor()){

            @Override
            protected Runnable createJobFor(Serialiser.PushTask<T> task) {
                return ParallelSerialiser.this.createPushJob(task, this.postProcess);
            }
        }.autostart();
    }
}

