/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.io.serial;

import plugins.Library.io.serial.ProgressTracker;
import plugins.Library.io.serial.Translator;
import plugins.Library.util.exec.Progress;

public interface Serialiser<T> {

    public static interface Composite<S extends Serialiser<?>> {
        public S getChildSerialiser();
    }

    public static interface Translate<T, I>
    extends Serialiser<T> {
        public Translator<T, I> getTranslator();
    }

    public static interface Trackable<T>
    extends Serialiser<T> {
        public ProgressTracker<T, ? extends Progress> getTracker();
    }

    public static final class PushTask<T>
    extends Task<T> {
        public PushTask(T d) {
            if (d == null) {
                throw new IllegalArgumentException("Cowardly refusing to make a PushTask with null data.");
            }
            this.data = d;
        }

        public PushTask(T d, Object m) {
            if (d == null && m == null) {
                throw new IllegalArgumentException("Cowardly refusing to make a PushTask with null data.");
            }
            this.data = d;
            this.meta = m;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PushTask)) {
                return false;
            }
            return this.data == ((PushTask)o).data;
        }

        public int hashCode() {
            return System.identityHashCode(this.data);
        }
    }

    public static final class PullTask<T>
    extends Task<T> {
        public PullTask(Object m) {
            if (m == null) {
                throw new IllegalArgumentException("Cowardly refusing to make a PullTask with null metadata.");
            }
            this.meta = m;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PullTask)) {
                return false;
            }
            return this.meta == ((PullTask)o).meta;
        }

        public int hashCode() {
            return System.identityHashCode(this.meta);
        }
    }

    public static abstract class Task<T> {
        public Object meta = null;
        public T data = null;
    }
}

