/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import plugins.Library.util.CompositeIterable;
import plugins.Library.util.Integers;
import plugins.Library.util.Sorted;
import plugins.Library.util.func.Tuples;

public class BTreeMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
SortedMap<K, V> {
    public final int NODE_MIN;
    public final int NODE_MAX;
    public final int ENT_MIN;
    public final int ENT_MAX;
    protected final Comparator<? super K> comparator;
    protected Node root = this.newNode(null, null, true);
    protected int size = 0;
    private Set<Map.Entry<K, V>> entrySet = null;

    public BTreeMap(Comparator<? super K> cmp, int node_min) {
        if (node_min < 2) {
            throw new IllegalArgumentException("The minimum number of subnodes must be set to at least 2");
        }
        this.comparator = cmp;
        this.NODE_MIN = node_min;
        this.NODE_MAX = node_min << 1;
        this.ENT_MIN = this.NODE_MIN - 1;
        this.ENT_MAX = this.NODE_MAX - 1;
    }

    public BTreeMap(int node_min) {
        this(null, node_min);
    }

    public static <K> SortedSet<K> subSet(SortedSet<K> set, K lk, K rk) {
        SortedSet<K> ss;
        if (lk == null) {
            return rk == null ? set : set.headSet(rk);
        }
        SortedSet<K> sortedSet = ss = rk == null ? set.tailSet(lk) : set.subSet(lk, rk);
        if (ss.isEmpty() || !BTreeMap.compare0(ss.first(), lk, set.comparator())) {
            return ss;
        }
        K k2 = Sorted.higher(ss, lk);
        return k2 == null ? ss.headSet(lk) : ss.tailSet(k2);
    }

    public String toTreeString() {
        return this.root.toTreeString("");
    }

    public static final <K> int compare(K key1, K key2, Comparator<? super K> comparator) {
        return comparator != null ? comparator.compare(key1, key2) : ((Comparable)key1).compareTo(key2);
    }

    protected int compare(K key1, K key2) {
        return BTreeMap.compare(key1, key2, this.comparator);
    }

    public static final <K> boolean compare0(K key1, K key2, Comparator<? super K> comparator) {
        return key1 == null ? key2 == null : (key2 == null ? false : (comparator != null ? comparator.compare(key1, key2) : ((Comparable)key1).compareTo(key2)) == 0);
    }

    protected boolean compare0(K key1, K key2) {
        return BTreeMap.compare0(key1, key2, this.comparator);
    }

    protected int compareL(K lkey1, K lkey2) {
        return lkey1 == null ? (lkey2 == null ? 0 : -1) : (lkey2 == null ? 1 : BTreeMap.compare(lkey1, lkey2, this.comparator));
    }

    protected int compareR(K rkey1, K rkey2) {
        return rkey2 == null ? (rkey1 == null ? 0 : -1) : (rkey1 == null ? 1 : BTreeMap.compare(rkey1, rkey2, this.comparator));
    }

    static final void verify(boolean b) {
        if (!b) {
            throw new IllegalStateException("Verification failed");
        }
    }

    final void verifyNodeIntegrity(Node node) {
        if (node.entries.isEmpty()) {
            BTreeMap.verify(node.lkey == null && node.rkey == null);
            BTreeMap.verify(node.isLeaf() && node.rnodes == null && node.lnodes == null);
            return;
        }
        BTreeMap.verify(this.compareL(node.lkey, node.entries.firstKey()) < 0);
        BTreeMap.verify(this.compareR(node.entries.lastKey(), node.rkey) < 0);
        int s = node.nodeSize();
        if (!node.isLeaf()) {
            Iterator it = node.entries.keySet().iterator();
            BTreeMap.verify(it.hasNext());
            Object prev = node.lkey;
            Object curr = it.next();
            while (curr != node.rkey || prev != node.rkey) {
                Node node1 = node.rnodes.get(prev);
                BTreeMap.verify(node1 != null);
                s += node1.totalSize();
                BTreeMap.verify(this.compare0(curr, node1.rkey));
                Node node2 = node.lnodes.get(curr);
                BTreeMap.verify(node1 == node2 && this.compare0(node2.lkey, prev));
                prev = curr;
                curr = it.hasNext() ? it.next() : node.rkey;
            }
            BTreeMap.verify(node.nodeSize() + 1 == node.rnodes.size());
            BTreeMap.verify(node.nodeSize() + 1 == node.lnodes.size());
        }
        BTreeMap.verify(node._size < 0 || node._size == s);
        BTreeMap.verify(node.nodeSize() <= this.ENT_MAX);
        BTreeMap.verify(node.lkey == null && node.rkey == null && node.nodeSize() >= 1 || node.nodeSize() >= this.ENT_MIN);
    }

    final int verifyTreeIntegrity(Node node) {
        this.verifyNodeIntegrity(node);
        if (node.isLeaf()) {
            return 0;
        }
        int depth = -1;
        for (Node n : node.lnodes.values()) {
            int d = this.verifyTreeIntegrity(n);
            if (depth < 0) {
                depth = d;
            }
            BTreeMap.verify(d == depth);
        }
        return depth + 1;
    }

    final void verifyTreeIntegrity() {
        this.verifyTreeIntegrity(this.root);
    }

    protected Node newNode(K lk, K rk, boolean lf) {
        return new Node(lk, rk, lf);
    }

    protected void swapKey(K key, Node src, Node dst) {
        Object val = src.entries.remove(key);
        dst.entries.put(key, val);
    }

    private K split(Node parent, Node child) {
        Object mkey;
        assert (child.nodeSize() == this.ENT_MAX);
        assert (parent != null ? parent.nodeSize() < this.ENT_MAX && !parent.isLeaf() && parent.rnodes.get(child.lkey) == child && parent.lnodes.get(child.rkey) == child : child.lkey == null && child.rkey == null);
        if (parent == null) {
            parent = this.root = this.newNode(null, null, false);
            parent.addChildNode(child);
        }
        child._size = -1;
        parent._size = -1;
        Node lnode = this.newNode(null, null, child.isLeaf());
        if (child.isLeaf()) {
            Iterator it = child.entries.entrySet().iterator();
            for (int i = 0; i < this.ENT_MIN; ++i) {
                Map.Entry entry = it.next();
                it.remove();
                Object key = entry.getKey();
                lnode.entries.put(key, entry.getValue());
            }
            Map.Entry median = it.next();
            it.remove();
            mkey = median.getKey();
            lnode.lkey = child.lkey;
            child.lkey = mkey;
            lnode.rkey = child.lkey;
            parent.rnodes.put(lnode.lkey, lnode);
            parent.lnodes.put(child.rkey, child);
            parent.entries.put(mkey, median.getValue());
            parent.rnodes.put(mkey, child);
            parent.lnodes.put(mkey, lnode);
        } else {
            lnode.rnodes.put(child.lkey, child.rnodes.remove(child.lkey));
            Iterator it = child.entries.entrySet().iterator();
            for (int i = 0; i < this.ENT_MIN; ++i) {
                Map.Entry entry = it.next();
                it.remove();
                Object key = entry.getKey();
                lnode.entries.put(key, entry.getValue());
                lnode.lnodes.put(key, child.lnodes.remove(key));
                lnode.rnodes.put(key, child.rnodes.remove(key));
            }
            Map.Entry median = it.next();
            it.remove();
            mkey = median.getKey();
            lnode.lnodes.put(mkey, child.lnodes.remove(mkey));
            lnode.lkey = child.lkey;
            child.lkey = mkey;
            lnode.rkey = child.lkey;
            parent.rnodes.put(lnode.lkey, lnode);
            parent.lnodes.put(child.rkey, child);
            parent.entries.put(mkey, median.getValue());
            parent.rnodes.put(mkey, child);
            parent.lnodes.put(mkey, lnode);
        }
        assert (parent.rnodes.get(mkey) == child);
        assert (parent.lnodes.get(mkey) == lnode);
        return mkey;
    }

    private K merge(Node parent, Node lnode, Node rnode) {
        assert (this.compare(lnode.rkey, rnode.lkey) == 0);
        assert (lnode.isLeaf() && rnode.isLeaf() || !lnode.isLeaf() && !rnode.isLeaf());
        assert (lnode.nodeSize() == this.ENT_MIN);
        assert (rnode.nodeSize() == this.ENT_MIN);
        assert (parent == this.root && parent.nodeSize() > 0 || parent.nodeSize() > this.ENT_MIN);
        assert (!parent.isLeaf() && parent.rnodes.get(lnode.rkey) == rnode && parent.lnodes.get(rnode.lkey) == lnode);
        rnode._size = -1;
        lnode._size = -1;
        parent._size = -1;
        Object mkey = rnode.lkey;
        if (rnode.isLeaf()) {
            rnode.entries.putAll(lnode.entries);
            rnode.entries.put(mkey, parent.entries.remove(mkey));
            rnode.lkey = lnode.lkey;
            parent.rnodes.remove(mkey);
            parent.lnodes.remove(mkey);
            parent.rnodes.put(lnode.lkey, rnode);
        } else {
            rnode.entries.putAll(lnode.entries);
            rnode.lnodes.putAll(lnode.lnodes);
            rnode.rnodes.putAll(lnode.rnodes);
            rnode.entries.put(mkey, parent.entries.remove(mkey));
            rnode.lnodes.put(mkey, lnode.lnodes.get(mkey));
            rnode.rnodes.put(lnode.lkey, lnode.rnodes.get(lnode.lkey));
            rnode.lkey = lnode.lkey;
            parent.rnodes.remove(mkey);
            parent.lnodes.remove(mkey);
            parent.rnodes.put(lnode.lkey, rnode);
        }
        if (parent == this.root && parent.entries.isEmpty()) {
            assert (parent.lkey == null && parent.rkey == null && rnode.lkey == null && rnode.rkey == null);
            this.root = rnode;
        }
        assert (parent.rnodes.get(rnode.lkey) == rnode);
        assert (parent.lnodes.get(rnode.rkey) == rnode);
        return mkey;
    }

    private K rotateL(Node parent, Node lnode, Node rnode) {
        assert (this.compare(lnode.rkey, rnode.lkey) == 0);
        assert (lnode.isLeaf() && rnode.isLeaf() || !lnode.isLeaf() && !rnode.isLeaf());
        assert (rnode.nodeSize() >= lnode.nodeSize());
        assert (rnode.nodeSize() > this.ENT_MIN);
        assert (!parent.isLeaf() && parent.rnodes.get(lnode.rkey) == rnode && parent.lnodes.get(rnode.lkey) == lnode);
        rnode._size = -1;
        lnode._size = -1;
        parent._size = -1;
        Object mkey = rnode.lkey;
        Object skey = rnode.entries.firstKey();
        lnode.entries.put(mkey, parent.entries.remove(mkey));
        parent.entries.put(skey, rnode.entries.remove(skey));
        parent.rnodes.put(skey, parent.rnodes.remove(mkey));
        parent.lnodes.put(skey, parent.lnodes.remove(mkey));
        rnode.lkey = skey;
        lnode.rkey = rnode.lkey;
        if (!lnode.isLeaf()) {
            lnode.rnodes.put(mkey, rnode.rnodes.remove(mkey));
            lnode.lnodes.put(skey, rnode.lnodes.remove(skey));
        }
        assert (parent.rnodes.get(skey) == rnode);
        assert (parent.lnodes.get(skey) == lnode);
        return mkey;
    }

    private K rotateR(Node parent, Node lnode, Node rnode) {
        assert (this.compare(lnode.rkey, rnode.lkey) == 0);
        assert (lnode.isLeaf() && rnode.isLeaf() || !lnode.isLeaf() && !rnode.isLeaf());
        assert (lnode.nodeSize() >= rnode.nodeSize());
        assert (lnode.nodeSize() > this.ENT_MIN);
        assert (!parent.isLeaf() && parent.rnodes.get(lnode.rkey) == rnode && parent.lnodes.get(rnode.lkey) == lnode);
        rnode._size = -1;
        lnode._size = -1;
        parent._size = -1;
        Object mkey = lnode.rkey;
        Object skey = lnode.entries.lastKey();
        rnode.entries.put(mkey, parent.entries.remove(mkey));
        parent.entries.put(skey, lnode.entries.remove(skey));
        parent.lnodes.put(skey, parent.lnodes.remove(mkey));
        parent.rnodes.put(skey, parent.rnodes.remove(mkey));
        rnode.lkey = skey;
        lnode.rkey = rnode.lkey;
        if (!rnode.isLeaf()) {
            rnode.lnodes.put(mkey, lnode.lnodes.remove(mkey));
            rnode.rnodes.put(skey, lnode.rnodes.remove(skey));
        }
        assert (parent.rnodes.get(skey) == rnode);
        assert (parent.lnodes.get(skey) == lnode);
        return mkey;
    }

    public int sizeRoot() {
        return this.root.nodeSize();
    }

    public int nodeMin() {
        return this.NODE_MIN;
    }

    public int entMax() {
        return this.ENT_MAX;
    }

    public int heightEstimate() {
        return 1 + this.size == 0 ? 0 : (int)Math.floor(Math.log(this.size) / Math.log(this.NODE_MIN));
    }

    public int minNodesFor(int entries) {
        return entries / this.NODE_MAX + 1;
    }

    public int minKeysFor(int entries) {
        return entries / this.NODE_MAX;
    }

    public Map.Entry<K, V> getEntry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index outside of range [0," + this.size + ")");
        }
        int current = 0;
        Node node = this.root;
        while (true) {
            if (node.isLeaf()) {
                for (Map.Entry en : node.entries.entrySet()) {
                    if (current == index) {
                        return en;
                    }
                    ++current;
                }
                throw new IllegalStateException("BTreeMap getKey method is buggy, please report.");
            }
            Node nextnode = node.rnodes.get(node.lkey);
            int next = current + nextnode.totalSize();
            if (index < next) {
                node = nextnode;
                continue;
            }
            current = next;
            for (Map.Entry en : node.entries.entrySet()) {
                if (current == index) {
                    return en;
                }
                nextnode = node.rnodes.get(en.getKey());
                if (index < (next = ++current + nextnode.totalSize())) {
                    node = nextnode;
                    break;
                }
                current = next;
            }
            if (!$assertionsDisabled && current > index) break;
        }
        throw new AssertionError();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.root = this.newNode(null, null, true);
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object k) {
        Object key = k;
        Node node = this.root;
        while (!node.isLeaf()) {
            Node nextnode = node.selectNode(key);
            if (nextnode == null) {
                return true;
            }
            node = nextnode;
        }
        return node.entries.containsKey(key);
    }

    @Override
    public V get(Object k) {
        Object key = k;
        Node node = this.root;
        while (!node.isLeaf()) {
            Node nextnode = node.selectNode(key);
            if (nextnode == null) {
                return node.entries.get(key);
            }
            node = nextnode;
        }
        return node.entries.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new UnsupportedOperationException("Sorry, this BTreeMap implementation can't handle null keys, even if the comparator supports it.");
        }
        Node node = this.root;
        Node parent = null;
        while (true) {
            node._size = -1;
            if (node.nodeSize() == this.ENT_MAX) {
                K median = this.split(parent, node);
                if (parent == null) {
                    parent = this.root;
                }
                if ((node = parent.selectNode(key)) == null) {
                    return parent.entries.put(key, value);
                }
            }
            assert (node.nodeSize() < this.ENT_MAX);
            if (node.isLeaf()) {
                int sz = node.nodeSize();
                V v = node.entries.put(key, value);
                if (node.nodeSize() != sz) {
                    ++this.size;
                }
                return v;
            }
            Node nextnode = node.selectNode(key);
            if (nextnode == null) {
                return node.entries.put(key, value);
            }
            parent = node;
            node = nextnode;
        }
    }

    @Override
    public V remove(Object k) {
        Object key = k;
        Node node = this.root;
        Node parent = null;
        while (true) {
            node._size = -1;
            if (node != this.root && node.nodeSize() == this.ENT_MIN) {
                int R;
                Node lnode = parent.nodeL(node);
                Node rnode = parent.nodeR(node);
                int L = lnode == null ? -1 : lnode.nodeSize();
                int n = R = rnode == null ? -1 : rnode.nodeSize();
                K kk = L < 0 ? (R == this.ENT_MIN ? this.merge(parent, node, rnode) : this.rotateL(parent, node, rnode)) : (R < 0 ? (L == this.ENT_MIN ? this.merge(parent, lnode, node) : this.rotateR(parent, lnode, node)) : (R > L ? this.rotateL(parent, node, rnode) : (L > R ? this.rotateR(parent, lnode, node) : ((this.size & 1) == 1 ? (R == this.ENT_MIN ? this.merge(parent, node, rnode) : this.rotateL(parent, node, rnode)) : (L == this.ENT_MIN ? this.merge(parent, lnode, node) : this.rotateR(parent, lnode, node))))));
                node = parent.selectNode(key);
                assert (node != null);
            }
            assert (node == this.root || node.nodeSize() >= this.ENT_MIN);
            if (node.isLeaf()) {
                int sz = node.nodeSize();
                Object v = node.entries.remove(key);
                if (node.nodeSize() != sz) {
                    --this.size;
                }
                return v;
            }
            Node nextnode = node.selectNode(key);
            if (nextnode == null) {
                Node lnode = node.lnodes.get(key);
                Node rnode = node.rnodes.get(key);
                int L = lnode.nodeSize();
                int R = rnode.nodeSize();
                K kk = R > L ? this.rotateL(node, lnode, rnode) : (L > R ? this.rotateR(node, lnode, rnode) : ((this.size & 1) == 1 ? (R == this.ENT_MIN ? this.merge(node, lnode, rnode) : this.rotateL(node, lnode, rnode)) : (L == this.ENT_MIN ? this.merge(node, lnode, rnode) : this.rotateR(node, lnode, rnode))));
                nextnode = node.selectNode(key);
                assert (nextnode != null);
            }
            parent = node;
            node = nextnode;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        if (t.isEmpty()) {
            return;
        }
        if (t == this || this.isEmpty() && t instanceof SortedMap) {
            TreeMap map = (TreeMap)t;
            HashMap lnodes = null;
            if (!(this.comparator == null && map.comparator() == null || ((Object)this.comparator).equals(map.comparator()))) {
                super.putAll(map);
                return;
            }
            while (map.size() > 0) {
                int k = this.minNodesFor(map.size());
                HashMap nextlnodes = new HashMap(k << 1);
                TreeMap nextmap = new TreeMap(this.comparator);
                Iterator it = map.entrySet().iterator();
                Object prevkey = null;
                for (Integer n : Integers.allocateEvenly(map.size() - k + 1, k)) {
                    Map.Entry en = this.makeNode(it, n, prevkey, lnodes, nextlnodes);
                    if (en == null) continue;
                    prevkey = en.getKey();
                    nextmap.put(prevkey, en.getValue());
                }
                lnodes = nextlnodes;
                map = nextmap;
            }
            assert (lnodes.size() == 1);
            this.root = (Node)lnodes.get(null);
            this.size = map.size();
        } else {
            super.putAll(t);
        }
    }

    private Map.Entry<K, V> makeNode(Iterator<Map.Entry<K, V>> it, int n, K prevkey, Map<K, Node> lnodes, Map<K, Node> nextlnodes) {
        Object key;
        Map.Entry<K, V> next;
        K key2;
        Map.Entry<K, V> en;
        int i;
        Node node;
        if (lnodes == null) {
            node = this.newNode(prevkey, null, true);
            for (i = 0; i < n; ++i) {
                en = it.next();
                key2 = en.getKey();
                node.entries.put(key2, en.getValue());
                prevkey = key2;
            }
        } else {
            node = this.newNode(prevkey, null, false);
            for (i = 0; i < n; ++i) {
                en = it.next();
                key2 = en.getKey();
                node.entries.put(key2, en.getValue());
                Node subnode = lnodes.get(key2);
                node.rnodes.put(prevkey, subnode);
                node.lnodes.put(key2, subnode);
                prevkey = key2;
            }
        }
        if (it.hasNext()) {
            next = it.next();
            key = next.getKey();
        } else {
            next = null;
            key = null;
        }
        if (lnodes != null) {
            Node subnode = lnodes.get(key);
            node.rnodes.put(prevkey, subnode);
            node.lnodes.put(key, subnode);
        }
        node.rkey = key;
        nextlnodes.put(key, node);
        return next;
    }

    public void restructure() {
        this.putAll(this);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return BTreeMap.this.size();
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        Stack<Node> nodestack = new Stack();
                        Stack<Iterator<Map.Entry<K, V>>> itstack = new Stack();
                        Node cnode;
                        Iterator<Map.Entry<K, V>> centit;
                        K lastkey;
                        boolean removeok;
                        {
                            this.cnode = BTreeMap.this.root;
                            this.centit = this.cnode.entries.entrySet().iterator();
                            this.lastkey = null;
                            this.removeok = false;
                        }

                        @Override
                        public boolean hasNext() {
                            for (Iterator iterator : this.itstack) {
                                if (!iterator.hasNext()) continue;
                                return true;
                            }
                            if (this.centit.hasNext()) {
                                return true;
                            }
                            return !this.cnode.isLeaf();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.cnode.isLeaf()) {
                                while (!this.centit.hasNext()) {
                                    if (this.nodestack.empty()) {
                                        assert (this.itstack.empty());
                                        throw new NoSuchElementException();
                                    }
                                    this.cnode = this.nodestack.pop();
                                    this.centit = this.itstack.pop();
                                }
                            } else {
                                while (!this.cnode.isLeaf()) {
                                    Node testnode = this.cnode.rnodes.get(this.lastkey);
                                    testnode.isLeaf();
                                    this.nodestack.push(this.cnode);
                                    this.itstack.push(this.centit);
                                    this.cnode = testnode;
                                    this.centit = this.cnode.entries.entrySet().iterator();
                                }
                            }
                            Map.Entry next = this.centit.next();
                            this.lastkey = next.getKey();
                            this.removeok = true;
                            return next;
                        }

                        @Override
                        public void remove() {
                            if (!this.removeok) {
                                throw new IllegalStateException("Iteration has not yet begun, or the element has already been removed.");
                            }
                            BTreeMap.this.remove(this.lastkey);
                            this.nodestack.clear();
                            this.itstack.clear();
                            this.cnode = BTreeMap.this.root;
                            this.centit = this.cnode.entries.entrySet().iterator();
                            Object stopkey = null;
                            while (!this.cnode.isLeaf()) {
                                stopkey = this.findstopkey(stopkey);
                                this.nodestack.push(this.cnode);
                                this.itstack.push(this.centit);
                                this.cnode = this.cnode.rnodes.get(stopkey);
                                this.centit = this.cnode.entries.entrySet().iterator();
                            }
                            this.lastkey = this.findstopkey(stopkey);
                            this.removeok = false;
                        }

                        private K findstopkey(K stopkey) {
                            SortedMap headmap = this.cnode.entries.headMap(this.lastkey);
                            if (!headmap.isEmpty()) {
                                stopkey = headmap.lastKey();
                                while (BTreeMap.this.compare(this.centit.next().getKey(), stopkey) < 0) {
                                }
                            }
                            return stopkey;
                        }
                    };
                }

                @Override
                public void clear() {
                    BTreeMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Object value = BTreeMap.this.get(e.getKey());
                    return value != null && value.equals(e.getValue());
                }

                @Override
                public boolean remove(Object o) {
                    if (this.contains(o)) {
                        Map.Entry e = (Map.Entry)o;
                        BTreeMap.this.remove(e.getKey());
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        Node node = this.root;
        while (true) {
            Object fkey = node.entries.firstKey();
            if (node.isLeaf()) {
                return fkey;
            }
            node = node.lnodes.get(fkey);
        }
    }

    @Override
    public K lastKey() {
        Node node = this.root;
        while (true) {
            Object lkey = node.entries.lastKey();
            if (node.isLeaf()) {
                return lkey;
            }
            node = node.rnodes.get(lkey);
        }
    }

    @Override
    public SortedMap<K, V> headMap(K rkey) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public SortedMap<K, V> tailMap(K lkey) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public SortedMap<K, V> subMap(K lkey, K rkey) {
        throw new UnsupportedOperationException("not implemented");
    }

    protected class Node
    implements Comparable<Node> {
        protected final boolean isLeaf;
        protected final SortedMap<K, V> entries;
        protected final Map<K, Node> lnodes;
        protected final Map<K, Node> rnodes;
        protected K lkey;
        protected K rkey;
        transient int _size = -1;
        private transient Iterable<Tuples.X3<K, Node, K>> _iterNodesK;
        private transient Iterable<Node> _iterNodes;
        private transient Iterable<K> _iterKeys;
        private transient Iterable<K> _iterAllKeys;
        private transient Iterable<Tuples.X2<K, K>> _iterKeyPairs;

        protected Node(K lk, K rk, boolean lf, SortedMap<K, V> map) {
            this.lkey = lk;
            this.rkey = rk;
            this.isLeaf = lf;
            this.entries = map;
            this.lnodes = lf ? null : new HashMap(BTreeMap.this.NODE_MAX);
            this.rnodes = lf ? null : new HashMap(BTreeMap.this.NODE_MAX);
        }

        protected Node(K lk, K rk, boolean lf) {
            this(lk, rk, lf, new TreeMap(bTreeMap.comparator));
        }

        protected void addAll(SortedMap<K, V> ent, Iterable<? extends Node> nodes) {
            assert (ent.comparator() == BTreeMap.this.comparator());
            assert (ent.isEmpty() || BTreeMap.this.compareL(this.lkey, ent.firstKey()) < 0);
            assert (ent.isEmpty() || BTreeMap.this.compareR(ent.lastKey(), this.rkey) < 0);
            this.entries.putAll(ent);
            if (!this.isLeaf) {
                for (Node node : nodes) {
                    this.addChildNode(node);
                }
            }
        }

        public int childCount() {
            return this.rnodes == null ? 0 : this.rnodes.size();
        }

        public int nodeSize() {
            return this.entries.size();
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public boolean isGhost() {
            return this.entries == null;
        }

        protected int totalSize() {
            if (this._size < 0) {
                int s = this.nodeSize();
                if (!this.isLeaf()) {
                    for (Node n : this.lnodes.values()) {
                        s += n.totalSize();
                    }
                }
                this._size = s;
            }
            return this._size;
        }

        public Node nodeL(Node node) {
            assert (this.lnodes.get(node.rkey) == node && this.rnodes.get(node.lkey) == node);
            return BTreeMap.this.compare0(this.lkey, node.lkey) ? null : this.lnodes.get(node.lkey);
        }

        public Node nodeR(Node node) {
            assert (this.lnodes.get(node.rkey) == node && this.rnodes.get(node.lkey) == node);
            return BTreeMap.this.compare0(node.rkey, this.rkey) ? null : this.rnodes.get(node.rkey);
        }

        public Node selectNode(K key) {
            assert (BTreeMap.this.compareL(this.lkey, key) < 0 && BTreeMap.this.compareR(key, this.rkey) < 0);
            SortedMap tailmap = this.entries.tailMap(key);
            if (tailmap.isEmpty()) {
                return this.lnodes.get(this.rkey);
            }
            Object next = tailmap.firstKey();
            return BTreeMap.this.compare(key, next) == 0 ? null : this.lnodes.get(next);
        }

        protected void addChildNode(Node child) {
            assert (BTreeMap.this.compare0(this.rkey, child.rkey) || this.entries.containsKey(child.rkey));
            assert (BTreeMap.this.compare0(this.lkey, child.lkey) || this.entries.containsKey(child.lkey));
            assert (this.lnodes.get(child.rkey) == null);
            assert (this.rnodes.get(child.lkey) == null);
            this.lnodes.put(child.rkey, child);
            this.rnodes.put(child.lkey, child);
        }

        public Iterable<Tuples.X3<K, Node, K>> iterNodesK() {
            if (this._iterNodesK == null) {
                this._iterNodesK = new CompositeIterable<Tuples.X2<K, K>, Tuples.X3<K, Node, K>>(this.iterKeyPairs(), true){

                    @Override
                    protected Tuples.X3<K, Node, K> nextFor(Tuples.X2<K, K> kp) {
                        return new Tuples.X3(kp._0, Node.this.rnodes.get(kp._0), kp._1);
                    }
                };
            }
            return this._iterNodesK;
        }

        public Iterable<Node> iterNodes() {
            if (this._iterNodes == null) {
                this._iterNodes = new CompositeIterable<Node, Node>(this.rnodes.values(), true){

                    @Override
                    protected Node nextFor(Node n) {
                        return n;
                    }
                };
            }
            return this._iterNodes;
        }

        public Iterable<K> iterKeys() {
            if (this._iterKeys == null) {
                this._iterKeys = new CompositeIterable<K, K>(this.entries.keySet(), true){

                    @Override
                    protected K nextFor(K k) {
                        return k;
                    }
                };
            }
            return this._iterKeys;
        }

        public Iterable<K> iterAllKeys() {
            if (this._iterAllKeys == null) {
                this._iterAllKeys = new Iterable<K>(){

                    @Override
                    public Iterator<K> iterator() {
                        return new Iterator<K>(){
                            final Iterator<K> it;
                            byte stage;
                            {
                                this.it = Node.this.entries.keySet().iterator();
                                this.stage = 0;
                            }

                            @Override
                            public boolean hasNext() {
                                return this.stage < 2;
                            }

                            @Override
                            public K next() {
                                switch (this.stage) {
                                    case 0: {
                                        this.stage = 1;
                                        return Node.this.lkey;
                                    }
                                    case 1: {
                                        if (this.it.hasNext()) {
                                            return this.it.next();
                                        }
                                        this.stage = (byte)2;
                                        return Node.this.rkey;
                                    }
                                    case 2: {
                                        return this.it.next();
                                    }
                                }
                                throw new AssertionError();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }
            return this._iterAllKeys;
        }

        public Iterable<Tuples.X2<K, K>> iterKeyPairs() {
            if (this._iterKeyPairs == null) {
                this._iterKeyPairs = new Iterable<Tuples.X2<K, K>>(){

                    @Override
                    public Iterator<Tuples.X2<K, K>> iterator() {
                        return new Iterator<Tuples.X2<K, K>>(){
                            final Iterator<K> it;
                            K lastkey;
                            {
                                this.it = Node.this.entries.keySet().iterator();
                                this.lastkey = Node.this.lkey;
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it.hasNext() || this.lastkey != Node.this.rkey;
                            }

                            @Override
                            public Tuples.X2<K, K> next() {
                                Object rk = !this.it.hasNext() && this.lastkey != Node.this.rkey ? Node.this.rkey : this.it.next();
                                this.lastkey = rk;
                                return new Tuples.X2(this.lastkey, this.lastkey);
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }
            return this._iterKeyPairs;
        }

        protected Iterable<Node> iterNodes(K lk, K rk) {
            assert (lk == null || rk == null || BTreeMap.this.compare(lk, rk) < 0);
            if (this.isLeaf) {
                return null;
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            SortedSet skey = Sorted.keySet(this.subEntries(lk, rk));
            if (skey.isEmpty()) {
                return nodes;
            }
            for (Object key : skey) {
                nodes.add(this.lnodes.get(key));
            }
            nodes.add(this.rnodes.get(skey.last()));
            return nodes;
        }

        protected SortedMap<K, V> subEntries(K lk, K rk) {
            assert (lk == null || rk == null || BTreeMap.this.compare(lk, rk) < 0);
            if (BTreeMap.this.compare0(lk, this.lkey)) {
                return BTreeMap.this.compare0(rk, this.rkey) ? this.entries : this.entries.headMap(rk);
            }
            SortedSet tset = Sorted.keySet(this.entries).tailSet(lk);
            assert (!tset.isEmpty());
            if (tset.size() == 1) {
                return this.entries.subMap(lk, lk);
            }
            Object k2 = Sorted.higher(tset, lk);
            return BTreeMap.this.compare0(rk, this.rkey) ? this.entries.tailMap(k2) : this.entries.subMap(k2, rk);
        }

        protected void merge(K lk, Iterable<K> keys, K rk) {
            Iterator<Node> it = this.iterNodes(lk, rk).iterator();
            Node child = it.next();
            assert (child == this.rnodes.get(lk));
            for (Object k : keys) {
                child.entries.put(k, this.entries.remove(k));
            }
            while (it.hasNext()) {
                Node next = it.next();
                child.addAll(next.entries, next.isLeaf ? null : next.iterNodes());
            }
            child.rkey = rk;
        }

        protected void split(K lk, Iterable<K> keys, K rk) {
            Node child = this.rnodes.get(lk);
            assert (BTreeMap.this.compare0(child.rkey, rk));
            for (Object k : keys) {
                BTreeMap.this.swapKey(k, child, this);
            }
            this.lnodes.remove(rk);
            this.rnodes.remove(lk);
            for (Tuples.X2 x2 : new PairIterable(lk, keys, rk)) {
                Node newnode = BTreeMap.this.newNode(x2._0, x2._1, child.isLeaf);
                newnode.addAll(child.subEntries(x2._0, x2._1), child.iterNodes(x2._0, x2._1));
                this.addChildNode(newnode);
            }
        }

        @Override
        public int compareTo(Node n) {
            int b = BTreeMap.this.compareR(this.rkey, n.rkey);
            return b == 0 ? BTreeMap.this.compareL(n.lkey, this.lkey) : b;
        }

        public String toTreeString(String istr) {
            String nistr = istr + "\t";
            StringBuilder s = new StringBuilder();
            s.append(istr).append('(').append(this.lkey).append(')').append('\n');
            if (this.isLeaf) {
                for (Map.Entry en : this.entries.entrySet()) {
                    s.append(istr).append(en.getKey()).append(" : ").append(en.getValue()).append('\n');
                }
            } else {
                s.append(this.rnodes.get(this.lkey).toTreeString(nistr));
                for (Map.Entry en : this.entries.entrySet()) {
                    s.append(istr).append(en.getKey()).append(" : ").append(en.getValue()).append('\n');
                    s.append(this.rnodes.get(en.getKey()).toTreeString(nistr));
                }
            }
            s.append(istr).append('(').append(this.rkey).append(')').append('\n');
            return s.toString();
        }

        public String getName() {
            return "BTreeMap node " + this.getRange();
        }

        public String getRange() {
            return (this.lkey == null ? "*" : this.lkey) + "-" + (this.rkey == null ? "*" : this.rkey);
        }
    }

    public static class PairIterable<E>
    implements Iterable<Tuples.X2<E, E>> {
        protected final E lobj;
        protected final E robj;
        protected final Iterable<E> ib;

        public PairIterable(E lo, Iterable<E> objs, E ro) {
            this.lobj = lo;
            this.ib = objs;
            this.robj = ro;
        }

        @Override
        public Iterator<Tuples.X2<E, E>> iterator() {
            return new Iterator<Tuples.X2<E, E>>(){
                final Iterator<E> it;
                E prev;
                {
                    this.it = PairIterable.this.ib.iterator();
                    this.prev = PairIterable.this.lobj;
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext() || this.prev != PairIterable.this.robj;
                }

                @Override
                public Tuples.X2<E, E> next() {
                    Object rk = !this.it.hasNext() && this.prev != PairIterable.this.robj ? PairIterable.this.robj : this.it.next();
                    this.prev = rk;
                    return new Tuples.X2(this.prev, this.prev);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

