/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import plugins.Library.io.DataFormatException;
import plugins.Library.io.serial.MapSerialiser;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.io.serial.Translator;
import plugins.Library.util.DataNotLoadedException;
import plugins.Library.util.Skeleton;
import plugins.Library.util.SkeletonBTreeSet;
import plugins.Library.util.SkeletonMap;
import plugins.Library.util.SkeletonValue;
import plugins.Library.util.exec.TaskAbortException;
import plugins.Library.util.exec.TaskCompleteException;

public class SkeletonTreeMap<K, V>
extends TreeMap<K, V>
implements Map<K, V>,
SortedMap<K, V>,
SkeletonMap<K, V>,
Cloneable {
    protected final TreeMap<K, SkeletonValue<V>> skmap;
    protected Object mapmeta;
    protected transient int ghosts;
    protected MapSerialiser<K, V> serialiser;
    private transient Set<Map.Entry<K, V>> entries;
    private transient Set<K> keys;
    private transient Collection<V> values;

    public SkeletonTreeMap() {
        this.skmap = new TreeMap();
    }

    public SkeletonTreeMap(Comparator<? super K> c) {
        this.skmap = new TreeMap(c);
    }

    public SkeletonTreeMap(Map<? extends K, ? extends V> m) {
        this.skmap = new TreeMap();
        this.putAll(m);
    }

    public SkeletonTreeMap(SortedMap<K, ? extends V> m) {
        this.skmap = new TreeMap(m.comparator());
        this.putAll(m);
    }

    public SkeletonTreeMap(SkeletonTreeMap<K, V> m) {
        this.skmap = new TreeMap(m.comparator());
        for (Map.Entry<K, SkeletonValue<V>> en : m.skmap.entrySet()) {
            this.skmap.put(en.getKey(), (SkeletonValue<Object>)en.getValue().clone());
        }
        this.ghosts = m.ghosts;
    }

    public Object putGhost(K key, Object o) {
        if (key == null) {
            throw new IllegalArgumentException("No null keys");
        }
        if (o == null) {
            throw new IllegalArgumentException("Cannot put a null dummy into the map. Use put(K, V) to mark an object as loaded.");
        }
        SkeletonValue<Object> sk = this.skmap.get(key);
        if (sk == null) {
            sk = new SkeletonValue<Object>(null, o, false);
            this.skmap.put(key, sk);
            ++this.ghosts;
            return null;
        }
        if (sk.isLoaded()) {
            ++this.ghosts;
        }
        return sk.setGhost(o);
    }

    public void setSerialiser(MapSerialiser<K, V> s) {
        if (this.serialiser != null && !this.isLive()) {
            throw new IllegalStateException("Cannot change the serialiser when the structure is not live.");
        }
        this.serialiser = s;
    }

    public static <K, V> void swapKey(K key, SkeletonTreeMap<K, V> src, SkeletonTreeMap<K, V> dst) {
        if (dst.containsKey(key)) {
            throw new IllegalArgumentException("SkeletonTreeMap.swapKey: key " + key + " already exists in target map");
        }
        if (!src.containsKey(key)) {
            throw new IllegalArgumentException("SkeletonTreeMap.swapKey: key " + key + " does not exist in source map");
        }
        SkeletonValue<V> sk = src.skmap.remove(key);
        if (!sk.isLoaded()) {
            --src.ghosts;
            ++dst.ghosts;
        }
        dst.skmap.put(key, sk);
    }

    @Override
    public boolean isLive() {
        return this.ghosts == 0;
    }

    @Override
    public boolean isBare() {
        return this.ghosts == this.skmap.size();
    }

    @Override
    public MapSerialiser<K, V> getSerialiser() {
        return this.serialiser;
    }

    @Override
    public Object getMeta() {
        return this.mapmeta;
    }

    @Override
    public void setMeta(Object m) {
        this.mapmeta = m;
    }

    @Override
    public void inflate() throws TaskAbortException {
        if (this.serialiser == null) {
            throw new IllegalStateException("No serialiser set for this structure.");
        }
        if (this.isLive()) {
            return;
        }
        HashMap tasks = new HashMap(this.size() << 1);
        for (Map.Entry<K, SkeletonValue<V>> entry : this.skmap.entrySet()) {
            SkeletonValue<V> skel = entry.getValue();
            if (skel.isLoaded()) continue;
            tasks.put(entry.getKey(), new Serialiser.PullTask(skel.meta()));
        }
        this.serialiser.pull(tasks, this.mapmeta);
        for (Map.Entry<K, SkeletonValue<V>> entry : tasks.entrySet()) {
            assert (this.skmap.get(entry.getKey()) != null);
            this.put(entry.getKey(), ((Serialiser.PullTask)((Object)entry.getValue())).data);
        }
    }

    @Override
    public void deflate() throws TaskAbortException {
        if (this.serialiser == null) {
            throw new IllegalStateException("No serialiser set for this structure.");
        }
        if (this.isBare()) {
            return;
        }
        HashMap<K, Serialiser.PushTask<V>> tasks = new HashMap<K, Serialiser.PushTask<V>>(this.size() << 1);
        for (Map.Entry<K, SkeletonValue<V>> entry : this.skmap.entrySet()) {
            SkeletonValue<V> skel = entry.getValue();
            if (skel.data() == null) {
                if (skel.isLoaded()) {
                    throw new TaskAbortException("Skeleton value in " + this + " : isLoaded() = true, data = null, meta = " + skel.meta() + " for " + entry.getKey(), new NullPointerException());
                }
                if (skel.meta() == null) {
                    throw new TaskAbortException("Skeleton value in " + this + " : isLoaded() = false, data = null, meta = null for " + entry.getKey(), new NullPointerException());
                }
            }
            tasks.put(entry.getKey(), new Serialiser.PushTask<V>(skel.data(), skel.meta()));
            if (!(skel.data() instanceof SkeletonBTreeSet)) continue;
            SkeletonBTreeSet ss = (SkeletonBTreeSet)skel.data();
        }
        this.serialiser.push(tasks, this.mapmeta);
        for (Map.Entry<K, SkeletonValue<V>> entry : tasks.entrySet()) {
            assert (this.skmap.get(entry.getKey()) != null);
            this.putGhost(entry.getKey(), ((Serialiser.PushTask)((Object)entry.getValue())).meta);
        }
    }

    @Override
    public void inflate(K key) throws TaskAbortException {
        if (this.serialiser == null) {
            throw new IllegalStateException("No serialiser set for this structure.");
        }
        SkeletonValue<V> skel = this.skmap.get(key);
        if (skel == null) {
            throw new IllegalArgumentException("Key " + key + " does not belong to the map");
        }
        if (skel.isLoaded()) {
            return;
        }
        HashMap tasks = new HashMap();
        tasks.put(key, new Serialiser.PullTask(skel.meta()));
        try {
            this.serialiser.pull(tasks, this.mapmeta);
            this.put(key, ((Serialiser.PullTask)tasks.remove(key)).data);
            if (tasks.isEmpty()) {
                return;
            }
            for (Map.Entry en : tasks.entrySet()) {
                Serialiser.PullTask t = (Serialiser.PullTask)en.getValue();
                if (t.data == null) {
                    throw new DataFormatException("Inflate got null from PullTask for " + key + " on " + this, null, null, tasks, en.getKey());
                }
                SkeletonValue<Object> sk = this.skmap.get(en.getKey());
                if (sk == null) {
                    throw new DataFormatException("SkeletonTreeMap got unexpected extra data from the serialiser.", null, sk, tasks, en.getKey());
                }
                if (!sk.meta().equals(t.meta)) continue;
                if (!sk.isLoaded()) {
                    --this.ghosts;
                }
                sk.set(t.data);
            }
        }
        catch (TaskCompleteException e) {
            assert (this.skmap.get(key).isLoaded());
        }
        catch (DataFormatException e) {
            throw new TaskAbortException("Could not complete inflate operation", e);
        }
    }

    @Override
    public void deflate(K key) throws TaskAbortException {
        if (this.serialiser == null) {
            throw new IllegalStateException("No serialiser set for this structure.");
        }
        SkeletonValue<V> skel = this.skmap.get(key);
        if (skel == null || !skel.isLoaded()) {
            return;
        }
        HashMap<K, Serialiser.PushTask<Object>> tasks = new HashMap<K, Serialiser.PushTask<Object>>(this.size() << 1);
        tasks.put(key, new Serialiser.PushTask<V>(skel.data(), skel.meta()));
        for (Map.Entry<K, SkeletonValue<V>> entry : this.skmap.entrySet()) {
            skel = entry.getValue();
            if (skel.isLoaded()) continue;
            assert (skel.data() == null);
            tasks.put(entry.getKey(), new Serialiser.PushTask<Object>(null, skel.meta()));
        }
        this.serialiser.push(tasks, this.mapmeta);
        for (Map.Entry<K, SkeletonValue<V>> entry : tasks.entrySet()) {
            assert (this.skmap.get(entry.getKey()) != null);
            this.putGhost(entry.getKey(), ((Serialiser.PushTask)((Object)entry.getValue())).meta);
        }
    }

    @Override
    public int size() {
        return this.skmap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.skmap.isEmpty();
    }

    @Override
    public void clear() {
        this.skmap.clear();
        this.ghosts = 0;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.skmap.comparator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.skmap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (!this.isLive()) {
            throw new DataNotLoadedException("TreeMap not fully loaded.", this);
        }
        for (SkeletonValue<V> v : this.skmap.values()) {
            if (!value.equals(v.data())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        SkeletonValue<V> sk = this.skmap.get(key);
        if (sk == null) {
            return null;
        }
        if (!sk.isLoaded()) {
            throw new DataNotLoadedException("Data not loaded for key " + key + ": " + sk.meta(), (Skeleton)this, key, sk.meta());
        }
        return sk.data();
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        SkeletonValue<V> sk = this.skmap.get(key);
        if (sk == null) {
            sk = new SkeletonValue<V>(value, null, true);
            this.skmap.put(key, sk);
            return null;
        }
        if (!sk.isLoaded()) {
            --this.ghosts;
        }
        return sk.set(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        SortedMap<K, SkeletonValue<V>> putmap;
        if (map instanceof SkeletonTreeMap) {
            putmap = ((SkeletonTreeMap)map).skmap;
        } else if (map instanceof UnwrappingSortedSubMap) {
            putmap = ((UnwrappingSortedSubMap)map).bkmap;
        } else {
            for (Map.Entry<K, V> en : map.entrySet()) {
                this.put(en.getKey(), en.getValue());
            }
            return;
        }
        int g = 0;
        for (Map.Entry<K, SkeletonValue<V>> en : putmap.entrySet()) {
            SkeletonValue<V> sk = en.getValue();
            SkeletonValue<V> old = this.skmap.put(en.getKey(), sk);
            if (old == null) {
                if (sk.isLoaded()) continue;
                ++g;
                continue;
            }
            if (old.isLoaded()) {
                if (sk.isLoaded()) continue;
                ++g;
                continue;
            }
            if (!sk.isLoaded()) continue;
            --g;
        }
        this.ghosts += g;
    }

    @Override
    public V remove(Object key) {
        SkeletonValue<V> sk = this.skmap.remove(key);
        if (sk == null) {
            return null;
        }
        if (!sk.isLoaded()) {
            --this.ghosts;
        }
        return sk.data();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new UnwrappingEntrySet(this.skmap, false);
        }
        return this.entries;
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet<K>(){

                @Override
                public int size() {
                    return SkeletonTreeMap.this.skmap.size();
                }

                @Override
                public Iterator<K> iterator() {
                    return new UnwrappingIterator(SkeletonTreeMap.this.skmap.entrySet().iterator(), 0, false);
                }

                @Override
                public void clear() {
                    SkeletonTreeMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    return SkeletonTreeMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    boolean c = this.contains(o);
                    SkeletonTreeMap.this.remove(o);
                    return c;
                }
            };
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return SkeletonTreeMap.this.size();
                }

                @Override
                public Iterator<V> iterator() {
                    return new UnwrappingIterator(SkeletonTreeMap.this.skmap.entrySet().iterator(), 1, false);
                }

                @Override
                public void clear() {
                    SkeletonTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public K firstKey() {
        return this.skmap.firstKey();
    }

    @Override
    public K lastKey() {
        return this.skmap.lastKey();
    }

    @Override
    public SortedMap<K, V> subMap(K fr, K to) {
        return new UnwrappingSortedSubMap(this.skmap.subMap(fr, to));
    }

    @Override
    public SortedMap<K, V> headMap(K to) {
        return new UnwrappingSortedSubMap(this.skmap.headMap(to));
    }

    @Override
    public SortedMap<K, V> tailMap(K fr) {
        return new UnwrappingSortedSubMap(this.skmap.tailMap(fr));
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof SkeletonTreeMap) {
            return this.skmap.equals(((SkeletonTreeMap)o).skmap);
        }
        return super.equals(o);
    }

    @Override
    public Object clone() {
        return new SkeletonTreeMap<K, V>(this);
    }

    @Override
    public String toString() {
        if (this.isLive()) {
            return this.getClass().getName() + "@" + System.identityHashCode(this) + ":" + super.toString();
        }
        return this.getClass().getName() + "@" + System.identityHashCode(this);
    }

    protected class UnwrappingEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        protected final SortedMap<K, SkeletonValue<V>> bkmap;
        protected final boolean issub;

        protected UnwrappingEntrySet(SortedMap<K, SkeletonValue<V>> bk, boolean sub) {
            this.bkmap = bk;
            this.issub = sub;
        }

        @Override
        public int size() {
            return this.bkmap.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new UnwrappingIterator(this.bkmap.entrySet().iterator(), 2, this.issub);
        }

        @Override
        public void clear() {
            if (this.issub) {
                throw new UnsupportedOperationException("not implemented");
            }
            SkeletonTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry en = (Map.Entry)o;
            Object key = en.getKey();
            Object val = en.getValue();
            SkeletonValue sk = (SkeletonValue)this.bkmap.get(key);
            if (sk == null) {
                return false;
            }
            if (!sk.isLoaded()) {
                throw new DataNotLoadedException("Data not loaded for key " + key + ": " + sk.meta(), (Skeleton)SkeletonTreeMap.this, key, sk.meta());
            }
            return sk.data() == null && val == null || sk.data().equals(val);
        }

        @Override
        public boolean remove(Object o) {
            if (this.issub) {
                throw new UnsupportedOperationException("not implemented");
            }
            boolean c = this.contains(o);
            if (c) {
                SkeletonTreeMap.this.remove(((Map.Entry)o).getKey());
            }
            return c;
        }
    }

    protected class UnwrappingSortedSubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V> {
        final SortedMap<K, SkeletonValue<V>> bkmap;
        private transient Set<Map.Entry<K, V>> entries;

        protected UnwrappingSortedSubMap(SortedMap<K, SkeletonValue<V>> sub) {
            this.bkmap = sub;
        }

        @Override
        public int size() {
            return this.bkmap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.bkmap.isEmpty();
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.bkmap.comparator();
        }

        @Override
        public K firstKey() {
            return this.bkmap.firstKey();
        }

        @Override
        public K lastKey() {
            return this.bkmap.lastKey();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                this.entries = new UnwrappingEntrySet(this.bkmap, true);
            }
            return this.entries;
        }

        @Override
        public SortedMap<K, V> subMap(K fr, K to) {
            return new UnwrappingSortedSubMap(this.bkmap.subMap(fr, to));
        }

        @Override
        public SortedMap<K, V> headMap(K to) {
            return new UnwrappingSortedSubMap(this.bkmap.headMap(to));
        }

        @Override
        public SortedMap<K, V> tailMap(K fr) {
            return new UnwrappingSortedSubMap(this.bkmap.tailMap(fr));
        }
    }

    protected class UnwrappingIterator<T>
    implements Iterator<T> {
        protected final Iterator<Map.Entry<K, SkeletonValue<V>>> iter;
        protected Map.Entry<K, SkeletonValue<V>> last;
        protected static final int KEY = 0;
        protected static final int VALUE = 1;
        protected static final int ENTRY = 2;
        protected final boolean issub;
        protected boolean gotvalue;
        protected final int type;

        protected UnwrappingIterator(Iterator<Map.Entry<K, SkeletonValue<V>>> it, int t, boolean sub) {
            assert (t == 0 || t == 1 || t == 2);
            this.type = t;
            this.iter = it;
            this.issub = sub;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            switch (this.type) {
                case 0: {
                    this.last = this.iter.next();
                    return (T)this.last.getKey();
                }
                case 1: {
                    SkeletonValue skel;
                    if (this.last == null || this.gotvalue) {
                        this.last = this.iter.next();
                    }
                    if (!(this.gotvalue = (skel = this.last.getValue()).isLoaded())) {
                        throw new DataNotLoadedException("SkeletonTreeMap: Data not loaded for key " + this.last.getKey() + ": " + skel.meta(), (Skeleton)SkeletonTreeMap.this, this.last.getKey(), skel.meta());
                    }
                    return (T)skel.data();
                }
                case 2: {
                    this.last = this.iter.next();
                    return (T)new UnwrappingEntry(this.last);
                }
            }
            throw new AssertionError();
        }

        @Override
        public void remove() {
            if (this.issub) {
                throw new UnsupportedOperationException("not implemented");
            }
            if (this.last == null) {
                throw new IllegalStateException("Iteration has not yet begun, or the element has already been removed.");
            }
            if (!this.last.getValue().isLoaded()) {
                --SkeletonTreeMap.this.ghosts;
            }
            this.iter.remove();
            this.last = null;
        }

        protected class UnwrappingEntry
        implements Map.Entry<K, V> {
            final K key;
            final SkeletonValue<V> skel;

            protected UnwrappingEntry(Map.Entry<K, SkeletonValue<V>> en) {
                this.key = en.getKey();
                this.skel = en.getValue();
            }

            protected void verifyLoaded() {
                if (!this.skel.isLoaded()) {
                    throw new DataNotLoadedException("SkeletonTreeMap: Data not loaded for key " + this.key + ": " + this.skel.meta(), (Skeleton)SkeletonTreeMap.this, this.key, this.skel.meta());
                }
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                this.verifyLoaded();
                return this.skel.data();
            }

            @Override
            public V setValue(V value) {
                if (!this.skel.isLoaded()) {
                    --SkeletonTreeMap.this.ghosts;
                }
                return this.skel.set(value);
            }

            @Override
            public int hashCode() {
                this.verifyLoaded();
                return (this.key == null ? 0 : this.key.hashCode()) ^ (this.skel.data() == null ? 0 : this.skel.data().hashCode());
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                this.verifyLoaded();
                Map.Entry en = (Map.Entry)o;
                return (this.key == null ? en.getKey() == null : this.key.equals(en.getKey())) && (this.skel.data() == null ? en.getValue() == null : this.skel.data().equals(en.getValue()));
            }
        }
    }

    public static abstract class TreeMapTranslator<K, V>
    implements Translator<SkeletonTreeMap<K, V>, Map<String, Object>> {
        public static <K, V> Map<String, Object> app(SkeletonTreeMap<K, V> map, Map<String, Object> intm, Translator<K, String> ktr) {
            if (!map.isBare()) {
                throw new IllegalArgumentException("Data structure is not bare. Try calling deflate() first.");
            }
            if (map.comparator() != null) {
                throw new UnsupportedOperationException("Sorry, this translator does not (yet) support comparators");
            }
            if (ktr != null) {
                for (Map.Entry en : map.skmap.entrySet()) {
                    intm.put(ktr.app(en.getKey()), en.getValue().meta());
                }
            } else {
                for (Map.Entry en : map.skmap.entrySet()) {
                    intm.put(en.getKey().toString(), en.getValue().meta());
                }
            }
            return intm;
        }

        public static <K, V> SkeletonTreeMap<K, V> rev(Map<String, Object> intm, SkeletonTreeMap<K, V> map, Translator<K, String> ktr) throws DataFormatException {
            if (ktr == null) {
                try {
                    for (Map.Entry<String, Object> en : intm.entrySet()) {
                        map.putGhost(en.getKey(), en.getValue());
                    }
                }
                catch (ClassCastException e) {
                    throw new DataFormatException("TreeMapTranslator: reverse translation failed. Try supplying a non-null key-translator.", e, intm, null, null);
                }
            } else {
                for (Map.Entry<String, Object> en : intm.entrySet()) {
                    map.putGhost((String)ktr.rev(en.getKey()), en.getValue());
                }
            }
            return map;
        }
    }
}

