/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.builder.HtmlDocumentBuilder;
import net.java.textilej.parser.markup.Dialect;

public class MarkupParser {
    private Dialect dialect;
    private DocumentBuilder builder;

    public MarkupParser() {
    }

    public MarkupParser(Dialect dialect, DocumentBuilder builder) {
        this.dialect = dialect;
        this.builder = builder;
    }

    public MarkupParser(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public DocumentBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(DocumentBuilder builder) {
        this.builder = builder;
    }

    public void parse(Reader markupContent) throws IOException {
        this.parse(markupContent, true);
    }

    public void parse(Reader markupContent, boolean asDocument) throws IOException {
        this.parse(this.readFully(markupContent), asDocument);
    }

    public void parse(String markupContent) {
        this.parse(markupContent, true);
    }

    public void parse(String markupContent, boolean asDocument) {
        if (this.dialect == null) {
            throw new IllegalStateException("markup dialect is not set");
        }
        if (this.builder == null) {
            throw new IllegalStateException("builder is not set");
        }
        this.dialect.processContent(this, markupContent, asDocument);
    }

    private String readFully(Reader reader) throws IOException {
        int c;
        StringWriter writer = new StringWriter();
        while ((c = reader.read()) != -1) {
            writer.write(c);
        }
        return writer.toString();
    }

    public String parseToHtml(String markupContent) {
        if (this.builder != null) {
            throw new IllegalStateException("Builder must not be set");
        }
        StringWriter out = new StringWriter();
        this.setBuilder(new HtmlDocumentBuilder(out));
        this.parse(markupContent);
        this.setBuilder(null);
        return out.toString();
    }
}

